/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.filter.file;

import java.io.File;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;

public class TIFFFilter
extends CustomizedFileFilter {
    public static final String TIFF = "tiff";
    public static final String TIF = "tif";
    public static final String TF_2 = "tf2";
    public static final String TF_8 = "tf8";
    public static final String BTF = "btf";
    public static final String[] extensions = new String[5];
    private static final String description;

    public String getMimeType() {
        return "image/tiff";
    }

    public String getExtension() {
        return TIFF;
    }

    public String getDescription() {
        return description;
    }

    public boolean accept(File f) {
        if (f == null) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        return this.isSupported(f.getName(), extensions);
    }

    public boolean accept(String fileName) {
        return this.isSupported(fileName, extensions);
    }

    static {
        TIFFFilter.extensions[0] = TIFF;
        TIFFFilter.extensions[1] = TIF;
        TIFFFilter.extensions[2] = TF_2;
        TIFFFilter.extensions[3] = TF_8;
        TIFFFilter.extensions[4] = BTF;
        String s = "Tagged Image File Format (";
        for (int i = 0; i < extensions.length; ++i) {
            s = s + "*." + extensions[i];
            if (i >= extensions.length - 1) continue;
            s = s + ", ";
        }
        description = s = s + ")";
    }
}

