/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.filter.file;

import java.io.File;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;

public class DVFilter
extends CustomizedFileFilter {
    public static final String DV = "dv";
    public static final String R3D = "r3d";
    public static final String R3D_D3D = "r3d_d3d";
    public static final String[] extensions = new String[3];
    private static final String description;

    public String getMimeType() {
        return "application/octet-stream";
    }

    public String getExtension() {
        return DV;
    }

    public String getDescription() {
        return description;
    }

    public boolean accept(File f) {
        if (f == null) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        return this.isSupported(f.getName(), extensions);
    }

    public boolean accept(String fileName) {
        return this.isSupported(fileName, extensions);
    }

    static {
        DVFilter.extensions[0] = DV;
        DVFilter.extensions[1] = R3D;
        DVFilter.extensions[2] = R3D_D3D;
        String s = "Deltavision (";
        for (int i = 0; i < extensions.length; ++i) {
            s = s + "*." + extensions[i];
            if (i >= extensions.length - 1) continue;
            s = s + ", ";
        }
        description = s = s + ")";
    }
}

