/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.undo.CompositeEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorColorChooserAction
extends AbstractSelectedAction {
    protected AttributeKey<Color> key;
    private static JColorChooser colorChooser;
    private HashMap<AttributeKey, Object> fixedAttributes;

    public EditorColorChooserAction(DrawingEditor editor, AttributeKey<Color> key) {
        this(editor, key, null, null);
    }

    public EditorColorChooserAction(DrawingEditor editor, AttributeKey<Color> key, Icon icon) {
        this(editor, key, null, icon);
    }

    public EditorColorChooserAction(DrawingEditor editor, AttributeKey<Color> key, String name) {
        this(editor, key, name, null);
    }

    public EditorColorChooserAction(DrawingEditor editor, AttributeKey<Color> key, String name, Icon icon) {
        this(editor, key, name, icon, new HashMap<AttributeKey, Object>());
    }

    public EditorColorChooserAction(DrawingEditor editor, AttributeKey<Color> key, String name, Icon icon, Map<AttributeKey, Object> fixedAttributes) {
        super(editor);
        this.key = key;
        this.putValue("Name", name);
        this.putValue("SmallIcon", icon);
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (colorChooser == null) {
            colorChooser = new JColorChooser();
        }
        Color initialColor = this.getInitialColor();
        Color chosenColor = JColorChooser.showDialog((Component)e.getSource(), this.labels.getString("drawColor"), initialColor);
        if (chosenColor != null) {
            this.changeAttribute(chosenColor);
        }
    }

    public void changeAttribute(Color value) {
        CompositeEdit edit = new CompositeEdit("attributes");
        this.fireUndoableEditHappened(edit);
        Drawing drawing = this.getDrawing();
        for (Figure figure : this.getView().getSelectedFigures()) {
            figure.willChange();
            this.key.basicSet(figure, value);
            for (Map.Entry<AttributeKey, Object> entry : this.fixedAttributes.entrySet()) {
                entry.getKey().basicSet(figure, entry.getValue());
            }
            figure.changed();
        }
        this.getEditor().setDefaultAttribute(this.key, value);
        this.fireUndoableEditHappened(edit);
    }

    public void selectionChanged(FigureSelectionEvent evt) {
    }

    protected Color getInitialColor() {
        Color initialColor = (Color)this.getEditor().getDefaultAttribute(this.key);
        if (initialColor == null) {
            initialColor = Color.red;
        }
        return initialColor;
    }
}

