/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.Point2D;
import java.util.HashMap;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.draw.TextTool;
import org.jhotdraw.draw.Tool;

public class LabelFigure
extends TextFigure
implements FigureListener {
    private TextHolderFigure target;

    public LabelFigure() {
        this("Label");
    }

    public LabelFigure(String text) {
        this.setText(text);
        this.setEditable(false);
    }

    public void setLabelFor(TextHolderFigure target) {
        if (this.target != null) {
            this.target.removeFigureListener(this);
        }
        this.target = target;
        if (this.target != null) {
            this.target.addFigureListener(this);
        }
    }

    public TextHolderFigure getLabelFor() {
        return this.target == null ? this : this.target;
    }

    public Tool getTool(Point2D.Double p) {
        return this.target != null && this.contains(p) ? new TextTool(this.target) : null;
    }

    public void figureAreaInvalidated(FigureEvent e) {
    }

    public void figureAttributeChanged(FigureEvent e) {
    }

    public void figureAdded(FigureEvent e) {
    }

    public void figureChanged(FigureEvent e) {
    }

    public void figureRemoved(FigureEvent e) {
        if (e.getFigure() == this.target) {
            this.target.removeFigureListener(this);
            this.target = null;
        }
    }

    public void figureRequestRemove(FigureEvent e) {
    }

    public void remap(HashMap oldToNew) {
        Figure newTarget;
        super.remap(oldToNew);
        if (this.target != null && (newTarget = (Figure)oldToNew.get(this.target)) != null) {
            this.target.removeFigureListener(this);
            this.target = (TextHolderFigure)newTarget;
            newTarget.addFigureListener(this);
        }
    }

    public void figureHandlesChanged(FigureEvent e) {
    }
}

