/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.application.action;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.jhotdraw.application.DocumentView;
import org.jhotdraw.application.action.AbstractDocumentViewAction;

public class PropertyAction
extends AbstractDocumentViewAction {
    private String propertyName;
    private Class[] parameterClass;
    private Object propertyValue;
    private String setterName;
    private String getterName;
    private PropertyChangeListener projectListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == PropertyAction.this.propertyName) {
                PropertyAction.this.updateSelectedState();
            }
        }
    };

    public PropertyAction(String propertyName, Object propertyValue) {
        this(propertyName, propertyValue.getClass(), propertyValue);
    }

    public PropertyAction(String propertyName, Class propertyClass, Object propertyValue) {
        this.propertyName = propertyName;
        this.parameterClass = new Class[]{propertyClass};
        this.propertyValue = propertyValue;
        this.setterName = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        this.getterName = (propertyClass == Boolean.TYPE || propertyClass == Boolean.class ? "is" : "get") + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        this.updateSelectedState();
    }

    public void actionPerformed(ActionEvent evt) {
        DocumentView p = this.getCurrentView();
        try {
            p.getClass().getMethod(this.setterName, this.parameterClass).invoke((Object)p, this.propertyValue);
        }
        catch (Throwable e) {
            InternalError error = new InternalError("Method invocation failed");
            error.initCause(e);
            throw error;
        }
    }

    protected void installProjectListeners(DocumentView p) {
        super.installProjectListeners(p);
        p.addPropertyChangeListener(this.projectListener);
        this.updateSelectedState();
    }

    protected void uninstallProjectListeners(DocumentView p) {
        super.uninstallProjectListeners(p);
        p.removePropertyChangeListener(this.projectListener);
    }

    private void updateSelectedState() {
        boolean isSelected = false;
        DocumentView p = this.getCurrentView();
        if (p != null) {
            try {
                Object value = p.getClass().getMethod(this.getterName, null).invoke((Object)p, new Object[0]);
                isSelected = value == this.propertyValue || value != null && this.propertyValue != null && value.equals(this.propertyValue);
            }
            catch (Throwable e) {
                InternalError error = new InternalError("Method invocation failed");
                error.initCause(e);
                throw error;
            }
        }
        this.putValue("selected", isSelected);
    }
}

