/*
 * Decompiled with CFR 0.152.
 */
package ome.model.screen;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IAnnotated;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.model.annotations.ReagentAnnotationLink;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.model.screen.Screen;
import ome.model.screen.Well;
import ome.model.screen.WellReagentLink;
import ome.util.CBlock;
import ome.util.CountCollectionPersister;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FilterDefs(value={@FilterDef(name="reagent_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="reagent_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="reagent_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="reagent_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="reagent_owner_filter_WELLLINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="reagent_group_filter_WELLLINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="reagent_event_filter_WELLLINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="reagent_perms_filter_WELLLINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="reagent_owner_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="reagent_group_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="reagent_event_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="reagent_perms_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="reagent_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="reagent_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="reagent_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="reagent_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="securityFilter")})
@Entity
@Table(name="reagent", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_reagent", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_reagent"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class Reagent
implements Serializable,
IObject,
IMutable,
IAnnotated {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "reagent_owner_filter";
    public static final String GROUP_FILTER = "reagent_group_filter";
    public static final String EVENT_FILTER = "reagent_event_filter";
    public static final String PERMS_FILTER = "reagent_perms_filter";
    public static final String ID = "ome.model.screen.Reagent_id";
    protected Long id;
    public static final String VERSION = "ome.model.screen.Reagent_version";
    protected Integer version = 0;
    protected String reagentIdentifier = null;
    protected Screen screen = null;
    protected Set<WellReagentLink> wellLinks = new HashSet<WellReagentLink>();
    public static final String OWNER_FILTER_WELLLINKS = "reagent_owner_filter_WELLLINKS";
    public static final String GROUP_FILTER_WELLLINKS = "reagent_group_filter_WELLLINKS";
    public static final String EVENT_FILTER_WELLLINKS = "reagent_event_filter_WELLLINKS";
    public static final String PERMS_FILTER_WELLLINKS = "reagent_perms_filter_WELLLINKS";
    private Map<Long, Long> wellLinksCountPerOwner = null;
    protected Set<ReagentAnnotationLink> annotationLinks = new HashSet<ReagentAnnotationLink>();
    public static final String OWNER_FILTER_ANNOTATIONLINKS = "reagent_owner_filter_ANNOTATIONLINKS";
    public static final String GROUP_FILTER_ANNOTATIONLINKS = "reagent_group_filter_ANNOTATIONLINKS";
    public static final String EVENT_FILTER_ANNOTATIONLINKS = "reagent_event_filter_ANNOTATIONLINKS";
    public static final String PERMS_FILTER_ANNOTATIONLINKS = "reagent_perms_filter_ANNOTATIONLINKS";
    private Map<Long, Long> annotationLinksCountPerOwner = null;
    protected String name = null;
    protected String description = null;
    protected ome.model.internal.Details details = new Details();
    public static final String REAGENTIDENTIFIER = "ome.model.screen.Reagent_reagentIdentifier";
    public static final String SCREEN = "ome.model.screen.Reagent_screen";
    public static final String WELLLINKSCOUNTPEROWNER = "ome.model.screen.Reagent_wellLinksCountPerOwner";
    public static final String WELLLINKS = "ome.model.screen.Reagent_wellLinks";
    public static final String ANNOTATIONLINKSCOUNTPEROWNER = "ome.model.screen.Reagent_annotationLinksCountPerOwner";
    public static final String ANNOTATIONLINKS = "ome.model.screen.Reagent_annotationLinks";
    public static final String NAME = "ome.model.screen.Reagent_name";
    public static final String DESCRIPTION = "ome.model.screen.Reagent_description";
    public static final String DETAILS = "ome.model.screen.Reagent_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public Reagent() {
        this(null, true);
    }

    protected Reagent(Long id) {
        this(id, true);
    }

    public Reagent(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public Reagent(Screen _screen, String _name) {
        this(null, true);
        this.setScreen(_screen);
        this.setName(_name);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_reagent")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="reagentIdentifier", updatable=true)
    public String getReagentIdentifier() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.reagentIdentifier;
    }

    public void setReagentIdentifier(String reagentIdentifier) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.reagentIdentifier = reagentIdentifier;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Screen.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="screen", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKreagent_screen_screen")
    public Screen getScreen() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.screen;
    }

    public void setScreen(Screen screen) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.screen = screen;
    }

    @OneToMany(mappedBy="child", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="reagent_owner_filter_WELLLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="reagent_group_filter_WELLLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="reagent_event_filter_WELLLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="reagent_perms_filter_WELLLINKS", condition=":permsStr = permissions")})
    protected Set<WellReagentLink> getWellLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.wellLinks;
    }

    protected void setWellLinks(Set<WellReagentLink> wellLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.wellLinks = wellLinks;
    }

    public int sizeOfWellLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.wellLinks == null ? -1 : this.wellLinks.size();
    }

    public Iterator<WellReagentLink> iterateWellLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellLinks() == null) {
            return new EmptyIterator<WellReagentLink>();
        }
        return this.getWellLinks().iterator();
    }

    public Collection<WellReagentLink> unmodifiableWellLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getWellLinks());
    }

    public <E> List<E> collectWellLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<WellReagentLink> it = this.iterateWellLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addWellReagentLink(WellReagentLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellLinks() == null) {
            this.throwNullCollectionException("WellLinks");
        }
        this.getWellLinks().add(target);
        if (target != null) {
            target.setChild(this);
        }
    }

    public void addWellReagentLinkSet(Collection<WellReagentLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellLinks() == null) {
            this.throwNullCollectionException("WellLinks");
        }
        this.getWellLinks().addAll(targets);
        for (WellReagentLink target : targets) {
            if (target == null) continue;
            target.setChild(this);
        }
    }

    public void removeWellReagentLink(WellReagentLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellLinks() == null) {
            this.throwNullCollectionException("WellLinks");
        }
        this.getWellLinks().remove(target);
        target.setChild(null);
    }

    public void removeWellReagentLinkSet(Collection<WellReagentLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellLinks() == null) {
            this.throwNullCollectionException("WellLinks");
        }
        this.getWellLinks().removeAll(targets);
        for (WellReagentLink target : targets) {
            target.setChild(null);
        }
    }

    public WellReagentLink linkWell(Well addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        WellReagentLink link = new WellReagentLink();
        link.link(addition, this);
        this.addWellReagentLink(link, true);
        return link;
    }

    public void addWellReagentLink(WellReagentLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellLinks() == null) {
            this.throwNullCollectionException("WellLinks");
        }
        this.getWellLinks().add(link);
        if (bothSides && link.parent().isLoaded()) {
            link.parent().addWellReagentLink(link, false);
        }
    }

    public Iterator<Well> linkedWellIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellLinks() == null) {
            return new EmptyIterator<Well>();
        }
        final Iterator<WellReagentLink> it = this.getWellLinks().iterator();
        return new Iterator<Well>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Well next() {
                if (it == null) {
                    throw new NoSuchElementException("wellLinks is null; no elements.");
                }
                WellReagentLink link = (WellReagentLink)it.next();
                return link.parent();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<WellReagentLink> findWellReagentLink(Well target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<WellReagentLink> it = this.iterateWellLinks();
        HashSet<WellReagentLink> result = new HashSet<WellReagentLink>();
        while (it.hasNext()) {
            WellReagentLink link = it.next();
            if (link.parent() != target) continue;
            result.add(link);
        }
        return result;
    }

    public List<Well> linkedWellList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Well> it = this.linkedWellIterator();
        ArrayList<Well> list = new ArrayList<Well>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public <E> List<E> eachLinkedWell(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Well> it = this.linkedWellIterator();
        while (it.hasNext()) {
            Well obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void unlinkWell(Well removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<WellReagentLink> toRemove = this.findWellReagentLink(removal);
        Iterator<WellReagentLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeWellReagentLink(it.next(), true);
        }
    }

    public void removeWellReagentLink(WellReagentLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getWellLinks() == null) {
            this.throwNullCollectionException("WellLinks");
        }
        this.getWellLinks().remove(link);
        if (bothSides && link.parent().isLoaded()) {
            link.parent().removeWellReagentLink(link, false);
        }
    }

    public void clearWellLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<WellReagentLink> list = new ArrayList<WellReagentLink>(this.getWellLinks());
        for (WellReagentLink link : list) {
            this.removeWellReagentLink(link, true);
        }
    }

    protected void setWellLinksCountPerOwner(Map<Long, Long> map) {
        this.wellLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_Reagent_wellLinks")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_Reagent_wellLinks_by_owner", joinColumns={@JoinColumn(name="Reagent_id")})
    public Map<Long, Long> getWellLinksCountPerOwner() {
        return this.wellLinksCountPerOwner;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="reagent_owner_filter_ANNOTATIONLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="reagent_group_filter_ANNOTATIONLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="reagent_event_filter_ANNOTATIONLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="reagent_perms_filter_ANNOTATIONLINKS", condition=":permsStr = permissions")})
    protected Set<ReagentAnnotationLink> getAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks;
    }

    protected void setAnnotationLinks(Set<ReagentAnnotationLink> annotationLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.annotationLinks = annotationLinks;
    }

    @Override
    public int sizeOfAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks == null ? -1 : this.annotationLinks.size();
    }

    public Iterator<ReagentAnnotationLink> iterateAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<ReagentAnnotationLink>();
        }
        return this.getAnnotationLinks().iterator();
    }

    public Collection<ReagentAnnotationLink> unmodifiableAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getAnnotationLinks());
    }

    @Override
    public <E> List<E> collectAnnotationLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<ReagentAnnotationLink> it = this.iterateAnnotationLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addReagentAnnotationLink(ReagentAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(target);
        if (target != null) {
            target.setParent(this);
        }
    }

    public void addReagentAnnotationLinkSet(Collection<ReagentAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().addAll(targets);
        for (ReagentAnnotationLink target : targets) {
            if (target == null) continue;
            target.setParent(this);
        }
    }

    public void removeReagentAnnotationLink(ReagentAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(target);
        target.setParent(null);
    }

    public void removeReagentAnnotationLinkSet(Collection<ReagentAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().removeAll(targets);
        for (ReagentAnnotationLink target : targets) {
            target.setParent(null);
        }
    }

    public ReagentAnnotationLink linkAnnotation(Annotation addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ReagentAnnotationLink link = new ReagentAnnotationLink();
        link.link(this, addition);
        this.addReagentAnnotationLink(link, true);
        return link;
    }

    public void addReagentAnnotationLink(ReagentAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(link);
    }

    @Override
    public Iterator<Annotation> linkedAnnotationIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<Annotation>();
        }
        final Iterator<ReagentAnnotationLink> it = this.getAnnotationLinks().iterator();
        return new Iterator<Annotation>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Annotation next() {
                if (it == null) {
                    throw new NoSuchElementException("annotationLinks is null; no elements.");
                }
                ReagentAnnotationLink link = (ReagentAnnotationLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<ReagentAnnotationLink> findReagentAnnotationLink(Annotation target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<ReagentAnnotationLink> it = this.iterateAnnotationLinks();
        HashSet<ReagentAnnotationLink> result = new HashSet<ReagentAnnotationLink>();
        while (it.hasNext()) {
            ReagentAnnotationLink link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public List<Annotation> linkedAnnotationList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Override
    public <E> List<E> eachLinkedAnnotation(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        while (it.hasNext()) {
            Annotation obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<ReagentAnnotationLink> toRemove = this.findReagentAnnotationLink(removal);
        Iterator<ReagentAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeReagentAnnotationLink(it.next(), true);
        }
    }

    public void removeReagentAnnotationLink(ReagentAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(link);
    }

    @Override
    public void clearAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<ReagentAnnotationLink> list = new ArrayList<ReagentAnnotationLink>(this.getAnnotationLinks());
        for (ReagentAnnotationLink link : list) {
            this.removeReagentAnnotationLink(link, true);
        }
    }

    protected void setAnnotationLinksCountPerOwner(Map<Long, Long> map) {
        this.annotationLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_Reagent_annotationLinks")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_Reagent_annotationLinks_by_owner", joinColumns={@JoinColumn(name="Reagent_id")})
    public Map<Long, Long> getAnnotationLinksCountPerOwner() {
        return this.annotationLinksCountPerOwner;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="name", updatable=true)
    public String getName() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.name;
    }

    public void setName(String name) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.name = name;
    }

    @Type(type="org.hibernate.type.TextType")
    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="description", updatable=true)
    public String getDescription() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.description;
    }

    public void setDescription(String description) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.description = description;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public Reagent newInstance() {
        return new Reagent();
    }

    public Reagent proxy() {
        return new Reagent(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.reagentIdentifier = (String)__filter.filter(REAGENTIDENTIFIER, this.reagentIdentifier);
            this.screen = (Screen)__filter.filter(SCREEN, this.screen);
            this.wellLinksCountPerOwner = __filter.filter(WELLLINKSCOUNTPEROWNER, this.wellLinksCountPerOwner);
            this.wellLinks = (Set)__filter.filter(WELLLINKS, this.wellLinks);
            this.annotationLinksCountPerOwner = __filter.filter(ANNOTATIONLINKSCOUNTPEROWNER, this.annotationLinksCountPerOwner);
            this.annotationLinks = (Set)__filter.filter(ANNOTATIONLINKS, this.annotationLinks);
            this.name = (String)__filter.filter(NAME, this.name);
            this.description = (String)__filter.filter(DESCRIPTION, this.description);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(REAGENTIDENTIFIER)) {
            return this.getReagentIdentifier();
        }
        if (field.equals(SCREEN)) {
            return this.getScreen();
        }
        if (field.equals(WELLLINKSCOUNTPEROWNER)) {
            return this.getWellLinksCountPerOwner();
        }
        if (field.equals(WELLLINKS)) {
            return this.getWellLinks();
        }
        if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            return this.getAnnotationLinksCountPerOwner();
        }
        if (field.equals(ANNOTATIONLINKS)) {
            return this.getAnnotationLinks();
        }
        if (field.equals(NAME)) {
            return this.getName();
        }
        if (field.equals(DESCRIPTION)) {
            return this.getDescription();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(REAGENTIDENTIFIER)) {
            this.setReagentIdentifier((String)value);
        } else if (field.equals(SCREEN)) {
            this.setScreen((Screen)value);
        } else if (field.equals(WELLLINKSCOUNTPEROWNER)) {
            this.setWellLinksCountPerOwner((Map)value);
        } else if (field.equals(WELLLINKS)) {
            this.setWellLinks((Set)value);
        } else if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            this.setAnnotationLinksCountPerOwner((Map)value);
        } else if (field.equals(ANNOTATIONLINKS)) {
            this.setAnnotationLinks((Set)value);
        } else if (field.equals(NAME)) {
            this.setName((String)value);
        } else if (field.equals(DESCRIPTION)) {
            this.setDescription((String)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.reagentIdentifier = null;
        this.screen = null;
        this.wellLinksCountPerOwner = null;
        this.wellLinks = null;
        this.annotationLinksCountPerOwner = null;
        this.annotationLinks = null;
        this.name = null;
        this.description = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(REAGENTIDENTIFIER);
        raw.add(SCREEN);
        raw.add(WELLLINKSCOUNTPEROWNER);
        raw.add(WELLLINKS);
        raw.add(ANNOTATIONLINKSCOUNTPEROWNER);
        raw.add(ANNOTATIONLINKS);
        raw.add(NAME);
        raw.add(DESCRIPTION);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public ome.model.internal.Details newInstance() {
            return new Details();
        }

        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=false)
        @ForeignKey(name="FKreagent_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKreagent_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKreagent_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKreagent_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKreagent_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

