/*
 * Decompiled with CFR 0.152.
 */
package ome.model.meta;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IGlobal;
import ome.model.IObject;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.ExternalInfo;
import ome.util.DetailsFieldBridge;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Target;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="dbpatch", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_dbpatch", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_dbpatch"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class DBPatch
implements Serializable,
IObject,
IGlobal {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String ID = "ome.model.meta.DBPatch_id";
    protected Long id;
    protected String currentVersion = null;
    protected Integer currentPatch = null;
    protected String previousVersion = null;
    protected Integer previousPatch = null;
    protected Timestamp finished = null;
    protected String message = null;
    protected ome.model.internal.Details details = new Details();
    public static final String CURRENTVERSION = "ome.model.meta.DBPatch_currentVersion";
    public static final String CURRENTPATCH = "ome.model.meta.DBPatch_currentPatch";
    public static final String PREVIOUSVERSION = "ome.model.meta.DBPatch_previousVersion";
    public static final String PREVIOUSPATCH = "ome.model.meta.DBPatch_previousPatch";
    public static final String FINISHED = "ome.model.meta.DBPatch_finished";
    public static final String MESSAGE = "ome.model.meta.DBPatch_message";
    public static final String DETAILS = "ome.model.meta.DBPatch_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public DBPatch() {
        this(null, true);
    }

    protected DBPatch(Long id) {
        this(id, true);
    }

    public DBPatch(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public DBPatch(String _currentVersion, Integer _currentPatch, String _previousVersion, Integer _previousPatch) {
        this(null, true);
        this.setCurrentVersion(_currentVersion);
        this.setCurrentPatch(_currentPatch);
        this.setPreviousVersion(_previousVersion);
        this.setPreviousPatch(_previousPatch);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_dbpatch")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="currentVersion", updatable=false)
    public String getCurrentVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.currentVersion;
    }

    public void setCurrentVersion(String currentVersion) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.currentVersion = currentVersion;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="currentPatch", updatable=false)
    public Integer getCurrentPatch() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.currentPatch;
    }

    public void setCurrentPatch(Integer currentPatch) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.currentPatch = currentPatch;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="previousVersion", updatable=false)
    public String getPreviousVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.previousVersion;
    }

    public void setPreviousVersion(String previousVersion) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.previousVersion = previousVersion;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="previousPatch", updatable=false)
    public Integer getPreviousPatch() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.previousPatch;
    }

    public void setPreviousPatch(Integer previousPatch) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.previousPatch = previousPatch;
    }

    @DateBridge(resolution=Resolution.MINUTE)
    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="finished", updatable=false)
    public Timestamp getFinished() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.finished;
    }

    public void setFinished(Timestamp finished) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.finished = finished;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="message", updatable=false)
    public String getMessage() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.message;
    }

    public void setMessage(String message) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.message = message;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public DBPatch newInstance() {
        return new DBPatch();
    }

    public DBPatch proxy() {
        return new DBPatch(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.currentVersion = (String)__filter.filter(CURRENTVERSION, this.currentVersion);
            this.currentPatch = (Integer)__filter.filter(CURRENTPATCH, this.currentPatch);
            this.previousVersion = (String)__filter.filter(PREVIOUSVERSION, this.previousVersion);
            this.previousPatch = (Integer)__filter.filter(PREVIOUSPATCH, this.previousPatch);
            this.finished = (Timestamp)__filter.filter(FINISHED, this.finished);
            this.message = (String)__filter.filter(MESSAGE, this.message);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(CURRENTVERSION)) {
            return this.getCurrentVersion();
        }
        if (field.equals(CURRENTPATCH)) {
            return this.getCurrentPatch();
        }
        if (field.equals(PREVIOUSVERSION)) {
            return this.getPreviousVersion();
        }
        if (field.equals(PREVIOUSPATCH)) {
            return this.getPreviousPatch();
        }
        if (field.equals(FINISHED)) {
            return this.getFinished();
        }
        if (field.equals(MESSAGE)) {
            return this.getMessage();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(CURRENTVERSION)) {
            this.setCurrentVersion((String)value);
        } else if (field.equals(CURRENTPATCH)) {
            this.setCurrentPatch((Integer)value);
        } else if (field.equals(PREVIOUSVERSION)) {
            this.setPreviousVersion((String)value);
        } else if (field.equals(PREVIOUSPATCH)) {
            this.setPreviousPatch((Integer)value);
        } else if (field.equals(FINISHED)) {
            this.setFinished((Timestamp)value);
        } else if (field.equals(MESSAGE)) {
            this.setMessage((String)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.currentVersion = null;
        this.currentPatch = null;
        this.previousVersion = null;
        this.previousPatch = null;
        this.finished = null;
        this.message = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(CURRENTVERSION);
        raw.add(CURRENTPATCH);
        raw.add(PREVIOUSVERSION);
        raw.add(PREVIOUSPATCH);
        raw.add(FINISHED);
        raw.add(MESSAGE);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public ome.model.internal.Details newInstance() {
            return new Details();
        }

        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=false)
        @ForeignKey(name="FKdbpatch_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }
    }
}

