/*
 * Decompiled with CFR 0.152.
 */
package IceSSL;

import Ice.BooleanHolder;
import Ice.CommunicatorDestroyedException;
import Ice.ConnectionLostException;
import Ice.LocalException;
import Ice.Logger;
import Ice.MemoryLimitException;
import Ice.SecurityException;
import Ice.SocketException;
import Ice.Stats;
import IceInternal.Buffer;
import IceInternal.Network;
import IceInternal.SocketStatus;
import IceInternal.Transceiver;
import IceSSL.ConnectionInfo;
import IceSSL.Instance;
import IceSSL.Util;
import IceUtilInternal.Assert;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;

final class TransceiverI
implements Transceiver {
    private Instance _instance;
    private SocketChannel _fd;
    private SSLEngine _engine;
    private String _host;
    private String _adapterName;
    private boolean _incoming;
    private int _state;
    private Logger _logger;
    private Stats _stats;
    private String _desc;
    private int _maxPacketSize;
    private ByteBuffer _appInput;
    private ByteBuffer _netInput;
    private ByteBuffer _netOutput;
    private static ByteBuffer _emptyBuffer = ByteBuffer.allocate(0);
    private ConnectionInfo _info;
    private static final int StateNeedConnect = 0;
    private static final int StateConnectPending = 1;
    private static final int StateConnected = 2;
    private static final int StateHandshakeComplete = 3;

    public SelectableChannel fd() {
        assert (this._fd != null);
        return this._fd;
    }

    public SocketStatus initialize() {
        try {
            if (this._state == 0) {
                this._state = 1;
                return SocketStatus.NeedConnect;
            }
            if (this._state <= 1) {
                Network.doFinishConnect(this._fd);
                this._state = 2;
                this._desc = Network.fdToString(this._fd);
            }
            assert (this._state == 2);
            SocketStatus status = this.handshakeNonBlocking();
            if (status != SocketStatus.Finished) {
                return status;
            }
        }
        catch (LocalException ex) {
            if (this._instance.networkTraceLevel() >= 2) {
                String s = "failed to establish ssl connection\n" + this._desc + "\n" + ex;
                this._logger.trace(this._instance.networkTraceCategory(), s);
            }
            throw ex;
        }
        return SocketStatus.Finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this._instance.networkTraceLevel() >= 1) {
            String s = "closing ssl connection\n" + this.toString();
            this._logger.trace(this._instance.networkTraceCategory(), s);
        }
        assert (this._fd != null);
        if (this._state >= 2) {
            try {
                this._engine.closeOutbound();
                this._netOutput.clear();
                while (!this._engine.isOutboundDone()) {
                    this._engine.wrap(_emptyBuffer, this._netOutput);
                    try {
                        this.flushNonBlocking();
                    }
                    catch (LocalException ex) {}
                }
            }
            catch (SSLException ex) {
                // empty catch block
            }
            try {
                this._engine.closeInbound();
            }
            catch (SSLException sSLException) {
                // empty catch block
            }
        }
        try {
            Network.closeSocket(this._fd);
            Object var3_5 = null;
            this._fd = null;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this._fd = null;
            throw throwable;
        }
    }

    public boolean write(Buffer buf) {
        if (this._state < 3) {
            throw new ConnectionLostException();
        }
        SocketStatus status = this.writeNonBlocking(buf.b);
        if (status != SocketStatus.Finished) {
            assert (status == SocketStatus.NeedWrite);
            return false;
        }
        return true;
    }

    public boolean read(Buffer buf, BooleanHolder moreData) {
        if (this._state < 3) {
            throw new ConnectionLostException();
        }
        int rem = 0;
        if (this._instance.networkTraceLevel() >= 3) {
            rem = buf.b.remaining();
        }
        int pos = buf.b.position();
        this.fill(buf.b);
        if (this._instance.networkTraceLevel() >= 3 && buf.b.position() > pos) {
            String s = "received " + (buf.b.position() - pos) + " of " + rem + " bytes via ssl\n" + this.toString();
            this._logger.trace(this._instance.networkTraceCategory(), s);
        }
        if (this._stats != null && buf.b.position() > pos) {
            this._stats.bytesReceived(this.type(), buf.b.position() - pos);
        }
        try {
            block7: while (buf.b.hasRemaining()) {
                this._netInput.flip();
                SSLEngineResult result = this._engine.unwrap(this._netInput, this._appInput);
                this._netInput.compact();
                switch (result.getStatus()) {
                    case BUFFER_OVERFLOW: {
                        assert (false);
                        break;
                    }
                    case BUFFER_UNDERFLOW: {
                        SocketStatus status = this.readNonBlocking();
                        if (status == SocketStatus.Finished) continue block7;
                        assert (status == SocketStatus.NeedRead);
                        moreData.value = false;
                        return false;
                    }
                    case CLOSED: {
                        throw new ConnectionLostException();
                    }
                }
                pos = buf.b.position();
                this.fill(buf.b);
                if (this._instance.networkTraceLevel() >= 3 && buf.b.position() > pos) {
                    String s = "received " + (buf.b.position() - pos) + " of " + rem + " bytes via ssl\n" + this.toString();
                    this._logger.trace(this._instance.networkTraceCategory(), s);
                }
                if (this._stats == null || buf.b.position() <= pos) continue;
                this._stats.bytesReceived(this.type(), buf.b.position() - pos);
            }
        }
        catch (SSLException ex) {
            SecurityException e = new SecurityException();
            e.reason = "IceSSL: error during read";
            e.initCause(ex);
            throw e;
        }
        moreData.value = this._netInput.position() > 0;
        return true;
    }

    public String type() {
        return "ssl";
    }

    public String toString() {
        return this._desc;
    }

    public void checkSendSize(Buffer buf, int messageSizeMax) {
        if (buf.size() > messageSizeMax) {
            throw new MemoryLimitException();
        }
    }

    ConnectionInfo getConnectionInfo() {
        assert (this._fd != null);
        return this._info;
    }

    TransceiverI(Instance instance, SSLEngine engine, SocketChannel fd, String host, boolean connected, boolean incoming, String adapterName) {
        this._instance = instance;
        this._engine = engine;
        this._fd = fd;
        this._host = host;
        this._adapterName = adapterName;
        this._incoming = incoming;
        this._state = connected ? 2 : 0;
        this._logger = instance.communicator().getLogger();
        try {
            this._stats = instance.communicator().getStats();
        }
        catch (CommunicatorDestroyedException ex) {
            // empty catch block
        }
        this._desc = Network.fdToString(this._fd);
        this._maxPacketSize = 0;
        if (System.getProperty("os.name").startsWith("Windows")) {
            this._maxPacketSize = Network.getSendBufferSize(this._fd) / 2;
            if (this._maxPacketSize < 512) {
                this._maxPacketSize = 0;
            }
        }
        this._appInput = ByteBuffer.allocateDirect(engine.getSession().getApplicationBufferSize() * 2);
        this._netInput = ByteBuffer.allocateDirect(engine.getSession().getPacketBufferSize() * 2);
        this._netOutput = ByteBuffer.allocateDirect(engine.getSession().getPacketBufferSize() * 2);
    }

    protected void finalize() throws Throwable {
        Assert.FinalizerAssert(this._fd == null);
        super.finalize();
    }

    private SocketStatus handshakeNonBlocking() {
        try {
            SSLEngineResult.HandshakeStatus status = this._engine.getHandshakeStatus();
            while (this._state != 3) {
                SSLEngineResult result = null;
                switch (status) {
                    case FINISHED: {
                        this.handshakeCompleted();
                        break;
                    }
                    case NEED_TASK: {
                        Runnable task;
                        while ((task = this._engine.getDelegatedTask()) != null) {
                            task.run();
                        }
                        status = this._engine.getHandshakeStatus();
                        break;
                    }
                    case NEED_UNWRAP: {
                        SocketStatus ss;
                        this._netInput.flip();
                        result = this._engine.unwrap(this._netInput, this._appInput);
                        this._netInput.compact();
                        status = result.getHandshakeStatus();
                        switch (result.getStatus()) {
                            case BUFFER_OVERFLOW: {
                                assert (false);
                                break;
                            }
                            case BUFFER_UNDERFLOW: {
                                assert (status == SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
                                ss = this.readNonBlocking();
                                if (ss == SocketStatus.Finished) break;
                                return ss;
                            }
                            case CLOSED: {
                                throw new ConnectionLostException();
                            }
                        }
                        break;
                    }
                    case NEED_WRAP: {
                        SocketStatus ss;
                        result = this._engine.wrap(_emptyBuffer, this._netOutput);
                        if (result.bytesProduced() > 0 && (ss = this.flushNonBlocking()) != SocketStatus.Finished) {
                            return ss;
                        }
                        status = result.getHandshakeStatus();
                        break;
                    }
                    case NOT_HANDSHAKING: {
                        assert (false);
                        break;
                    }
                }
                if (result == null) continue;
                switch (result.getStatus()) {
                    case BUFFER_OVERFLOW: {
                        assert (false);
                        break;
                    }
                    case BUFFER_UNDERFLOW: {
                        assert (status == SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
                        break;
                    }
                    case CLOSED: {
                        throw new ConnectionLostException();
                    }
                }
            }
        }
        catch (SSLException ex) {
            SecurityException e = new SecurityException();
            e.reason = "IceSSL: handshake error";
            e.initCause(ex);
            throw e;
        }
        return SocketStatus.Finished;
    }

    private void handshakeCompleted() {
        int verifyPeer;
        this._state = 3;
        if (!this._incoming && (verifyPeer = this._instance.communicator().getProperties().getPropertyAsIntWithDefault("IceSSL.VerifyPeer", 2)) > 0) {
            try {
                this._engine.getSession().getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException ex) {
                SecurityException e = new SecurityException();
                e.reason = "IceSSL: server did not supply a certificate";
                e.initCause(ex);
                throw e;
            }
        }
        this._info = Util.populateConnectionInfo(this._engine.getSession(), this._fd.socket(), this._adapterName, this._incoming);
        this._instance.verifyPeer(this._info, this._fd, this._host, this._incoming);
        if (this._instance.networkTraceLevel() >= 1) {
            String s = this._incoming ? "accepted ssl connection\n" + this._desc : "ssl connection established\n" + this._desc;
            this._logger.trace(this._instance.networkTraceCategory(), s);
        }
        if (this._instance.securityTraceLevel() >= 1) {
            this._instance.traceConnection(this._fd, this._engine, this._incoming);
        }
    }

    private SocketStatus writeNonBlocking(ByteBuffer buf) {
        try {
            while (buf.hasRemaining() || this._netOutput.position() > 0) {
                SocketStatus ss;
                int rem = buf.remaining();
                if (rem > 0) {
                    SSLEngineResult result = this._engine.wrap(buf, this._netOutput);
                    switch (result.getStatus()) {
                        case BUFFER_OVERFLOW: {
                            break;
                        }
                        case BUFFER_UNDERFLOW: {
                            assert (false);
                            break;
                        }
                        case CLOSED: {
                            throw new ConnectionLostException();
                        }
                    }
                    if (result.bytesConsumed() > 0) {
                        if (this._instance.networkTraceLevel() >= 3) {
                            String s = "sent " + result.bytesConsumed() + " of " + rem + " bytes via ssl\n" + this.toString();
                            this._logger.trace(this._instance.networkTraceCategory(), s);
                        }
                        if (this._stats != null) {
                            this._stats.bytesSent(this.type(), result.bytesConsumed());
                        }
                    }
                }
                if (this._netOutput.position() <= 0 || (ss = this.flushNonBlocking()) == SocketStatus.Finished) continue;
                assert (ss == SocketStatus.NeedWrite);
                return ss;
            }
        }
        catch (SSLException ex) {
            SecurityException e = new SecurityException();
            e.reason = "IceSSL: error while encoding message";
            e.initCause(ex);
            throw e;
        }
        assert (this._netOutput.position() == 0);
        return SocketStatus.Finished;
    }

    private SocketStatus flushNonBlocking() {
        this._netOutput.flip();
        int size = this._netOutput.limit();
        int packetSize = size - this._netOutput.position();
        if (this._maxPacketSize > 0 && packetSize > this._maxPacketSize) {
            packetSize = this._maxPacketSize;
            this._netOutput.limit(this._netOutput.position() + packetSize);
        }
        SocketStatus status = SocketStatus.Finished;
        while (this._netOutput.hasRemaining()) {
            try {
                assert (this._fd != null);
                int ret = this._fd.write(this._netOutput);
                if (ret == -1) {
                    throw new ConnectionLostException();
                }
                if (ret == 0) {
                    status = SocketStatus.NeedWrite;
                    break;
                }
                if (packetSize != this._maxPacketSize) continue;
                assert (this._netOutput.position() == this._netOutput.limit());
                packetSize = size - this._netOutput.position();
                if (packetSize > this._maxPacketSize) {
                    packetSize = this._maxPacketSize;
                }
                this._netOutput.limit(this._netOutput.position() + packetSize);
            }
            catch (InterruptedIOException ex) {
            }
            catch (IOException ex) {
                if (Network.connectionLost(ex)) {
                    ConnectionLostException se = new ConnectionLostException();
                    se.initCause(ex);
                    throw se;
                }
                SocketException se = new SocketException();
                se.initCause(ex);
                throw se;
            }
        }
        if (status == SocketStatus.Finished) {
            this._netOutput.clear();
        } else {
            this._netOutput.limit(size);
            this._netOutput.compact();
        }
        return status;
    }

    private SocketStatus readNonBlocking() {
        while (true) {
            try {
                assert (this._fd != null);
                int ret = this._fd.read(this._netInput);
                if (ret == -1) {
                    throw new ConnectionLostException();
                }
                if (ret == 0) {
                    return SocketStatus.NeedRead;
                }
            }
            catch (InterruptedIOException ex) {
                continue;
            }
            catch (IOException ex) {
                if (Network.connectionLost(ex)) {
                    ConnectionLostException se = new ConnectionLostException();
                    se.initCause(ex);
                    throw se;
                }
                SocketException se = new SocketException();
                se.initCause(ex);
                throw se;
            }
            break;
        }
        return SocketStatus.Finished;
    }

    private void fill(ByteBuffer buf) {
        this._appInput.flip();
        if (this._appInput.hasRemaining()) {
            int bytesNeeded;
            int bytesAvailable = this._appInput.remaining();
            if (bytesAvailable > (bytesNeeded = buf.remaining())) {
                bytesAvailable = bytesNeeded;
            }
            if (buf.hasArray()) {
                byte[] arr = buf.array();
                int offset = buf.arrayOffset() + buf.position();
                this._appInput.get(arr, offset, bytesAvailable);
                buf.position(offset + bytesAvailable);
            } else if (this._appInput.hasArray()) {
                byte[] arr = this._appInput.array();
                int offset = this._appInput.arrayOffset() + this._appInput.position();
                buf.put(arr, offset, bytesAvailable);
                this._appInput.position(offset + bytesAvailable);
            } else {
                byte[] arr = new byte[bytesAvailable];
                this._appInput.get(arr);
                buf.put(arr);
            }
        }
        this._appInput.compact();
    }
}

