/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.BooleanHolder;
import Ice.ConnectionLostException;
import Ice.LocalException;
import Ice.Logger;
import Ice.MemoryLimitException;
import Ice.SocketException;
import Ice.Stats;
import IceInternal.Buffer;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.SocketStatus;
import IceInternal.TraceLevels;
import IceInternal.Transceiver;
import IceUtilInternal.Assert;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;

final class TcpTransceiver
implements Transceiver {
    private SocketChannel _fd;
    private TraceLevels _traceLevels;
    private Logger _logger;
    private Stats _stats;
    private String _desc;
    private int _state;
    private int _maxPacketSize;
    private static final int StateNeedConnect = 0;
    private static final int StateConnectPending = 1;
    private static final int StateConnected = 2;

    public SelectableChannel fd() {
        assert (this._fd != null);
        return this._fd;
    }

    public SocketStatus initialize() {
        if (this._state == 0) {
            this._state = 1;
            return SocketStatus.NeedConnect;
        }
        if (this._state <= 1) {
            try {
                Network.doFinishConnect(this._fd);
                this._state = 2;
                this._desc = Network.fdToString(this._fd);
            }
            catch (LocalException ex) {
                if (this._traceLevels.network >= 2) {
                    String s = "failed to establish tcp connection\n" + this._desc + "\n" + ex;
                    this._logger.trace(this._traceLevels.networkCat, s);
                }
                throw ex;
            }
            if (this._traceLevels.network >= 1) {
                String s = "tcp connection established\n" + this._desc;
                this._logger.trace(this._traceLevels.networkCat, s);
            }
        }
        assert (this._state == 2);
        return SocketStatus.Finished;
    }

    public void close() {
        if (this._traceLevels.network >= 1) {
            String s = "closing tcp connection\n" + this.toString();
            this._logger.trace(this._traceLevels.networkCat, s);
        }
        assert (this._fd != null);
        try {
            try {
                this._fd.close();
            }
            catch (IOException ex) {
                SocketException se = new SocketException();
                se.initCause(ex);
                throw se;
            }
            Object var4_3 = null;
            this._fd = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._fd = null;
            throw throwable;
        }
    }

    public boolean write(Buffer buf) {
        int size = buf.b.limit();
        int packetSize = size - buf.b.position();
        if (this._maxPacketSize > 0 && packetSize > this._maxPacketSize) {
            packetSize = this._maxPacketSize;
            buf.b.limit(buf.b.position() + packetSize);
        }
        while (buf.b.hasRemaining()) {
            try {
                assert (this._fd != null);
                int ret = this._fd.write(buf.b);
                if (ret == -1) {
                    throw new ConnectionLostException();
                }
                if (ret == 0) {
                    if (packetSize == this._maxPacketSize) {
                        buf.b.limit(size);
                    }
                    return false;
                }
                if (this._traceLevels.network >= 3) {
                    String s = "sent " + ret + " of " + size + " bytes via tcp\n" + this.toString();
                    this._logger.trace(this._traceLevels.networkCat, s);
                }
                if (this._stats != null) {
                    this._stats.bytesSent(this.type(), ret);
                }
                if (packetSize != this._maxPacketSize) continue;
                assert (buf.b.position() == buf.b.limit());
                packetSize = size - buf.b.position();
                if (packetSize > this._maxPacketSize) {
                    packetSize = this._maxPacketSize;
                }
                buf.b.limit(buf.b.position() + packetSize);
            }
            catch (InterruptedIOException ex) {
            }
            catch (IOException ex) {
                SocketException se = new SocketException();
                se.initCause(ex);
                throw se;
            }
        }
        return true;
    }

    public boolean read(Buffer buf, BooleanHolder moreData) {
        int remaining = 0;
        if (this._traceLevels.network >= 3) {
            remaining = buf.b.remaining();
        }
        moreData.value = false;
        while (buf.b.hasRemaining()) {
            try {
                assert (this._fd != null);
                int ret = this._fd.read(buf.b);
                if (ret == -1) {
                    throw new ConnectionLostException();
                }
                if (ret == 0) {
                    return false;
                }
                if (ret <= 0) continue;
                if (this._traceLevels.network >= 3) {
                    String s = "received " + ret + " of " + remaining + " bytes via tcp\n" + this.toString();
                    this._logger.trace(this._traceLevels.networkCat, s);
                }
                if (this._stats == null) continue;
                this._stats.bytesReceived(this.type(), ret);
            }
            catch (InterruptedIOException ex) {
            }
            catch (IOException ex) {
                SocketException se;
                if (Network.connectionLost(ex)) {
                    se = new ConnectionLostException();
                    se.initCause(ex);
                    throw se;
                }
                se = new SocketException();
                se.initCause(ex);
                throw se;
            }
        }
        return true;
    }

    public String type() {
        return "tcp";
    }

    public String toString() {
        return this._desc;
    }

    public void checkSendSize(Buffer buf, int messageSizeMax) {
        if (buf.size() > messageSizeMax) {
            throw new MemoryLimitException();
        }
    }

    TcpTransceiver(Instance instance, SocketChannel fd, boolean connected) {
        this._fd = fd;
        this._traceLevels = instance.traceLevels();
        this._logger = instance.initializationData().logger;
        this._stats = instance.initializationData().stats;
        this._state = connected ? 2 : 0;
        this._desc = Network.fdToString(this._fd);
        this._maxPacketSize = 0;
        if (System.getProperty("os.name").startsWith("Windows")) {
            this._maxPacketSize = Network.getSendBufferSize(this._fd) / 2;
            if (this._maxPacketSize < 512) {
                this._maxPacketSize = 0;
            }
        }
    }

    protected synchronized void finalize() throws Throwable {
        Assert.FinalizerAssert(this._fd == null);
        super.finalize();
    }
}

