/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.SocketException;
import IceInternal.Instance;
import IceInternal.Selector;
import IceInternal.SelectorHandler;
import IceInternal.SocketStatus;
import IceInternal.Timer;
import IceInternal.TimerTask;
import IceUtilInternal.Assert;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;

public class SelectorThread {
    private Instance _instance;
    private boolean _destroyed;
    private Selector _selector;
    private LinkedList<SocketReadyCallback> _finished = new LinkedList();
    private HelperThread _thread;
    private Timer _timer;

    SelectorThread(Instance instance) {
        this._instance = instance;
        this._destroyed = false;
        this._selector = new Selector(instance, 0);
        this._thread = new HelperThread();
        this._thread.start();
        this._timer = this._instance.timer();
    }

    protected synchronized void finalize() throws Throwable {
        Assert.FinalizerAssert(this._destroyed);
    }

    public synchronized void destroy() {
        assert (!this._destroyed);
        this._destroyed = true;
        this._selector.setInterrupt();
    }

    public synchronized void _register(SocketReadyCallback cb, SocketStatus status, int timeout) {
        assert (!this._destroyed);
        assert (status != SocketStatus.Finished);
        cb._timeout = timeout;
        cb._status = status;
        if (cb._timeout >= 0) {
            this._timer.schedule(cb, cb._timeout);
        }
        this._selector.add(cb, status);
    }

    public synchronized void unregister(SocketReadyCallback cb) {
        assert (!this._destroyed);
        assert (cb._status != SocketStatus.Finished);
        this._selector.remove(cb);
        cb._status = SocketStatus.Finished;
    }

    public synchronized void finish(SocketReadyCallback cb) {
        assert (!this._destroyed);
        assert (cb._status != SocketStatus.Finished);
        this._selector.remove(cb);
        cb._status = SocketStatus.Finished;
        this._finished.add(cb);
        this._selector.setInterrupt();
    }

    public void joinWithThread() {
        if (this._thread != null) {
            try {
                this._thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        block10: while (true) {
            try {
                this._selector.select();
            }
            catch (IOException ex) {
                se = new SocketException();
                se.initCause(ex);
                sw = new StringWriter();
                pw = new PrintWriter((Writer)sw);
                se.printStackTrace(pw);
                pw.flush();
                s = "exception in selector thread:\n" + sw.toString();
                this._instance.initializationData().logger.error(s);
                continue;
            }
            readyList = new LinkedList<SocketReadyCallback>();
            finished = false;
            sw = this;
            synchronized (sw) {
                this._selector.checkTimeout();
                if (this._selector.isInterrupted()) {
                    if (this._selector.processInterrupt()) {
                        continue;
                    }
                    if (this._destroyed) {
                        break;
                    }
                    do {
                        cb = this._finished.removeFirst();
                        cb._previousStatus = SocketStatus.Finished;
                        readyList.add(cb);
                    } while (this._selector.clearInterrupt());
                    finished = true;
                } else {
                    while ((cb = (SocketReadyCallback)this._selector.getNextSelected()) != null) {
                        cb._previousStatus = cb._status;
                        readyList.add(cb);
                    }
                }
            }
            iter = readyList.iterator();
            while (true) {
                if (iter.hasNext()) ** break;
                continue block10;
                status = SocketStatus.Finished;
                cb = (SocketReadyCallback)iter.next();
                try {
                    if (cb._timeout >= 0) {
                        this._timer.cancel(cb);
                    }
                    if (finished) {
                        cb.socketFinished();
                    } else {
                        status = cb.socketReady();
                    }
                }
                catch (Exception ex) {
                    sw = new StringWriter();
                    pw = new PrintWriter(sw);
                    ex.printStackTrace(pw);
                    pw.flush();
                    s = "exception in selector thread " + this._thread.getName() + " while calling socketReady():\n" + sw.toString();
                    this._instance.initializationData().logger.error(s);
                    status = SocketStatus.Finished;
                }
                if (status == SocketStatus.Finished) continue;
                if (cb.hasMoreData()) {
                    this._selector.hasMoreData(cb);
                }
                if (status != cb._previousStatus) {
                    var6_8 = this;
                    synchronized (var6_8) {
                        if (cb._status != SocketStatus.Finished) {
                            this._selector.update(cb, status);
                            cb._status = status;
                        }
                    }
                }
                if (cb._timeout < 0) continue;
                this._timer.schedule(cb, cb._timeout);
            }
            break;
        }
        if (!SelectorThread.$assertionsDisabled && !this._destroyed) {
            throw new AssertionError();
        }
        this._selector.destroy();
    }

    private final class HelperThread
    extends Thread {
        HelperThread() {
            String threadName = ((SelectorThread)SelectorThread.this)._instance.initializationData().properties.getProperty("Ice.ProgramName");
            if (threadName.length() > 0) {
                threadName = threadName + "-";
            }
            this.setName(threadName + "Ice.SelectorThread");
        }

        public void run() {
            try {
                SelectorThread.this.run();
            }
            catch (Exception ex) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                pw.flush();
                String s = "exception in selector thread " + this.getName() + ":\n" + sw.toString();
                ((SelectorThread)SelectorThread.this)._instance.initializationData().logger.error(s);
            }
        }
    }

    public static abstract class SocketReadyCallback
    extends SelectorHandler
    implements TimerTask {
        protected int _timeout;
        protected SocketStatus _status;
        protected SocketStatus _previousStatus;

        public abstract SocketStatus socketReady();

        public abstract void socketFinished();
    }
}

