/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.AlreadyRegisteredException;
import Ice.Communicator;
import Ice.CommunicatorDestroyedException;
import Ice.InitializationException;
import Ice.NotRegisteredException;
import Ice.Plugin;
import Ice.PluginFactory;
import Ice.PluginInitializationException;
import Ice.PluginManager;
import Ice.Properties;
import Ice.StringSeqHolder;
import Ice.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public final class PluginManagerI
implements PluginManager {
    private static String _kindOfObject = "plugin";
    private Communicator _communicator;
    private Map<String, Plugin> _plugins = new HashMap<String, Plugin>();
    private List<Plugin> _initOrder = new ArrayList<Plugin>();
    private boolean _initialized;

    public synchronized void initializePlugins() {
        if (this._initialized) {
            InitializationException ex = new InitializationException();
            ex.reason = "plug-ins already initialized";
            throw ex;
        }
        ArrayList<Plugin> initializedPlugins = new ArrayList<Plugin>();
        try {
            for (Plugin p : this._initOrder) {
                p.initialize();
                initializedPlugins.add(p);
            }
        }
        catch (RuntimeException ex) {
            ListIterator i = initializedPlugins.listIterator(initializedPlugins.size());
            while (i.hasPrevious()) {
                Plugin p = (Plugin)i.previous();
                try {
                    p.destroy();
                }
                catch (RuntimeException e) {}
            }
            throw ex;
        }
        this._initialized = true;
    }

    public synchronized Plugin getPlugin(String name) {
        if (this._communicator == null) {
            throw new CommunicatorDestroyedException();
        }
        Plugin p = this._plugins.get(name);
        if (p != null) {
            return p;
        }
        NotRegisteredException ex = new NotRegisteredException();
        ex.id = name;
        ex.kindOfObject = _kindOfObject;
        throw ex;
    }

    public synchronized void addPlugin(String name, Plugin plugin) {
        if (this._communicator == null) {
            throw new CommunicatorDestroyedException();
        }
        if (this._plugins.containsKey(name)) {
            AlreadyRegisteredException ex = new AlreadyRegisteredException();
            ex.id = name;
            ex.kindOfObject = _kindOfObject;
            throw ex;
        }
        this._plugins.put(name, plugin);
    }

    public synchronized void destroy() {
        if (this._communicator != null) {
            if (this._initialized) {
                for (Map.Entry<String, Plugin> entry : this._plugins.entrySet()) {
                    try {
                        Plugin p = entry.getValue();
                        p.destroy();
                    }
                    catch (RuntimeException ex) {
                        Util.getProcessLogger().warning("unexpected exception raised by plug-in `" + entry.getKey() + "' destruction:\n" + ex.toString());
                    }
                }
            }
            this._communicator = null;
        }
    }

    public PluginManagerI(Communicator communicator) {
        this._communicator = communicator;
        this._initialized = false;
    }

    public void loadPlugins(StringSeqHolder cmdArgs) {
        assert (this._communicator != null);
        String prefix = "Ice.Plugin.";
        Properties properties = this._communicator.getProperties();
        Map<String, String> plugins = properties.getPropertiesForPrefix("Ice.Plugin.");
        String[] loadOrder = properties.getPropertyAsList("Ice.PluginLoadOrder");
        for (int i = 0; i < loadOrder.length; ++i) {
            if (this._plugins.containsKey(loadOrder[i])) {
                PluginInitializationException ex = new PluginInitializationException();
                ex.reason = "plug-in `" + loadOrder[i] + "' already loaded";
                throw ex;
            }
            String key = "Ice.Plugin." + loadOrder[i] + ".java";
            boolean hasKey = plugins.containsKey(key);
            if (hasKey) {
                plugins.remove("Ice.Plugin." + loadOrder[i]);
            } else {
                key = "Ice.Plugin." + loadOrder[i];
                hasKey = plugins.containsKey(key);
            }
            if (!hasKey) {
                PluginInitializationException ex = new PluginInitializationException();
                ex.reason = "plug-in `" + loadOrder[i] + "' not defined";
                throw ex;
            }
            String value = plugins.get(key);
            this.loadPlugin(loadOrder[i], value, cmdArgs);
            plugins.remove(key);
        }
        while (!plugins.isEmpty()) {
            Iterator<Map.Entry<String, String>> p = plugins.entrySet().iterator();
            Map.Entry<String, String> entry = p.next();
            String name = entry.getKey().substring("Ice.Plugin.".length());
            int dotPos = name.lastIndexOf(46);
            if (dotPos != -1) {
                String suffix = name.substring(dotPos + 1);
                if (suffix.equals("cpp") || suffix.equals("clr")) {
                    p.remove();
                } else if (suffix.equals("java")) {
                    name = name.substring(0, dotPos);
                    this.loadPlugin(name, entry.getValue(), cmdArgs);
                    p.remove();
                    plugins.remove("Ice.Plugin." + name);
                } else {
                    dotPos = -1;
                }
            }
            if (dotPos != -1) continue;
            String value = entry.getValue();
            p.remove();
            String javaValue = plugins.remove("Ice.Plugin." + name + ".java");
            if (javaValue != null) {
                value = javaValue;
            }
            this.loadPlugin(name, value, cmdArgs);
        }
        if (properties.getPropertyAsIntWithDefault("Ice.InitPlugins", 1) > 0) {
            this.initializePlugins();
        }
    }

    private void loadPlugin(String name, String pluginSpec, StringSeqHolder cmdArgs) {
        String[] args;
        String className;
        assert (this._communicator != null);
        int pos = pluginSpec.indexOf(32);
        if (pos == -1) {
            pos = pluginSpec.indexOf(9);
        }
        if (pos == -1) {
            pos = pluginSpec.indexOf(10);
        }
        if (pos == -1) {
            className = pluginSpec;
            args = new String[]{};
        } else {
            className = pluginSpec.substring(0, pos);
            args = pluginSpec.substring(pos).trim().split("[ \t\n]+", pos);
        }
        Properties properties = this._communicator.getProperties();
        args = properties.parseCommandLineOptions(name, args);
        cmdArgs.value = properties.parseCommandLineOptions(name, cmdArgs.value);
        PluginFactory pluginFactory = null;
        try {
            Class<?> c = Class.forName(className);
            Object obj = c.newInstance();
            try {
                pluginFactory = (PluginFactory)obj;
            }
            catch (ClassCastException ex) {
                PluginInitializationException e = new PluginInitializationException();
                e.reason = "class " + className + " does not implement Ice.PluginFactory";
                e.initCause(ex);
                throw e;
            }
        }
        catch (ClassNotFoundException ex) {
            PluginInitializationException e = new PluginInitializationException();
            e.reason = "class " + className + " not found";
            e.initCause(ex);
            throw e;
        }
        catch (IllegalAccessException ex) {
            PluginInitializationException e = new PluginInitializationException();
            e.reason = "unable to access default constructor in class " + className;
            e.initCause(ex);
            throw e;
        }
        catch (InstantiationException ex) {
            PluginInitializationException e = new PluginInitializationException();
            e.reason = "unable to instantiate class " + className;
            e.initCause(ex);
            throw e;
        }
        Plugin plugin = null;
        try {
            plugin = pluginFactory.create(this._communicator, name, args);
        }
        catch (PluginInitializationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            PluginInitializationException e = new PluginInitializationException();
            e.reason = "exception in factory " + className;
            e.initCause(ex);
            throw e;
        }
        if (plugin == null) {
            PluginInitializationException e = new PluginInitializationException();
            e.reason = "failure in factory " + className;
            throw e;
        }
        this._plugins.put(name, plugin);
        this._initOrder.add(plugin);
    }
}

