/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import Freeze.Catalog;
import Freeze.CatalogData;
import Freeze.CatalogIndexList;
import Freeze.Connection;
import Freeze.ConnectionI;
import Freeze.DatabaseException;
import Freeze.DeadlockException;
import Freeze.IndexNotFoundException;
import Freeze.Map;
import Freeze.NotFoundException;
import Freeze.Transaction;
import Freeze.Util;
import Ice.Communicator;
import Ice.Properties;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseType;
import com.sleepycat.db.Environment;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;

class MapDb {
    private Database _db;
    private final Communicator _communicator;
    private final String _dbName;
    private final String _errorPrefix;
    private String _key;
    private String _value;
    private final int _trace;
    private Map.Index[] _indices;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    MapDb(ConnectionI connection, String dbName, String key, String value, Comparator comparator, Map.Index[] indices, Map indexComparators, boolean createDb) {
        Transaction tx;
        int pageSize;
        boolean checksum;
        String propPrefix;
        Properties properties;
        int btreeMinKey;
        this._communicator = connection.communicator();
        this._dbName = dbName;
        this._errorPrefix = "Freeze DB DbEnv(\"" + connection.dbEnv().getEnvName() + "\") Db(\"" + dbName + "\"): ";
        this._indices = indices;
        this._trace = connection.trace();
        Catalog catalog = new Catalog((Connection)connection, Util.catalogName(), true);
        CatalogData catalogData = (CatalogData)catalog.get(this._dbName);
        if (catalogData != null) {
            if (catalogData.evictor) {
                throw new DatabaseException(this._errorPrefix + "is not an evictor");
            }
            this._key = catalogData.key;
            this._value = catalogData.value;
            this.checkTypes(key, value);
        } else {
            this._key = key;
            this._value = value;
        }
        DatabaseConfig config = new DatabaseConfig();
        config.setAllowCreate(createDb);
        config.setType(DatabaseType.BTREE);
        if (comparator != null) {
            config.setBtreeComparator(comparator);
        }
        if ((btreeMinKey = (properties = this._communicator.getProperties()).getPropertyAsInt((propPrefix = "Freeze.Map." + this._dbName + ".") + "BtreeMinKey")) > 2) {
            if (this._trace >= 1) {
                this._communicator.getLogger().trace("Freeze.Map", "Setting \"" + this._dbName + "\"'s btree minkey to " + btreeMinKey);
            }
            config.setBtreeMinKey(btreeMinKey);
        }
        boolean bl = checksum = properties.getPropertyAsInt(propPrefix + "Checksum") > 0;
        if (checksum) {
            if (this._trace >= 1) {
                this._communicator.getLogger().trace("Freeze.Map", "Turning checksum on for \"" + this._dbName + "\"");
            }
            config.setChecksum(true);
        }
        if ((pageSize = properties.getPropertyAsInt(propPrefix + "PageSize")) > 0) {
            if (this._trace >= 1) {
                this._communicator.getLogger().trace("Freeze.Map", "Setting \"" + this._dbName + "\"'s pagesize to " + pageSize);
            }
            config.setPageSize(pageSize);
        }
        if (this._trace >= 1) {
            this._communicator.getLogger().trace("Freeze.Map", "opening Db \"" + this._dbName + "\"");
        }
        boolean ownTx = (tx = connection.currentTransaction()) == null;
        while (true) {
            if (ownTx) {
                tx = null;
                tx = connection.beginTransaction();
            }
            com.sleepycat.db.Transaction txn = Util.getTxn(tx);
            this._db = connection.dbEnv().getEnv().openDatabase(txn, this._dbName, null, config);
            String[] oldIndices = null;
            LinkedList<String> newIndices = new LinkedList<String>();
            CatalogIndexList catalogIndexList = new CatalogIndexList((Connection)connection, Util.catalogIndexListName(), true);
            if (createDb) {
                oldIndices = (String[])catalogIndexList.get(this._dbName);
            }
            if (this._indices != null) {
                for (int i = 0; i < this._indices.length; ++i) {
                    int j;
                    String indexName = this._indices[i].name();
                    Comparator indexComparator = null;
                    if (indexComparators != null) {
                        indexComparator = (Comparator)indexComparators.get(indexName);
                    }
                    this._indices[i].associate(this._dbName, this._db, txn, createDb, indexComparator);
                    if (!createDb) continue;
                    if (oldIndices != null && (j = Arrays.asList(oldIndices).indexOf(indexName)) != -1) {
                        oldIndices[j] = null;
                    }
                    newIndices.add(indexName);
                }
            }
            if (catalogData == null) {
                catalogData = new CatalogData();
                catalogData.evictor = false;
                catalogData.key = key;
                catalogData.value = value;
                catalog.put(this._dbName, catalogData);
            }
            if (createDb) {
                int oldSize;
                boolean indexRemoved = false;
                if (oldIndices != null) {
                    for (int i = 0; i < oldIndices.length; ++i) {
                        String index = oldIndices[i];
                        if (index == null) continue;
                        if (this._trace >= 1) {
                            this._communicator.getLogger().trace("Freeze.Map", "removing old index \"" + index + "\" on Db \"" + this._dbName + "\"");
                        }
                        indexRemoved = true;
                        try {
                            connection.removeMapIndex(this._dbName, index);
                            continue;
                        }
                        catch (IndexNotFoundException ife) {
                            if (this._trace < 1) continue;
                            this._communicator.getLogger().trace("Freeze.Map", "index \"" + index + "\" on Db \"" + this._dbName + "\" does not exist");
                        }
                    }
                }
                int n = oldSize = oldIndices == null ? 0 : oldIndices.length;
                if (indexRemoved || newIndices.size() != oldSize) {
                    if (newIndices.size() == 0) {
                        catalogIndexList.remove(this._dbName);
                        if (this._trace >= 1) {
                            this._communicator.getLogger().trace("Freeze.Map", "Removed catalogIndexList entry for Db \"" + this._dbName + "\"");
                        }
                    } else {
                        catalogIndexList.put(this._dbName, newIndices.toArray(new String[0]));
                        if (this._trace >= 1) {
                            this._communicator.getLogger().trace("Freeze.Map", "Updated catalogIndexList entry for Db \"" + this._dbName + "\"");
                        }
                    }
                }
            }
            if (ownTx) {
                try {
                    tx.commit();
                    Object var28_38 = null;
                    tx = null;
                }
                catch (Throwable throwable) {
                    Object var28_39 = null;
                    tx = null;
                    throw throwable;
                }
            }
            Object var30_23 = null;
            if (!ownTx || tx == null) break;
            try {
                tx.rollback();
            }
            catch (DatabaseException de) {}
            break;
            {
                catch (FileNotFoundException dx) {
                    this.clearIndices();
                    NotFoundException ex = new NotFoundException();
                    ex.initCause(dx);
                    ex.message = this._errorPrefix + "Db.open: " + dx.getMessage();
                    throw ex;
                }
                catch (com.sleepycat.db.DeadlockException dx) {
                    if (ownTx) {
                        if (connection.deadlockWarning()) {
                            connection.communicator().getLogger().warning("Deadlock in Freeze.Shared.Shared on Db \"" + this._dbName + "\"; retrying ...");
                        }
                    } else {
                        this.clearIndices();
                        DeadlockException ex = new DeadlockException(this._errorPrefix + "Db.open: " + dx.getMessage(), tx);
                        ex.initCause(dx);
                        throw ex;
                    }
                    tx = null;
                    var30_23 = null;
                    if (!ownTx || tx == null) continue;
                    try {
                        tx.rollback();
                    }
                    catch (DatabaseException de) {}
                    continue;
                }
                catch (com.sleepycat.db.DatabaseException dx) {
                    this.clearIndices();
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(dx);
                    ex.message = this._errorPrefix + "Db.open: " + dx.getMessage();
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                var30_23 = null;
                if (ownTx && tx != null) {
                    try {
                        tx.rollback();
                    }
                    catch (DatabaseException de) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            break;
        }
    }

    MapDb(Communicator communicator, String envName, String dbName, String key, String value, Environment dbEnv) throws com.sleepycat.db.DatabaseException {
        this._communicator = communicator;
        this._dbName = dbName;
        this._errorPrefix = "Freeze DB DbEnv(\"" + envName + "\") Db(\"" + dbName + "\"): ";
        this._key = key;
        this._value = value;
        this._trace = this._communicator.getProperties().getPropertyAsInt("Freeze.Trace.Map");
        if (this._trace >= 1) {
            this._communicator.getLogger().trace("Freeze.Map", "opening Db \"" + this._dbName + "\"");
        }
        DatabaseConfig config = new DatabaseConfig();
        config.setAllowCreate(true);
        config.setType(DatabaseType.BTREE);
        config.setTransactional(true);
        try {
            this._db = dbEnv.openDatabase(null, this._dbName, null, config);
        }
        catch (FileNotFoundException dx) {
            NotFoundException ex = new NotFoundException();
            ex.initCause(dx);
            ex.message = this._errorPrefix + "Db.open: " + dx.getMessage();
            throw ex;
        }
    }

    void close() {
        if (this._trace >= 1) {
            this._communicator.getLogger().trace("Freeze.Map", "closing Db \"" + this._dbName + "\"");
        }
        this.clearIndices();
        if (this._db != null) {
            try {
                try {
                    this._db.close();
                }
                catch (com.sleepycat.db.DatabaseException dx) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(dx);
                    ex.message = this._errorPrefix + "close: " + dx.getMessage();
                    throw ex;
                }
                Object var4_1 = null;
                this._db = null;
            }
            catch (Throwable throwable) {
                Object var4_2 = null;
                this._db = null;
                throw throwable;
            }
        }
    }

    void connectIndices(Map.Index[] indices) {
        if (indices != null) {
            assert (this._indices != null && indices.length == this._indices.length);
            for (int i = 0; i < indices.length; ++i) {
                indices[i].init(this._indices[i]);
            }
        }
    }

    void clearIndices() {
        if (this._indices != null) {
            for (int i = 0; i < this._indices.length; ++i) {
                this._indices[i].close();
            }
            this._indices = null;
        }
    }

    Database db() {
        return this._db;
    }

    String dbName() {
        return this._dbName;
    }

    void checkTypes(String key, String value) {
        if (!key.equals(this._key)) {
            throw new DatabaseException(this._errorPrefix + this._dbName + "'s key type is " + this._key + ", not " + key);
        }
        if (!value.equals(this._value)) {
            throw new DatabaseException(this._errorPrefix + this._dbName + "'s value type is " + this._value + ", not " + value);
        }
    }
}

