/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataRetrieve;

public class ICSWriter
extends FormatWriter {
    private long dimensionOffset;
    private int dimensionLength;
    private long pixelOffset;
    private int lastPlane = -1;

    public ICSWriter() {
        super("Image Cytometry Standard", "ics");
    }

    public void saveBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        this.checkParams(no, buf, x, y, w, h);
        MetadataRetrieve meta = this.getMetadataRetrieve();
        int sizeX = (Integer)meta.getPixelsSizeX(this.series).getValue();
        int sizeY = (Integer)meta.getPixelsSizeY(this.series).getValue();
        int pixelType = FormatTools.pixelTypeFromString(meta.getPixelsType(this.series).toString());
        int bytesPerPixel = FormatTools.getBytesPerPixel(pixelType);
        int rgbChannels = this.getSamplesPerPixel();
        int planeSize = sizeX * sizeY * rgbChannels * bytesPerPixel;
        if (!this.initialized[this.series][no]) {
            this.initialized[this.series][no] = true;
            if (!this.isFullPlane(x, y, w, h)) {
                this.out.seek(this.pixelOffset + (long)((no + 1) * planeSize));
            }
        }
        this.out.seek(this.pixelOffset + (long)(no * planeSize));
        if (this.isFullPlane(x, y, w, h) && (this.interleaved || rgbChannels == 1)) {
            this.out.write(buf);
        } else {
            this.out.skipBytes(bytesPerPixel * rgbChannels * sizeX * y);
            for (int row = 0; row < h; ++row) {
                ByteArrayOutputStream strip = new ByteArrayOutputStream();
                for (int col = 0; col < w; ++col) {
                    for (int c = 0; c < rgbChannels; ++c) {
                        int index = this.interleaved ? rgbChannels * (row * w + col) + c : w * (c * h + row) + col;
                        strip.write(buf, index * bytesPerPixel, bytesPerPixel);
                    }
                }
                this.out.skipBytes(bytesPerPixel * rgbChannels * x);
                this.out.write(strip.toByteArray());
                this.out.skipBytes(bytesPerPixel * rgbChannels * (sizeX - w - x));
            }
        }
        this.lastPlane = no;
    }

    public boolean canDoStacks() {
        return true;
    }

    public int[] getPixelTypes(String codec) {
        return new int[]{0, 1, 2, 3, 4, 5, 6};
    }

    public void setId(String id) throws FormatException, IOException {
        super.setId(id);
        if (this.out.length() == 0L) {
            this.out.writeBytes("\t\n");
            this.out.writeBytes("ics_version\t2.0\n");
            this.out.writeBytes("filename\t" + this.currentId + "\n");
            this.out.writeBytes("layout\tparameters\t6\n");
            MetadataRetrieve meta = this.getMetadataRetrieve();
            MetadataTools.verifyMinimumPopulated(meta, this.series);
            int pixelType = FormatTools.pixelTypeFromString(meta.getPixelsType(this.series).toString());
            this.dimensionOffset = this.out.getFilePointer();
            int[] sizes = this.overwriteDimensions(meta);
            this.dimensionLength = (int)(this.out.getFilePointer() - this.dimensionOffset);
            boolean signed = FormatTools.isSigned(pixelType);
            boolean littleEndian = meta.getPixelsBinDataBigEndian(this.series, 0) == false;
            this.out.writeBytes("representation\tformat\t" + (pixelType == 6 ? "real\n" : "integer\n"));
            this.out.writeBytes("representation\tsign\t" + (signed ? "signed\n" : "unsigned\n"));
            this.out.writeBytes("representation\tcompression\tuncompressed\n");
            this.out.writeBytes("representation\tbyte_order\t");
            for (int i = 0; i < sizes[0] / 8; ++i) {
                if (littleEndian) {
                    this.out.writeBytes(i + 1 + "\t");
                    continue;
                }
                this.out.writeBytes(sizes[0] / 8 - i + "\t");
            }
            this.out.writeBytes("\nparameter\tscale\t1.000000\t");
            String order = meta.getPixelsDimensionOrder(this.series).toString();
            StringBuffer units = new StringBuffer();
            for (int i = 0; i < order.length(); ++i) {
                char dim = order.charAt(i);
                Double value = 1.0;
                if (dim == 'x') {
                    value = meta.getPixelsPhysicalSizeX(0);
                    units.append("micrometers\t");
                } else if (dim == 'y') {
                    value = meta.getPixelsPhysicalSizeY(0);
                    units.append("micrometers\t");
                } else if (dim == 'z') {
                    value = meta.getPixelsPhysicalSizeZ(0);
                    units.append("micrometers\t");
                } else if (dim == 't') {
                    value = meta.getPixelsTimeIncrement(0);
                    units.append("seconds\t");
                }
                this.out.writeBytes(value + "\t");
            }
            this.out.writeBytes("\nparameter\tunits\tbits\t" + units.toString() + "\n");
            this.out.writeBytes("\nend\n");
            this.pixelOffset = this.out.getFilePointer();
        } else {
            RandomAccessInputStream in = new RandomAccessInputStream(this.currentId);
            in.findString(new String[]{"\nend\n"});
            this.pixelOffset = in.getFilePointer();
            in.close();
        }
    }

    public void close() throws IOException {
        if (this.lastPlane != this.getPlaneCount() - 1 && this.out != null) {
            this.overwriteDimensions(this.getMetadataRetrieve());
        }
        super.close();
        this.pixelOffset = 0L;
        this.lastPlane = -1;
        this.dimensionOffset = 0L;
        this.dimensionLength = 0;
    }

    private int[] overwriteDimensions(MetadataRetrieve meta) throws IOException {
        int i;
        this.out.seek(this.dimensionOffset);
        String order = meta.getPixelsDimensionOrder(this.series).toString();
        int sizeX = (Integer)meta.getPixelsSizeX(this.series).getValue();
        int sizeY = (Integer)meta.getPixelsSizeY(this.series).getValue();
        int z = (Integer)meta.getPixelsSizeZ(this.series).getValue();
        int c = (Integer)meta.getPixelsSizeC(this.series).getValue();
        int t = (Integer)meta.getPixelsSizeT(this.series).getValue();
        int pixelType = FormatTools.pixelTypeFromString(meta.getPixelsType(this.series).toString());
        int bytesPerPixel = FormatTools.getBytesPerPixel(pixelType);
        int rgbChannels = this.getSamplesPerPixel();
        if (this.lastPlane < 0) {
            this.lastPlane = z * c * t - 1;
        }
        int[] pos = FormatTools.getZCTCoords(order, z, c, t, z * c * t, this.lastPlane);
        this.lastPlane = -1;
        StringBuffer dimOrder = new StringBuffer();
        int[] sizes = new int[6];
        int nextSize = 0;
        sizes[nextSize++] = 8 * bytesPerPixel;
        if (rgbChannels > 1) {
            dimOrder.append("ch\t");
            sizes[nextSize++] = pos[1] + 1;
        }
        for (i = 0; i < order.length(); ++i) {
            if (order.charAt(i) == 'X') {
                sizes[nextSize++] = sizeX;
            } else if (order.charAt(i) == 'Y') {
                sizes[nextSize++] = sizeY;
            } else if (order.charAt(i) == 'Z') {
                sizes[nextSize++] = pos[0] + 1;
            } else if (order.charAt(i) == 'T') {
                sizes[nextSize++] = pos[2] + 1;
            } else if (order.charAt(i) == 'C' && dimOrder.indexOf("ch") == -1) {
                sizes[nextSize++] = pos[1] + 1;
                dimOrder.append("ch");
            }
            if (order.charAt(i) != 'C') {
                dimOrder.append(String.valueOf(order.charAt(i)).toLowerCase());
            }
            dimOrder.append("\t");
        }
        this.out.writeBytes("layout\torder\tbits\t" + dimOrder.toString() + "\n");
        this.out.writeBytes("layout\tsizes\t");
        for (i = 0; i < sizes.length; ++i) {
            this.out.writeBytes(sizes[i] + "\t");
        }
        while (this.out.getFilePointer() - this.dimensionOffset < (long)(this.dimensionLength - 1)) {
            this.out.writeBytes(" ");
        }
        this.out.writeBytes("\n");
        return sizes;
    }
}

