/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.meta.MetadataStore;
import loci.formats.services.MetakitService;
import ome.xml.model.primitives.PositiveInteger;

public class VolocityReader
extends FormatReader {
    private static final String DATA_DIR = "Data";
    private static final int SIGNATURE_SIZE = 13;
    private String[][] pixelsFiles;
    private String[] timestampFiles;
    private ArrayList<String> extraFiles;
    private int[] planePadding;
    private Object[][] sampleTable;
    private Object[][] stringTable;
    private Location dir = null;
    private int[] blockSize;

    public VolocityReader() {
        super("Volocity Library", "mvd2");
        this.domains = new String[]{"Unknown"};
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        ArrayList<String> files = new ArrayList<String>();
        files.addAll(this.extraFiles);
        for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
            files.add(this.pixelsFiles[this.getSeries()][c]);
        }
        files.add(this.timestampFiles[this.getSeries()]);
        return files.toArray(new String[files.size()]);
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 2;
        if (!FormatTools.validStream(stream, 2, false)) {
            return false;
        }
        String check = stream.readString(2);
        return check.equals("JL") || check.equals("LJ");
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        long offset;
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int[] zct = this.getZCTCoords(no);
        RandomAccessInputStream pix = new RandomAccessInputStream(this.pixelsFiles[this.getSeries()][zct[1]]);
        int padding = zct[2] * this.planePadding[this.getSeries()];
        long planeSize = FormatTools.getPlaneSize(this);
        int planesInFile = (int)(pix.length() / planeSize);
        int planeIndex = no / this.getEffectiveSizeC();
        if (planesInFile == this.getSizeT()) {
            planeIndex = zct[2];
            int block = this.blockSize[this.getSeries()];
            padding = block - (int)(planeSize % (long)block);
            if (padding == block) {
                padding = 0;
            }
            padding *= zct[2];
        }
        if ((offset = (long)this.blockSize[this.getSeries()] + (long)planeIndex * planeSize + (long)padding) >= pix.length()) {
            return buf;
        }
        pix.seek(offset);
        this.readPlane(pix, x, y, w, h, buf);
        pix.close();
        if (this.getRGBChannelCount() == 4) {
            for (int i = 0; i < buf.length / 4; ++i) {
                byte a = buf[i * 4];
                buf[i * 4] = buf[i * 4 + 1];
                buf[i * 4 + 1] = buf[i * 4 + 2];
                buf[i * 4 + 2] = buf[i * 4 + 3];
                buf[i * 4 + 3] = a;
            }
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelsFiles = null;
            this.extraFiles = null;
            this.timestampFiles = null;
            this.planePadding = null;
            this.sampleTable = null;
            this.stringTable = null;
            this.dir = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        String[] files;
        super.initFile(id);
        this.extraFiles = new ArrayList();
        Location file = new Location(id).getAbsoluteFile();
        this.extraFiles.add(file.getAbsolutePath());
        Location parentDir = file.getParentFile();
        this.dir = new Location(parentDir, DATA_DIR);
        if (!this.dir.exists()) {
            throw new FormatException("Could not find data directory.");
        }
        for (String f : files = this.dir.list(true)) {
            if (VolocityReader.checkSuffix(f, "aisf") || VolocityReader.checkSuffix(f, "atsf")) continue;
            this.extraFiles.add(new Location(this.dir, f).getAbsolutePath());
        }
        try {
            ServiceFactory factory = new ServiceFactory();
            MetakitService reader = (MetakitService)factory.getInstance(MetakitService.class);
            reader.initialize(id);
            this.sampleTable = reader.getTableData(1);
            this.stringTable = reader.getTableData(2);
        }
        catch (DependencyException e) {
            throw new MissingLibraryException("Could not find Metakit library", e);
        }
        ArrayList<String> stackNames = new ArrayList<String>();
        ArrayList<Integer> parentIDs = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.sampleTable.length; ++i2) {
            Integer stringID = (Integer)this.sampleTable[i2][11];
            String name = this.getString(stringID);
            int channelIndex = this.getChildIndex((Integer)this.sampleTable[i2][0], "Channels");
            if (i2 <= 0 || (Integer)this.sampleTable[i2][2] != 1 || channelIndex < 0 && (this.sampleTable[i2][14] == null || this.sampleTable[i2][14].equals(0))) continue;
            if (channelIndex < 0) {
                RandomAccessInputStream s = this.getStream(i2);
                s.seek(22L);
                int x = s.readInt();
                int y = s.readInt();
                int z = s.readInt();
                if (x * y * z == 0 || (long)(x * y * z) >= s.length()) continue;
                stackNames.add(name);
                parentIDs.add((Integer)this.sampleTable[i2][0]);
                continue;
            }
            stackNames.add(name);
            parentIDs.add((Integer)this.sampleTable[i2][0]);
        }
        this.core = new CoreMetadata[parentIDs.size()];
        String[][] channelNames = new String[this.core.length][];
        Double[] physicalX = new Double[this.core.length];
        Double[] physicalY = new Double[this.core.length];
        Double[] physicalZ = new Double[this.core.length];
        Double[] magnification = new Double[this.core.length];
        String[] detector = new String[this.core.length];
        String[] description = new String[this.core.length];
        this.pixelsFiles = new String[this.core.length][];
        this.timestampFiles = new String[this.core.length];
        for (int i3 = 0; i3 < parentIDs.size(); ++i3) {
            int descriptionIndex;
            int detectorIndex;
            int objectiveIndex;
            int zIndex;
            int yIndex;
            int xIndex;
            this.core[i3] = new CoreMetadata();
            Integer parent = (Integer)parentIDs.get(i3);
            int channelIndex = this.getChildIndex(parent, "Channels");
            if (channelIndex >= 0) {
                Integer[] channels = this.getAllChildren((Integer)this.sampleTable[channelIndex][0]);
                this.core[i3].sizeC = channels.length;
                this.pixelsFiles[i3] = new String[this.core[i3].sizeC];
                channelNames[i3] = new String[channels.length];
                for (int c = 0; c < channels.length; ++c) {
                    channelNames[i3][c] = this.getString((Integer)this.sampleTable[channels[c]][11]);
                    RandomAccessInputStream data = this.getStream(channels[c]);
                    data.seek(22L);
                    int stackID = data.readInt();
                    this.pixelsFiles[i3][c] = new Location(this.dir, stackID + ".aisf").getAbsolutePath();
                    data.close();
                }
            } else {
                this.pixelsFiles[i3] = new String[1];
                for (int row = 0; row < this.sampleTable.length; ++row) {
                    if (!parent.equals(this.sampleTable[row][0])) continue;
                    Object o = this.sampleTable[row][14];
                    if (o == null) break;
                    String fileLink = o.toString().trim() + ".dat";
                    this.pixelsFiles[i3][0] = new Location(this.dir, fileLink).getAbsolutePath();
                    break;
                }
            }
            RandomAccessInputStream data = null;
            int timestampIndex = this.getChildIndex(parent, "Timepoint times stream");
            if (timestampIndex >= 0) {
                data = this.getStream(timestampIndex);
                data.seek(22L);
                int timestampID = data.readInt();
                this.timestampFiles[i3] = new Location(this.dir, timestampID + ".atsf").getAbsolutePath();
                data.close();
            }
            if ((xIndex = this.getChildIndex(parent, "um/pixel (X)")) >= 0) {
                data = this.getStream(xIndex);
                data.seek(13L);
                physicalX[i3] = data.readDouble();
                data.close();
            }
            if ((yIndex = this.getChildIndex(parent, "um/pixel (Y)")) >= 0) {
                data = this.getStream(yIndex);
                data.seek(13L);
                physicalY[i3] = data.readDouble();
                data.close();
            }
            if ((zIndex = this.getChildIndex(parent, "um/pixel (Z)")) >= 0) {
                data = this.getStream(zIndex);
                data.seek(13L);
                physicalZ[i3] = data.readDouble();
                data.close();
            }
            if ((objectiveIndex = this.getChildIndex(parent, "Microscope Objective")) >= 0) {
                data = this.getStream(objectiveIndex);
                data.seek(13L);
                magnification[i3] = data.readDouble();
                data.close();
            }
            if ((detectorIndex = this.getChildIndex(parent, "Camera/Detector")) >= 0) {
                data = this.getStream(detectorIndex);
                data.seek(13L);
                int len = data.readInt();
                detector[i3] = data.readString(len);
                data.close();
            }
            if ((descriptionIndex = this.getChildIndex(parent, "Experiment Description")) < 0) continue;
            data = this.getStream(descriptionIndex);
            data.seek(13L);
            int len = data.readInt();
            description[i3] = data.readString(len);
            data.close();
        }
        this.planePadding = new int[this.core.length];
        this.blockSize = new int[this.core.length];
        double[][][] stamps = new double[this.core.length][][];
        for (i = 0; i < this.core.length; ++i) {
            RandomAccessInputStream s;
            this.setSeries(i);
            this.core[i].littleEndian = true;
            if (this.timestampFiles[i] != null) {
                s = new RandomAccessInputStream(this.timestampFiles[i]);
                s.seek(17L);
                s.order(this.isLittleEndian());
                this.core[i].sizeT = s.readInt();
                s.close();
            } else {
                this.core[i].sizeT = 1;
            }
            this.core[i].rgb = false;
            this.core[i].interleaved = true;
            this.core[i].dimensionOrder = "XYCZT";
            s = new RandomAccessInputStream(this.pixelsFiles[i][0]);
            s.order(this.isLittleEndian());
            if (VolocityReader.checkSuffix(this.pixelsFiles[i][0], "aisf")) {
                s.seek(18L);
                this.blockSize[i] = s.readShort() * 256;
                s.skipBytes(5);
                int x = s.readInt();
                int y = s.readInt();
                int zStart = s.readInt();
                int w = s.readInt();
                int h = s.readInt();
                this.core[i].sizeX = w - x;
                this.core[i].sizeY = h - y;
                this.core[i].sizeZ = s.readInt() - zStart;
                this.core[i].imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
                int planesPerFile = this.getSizeZ() * this.getSizeT();
                int planeSize = FormatTools.getPlaneSize(this);
                int bytesPerPixel = 0;
                for (int bytesPerPlane = (int)((s.length() - (long)this.blockSize[i]) / (long)planesPerFile); bytesPerPlane >= planeSize; bytesPerPlane -= planeSize) {
                    ++bytesPerPixel;
                }
                if (bytesPerPixel % 3 == 0) {
                    this.core[i].sizeC *= 3;
                    this.core[i].rgb = true;
                    bytesPerPixel /= 3;
                }
                this.core[i].pixelType = FormatTools.pixelTypeFromBytes(bytesPerPixel, false, false);
                int timepoint = FormatTools.getPlaneSize(this) * this.getSizeZ();
                this.planePadding[i] = this.blockSize[i] - timepoint % this.blockSize[i];
                if (this.planePadding[i] == this.blockSize[i]) {
                    this.planePadding[i] = 0;
                }
            } else {
                s.seek(22L);
                this.core[i].sizeX = s.readInt();
                this.core[i].sizeY = s.readInt();
                this.core[i].sizeZ = s.readInt();
                this.core[i].sizeC = 4;
                this.core[i].imageCount = this.getSizeZ() * this.getSizeT();
                this.core[i].rgb = true;
                this.core[i].pixelType = 1;
                this.blockSize[i] = 99;
                this.planePadding[i] = 0;
            }
            s.close();
        }
        this.setSeries(0);
        for (i = 0; i < this.getSeriesCount(); ++i) {
            this.setSeries(i);
            this.addSeriesMeta("Name", stackNames.get(i));
            this.addSeriesMeta("Pixel width (in microns)", physicalX[i]);
            this.addSeriesMeta("Pixel height (in microns)", physicalY[i]);
            this.addSeriesMeta("Z step (in microns)", physicalZ[i]);
            this.addSeriesMeta("Objective magnification", magnification[i]);
            this.addSeriesMeta("Camera/Detector", detector[i]);
            this.addSeriesMeta("Description", description[i]);
            if (channelNames[i] == null) continue;
            for (int c = 0; c < channelNames[i].length; ++c) {
                this.addSeriesMeta("Channel #" + (c + 1), channelNames[i][c]);
            }
        }
        this.setSeries(0);
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        String instrument = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrument, 0);
        for (int i4 = 0; i4 < this.getSeriesCount(); ++i4) {
            store.setImageInstrumentRef(instrument, i4);
            this.setSeries(i4);
            store.setImageName((String)stackNames.get(i4), i4);
            store.setImageDescription(description[i4], i4);
            if (channelNames[i4] != null) {
                for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                    store.setChannelName(channelNames[i4][c], i4, c);
                }
            }
            store.setPixelsPhysicalSizeX(physicalX[i4], i4);
            store.setPixelsPhysicalSizeY(physicalY[i4], i4);
            store.setPixelsPhysicalSizeZ(physicalZ[i4], i4);
            String objective = MetadataTools.createLSID("Objective", 0, i4);
            store.setObjectiveID(objective, 0, i4);
            if (magnification[i4] != null) {
                store.setObjectiveNominalMagnification(new PositiveInteger(Integer.valueOf(magnification[i4].intValue())), 0, i4);
            }
            store.setObjectiveCorrection(this.getCorrection("Other"), 0, i4);
            store.setObjectiveImmersion(this.getImmersion("Other"), 0, i4);
            store.setImageObjectiveSettingsID(objective, i4);
            String detectorID = MetadataTools.createLSID("Detector", 0, i4);
            store.setDetectorID(detectorID, 0, i4);
            store.setDetectorModel(detector[i4], 0, i4);
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                store.setDetectorSettingsID(detectorID, i4, c);
            }
        }
        this.setSeries(0);
    }

    private String getString(Integer stringID) {
        for (int row = 0; row < this.stringTable.length; ++row) {
            if (!stringID.equals(this.stringTable[row][0])) continue;
            String s = (String)this.stringTable[row][1];
            if (s != null) {
                s = s.trim();
            }
            return s;
        }
        return null;
    }

    private int getChildIndex(Integer parentID, String childName) {
        for (int row = 0; row < this.sampleTable.length; ++row) {
            String name;
            if (!parentID.equals(this.sampleTable[row][1]) || !childName.equals(name = this.getString((Integer)this.sampleTable[row][11]))) continue;
            return row;
        }
        return -1;
    }

    private Integer[] getAllChildren(Integer parentID) {
        ArrayList<Integer> children = new ArrayList<Integer>();
        for (int row = 0; row < this.sampleTable.length; ++row) {
            if (!parentID.equals(this.sampleTable[row][1])) continue;
            children.add(row);
        }
        return children.toArray(new Integer[children.size()]);
    }

    private RandomAccessInputStream getStream(int row) throws IOException {
        Object o = this.sampleTable[row][14];
        String fileLink = o == null ? "0" : o.toString().trim();
        RandomAccessInputStream data = null;
        if (fileLink.equals("0")) {
            data = new RandomAccessInputStream((byte[])this.sampleTable[row][13]);
        } else {
            fileLink = new Location(this.dir, fileLink + ".dat").getAbsolutePath();
            data = new RandomAccessInputStream(fileLink);
        }
        data.order(true);
        return data;
    }
}

