/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;

public class SlidebookReader
extends FormatReader {
    public static final long SLD_MAGIC_BYTES_1 = 1811939329L;
    public static final long SLD_MAGIC_BYTES_2 = 4110483969L;
    public static final long SLD_MAGIC_BYTES_3 = 4127260929L;
    private Vector<Long> metadataOffsets;
    private Vector<Long> pixelOffsets;
    private Vector<Long> pixelLengths;
    private Vector<Double> ndFilters;
    private boolean adjust = true;
    private boolean isSpool;
    private Hashtable<Integer, Integer> metadataInPlanes;

    public SlidebookReader() {
        super("Olympus Slidebook", new String[]{"sld", "spl"});
        this.domains = new String[]{"Light Microscopy"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 8;
        if (!FormatTools.validStream(stream, 8, false)) {
            return false;
        }
        long magicBytes = stream.readInt();
        return magicBytes == 1811939329L || magicBytes == 4110483969L;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int plane = FormatTools.getPlaneSize(this);
        long offset = this.pixelOffsets.get(this.series) + (long)(plane * no);
        this.in.seek(offset);
        if (this.isSpool) {
            Object[] keys = this.metadataInPlanes.keySet().toArray(new Integer[0]);
            Arrays.sort(keys);
            Object[] arr$ = keys;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int key = (Integer)arr$[i$];
                if (key >= no) continue;
                this.in.skipBytes(256);
            }
            this.in.order(false);
            long magicBytes = (long)this.in.readInt() & 0xFFFFFFFFL;
            this.in.order(this.isLittleEndian());
            if (magicBytes == 4127260929L && !this.metadataInPlanes.contains(no)) {
                this.metadataInPlanes.put(no, 0);
                this.in.skipBytes(252);
            } else {
                this.in.seek(this.in.getFilePointer() - 4L);
            }
        }
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelLengths = null;
            this.pixelOffsets = null;
            this.metadataOffsets = null;
            this.ndFilters = null;
            this.isSpool = false;
            this.metadataInPlanes = null;
            this.adjust = true;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        int q;
        int i;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.isSpool = SlidebookReader.checkSuffix(id, "spl");
        if (this.isSpool) {
            this.metadataInPlanes = new Hashtable();
        }
        LOGGER.info("Finding offsets to pixel data");
        this.in.skipBytes(4);
        this.core[0].littleEndian = this.in.read() == 73;
        this.in.order(this.isLittleEndian());
        this.metadataOffsets = new Vector();
        this.pixelOffsets = new Vector();
        this.pixelLengths = new Vector();
        this.ndFilters = new Vector();
        this.in.seek(0L);
        while (this.in.getFilePointer() < this.in.length() - 8L) {
            LOGGER.debug("Looking for block at {}", (Object)this.in.getFilePointer());
            this.in.skipBytes(4);
            int checkOne = this.in.read();
            int checkTwo = this.in.read();
            if (checkOne == 73 && checkTwo == 73 || checkOne == 77 && checkTwo == 77) {
                LOGGER.debug("Found metadata offset: {}", (Object)(this.in.getFilePointer() - 6L));
                this.metadataOffsets.add(new Long(this.in.getFilePointer() - 6L));
                this.in.skipBytes(this.in.readShort() - 8);
                continue;
            }
            if (checkOne == -1 && checkTwo == -1) {
                boolean foundBlock = false;
                byte[] block = new byte[8192];
                this.in.read(block);
                while (!foundBlock) {
                    for (int i2 = 0; i2 < block.length - 2; ++i2) {
                        if ((block[i2] != 77 || block[i2 + 1] != 77) && (block[i2] != 73 || block[i2 + 1] != 73)) continue;
                        foundBlock = true;
                        this.in.seek(this.in.getFilePointer() - (long)block.length + (long)i2 - 2L);
                        LOGGER.debug("Found metadata offset: {}", (Object)(this.in.getFilePointer() - 2L));
                        this.metadataOffsets.add(new Long(this.in.getFilePointer() - 2L));
                        this.in.skipBytes(this.in.readShort() - 5);
                        break;
                    }
                    if (foundBlock) continue;
                    block[0] = block[block.length - 2];
                    block[1] = block[block.length - 1];
                    this.in.read(block, 2, block.length - 2);
                }
                continue;
            }
            String s = null;
            long fp = this.in.getFilePointer() - 6L;
            this.in.seek(fp);
            int len = this.in.read();
            if (len > 0 && len <= 32) {
                s = this.in.readString(len);
            }
            if (s != null && s.indexOf("Annotation") != -1) {
                if (s.equals("CTimelapseAnnotation")) {
                    this.in.skipBytes(41);
                    if (this.in.read() == 0) {
                        this.in.skipBytes(10);
                        continue;
                    }
                    this.in.seek(this.in.getFilePointer() - 1L);
                    continue;
                }
                if (s.equals("CIntensityBarAnnotation")) {
                    this.in.skipBytes(56);
                    int n = this.in.read();
                    while (n == 0 || n < 6 || n > 128) {
                        n = this.in.read();
                    }
                    this.in.seek(this.in.getFilePointer() - 1L);
                    continue;
                }
                if (s.equals("CCubeAnnotation")) {
                    this.in.skipBytes(66);
                    int n = this.in.read();
                    if (n == 0) continue;
                    this.in.seek(this.in.getFilePointer() - 1L);
                    continue;
                }
                if (!s.equals("CScaleBarAnnotation")) continue;
                this.in.skipBytes(38);
                int extra = this.in.read();
                if (extra <= 16) {
                    this.in.skipBytes(3 + extra);
                    continue;
                }
                this.in.skipBytes(2);
                continue;
            }
            if (s != null && s.indexOf("Decon") != -1) {
                this.in.seek(fp);
                while (this.in.read() != 93) {
                }
                continue;
            }
            if (fp % 2L == 1L) {
                fp -= 2L;
            }
            this.in.seek(fp);
            String checkString = this.in.readString(64);
            if (checkString.indexOf("II") != -1 || checkString.indexOf("MM") != -1) {
                int index = checkString.indexOf("II");
                if (index == -1) {
                    index = checkString.indexOf("MM");
                }
                this.in.seek(fp + (long)index - 4L);
                continue;
            }
            this.in.seek(fp);
            LOGGER.debug("Found pixel offset at {}", (Object)fp);
            this.pixelOffsets.add(new Long(fp));
            try {
                byte[] buf = new byte[8192];
                boolean found = false;
                int n = this.in.read(buf);
                while (!found && this.in.getFilePointer() < this.in.length()) {
                    for (int i3 = 0; i3 < n - 6; ++i3) {
                        if ((buf[i3] != 104 && buf[i3] != 105 || buf[i3 + 1] != 0 || buf[i3 + 4] != 73 || buf[i3 + 5] != 73) && (buf[i3] != 0 || buf[i3 + 1] != 104 && buf[i3 + 1] != 105 || buf[i3 + 4] != 77 || buf[i3 + 5] != 77)) continue;
                        found = true;
                        this.in.seek(this.in.getFilePointer() - (long)n + (long)i3 - 20L);
                        if (buf[i3] != 105 && buf[i3 + 1] != 105) break;
                        this.pixelOffsets.remove(this.pixelOffsets.size() - 1);
                        break;
                    }
                    if (found) continue;
                    byte[] tmp = buf;
                    buf = new byte[8192];
                    System.arraycopy(tmp, tmp.length - 20, buf, 0, 20);
                    n = this.in.read(buf, 20, buf.length - 20);
                }
                if (this.in.getFilePointer() <= this.in.length()) {
                    if (this.pixelOffsets.size() <= this.pixelLengths.size()) continue;
                    long length = this.in.getFilePointer() - fp;
                    if (length / 2L % 2L == 1L) {
                        this.pixelOffsets.setElementAt(fp + 2L, this.pixelOffsets.size() - 1);
                        length -= 2L;
                    }
                    this.pixelLengths.add(new Long(length));
                    continue;
                }
                this.pixelOffsets.remove(this.pixelOffsets.size() - 1);
            }
            catch (EOFException e) {
                this.pixelOffsets.remove(this.pixelOffsets.size() - 1);
            }
        }
        for (int i4 = 0; i4 < this.pixelOffsets.size(); ++i4) {
            int padding;
            long length = this.pixelLengths.get(i4);
            long offset = this.pixelOffsets.get(i4);
            int n = padding = this.isSpool ? 0 : 7;
            if (length + offset + (long)padding <= this.in.length()) continue;
            this.pixelOffsets.remove(i4);
            this.pixelLengths.remove(i4);
            --i4;
        }
        if (this.pixelOffsets.size() > 1) {
            boolean little = this.isLittleEndian();
            this.core = new CoreMetadata[this.pixelOffsets.size()];
            for (int i5 = 0; i5 < this.getSeriesCount(); ++i5) {
                this.core[i5] = new CoreMetadata();
                this.core[i5].littleEndian = little;
            }
        }
        LOGGER.info("Determining dimensions");
        Vector<Float> pixelSize = new Vector<Float>();
        String objective = null;
        Vector<Double> pixelSizeZ = new Vector<Double>();
        long pixelBytes = 0L;
        for (int i6 = 0; i6 < this.pixelLengths.size(); ++i6) {
            pixelBytes += this.pixelLengths.get(i6).longValue();
        }
        String[] imageNames = new String[this.getSeriesCount()];
        Vector<String> channelNames = new Vector<String>();
        int nextName = 0;
        int iCount = 0;
        int hCount = 0;
        int uCount = 0;
        int prevSeries = -1;
        int prevSeriesU = -1;
        boolean nextChannel = false;
        for (i = 0; i < this.metadataOffsets.size(); ++i) {
            long off = this.metadataOffsets.get(i);
            this.in.seek(off);
            long next = i == this.metadataOffsets.size() - 1 ? this.in.length() : this.metadataOffsets.get(i + 1).longValue();
            int totalBlocks = (int)((next - off) / 128L);
            if (totalBlocks > 100) {
                totalBlocks = 1;
            }
            block13: for (q = 0; q < totalBlocks && !this.withinPixels(off + (long)(q * 128)); ++q) {
                short div;
                long end;
                this.in.seek(off + (long)(q * 128));
                char n = (char)this.in.readShort();
                if (n == 'i') {
                    ++iCount;
                    this.in.skipBytes(94);
                    pixelSizeZ.add(new Double(this.in.readFloat()));
                    this.in.seek(this.in.getFilePointer() - 20L);
                    for (int j = 0; j < this.pixelOffsets.size(); ++j) {
                        long l = end = j == this.pixelOffsets.size() - 1 ? this.in.length() : this.pixelOffsets.get(j + 1).longValue();
                        if (this.in.getFilePointer() >= end) continue;
                        if (this.core[j].sizeX == 0) {
                            this.core[j].sizeX = this.in.readShort();
                            this.core[j].sizeY = this.in.readShort();
                            short checkX = this.in.readShort();
                            short checkY = this.in.readShort();
                            div = this.in.readShort();
                            this.core[j].sizeX = this.core[j].sizeX / (div == 0 ? (short)1 : div);
                            div = this.in.readShort();
                            this.core[j].sizeY = this.core[j].sizeY / (div == 0 ? (short)1 : div);
                        }
                        if (prevSeries != j) {
                            iCount = 1;
                        }
                        prevSeries = j;
                        this.core[j].sizeC = iCount;
                        continue block13;
                    }
                    continue;
                }
                if (n == 'u') {
                    ++uCount;
                    for (int j = 0; j < this.pixelOffsets.size(); ++j) {
                        long l = end = j == this.pixelOffsets.size() - 1 ? this.in.length() : this.pixelOffsets.get(j + 1).longValue();
                        if (this.in.getFilePointer() >= end) continue;
                        if (prevSeriesU != j) {
                            uCount = 1;
                        }
                        prevSeriesU = j;
                        this.core[j].sizeZ = uCount;
                        continue block13;
                    }
                    continue;
                }
                if (n == 'h') {
                    ++hCount;
                    continue;
                }
                if (n == 'j') {
                    this.in.skipBytes(2);
                    String check = this.in.readString(2);
                    if (!check.equals("II") && !check.equals("MM")) continue;
                    this.in.skipBytes(10);
                    if (nextName < imageNames.length) {
                        imageNames[nextName++] = this.in.readCString().trim();
                    }
                    long fp = this.in.getFilePointer();
                    if (this.in.getFilePointer() % 2L == 1L) {
                        this.in.skipBytes(1);
                    }
                    while (this.in.readShort() == 0) {
                    }
                    this.in.skipBytes(18);
                    if (this.in.getFilePointer() - fp > 123L && fp % 2L == 0L) {
                        this.in.seek(fp + 123L);
                    }
                    int x = this.in.readInt();
                    int y = this.in.readInt();
                    div = this.in.readShort();
                    short s = div == 0 ? (short)1 : div;
                    div = this.in.readShort();
                    if ((x /= s) <= 16 || x >= this.core[nextName - 1].sizeX && this.core[nextName - 1].sizeX != 0 || (y /= div == 0 ? (short)1 : div) <= 16 || y >= this.core[nextName - 1].sizeY && this.core[nextName - 1].sizeY != 0) continue;
                    this.core[nextName - 1].sizeX = x;
                    this.core[nextName - 1].sizeY = y;
                    this.adjust = false;
                    continue;
                }
                if (n == 'm') {
                    if (this.in.getFilePointer() <= this.pixelOffsets.get(0)) continue;
                    this.in.skipBytes(14);
                    channelNames.add(this.in.readCString().trim());
                    continue;
                }
                if (n == 'd') {
                    this.in.skipBytes(6);
                    long fp = this.in.getFilePointer();
                    objective = this.in.readCString();
                    this.in.seek(fp + 144L);
                    pixelSize.add(Float.valueOf(this.in.readFloat()));
                    continue;
                }
                if (n == 'e') {
                    this.in.skipBytes(174);
                    this.ndFilters.add(new Double(this.in.readFloat()));
                    this.in.skipBytes(40);
                    this.setSeries(nextName);
                    this.addSeriesMeta("channel " + this.ndFilters.size() + " intensification", this.in.readShort());
                    continue;
                }
                if (n == 'k') {
                    this.in.skipBytes(14);
                    if (nextName > 0) {
                        this.setSeries(nextName - 1);
                    }
                    this.addSeriesMeta("Mag. changer", this.in.readCString());
                    continue;
                }
                if (!this.isSpool) continue;
                for (int j = 0; j < this.pixelOffsets.size(); ++j) {
                    long l = end = j == this.pixelOffsets.size() - 1 ? this.in.length() : this.pixelOffsets.get(j + 1).longValue();
                    if (this.in.getFilePointer() >= end) continue;
                    this.in.skipBytes(16);
                    this.core[j].sizeX = this.in.readShort();
                    this.core[j].sizeY = this.in.readShort();
                    this.adjust = false;
                    continue block13;
                }
            }
        }
        for (i = 0; i < this.getSeriesCount(); ++i) {
            this.setSeries(i);
            long pixels = this.pixelLengths.get(i) / 2L;
            boolean x = true;
            if (this.getSizeC() == 0) {
                this.core[i].sizeC = 1;
            }
            if (this.getSizeZ() == 0) {
                this.core[i].sizeZ = 1;
            }
            long plane = pixels / (long)(this.getSizeC() * this.getSizeZ());
            if (this.adjust) {
                boolean widthGreater;
                boolean bl = widthGreater = this.getSizeX() > this.getSizeY();
                while ((long)(this.getSizeX() * this.getSizeY()) > plane) {
                    if (x) {
                        this.core[i].sizeX /= 2;
                    } else {
                        this.core[i].sizeY /= 2;
                    }
                    x = !x;
                }
                while ((long)(this.getSizeX() * this.getSizeY()) < plane || this.getSizeX() < this.getSizeY() && widthGreater) {
                    ++this.core[i].sizeX;
                    this.core[i].sizeY = (int)(plane / (long)this.getSizeX());
                }
            }
            int nPlanes = this.getSizeZ() * this.getSizeC();
            this.core[i].sizeT = (int)(pixels / (long)(this.getSizeX() * this.getSizeY() * nPlanes));
            while ((long)(this.getSizeX() * this.getSizeY() * nPlanes * this.getSizeT()) > pixels) {
                --this.core[i].sizeT;
            }
            if (this.getSizeT() == 0) {
                this.core[i].sizeT = 1;
            }
            this.core[i].imageCount = nPlanes * this.getSizeT();
            this.core[i].pixelType = 3;
            this.core[i].dimensionOrder = "XYZTC";
            this.core[i].indexed = false;
            this.core[i].falseColor = false;
            this.core[i].metadataComplete = true;
        }
        this.setSeries(0);
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        for (int i7 = 0; i7 < this.getSeriesCount(); ++i7) {
            if (imageNames[i7] != null) {
                store.setImageName(imageNames[i7], i7);
            }
            MetadataTools.setDefaultCreationDate(store, id, i7);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            int i8;
            String instrumentID = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrumentID, 0);
            store.setImageInstrumentRef(instrumentID, 0);
            int index = 0;
            store.setObjectiveModel(objective, 0, 0);
            store.setObjectiveCorrection(this.getCorrection("Other"), 0, 0);
            store.setObjectiveImmersion(this.getImmersion("Other"), 0, 0);
            String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
            store.setObjectiveID(objectiveID, 0, 0);
            store.setImageObjectiveSettingsID(objectiveID, 0);
            for (i8 = 0; i8 < this.getSeriesCount(); ++i8) {
                if (i8 < pixelSize.size()) {
                    store.setPixelsPhysicalSizeX(new Double(((Float)pixelSize.get(i8)).floatValue()), i8);
                    store.setPixelsPhysicalSizeY(new Double(((Float)pixelSize.get(i8)).floatValue()), i8);
                }
                int idx = 0;
                for (q = 0; q < i8; ++q) {
                    idx += this.core[q].sizeC;
                }
                if (idx >= pixelSizeZ.size() || pixelSizeZ.get(idx) == null) continue;
                store.setPixelsPhysicalSizeZ((Double)pixelSizeZ.get(idx), i8);
            }
            for (i8 = 0; i8 < this.getSeriesCount(); ++i8) {
                this.setSeries(i8);
                for (int c = 0; c < this.getSizeC(); ++c) {
                    if (index < channelNames.size() && channelNames.get(index) != null) {
                        store.setChannelName((String)channelNames.get(index), i8, c);
                        this.addSeriesMeta("channel " + c, channelNames.get(index));
                    }
                    if (index < this.ndFilters.size() && this.ndFilters.get(index) != null) {
                        store.setChannelNDFilter(this.ndFilters.get(index), i8, c);
                        this.addSeriesMeta("channel " + c + " Neutral density", this.ndFilters.get(index));
                    }
                    ++index;
                }
            }
            this.setSeries(0);
        }
    }

    private boolean withinPixels(long offset) {
        for (int i = 0; i < this.pixelOffsets.size(); ++i) {
            long pixelOffset = this.pixelOffsets.get(i);
            long pixelLength = this.pixelLengths.get(i);
            if (offset < pixelOffset || offset >= pixelOffset + pixelLength) continue;
            return true;
        }
        return false;
    }
}

