/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;

public class SEQReader
extends BaseTiffReader {
    private static final int IMAGE_PRO_TAG_1 = 50288;
    private static final int IMAGE_PRO_TAG_2 = 40105;

    public SEQReader() {
        super("Image-Pro Sequence", "seq");
        this.domains = new String[]{"Unknown"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser parser = new TiffParser(stream);
        parser.setDoCaching(false);
        IFD ifd = parser.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        return ifd.containsKey(50288);
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        this.core[0].sizeZ = 0;
        this.core[0].sizeT = 0;
        MetadataLevel level = this.getMetadataOptions().getMetadataLevel();
        for (IFD ifd : this.ifds) {
            int tag2;
            short[] tag1;
            if (level != MetadataLevel.MINIMUM && (tag1 = (short[])ifd.getIFDValue(50288)) != null) {
                String seqId = "";
                for (int i = 0; i < tag1.length; ++i) {
                    seqId = seqId + tag1[i];
                }
                this.addGlobalMeta("Image-Pro SEQ ID", seqId);
            }
            if ((tag2 = ((IFD)this.ifds.get(0)).getIFDIntValue(40105)) != -1) {
                ++this.core[0].sizeZ;
                this.addGlobalMeta("Frame Rate", tag2);
            }
            this.addGlobalMeta("Number of images", this.getSizeZ());
        }
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        if (this.getSizeZ() == 1 && this.getSizeT() == 1) {
            this.core[0].sizeZ = this.ifds.size();
        }
        this.addGlobalMeta("frames", this.getSizeZ());
        this.addGlobalMeta("channels", super.getSizeC());
        this.addGlobalMeta("slices", this.getSizeT());
        String descr = ((IFD)this.ifds.get(0)).getComment();
        this.metadata.remove("Comment");
        if (descr != null) {
            String[] lines;
            for (String token : lines = descr.split("\n")) {
                int eq = (token = token.trim()).indexOf("=");
                if (eq == -1) {
                    eq = token.indexOf(":");
                }
                if (eq == -1) continue;
                String label = token.substring(0, eq);
                String data = token.substring(eq + 1);
                this.addGlobalMeta(label, data);
                if (label.equals("channels")) {
                    this.core[0].sizeC = Integer.parseInt(data);
                    continue;
                }
                if (label.equals("frames")) {
                    this.core[0].sizeT = Integer.parseInt(data);
                    continue;
                }
                if (!label.equals("slices")) continue;
                this.core[0].sizeZ = Integer.parseInt(data);
            }
        }
        if (this.isRGB() && this.getSizeC() != 3) {
            this.core[0].sizeC *= 3;
        }
        this.core[0].dimensionOrder = "XY";
        int maxNdx = 0;
        int max = 0;
        int[] dims = new int[]{this.getSizeZ(), this.getSizeC(), this.getSizeT()};
        String[] axes = new String[]{"Z", "C", "T"};
        for (int i = 0; i < dims.length; ++i) {
            if (dims[i] <= max) continue;
            max = dims[i];
            maxNdx = i;
        }
        this.core[0].dimensionOrder = this.core[0].dimensionOrder + axes[maxNdx];
        if (maxNdx != 1) {
            if (this.getSizeC() > 1) {
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + (maxNdx == 0 ? axes[2] : axes[0]);
            } else {
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + (maxNdx == 0 ? axes[2] : axes[0]) + "C";
            }
        } else {
            this.core[0].dimensionOrder = this.getSizeZ() > this.getSizeT() ? this.core[0].dimensionOrder + "ZT" : this.core[0].dimensionOrder + "TZ";
        }
    }
}

