/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffParser;

public class MinimalTiffReader
extends FormatReader {
    protected IFDList ifds;
    protected IFDList thumbnailIFDs;
    protected TiffParser tiffParser;
    private int lastPlane;

    public MinimalTiffReader() {
        this("Minimal TIFF", new String[]{"tif", "tiff"});
    }

    public MinimalTiffReader(String name, String suffix) {
        this(name, new String[]{suffix});
    }

    public MinimalTiffReader(String name, String[] suffixes) {
        super(name, suffixes);
        this.domains = new String[]{"Graphics"};
        this.suffixNecessary = false;
    }

    public IFDList getIFDs() {
        return this.ifds;
    }

    public IFDList getThumbnailIFDs() {
        return this.thumbnailIFDs;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return new TiffParser(stream).isValidHeader();
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.ifds == null || this.lastPlane < 0 || this.lastPlane > this.ifds.size()) {
            return null;
        }
        IFD lastIFD = (IFD)this.ifds.get(this.lastPlane);
        int[] bits = lastIFD.getBitsPerSample();
        if (bits[0] <= 8) {
            int[] colorMap = lastIFD.getIFDIntArray(320);
            if (colorMap == null) {
                if (this.lastPlane != 0) {
                    lastIFD = (IFD)this.ifds.get(0);
                    colorMap = lastIFD.getIFDIntArray(320);
                    if (colorMap == null) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            byte[][] table = new byte[3][colorMap.length / 3];
            int next = 0;
            for (int j = 0; j < table.length; ++j) {
                for (int i = 0; i < table[0].length; ++i) {
                    table[j][i] = (byte)(colorMap[next++] >> 8 & 0xFF);
                }
            }
            return table;
        }
        return null;
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.ifds == null || this.lastPlane < 0 || this.lastPlane > this.ifds.size()) {
            return null;
        }
        IFD lastIFD = (IFD)this.ifds.get(this.lastPlane);
        int[] bits = lastIFD.getBitsPerSample();
        if (bits[0] <= 16 && bits[0] > 8) {
            int[] colorMap = lastIFD.getIFDIntArray(320);
            if (colorMap == null || colorMap.length < 196608) {
                if (this.lastPlane != 0) {
                    lastIFD = (IFD)this.ifds.get(0);
                    colorMap = lastIFD.getIFDIntArray(320);
                    if (colorMap == null || colorMap.length < 196608) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            short[][] table = new short[3][colorMap.length / 3];
            int next = 0;
            for (int i = 0; i < table.length; ++i) {
                for (int j = 0; j < table[0].length; ++j) {
                    table[i][j] = (short)(colorMap[next++] & 0xFFFF);
                }
            }
            return table;
        }
        return null;
    }

    public int getThumbSizeX() {
        if (this.thumbnailIFDs != null && this.thumbnailIFDs.size() > 0) {
            try {
                return (int)((IFD)this.thumbnailIFDs.get(0)).getImageWidth();
            }
            catch (FormatException e) {
                LOGGER.debug("Could not retrieve thumbnail width", (Throwable)e);
            }
        }
        return super.getThumbSizeX();
    }

    public int getThumbSizeY() {
        if (this.thumbnailIFDs != null && this.thumbnailIFDs.size() > 0) {
            try {
                return (int)((IFD)this.thumbnailIFDs.get(0)).getImageLength();
            }
            catch (FormatException e) {
                LOGGER.debug("Could not retrieve thumbnail height", (Throwable)e);
            }
        }
        return super.getThumbSizeY();
    }

    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.thumbnailIFDs == null || this.thumbnailIFDs.size() <= no) {
            return super.openThumbBytes(no);
        }
        int[] bps = ((IFD)this.thumbnailIFDs.get(no)).getBitsPerSample();
        int b = bps[0];
        while (b % 8 != 0) {
            ++b;
        }
        if ((b /= 8) != FormatTools.getBytesPerPixel(this.getPixelType()) || bps.length != this.getRGBChannelCount()) {
            return super.openThumbBytes(no);
        }
        byte[] buf = new byte[this.getThumbSizeX() * this.getThumbSizeY() * this.getRGBChannelCount() * FormatTools.getBytesPerPixel(this.getPixelType())];
        return this.tiffParser.getSamples((IFD)this.thumbnailIFDs.get(no), buf);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        boolean float24;
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.lastPlane = no;
        this.tiffParser.getSamples((IFD)this.ifds.get(no), buf, x, y, w, h);
        boolean float16 = this.getPixelType() == 6 && ((IFD)this.ifds.get(0)).getBitsPerSample()[0] == 16;
        boolean bl = float24 = this.getPixelType() == 6 && ((IFD)this.ifds.get(0)).getBitsPerSample()[0] == 24;
        if (float16 || float24) {
            int nPixels = w * h * this.getRGBChannelCount();
            int nBytes = float16 ? 2 : 3;
            int mantissaBits = float16 ? 10 : 16;
            int exponentBits = float16 ? 5 : 7;
            int maxExponent = (int)Math.pow(2.0, exponentBits) - 1;
            int bits = nBytes * 8 - 1;
            byte[] newBuf = new byte[buf.length];
            for (int i = 0; i < nPixels; ++i) {
                int v = DataTools.bytesToInt((byte[])buf, (int)(i * nBytes), (int)nBytes, (boolean)this.isLittleEndian());
                int sign = v >> bits;
                int exponent = v >> mantissaBits & (int)(Math.pow(2.0, exponentBits) - 1.0);
                int mantissa = v & (int)(Math.pow(2.0, mantissaBits) - 1.0);
                if (exponent == 0) {
                    if (mantissa != 0) {
                        while ((mantissa & (int)Math.pow(2.0, mantissaBits)) == 0) {
                            mantissa <<= 1;
                            --exponent;
                        }
                        ++exponent;
                        mantissa &= (int)(Math.pow(2.0, mantissaBits) - 1.0);
                        exponent = (int)((double)exponent + (127.0 - (Math.pow(2.0, exponentBits - 1) - 1.0)));
                    }
                } else {
                    exponent = exponent == maxExponent ? 255 : (int)((double)exponent + (127.0 - (Math.pow(2.0, exponentBits - 1) - 1.0)));
                }
                int value = sign << 31 | exponent << 23 | (mantissa <<= 23 - mantissaBits);
                DataTools.unpackBytes((long)value, (byte[])newBuf, (int)(i * 4), (int)4, (boolean)this.isLittleEndian());
            }
            System.arraycopy(newBuf, 0, buf, 0, newBuf.length);
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.ifds = null;
            this.thumbnailIFDs = null;
            this.lastPlane = 0;
            this.tiffParser = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.tiffParser = new TiffParser(this.in);
        Boolean littleEndian = this.tiffParser.checkHeader();
        if (littleEndian == null) {
            throw new FormatException("Invalid TIFF file");
        }
        boolean little = littleEndian;
        this.in.order(little);
        LOGGER.info("Reading IFDs");
        this.ifds = this.tiffParser.getNonThumbnailIFDs();
        if (this.ifds == null || this.ifds.size() == 0) {
            throw new FormatException("No IFDs found");
        }
        this.thumbnailIFDs = this.tiffParser.getThumbnailIFDs();
        LOGGER.info("Populating metadata");
        this.core[0].imageCount = this.ifds.size();
        IFD firstIFD = (IFD)this.ifds.get(0);
        PhotoInterp photo = firstIFD.getPhotometricInterpretation();
        int samples = firstIFD.getSamplesPerPixel();
        this.core[0].rgb = samples > 1 || photo == PhotoInterp.RGB;
        this.core[0].interleaved = false;
        this.core[0].littleEndian = firstIFD.isLittleEndian();
        this.core[0].sizeX = (int)firstIFD.getImageWidth();
        this.core[0].sizeY = (int)firstIFD.getImageLength();
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = this.isRGB() ? samples : 1;
        this.core[0].sizeT = this.ifds.size();
        this.core[0].pixelType = firstIFD.getPixelType();
        this.core[0].metadataComplete = true;
        boolean bl = this.core[0].indexed = photo == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
        if (this.isIndexed()) {
            this.core[0].sizeC = 1;
            this.core[0].rgb = false;
            for (IFD ifd : this.ifds) {
                ifd.putIFDValue(262, (Object)PhotoInterp.RGB_PALETTE);
            }
        }
        if (this.getSizeC() == 1 && !this.isIndexed()) {
            this.core[0].rgb = false;
        }
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].bitsPerPixel = firstIFD.getBitsPerSample()[0];
    }
}

