/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.services.NetCDFService;

public class MINCReader
extends FormatReader {
    private NetCDFService netcdf;
    private byte[][][] pixelData;

    public MINCReader() {
        super("MINC MRI", "mnc");
        this.domains = new String[]{"Medical Imaging"};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        if (no < this.pixelData.length) {
            for (int row = y; row < y + h; ++row) {
                if (row >= this.pixelData[no].length || x + w > this.pixelData[no][row].length) continue;
                System.arraycopy(this.pixelData[no][row], x * bpp, buf, (h - row + y - 1) * w * bpp, w * bpp);
            }
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.netcdf != null) {
                this.netcdf.close();
            }
            this.pixelData = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        try {
            ServiceFactory factory = new ServiceFactory();
            this.netcdf = (NetCDFService)factory.getInstance(NetCDFService.class);
            this.netcdf.setFile(id);
        }
        catch (DependencyException e) {
            throw new MissingLibraryException(e);
        }
        Double physicalX = null;
        Double physicalY = null;
        Double physicalZ = null;
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            Vector<String> variableList = this.netcdf.getVariableList();
            for (String variable : variableList) {
                Hashtable<String, Object> attributes = this.netcdf.getVariableAttributes(variable);
                Object[] keys = attributes.keySet().toArray(new String[0]);
                Arrays.sort(keys);
                for (Object key : keys) {
                    if (attributes.get(key) instanceof Object[]) {
                        Object[] o;
                        StringBuffer sb = new StringBuffer();
                        for (Object q : o = (Object[])attributes.get(key)) {
                            sb.append(q.toString());
                        }
                        this.addGlobalMeta(variable + " " + (String)key, sb.toString());
                        continue;
                    }
                    this.addGlobalMeta(variable + " " + (String)key, attributes.get(key));
                    if (!((String)key).equals("step")) continue;
                    if (variable.equals("/xspace")) {
                        physicalX = new Double(attributes.get(key).toString());
                        continue;
                    }
                    if (variable.equals("/yspace")) {
                        physicalY = new Double(attributes.get(key).toString());
                        continue;
                    }
                    if (!variable.equals("/zspace")) continue;
                    physicalZ = new Double(attributes.get(key).toString());
                }
            }
        }
        try {
            Object s;
            Object pixels = this.netcdf.getVariableValue("/image");
            if (pixels instanceof byte[][][]) {
                this.core[0].pixelType = 1;
                this.pixelData = (byte[][][])pixels;
            } else if (pixels instanceof short[][][]) {
                this.core[0].pixelType = 3;
                s = (short[][][])pixels;
                this.pixelData = new byte[((short[][][])s).length][][];
                for (int i = 0; i < ((short[][][])s).length; ++i) {
                    this.pixelData[i] = new byte[s[i].length][];
                    for (int j = 0; j < s[i].length; ++j) {
                        this.pixelData[i][j] = DataTools.shortsToBytes((short[])s[i][j], (boolean)this.isLittleEndian());
                    }
                }
            } else if (pixels instanceof int[][][]) {
                this.core[0].pixelType = 5;
                s = (int[][][])pixels;
                this.pixelData = new byte[((short[][][])s).length][][];
                for (int i = 0; i < ((short[][][])s).length; ++i) {
                    this.pixelData[i] = new byte[s[i].length][];
                    for (int j = 0; j < s[i].length; ++j) {
                        this.pixelData[i][j] = DataTools.intsToBytes((int[])s[i][j], (boolean)this.isLittleEndian());
                    }
                }
            } else if (pixels instanceof float[][][]) {
                this.core[0].pixelType = 6;
                s = (float[][][])pixels;
                this.pixelData = new byte[((short[][][])s).length][][];
                for (int i = 0; i < ((short[][][])s).length; ++i) {
                    this.pixelData[i] = new byte[s[i].length][];
                    for (int j = 0; j < s[i].length; ++j) {
                        this.pixelData[i][j] = DataTools.floatsToBytes((float[])s[i][j], (boolean)this.isLittleEndian());
                    }
                }
            } else if (pixels instanceof double[][][]) {
                this.core[0].pixelType = 7;
                s = (double[][][])pixels;
                this.pixelData = new byte[((short[][][])s).length][][];
                for (int i = 0; i < ((short[][][])s).length; ++i) {
                    this.pixelData[i] = new byte[s[i].length][];
                    for (int j = 0; j < s[i].length; ++j) {
                        this.pixelData[i][j] = DataTools.doublesToBytes((double[])s[i][j], (boolean)this.isLittleEndian());
                    }
                }
            }
        }
        catch (ServiceException e) {
            throw new FormatException(e);
        }
        this.core[0].sizeX = this.netcdf.getDimension("/zspace");
        this.core[0].sizeY = this.netcdf.getDimension("/yspace");
        this.core[0].sizeZ = this.netcdf.getDimension("/xspace");
        this.core[0].sizeT = 1;
        this.core[0].sizeC = 1;
        this.core[0].imageCount = this.core[0].sizeZ;
        this.core[0].rgb = false;
        this.core[0].indexed = false;
        this.core[0].dimensionOrder = "XYZCT";
        this.addGlobalMeta("Comment", this.netcdf.getAttributeValue("/history"));
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            store.setImageDescription(this.netcdf.getAttributeValue("/history"), 0);
            if (physicalX != null) {
                store.setPixelsPhysicalSizeX(physicalX, 0);
            }
            if (physicalY != null) {
                store.setPixelsPhysicalSizeY(physicalY, 0);
            }
            if (physicalZ != null) {
                store.setPixelsPhysicalSizeZ(physicalZ, 0);
            }
        }
    }
}

