/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;

public class ImarisReader
extends FormatReader {
    private static final int IMARIS_MAGIC_BYTES = 5021964;
    private static final boolean IS_LITTLE = false;
    private int[] offsets;

    public ImarisReader() {
        super("Bitplane Imaris", "ims");
        this.suffixSufficient = false;
        this.domains = new String[]{"Unknown"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4;
        if (!FormatTools.validStream(stream, 4, false)) {
            return false;
        }
        return stream.readInt() == 5021964;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek((long)(this.offsets[no] + this.getSizeX() * (this.getSizeY() - y - h)));
        for (int row = h - 1; row >= 0; --row) {
            this.in.skipBytes(x);
            this.in.read(buf, row * w, w);
            this.in.skipBytes(this.getSizeX() - w - x);
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.offsets = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        LOGGER.info("Verifying Imaris RAW format");
        this.in.order(false);
        long magic = this.in.readInt();
        if (magic != 5021964L) {
            throw new FormatException("Imaris magic number not found.");
        }
        LOGGER.info("Reading header");
        int version = this.in.readInt();
        this.in.skipBytes(4);
        String imageName = this.in.readString(128);
        this.core[0].sizeX = this.in.readShort();
        this.core[0].sizeY = this.in.readShort();
        this.core[0].sizeZ = this.in.readShort();
        this.in.skipBytes(2);
        this.core[0].sizeC = this.in.readInt();
        this.in.skipBytes(2);
        String date = this.in.readString(32);
        float dx = this.in.readFloat();
        float dy = this.in.readFloat();
        float dz = this.in.readFloat();
        short mag = this.in.readShort();
        String description = this.in.readString(128);
        int isSurvey = this.in.readInt();
        LOGGER.info("Calculating image offsets");
        this.core[0].imageCount = this.getSizeZ() * this.getSizeC();
        this.offsets = new int[this.getImageCount()];
        float[] gains = new float[this.getSizeC()];
        float[] detectorOffsets = new float[this.getSizeC()];
        float[] pinholes = new float[this.getSizeC()];
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            for (int i = 0; i < this.getSizeC(); ++i) {
                this.addGlobalMeta("Channel #" + i + " Comment", this.in.readString(128));
                gains[i] = this.in.readFloat();
                detectorOffsets[i] = this.in.readFloat();
                pinholes[i] = this.in.readFloat();
                this.in.skipBytes(24);
            }
        }
        int offset = 336 + 164 * this.getSizeC();
        for (int i = 0; i < this.getSizeC(); ++i) {
            for (int j = 0; j < this.getSizeZ(); ++j) {
                this.offsets[i * this.getSizeZ() + j] = offset + j * this.getSizeX() * this.getSizeY();
            }
            offset += this.getSizeX() * this.getSizeY() * this.getSizeZ();
        }
        this.addGlobalMeta("Version", version);
        this.addGlobalMeta("Image name", imageName);
        this.addGlobalMeta("Image comment", description);
        this.addGlobalMeta("Survey performed", isSurvey == 0);
        this.addGlobalMeta("Original date", date);
        LOGGER.info("Populating metadata");
        this.core[0].sizeT = this.getImageCount() / (this.getSizeC() * this.getSizeZ());
        this.core[0].dimensionOrder = "XYZCT";
        this.core[0].rgb = false;
        this.core[0].interleaved = false;
        this.core[0].littleEndian = false;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.core[0].metadataComplete = true;
        this.core[0].pixelType = 1;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        store.setImageName(imageName, 0);
        MetadataTools.setDefaultCreationDate(store, this.currentId, 0);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            int i;
            store.setImageDescription(description, 0);
            String instrumentID = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrumentID, 0);
            store.setImageInstrumentRef(instrumentID, 0);
            store.setPixelsPhysicalSizeX(new Double(dx), 0);
            store.setPixelsPhysicalSizeY(new Double(dy), 0);
            store.setPixelsPhysicalSizeZ(new Double(dz), 0);
            store.setPixelsTimeIncrement(1.0, 0);
            for (i = 0; i < this.getSizeC(); ++i) {
                if (!(pinholes[i] > 0.0f)) continue;
                store.setChannelPinholeSize(new Double(pinholes[i]), 0, i);
            }
            for (i = 0; i < this.getSizeC(); ++i) {
                if (gains[i] > 0.0f) {
                    store.setDetectorSettingsGain(new Double(gains[i]), 0, i);
                }
                store.setDetectorSettingsOffset(new Double(this.offsets[i]), i, 0);
                String detectorID = MetadataTools.createLSID("Detector", 0, i);
                store.setDetectorID(detectorID, 0, i);
                store.setDetectorType(this.getDetectorType("Other"), 0, i);
                store.setDetectorSettingsID(detectorID, 0, i);
            }
        }
    }
}

