/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;

public class FluoviewReader
extends BaseTiffReader {
    private static final String FLUOVIEW_MAGIC_STRING = "FLUOVIEW";
    private static final int MMHEADER = 34361;
    private static final int MMSTAMP = 34362;
    private static final String DATE_FORMAT = "MM/dd/yyyy HH:mm:ss.SSS";
    private double voxelX = 1.0;
    private double voxelY = 1.0;
    private double voxelZ = 1.0;
    private double voxelC = 1.0;
    private double voxelT = 1.0;
    private String dimensionOrder;
    private String date = null;
    private int timeIndex = -1;
    private int fieldIndex = -1;
    private int montageIndex = -1;
    private double[][] stamps = null;
    private String[] gains;
    private String[] voltages;
    private String[] offsets;
    private String[] channelNames;
    private String[] lensNA;
    private String mag;
    private String detectorManufacturer;
    private String objectiveManufacturer;
    private String comment;
    private double[][] montageOffsets;
    private double[][] fieldOffsets;

    public FluoviewReader() {
        super("Olympus Fluoview/ABD TIFF", new String[]{"tif", "tiff"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Light Microscopy"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        String com = ifd.getComment();
        if (com == null) {
            com = "";
        }
        return com.indexOf(FLUOVIEW_MAGIC_STRING) != -1 && ifd.containsKey(new Integer(34361)) || ifd.containsKey(new Integer(34362));
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        int image = this.getImageIndex(no);
        if ((long)this.getSizeY() == ((IFD)this.ifds.get(0)).getImageLength()) {
            this.tiffParser.getSamples((IFD)this.ifds.get(image), buf, x, y, w, h);
        } else {
            FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
            this.tiffParser.getSamples((IFD)this.ifds.get(0), buf, x, image, w, 1L);
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.voxelT = 1.0;
            this.voxelC = 1.0;
            this.voxelZ = 1.0;
            this.voxelY = 1.0;
            this.voxelX = 1.0;
            this.dimensionOrder = null;
            this.lensNA = null;
            this.channelNames = null;
            this.offsets = null;
            this.voltages = null;
            this.gains = null;
            this.comment = null;
            this.objectiveManufacturer = null;
            this.detectorManufacturer = null;
            this.mag = null;
            this.date = null;
            this.timeIndex = -1;
            this.stamps = null;
            this.fieldIndex = -1;
            this.montageIndex = -1;
            this.fieldOffsets = null;
            this.montageOffsets = null;
        }
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        int diff;
        super.initStandardMetadata();
        short[] s = ((IFD)this.ifds.get(0)).getIFDShortArray(34361);
        if (s == null) {
            throw new FormatException("Invalid Fluoview/Andor TIFF. Tag 34361 not found.");
        }
        byte[] mmheader = this.shortArrayToBytes(s);
        RandomAccessInputStream ras = new RandomAccessInputStream(mmheader);
        ras.order(this.isLittleEndian());
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            this.put("Header Flag", ras.readShort());
            this.put("Image Type", ras.read());
            String name = ras.readString(257);
            name = name.substring(0, name.indexOf("\u0000"));
            this.put("Image name", name);
            ras.skipBytes(4);
            this.put("Number of colors", ras.readInt());
            ras.skipBytes(4);
            ras.skipBytes(4);
            this.put("Comment size", ras.readInt());
            ras.skipBytes(4);
        } else {
            ras.skipBytes(284);
        }
        String[] names = new String[10];
        int[] sizes = new int[10];
        double[] resolutions = new double[10];
        for (int i = 0; i < 10; ++i) {
            names[i] = ras.readString(16);
            sizes[i] = ras.readInt();
            double origin = ras.readDouble();
            resolutions[i] = ras.readDouble();
            this.put("Dimension " + (i + 1) + " Name", names[i]);
            this.put("Dimension " + (i + 1) + " Size", sizes[i]);
            this.put("Dimension " + (i + 1) + " Origin", origin);
            this.put("Dimension " + (i + 1) + " Resolution", resolutions[i]);
            this.put("Dimension " + (i + 1) + " Units", ras.readString(64));
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            ras.skipBytes(4);
            this.put("Map type", ras.readShort());
            this.put("Map min", ras.readDouble());
            this.put("Map max", ras.readDouble());
            this.put("Min value", ras.readDouble());
            this.put("Max value", ras.readDouble());
            ras.skipBytes(4);
            this.put("Gamma", ras.readDouble());
            this.put("Offset", ras.readDouble());
            this.put("Gray Channel Name", ras.readString(16));
            this.put("Gray Channel Size", ras.readInt());
            this.put("Gray Channel Origin", ras.readDouble());
            this.put("Gray Channel Resolution", ras.readDouble());
            this.put("Gray Channel Units", ras.readString(64));
            ras.skipBytes(4);
            this.put("Voice field", ras.readInt());
            ras.skipBytes(4);
            this.readStamps();
        }
        ras.close();
        this.dimensionOrder = "XY";
        int seriesCount = 1;
        this.core[0].sizeT = 1;
        this.core[0].sizeC = 1;
        this.core[0].sizeZ = 1;
        for (int i = 0; i < 10; ++i) {
            String name = names[i];
            int size = sizes[i];
            double voxel = resolutions[i];
            if (name == null || size == 0 || (name = name.toLowerCase().trim()).length() == 0) continue;
            if (name.equals("x")) {
                this.voxelX = voxel;
                continue;
            }
            if (name.equals("y")) {
                this.voxelY = voxel;
                continue;
            }
            if (name.equals("z") || name.equals("event")) {
                this.core[0].sizeZ *= size;
                if (this.dimensionOrder.indexOf("Z") == -1) {
                    this.dimensionOrder = this.dimensionOrder + "Z";
                }
                this.voxelZ = voxel;
                continue;
            }
            if (name.equals("ch") || name.equals("wavelength")) {
                this.core[0].sizeC *= size;
                if (this.dimensionOrder.indexOf("C") == -1) {
                    this.dimensionOrder = this.dimensionOrder + "C";
                }
                this.voxelC = voxel;
                continue;
            }
            if (name.equals("time") || name.equals("t") || name.equals("animation")) {
                this.core[0].sizeT *= size;
                if (this.dimensionOrder.indexOf("T") == -1) {
                    this.dimensionOrder = this.dimensionOrder + "T";
                }
                this.voxelT = voxel;
                this.timeIndex = i - 2;
                continue;
            }
            if (this.dimensionOrder.indexOf("S") == -1) {
                this.dimensionOrder = this.dimensionOrder + "S";
            }
            seriesCount *= size;
            if (name.equals("montage")) {
                this.montageIndex = i - 2;
                continue;
            }
            if (!name.equals("xy")) continue;
            this.fieldIndex = i - 2;
        }
        if (this.dimensionOrder.indexOf("Z") == -1) {
            this.dimensionOrder = this.dimensionOrder + "Z";
        }
        if (this.dimensionOrder.indexOf("T") == -1) {
            this.dimensionOrder = this.dimensionOrder + "T";
        }
        if (this.dimensionOrder.indexOf("C") == -1) {
            this.dimensionOrder = this.dimensionOrder + "C";
        }
        if (this.dimensionOrder.indexOf("S") == -1) {
            this.dimensionOrder = this.dimensionOrder + "S";
        }
        this.core[0].imageCount = this.ifds.size() / seriesCount;
        if (this.getSizeZ() > this.getImageCount()) {
            this.core[0].sizeZ = this.getImageCount();
        }
        if (this.getSizeT() > this.getImageCount()) {
            this.core[0].sizeT = this.getImageCount();
        }
        if (this.getSizeZ() * this.getSizeC() * this.getSizeT() > this.getImageCount() && (diff = this.getSizeZ() * this.getSizeC() * this.getSizeT() - this.getImageCount()) == this.getSizeC()) {
            if (this.getSizeZ() > 1) {
                --this.core[0].sizeZ;
            } else if (this.getSizeT() > 1) {
                --this.core[0].sizeT;
            } else {
                this.core[0].sizeC /= this.getSizeC();
            }
        }
        if (!(this.getImageCount() != 1 || this.getSizeT() != this.getSizeY() && this.getSizeZ() != this.getSizeY() || this.getSizeT() <= this.getImageCount() && this.getSizeZ() <= this.getImageCount())) {
            this.core[0].sizeY = 1;
            this.core[0].imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
        }
        this.core[0].dimensionOrder = this.dimensionOrder.replaceAll("S", "");
        if (seriesCount > 1) {
            CoreMetadata oldCore = this.core[0];
            this.core = new CoreMetadata[seriesCount];
            for (int i = 0; i < seriesCount; ++i) {
                this.core[i] = oldCore;
            }
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            this.comment = ((IFD)this.ifds.get(0)).getComment();
            this.gains = new String[this.getSizeC()];
            this.offsets = new String[this.getSizeC()];
            this.voltages = new String[this.getSizeC()];
            this.channelNames = new String[this.getSizeC()];
            this.lensNA = new String[this.getSizeC()];
            this.parsePageName();
            this.parseComment();
            this.addGlobalMeta("Comment", this.comment);
        }
    }

    protected void initMetadataStore() throws FormatException {
        int i;
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        if (this.date != null) {
            store.setImageAcquiredDate(this.date, 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) {
            return;
        }
        store.setImageDescription(this.comment, 0);
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrumentID, 0);
        store.setImageInstrumentRef(instrumentID, 0);
        if (this.timeIndex >= 0) {
            for (int s = 0; s < this.getSeriesCount(); ++s) {
                this.setSeries(s);
                for (int i2 = 0; i2 < this.getImageCount(); ++i2) {
                    int index = this.getImageIndex(i2);
                    store.setPlaneDeltaT(this.stamps[this.timeIndex][index], s, i2);
                }
            }
            this.setSeries(0);
        }
        for (i = 0; i < this.getSeriesCount(); ++i) {
            store.setPixelsPhysicalSizeX(this.voxelX, i);
            store.setPixelsPhysicalSizeY(this.voxelY, i);
            store.setPixelsPhysicalSizeZ(this.voxelZ, i);
            store.setPixelsTimeIncrement(this.voxelT, i);
            int montage = this.getMontage(i);
            int field = this.getField(i);
            double posX = 0.0;
            double posY = 0.0;
            double posZ = 0.0;
            if (this.montageOffsets != null && montage < this.montageOffsets.length) {
                if (this.montageOffsets[montage].length > 0) {
                    posX += this.montageOffsets[montage][0];
                }
                if (this.montageOffsets[montage].length > 1) {
                    posY += this.montageOffsets[montage][1];
                }
                if (this.montageOffsets[montage].length > 2) {
                    posZ += this.montageOffsets[montage][2];
                }
            }
            if (this.fieldOffsets != null && field < this.fieldOffsets.length) {
                if (this.fieldOffsets[field].length > 0) {
                    posX += this.fieldOffsets[field][0];
                }
                if (this.fieldOffsets[field].length > 1) {
                    posY += this.fieldOffsets[field][1];
                }
                if (this.fieldOffsets[field].length > 2) {
                    posZ += this.fieldOffsets[field][2];
                }
            }
            for (int image = 0; image < this.getImageCount(); ++image) {
                store.setPlanePositionX(posX, i, image);
                store.setPlanePositionY(posY, i, image);
                store.setPlanePositionZ(posZ, i, image);
            }
        }
        for (i = 0; i < this.getSizeC(); ++i) {
            if (this.channelNames[i] == null) continue;
            store.setChannelName(this.channelNames[i].trim(), 0, i);
        }
        for (i = 0; i < this.getSizeC(); ++i) {
            if (this.voltages[i] != null) {
                store.setDetectorSettingsVoltage(new Double(this.voltages[i]), 0, i);
            }
            if (this.gains[i] != null) {
                store.setDetectorSettingsGain(new Double(this.gains[i]), 0, i);
            }
            if (this.offsets[i] != null) {
                store.setDetectorSettingsOffset(new Double(this.offsets[i]), 0, i);
            }
            store.setDetectorType(this.getDetectorType("Other"), 0, i);
            if (this.detectorManufacturer != null) {
                store.setDetectorManufacturer(this.detectorManufacturer, 0, i);
            }
            String detectorID = MetadataTools.createLSID("Detector", 0, i);
            store.setDetectorID(detectorID, 0, i);
            store.setDetectorSettingsID(detectorID, 0, i);
        }
        if (this.mag != null && this.mag.toLowerCase().endsWith("x")) {
            this.mag = this.mag.substring(0, this.mag.length() - 1);
        } else if (this.mag == null) {
            this.mag = "1";
        }
        store.setObjectiveCorrection(this.getCorrection("Other"), 0, 0);
        store.setObjectiveImmersion(this.getImmersion("Other"), 0, 0);
        if (this.objectiveManufacturer != null) {
            String[] objectiveData = this.objectiveManufacturer.split(" ");
            store.setObjectiveModel(objectiveData[0], 0, 0);
            if (objectiveData.length > 2) {
                store.setObjectiveImmersion(this.getImmersion(objectiveData[2]), 0, 0);
            }
        }
        if (this.mag != null) {
            store.setObjectiveCalibratedMagnification(new Double(this.mag), 0, 0);
        }
        for (int i3 = 0; i3 < this.getSizeC(); ++i3) {
            if (this.lensNA[i3] == null) continue;
            store.setObjectiveLensNA(new Double(this.lensNA[i3]), 0, i3);
        }
        String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
        store.setObjectiveID(objectiveID, 0, 0);
        store.setImageObjectiveSettingsID(objectiveID, 0);
    }

    private int getImageIndex(int no) {
        int[] lengths = new int[4];
        int[] pos = this.getZCTCoords(no);
        int[] realPos = new int[4];
        for (int i = 2; i < this.dimensionOrder.length(); ++i) {
            char axis = this.dimensionOrder.charAt(i);
            if (axis == 'Z') {
                lengths[i - 2] = this.getSizeZ();
                realPos[i - 2] = pos[0];
                continue;
            }
            if (axis == 'C') {
                lengths[i - 2] = this.getEffectiveSizeC();
                realPos[i - 2] = pos[1];
                continue;
            }
            if (axis == 'T') {
                lengths[i - 2] = this.getSizeT();
                realPos[i - 2] = pos[2];
                continue;
            }
            if (axis != 'S') continue;
            lengths[i - 2] = this.getSeriesCount();
            realPos[i - 2] = this.getSeries();
        }
        return FormatTools.positionToRaster(lengths, realPos);
    }

    private void readStamps() throws FormatException, IOException {
        this.stamps = new double[8][this.ifds.size()];
        for (int i = 0; i < this.ifds.size(); ++i) {
            byte[] stamp = this.shortArrayToBytes(((IFD)this.ifds.get(i)).getIFDShortArray(34362));
            RandomAccessInputStream ras = new RandomAccessInputStream(stamp);
            ras.order(this.isLittleEndian());
            for (int j = 0; j < 8; ++j) {
                this.stamps[j][i] = ras.readDouble() / 1000.0;
            }
            ras.close();
        }
    }

    private byte[] shortArrayToBytes(short[] s) {
        byte[] b = new byte[s.length];
        for (int i = 0; i < s.length; ++i) {
            b[i] = (byte)s[i];
        }
        return b;
    }

    private void parsePageName() {
        String[] lines;
        String pageName = ((IFD)this.ifds.get(0)).getIFDTextValue(285);
        if (pageName == null) {
            return;
        }
        for (String line : lines = pageName.split("\n")) {
            if (!line.startsWith("Resolution")) continue;
            String[] resolutions = line.split("\t");
            if (resolutions.length > 1) {
                this.voxelX = Double.parseDouble(resolutions[1].trim());
            }
            if (resolutions.length <= 2) break;
            this.voxelY = Double.parseDouble(resolutions[2].trim());
            break;
        }
    }

    private void parseComment() {
        if (this.comment != null) {
            String key;
            String[] lines;
            block2: for (String token : lines = this.comment.split("\n")) {
                int eq = (token = token.trim()).indexOf("=");
                if (eq != -1) {
                    int j;
                    int i;
                    key = token.substring(0, eq);
                    String value = token.substring(eq + 1);
                    this.addGlobalMeta(key, value);
                    if (key.startsWith("Gain Ch")) {
                        int index = Integer.parseInt(key.substring(7).trim());
                        if (index <= 0 || index > this.gains.length) continue;
                        this.gains[index - 1] = value;
                        continue;
                    }
                    if (key.startsWith("PMT Voltage Ch")) {
                        int index = Integer.parseInt(key.substring(14).trim());
                        if (index <= 0 || index > this.voltages.length) continue;
                        this.voltages[index - 1] = value;
                        continue;
                    }
                    if (key.startsWith("Offset Ch")) {
                        int index = Integer.parseInt(key.substring(9).trim());
                        if (index <= 0 || index > this.offsets.length) continue;
                        this.offsets[index - 1] = value;
                        continue;
                    }
                    if (key.equals("Magnification")) {
                        this.mag = value;
                        continue;
                    }
                    if (key.equals("System Configuration")) {
                        this.detectorManufacturer = value;
                        continue;
                    }
                    if (key.equals("Objective Lens")) {
                        this.objectiveManufacturer = value;
                        continue;
                    }
                    if (key.startsWith("Channel ") && key.endsWith("Dye")) {
                        for (int i2 = 0; i2 < this.channelNames.length; ++i2) {
                            if (this.channelNames[i2] != null) continue;
                            this.channelNames[i2] = value;
                            continue block2;
                        }
                        continue;
                    }
                    if (key.startsWith("Confocal Aperture-Ch")) {
                        int index = Integer.parseInt(key.substring(20).trim());
                        if (index <= 0 || index > this.lensNA.length) continue;
                        this.lensNA[index - 1] = value.substring(0, value.length() - 2);
                        continue;
                    }
                    if (key.equals("Date")) {
                        this.date = value;
                        continue;
                    }
                    if (key.equals("Time")) {
                        this.date = this.date + " " + value;
                        continue;
                    }
                    if (key.equals("MontageOffsets")) {
                        String[] offsets = value.split("\t");
                        this.montageOffsets = new double[offsets.length - 1][3];
                        for (i = 1; i < offsets.length; ++i) {
                            String[] v = offsets[i].trim().split(",");
                            for (j = 0; j < v.length; ++j) {
                                this.montageOffsets[i - 1][j] = Double.parseDouble(v[j].trim());
                            }
                        }
                        continue;
                    }
                    if (!key.equals("XYFields")) continue;
                    String[] offsets = value.split("\t");
                    this.fieldOffsets = new double[offsets.length - 1][3];
                    for (i = 1; i < offsets.length; ++i) {
                        String[] v = offsets[i].trim().split(",");
                        for (j = 0; j < v.length; ++j) {
                            try {
                                this.fieldOffsets[i - 1][j] = Double.parseDouble(v[j].trim());
                                continue;
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                        }
                    }
                    continue;
                }
                if (!token.startsWith("Z") || token.indexOf(" um ") == -1) continue;
                String z = token.substring(token.indexOf("-") + 1);
                z = z.replaceAll("\\p{Alpha}", "").trim();
                int firstSpace = z.indexOf(" ");
                double size = Double.parseDouble(z.substring(0, firstSpace));
                double nPlanes = Double.parseDouble(z.substring(firstSpace).trim());
                this.voxelZ = size / nPlanes;
            }
            if (this.date != null) {
                this.date = DateTools.formatDate((String)this.date.trim(), (String[])new String[]{"MM/dd/yyyy hh:mm:ss a", "MM-dd-yyyy hh:mm:ss"}, (boolean)true);
                if (this.timeIndex >= 0 && this.date != null) {
                    long ms = DateTools.getTime((String)this.date, (String)"yyyy-MM-dd'T'HH:mm:ss");
                    int nChars = String.valueOf(this.getImageCount()).length();
                    for (int i = 0; i < this.getImageCount(); ++i) {
                        int[] zct = this.getZCTCoords(i);
                        key = String.format("Timestamp for Z=%2s, C=%2s, T=%2s", zct[0], zct[1], zct[2]);
                        long stamp = ms + (long)(this.stamps[this.timeIndex][i] * 1000.0);
                        this.addGlobalMeta(key, DateTools.convertDate((long)stamp, (int)0, (String)DATE_FORMAT));
                    }
                }
            }
            int start = this.comment.indexOf("[Version Info]");
            int end = this.comment.indexOf("[Version Info End]");
            if (start != -1 && end != -1 && end > start) {
                this.comment = this.comment.substring(start + 14, end).trim();
                start = this.comment.indexOf("=") + 1;
                end = this.comment.indexOf("\n");
                this.comment = end > start ? this.comment.substring(start, end).trim() : this.comment.substring(start).trim();
            } else {
                this.comment = "";
            }
        }
    }

    private int getMontage(int seriesIndex) {
        if (this.montageOffsets == null && this.fieldOffsets == null) {
            return 0;
        }
        int[] pos = this.getPos(seriesIndex);
        return this.montageIndex < this.fieldIndex ? pos[0] : pos[1];
    }

    private int getField(int seriesIndex) {
        if (this.montageOffsets == null && this.fieldOffsets == null) {
            return 0;
        }
        int[] pos = this.getPos(seriesIndex);
        return this.montageIndex < this.fieldIndex ? pos[1] : pos[0];
    }

    private int[] getPos(int seriesIndex) {
        int[] lengths = new int[2];
        if (this.montageIndex < this.fieldIndex) {
            lengths[0] = this.montageOffsets == null ? 1 : this.montageOffsets.length;
            lengths[1] = this.fieldOffsets == null ? 1 : this.fieldOffsets.length;
        } else {
            lengths[1] = this.montageOffsets == null ? 1 : this.montageOffsets.length;
            int n = lengths[0] = this.fieldOffsets == null ? 1 : this.fieldOffsets.length;
        }
        if (lengths[0] == 0) {
            lengths[0] = 1;
        }
        if (lengths[1] == 0) {
            lengths[1] = 1;
        }
        return FormatTools.rasterToPosition(lengths, seriesIndex);
    }
}

