/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import loci.common.DateTools;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;

public class FEITiffReader
extends BaseTiffReader {
    public static final int SFEG_TAG = 34680;
    public static final int HELIOS_TAG = 34682;
    private static final String DATE_FORMAT = "MM/dd/yyyy HH:mm:ss a";
    private static final double MAG_MULTIPLIER = 0.0024388925;
    private String imageName;
    private String imageDescription;
    private String date;
    private String userName;
    private String microscopeModel;
    private Double stageX;
    private Double stageY;
    private Double stageZ;
    private Double sizeX;
    private Double sizeY;
    private Double timeIncrement;
    private ArrayList<String> detectors;

    public FEITiffReader() {
        super("FEI TIFF", new String[]{"tif", "tiff"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Scanning Electron Microscopy (SEM)"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        return ifd.containsKey(34680) || ifd.containsKey(34682);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.imageName = null;
            this.imageDescription = null;
            this.date = null;
            this.userName = null;
            this.microscopeModel = null;
            this.stageZ = null;
            this.stageY = null;
            this.stageX = null;
            this.timeIncrement = null;
            this.sizeY = null;
            this.sizeX = null;
            this.detectors = null;
        }
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        boolean helios = ((IFD)this.ifds.get(0)).containsKey(34682);
        this.addGlobalMeta("Software", helios ? "Helios NanoLab" : "S-FEG");
        String tag = ((IFD)this.ifds.get(0)).getIFDTextValue(helios ? 34682 : 34680);
        IniParser parser = new IniParser();
        IniList ini = parser.parseINI(new BufferedReader(new StringReader(tag)));
        this.detectors = new ArrayList();
        if (helios) {
            IniTable userTable = ini.getTable("User");
            this.date = (String)userTable.get((Object)"Date") + " " + (String)userTable.get((Object)"Time");
            if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
                this.userName = (String)userTable.get((Object)"User");
                this.microscopeModel = (String)ini.getTable("System").get((Object)"SystemType");
                IniTable beamTable = ini.getTable((String)ini.getTable("Beam").get((Object)"Beam"));
                this.stageX = new Double((String)beamTable.get((Object)"StageX"));
                this.stageY = new Double((String)beamTable.get((Object)"StageY"));
                this.stageZ = new Double((String)beamTable.get((Object)"StageZ"));
                IniTable scanTable = ini.getTable("Scan");
                this.sizeX = new Double((String)scanTable.get((Object)"PixelWidth")) * 1000000.0;
                this.sizeY = new Double((String)scanTable.get((Object)"PixelHeight")) * 1000000.0;
                this.timeIncrement = new Double((String)scanTable.get((Object)"FrameTime"));
            }
        } else {
            IniTable dataTable = ini.getTable("DatabarData");
            this.imageName = (String)dataTable.get((Object)"ImageName");
            this.imageDescription = (String)dataTable.get((Object)"szUserText");
            String magnification = (String)ini.getTable("Vector").get((Object)"Magnification");
            this.sizeX = new Double(magnification) * 0.0024388925;
            this.sizeY = new Double(magnification) * 0.0024388925;
            IniTable scanTable = ini.getTable("Vector.Sysscan");
            this.stageX = new Double((String)scanTable.get((Object)"PositionX"));
            this.stageY = new Double((String)scanTable.get((Object)"PositionY"));
            IniTable detectorTable = ini.getTable("Vector.Video.Detectors");
            int detectorCount = Integer.parseInt((String)detectorTable.get((Object)"NrDetectorsConnected"));
            for (int i = 0; i < detectorCount; ++i) {
                this.detectors.add((String)detectorTable.get((Object)("Detector_" + i + "_Name")));
            }
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            HashMap iniMap = ini.flattenIntoHashMap();
            this.metadata.putAll(iniMap);
        }
    }

    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (this.date != null) {
            store.setImageAcquiredDate(DateTools.formatDate((String)this.date, (String)DATE_FORMAT), 0);
        } else {
            MetadataTools.setDefaultCreationDate(store, this.currentId, 0);
        }
        if (this.imageName != null) {
            store.setImageName(this.imageName, 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            String instrument;
            if (this.imageDescription != null) {
                store.setImageDescription(this.imageDescription, 0);
            }
            if (this.userName != null) {
                store.setExperimenterID(MetadataTools.createLSID("Experimenter", 0), 0);
                store.setExperimenterDisplayName(this.userName, 0);
            }
            if (this.microscopeModel != null) {
                instrument = MetadataTools.createLSID("Instrument", 0);
                store.setInstrumentID(instrument, 0);
                store.setImageInstrumentRef(instrument, 0);
                store.setMicroscopeModel(this.microscopeModel, 0);
            }
            if (this.detectors.size() > 0) {
                instrument = MetadataTools.createLSID("Instrument", 0);
                store.setInstrumentID(instrument, 0);
                store.setImageInstrumentRef(instrument, 0);
                for (int i = 0; i < this.detectors.size(); ++i) {
                    String detectorID = MetadataTools.createLSID("Detector", 0, i);
                    store.setDetectorID(detectorID, 0, i);
                    store.setDetectorModel(this.detectors.get(i), 0, i);
                    store.setDetectorType(this.getDetectorType("Other"), 0, i);
                }
            }
            store.setStageLabelX(this.stageX, 0);
            store.setStageLabelY(this.stageY, 0);
            store.setStageLabelZ(this.stageZ, 0);
            store.setStageLabelName("", 0);
            store.setPixelsPhysicalSizeX(this.sizeX, 0);
            store.setPixelsPhysicalSizeY(this.sizeY, 0);
            store.setPixelsTimeIncrement(this.timeIncrement, 0);
        }
    }
}

