/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.DeltavisionReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;

public class CellWorxReader
extends FormatReader {
    private static final String DATE_FORMAT = "EEE MMM dd HH:mm:ss yyyy";
    private boolean[][] fieldMap;
    private String[][] wellFiles;
    private String[][] logFiles;
    private int fieldCount = 0;
    private String plateLogFile;
    private String zMapFile;

    public CellWorxReader() {
        super("CellWorx", new String[]{"pnl", "htd", "log"});
        this.domains = new String[]{"High-Content Screening (HCS)"};
    }

    public boolean isThisType(String name, boolean open) {
        String[] list;
        if (CellWorxReader.checkSuffix(name, "pnl") || CellWorxReader.checkSuffix(name, "htd")) {
            return super.isThisType(name, open);
        }
        boolean foundHTD = false;
        boolean foundPNL = false;
        Location parent = new Location(name).getAbsoluteFile().getParentFile();
        for (String file : list = parent.list(true)) {
            if (CellWorxReader.checkSuffix(file, "htd")) {
                foundHTD = true;
            }
            if (!CellWorxReader.checkSuffix(file, "pnl")) continue;
            foundPNL = true;
        }
        return foundHTD && foundPNL;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> files = new Vector<String>();
        files.add(this.currentId);
        if (this.plateLogFile != null) {
            files.add(this.plateLogFile);
        }
        if (this.zMapFile != null) {
            files.add(this.zMapFile);
        }
        int row = this.getWellRow(this.getSeries());
        int col = this.getWellColumn(this.getSeries());
        files.add(this.logFiles[row][col]);
        if (!noPixels) {
            files.add(this.wellFiles[row][col]);
        }
        return files.toArray(new String[files.size()]);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int fieldIndex = this.getSeries() % this.fieldCount;
        String file = this.getPNLFile(this.getSeries());
        DeltavisionReader pnl = new DeltavisionReader();
        pnl.setId(file);
        pnl.openBytes(fieldIndex * this.getImageCount() + no, buf, x, y, w, h);
        pnl.close();
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.fieldMap = null;
            this.wellFiles = null;
            this.logFiles = null;
            this.fieldCount = 0;
            this.plateLogFile = null;
            this.zMapFile = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (!CellWorxReader.checkSuffix(id, "htd")) {
            LOGGER.info("Searching for .htd file");
            String base = new Location(id).getAbsolutePath();
            base = base.substring(0, base.lastIndexOf("_"));
            id = base + ".HTD";
            if (!new Location(id).exists()) {
                String[] list;
                Location parent = new Location(id).getAbsoluteFile().getParentFile();
                for (String f : list = parent.list(true)) {
                    if (!CellWorxReader.checkSuffix(f, "htd")) continue;
                    id = new Location(parent, f).getAbsolutePath();
                    break;
                }
            }
        }
        super.initFile(id);
        String plateData = DataTools.readFile((String)id);
        String[] lines = plateData.split("\n");
        int xWells = 0;
        int yWells = 0;
        int xFields = 0;
        int yFields = 0;
        String[] wavelengths = null;
        for (String line : lines) {
            int col;
            String[] mapping;
            int row;
            int split = line.indexOf("\",");
            if (split < 1) continue;
            String key = line.substring(1, split).trim();
            String value = line.substring(split + 2).trim();
            if (key.equals("XWells")) {
                xWells = Integer.parseInt(value);
                continue;
            }
            if (key.equals("YWells")) {
                yWells = Integer.parseInt(value);
                this.wellFiles = new String[yWells][xWells];
                this.logFiles = new String[yWells][xWells];
                continue;
            }
            if (key.startsWith("WellsSelection")) {
                row = Integer.parseInt(key.substring(14)) - 1;
                mapping = value.split(",");
                for (col = 0; col < xWells; ++col) {
                    if (!new Boolean(mapping[col].trim()).booleanValue()) continue;
                    this.wellFiles[row][col] = "";
                }
                continue;
            }
            if (key.equals("XSites")) {
                xFields = Integer.parseInt(value);
                continue;
            }
            if (key.equals("YSites")) {
                yFields = Integer.parseInt(value);
                this.fieldMap = new boolean[yFields][xFields];
                continue;
            }
            if (key.startsWith("SiteSelection")) {
                row = Integer.parseInt(key.substring(13)) - 1;
                mapping = value.split(",");
                for (col = 0; col < xFields; ++col) {
                    this.fieldMap[row][col] = new Boolean(mapping[col].trim());
                }
                continue;
            }
            if (key.equals("NWavelengths")) {
                wavelengths = new String[Integer.parseInt(value)];
                continue;
            }
            if (!key.startsWith("WaveName")) continue;
            int index = Integer.parseInt(key.substring(8)) - 1;
            wavelengths[index] = value.replaceAll("\"", "");
        }
        for (int row = 0; row < this.fieldMap.length; ++row) {
            for (int col = 0; col < this.fieldMap[row].length; ++col) {
                if (!this.fieldMap[row][col]) continue;
                ++this.fieldCount;
            }
        }
        String plateName = new Location(id).getAbsolutePath();
        plateName = plateName.substring(0, plateName.lastIndexOf(".")) + "_";
        int wellCount = 0;
        for (int row = 0; row < this.wellFiles.length; ++row) {
            for (int col = 0; col < this.wellFiles[row].length; ++col) {
                if (this.wellFiles[row][col] == null) continue;
                ++wellCount;
                char rowLetter = (char)(row + 65);
                String base = plateName + rowLetter + String.format("%02d", col + 1);
                this.wellFiles[row][col] = base + ".pnl";
                this.logFiles[row][col] = base + "_scan.log";
            }
        }
        this.plateLogFile = plateName + "scan.log";
        String serialNumber = null;
        if (new Location(this.plateLogFile).exists()) {
            String[] f;
            for (String line : f = DataTools.readFile((String)this.plateLogFile).split("\n")) {
                if (line.trim().startsWith("Z Map File")) {
                    String file = line.substring(line.indexOf(":") + 1);
                    file = file.substring(file.lastIndexOf("/") + 1).trim();
                    String parent = new Location(id).getAbsoluteFile().getParent();
                    this.zMapFile = new Location(parent, file).getAbsolutePath();
                    continue;
                }
                if (!line.trim().startsWith("Scanner SN")) continue;
                serialNumber = line.substring(line.indexOf(":") + 1).trim();
            }
        }
        this.core = new CoreMetadata[this.fieldCount * wellCount];
        String file = this.getPNLFile(0);
        DeltavisionReader pnl = new DeltavisionReader();
        pnl.setId(file);
        for (int i = 0; i < this.core.length; ++i) {
            this.setSeries(i);
            this.core[i] = new CoreMetadata();
            this.core[i].littleEndian = pnl.isLittleEndian();
            this.core[i].sizeX = pnl.getSizeX();
            this.core[i].sizeY = pnl.getSizeY();
            this.core[i].pixelType = pnl.getPixelType();
            this.core[i].sizeZ = 1;
            this.core[i].sizeT = 1;
            this.core[i].sizeC = wavelengths.length;
            this.core[i].imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
            this.core[i].dimensionOrder = "XYCZT";
            this.core[i].rgb = false;
            this.core[i].interleaved = pnl.isInterleaved();
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        String plateID = MetadataTools.createLSID("Plate", 0);
        Location plate = new Location(id).getAbsoluteFile().getParentFile();
        store.setPlateID(plateID, 0);
        store.setPlateName(plate.getName(), 0);
        for (int i = 0; i < this.core.length; ++i) {
            store.setImageID(MetadataTools.createLSID("Image", i), i);
        }
        int nextImage = 0;
        for (int row = 0; row < this.wellFiles.length; ++row) {
            for (int col = 0; col < this.wellFiles[row].length; ++col) {
                int wellIndex = row * this.wellFiles[row].length + col;
                String wellID = MetadataTools.createLSID("Well", 0, wellIndex);
                store.setWellID(wellID, 0, wellIndex);
                store.setWellColumn(new NonNegativeInteger(Integer.valueOf(col)), 0, wellIndex);
                store.setWellRow(new NonNegativeInteger(Integer.valueOf(row)), 0, wellIndex);
                for (int fieldRow = 0; fieldRow < this.fieldMap.length; ++fieldRow) {
                    for (int fieldCol = 0; fieldCol < this.fieldMap[fieldRow].length; ++fieldCol) {
                        if (!this.fieldMap[fieldRow][fieldCol] || this.wellFiles[row][col] == null) continue;
                        int fieldIndex = fieldRow * this.fieldMap[fieldRow].length + fieldCol;
                        String wellSampleID = MetadataTools.createLSID("WellSample", 0, wellIndex, fieldIndex);
                        store.setWellSampleID(wellSampleID, 0, wellIndex, fieldIndex);
                        String imageID = MetadataTools.createLSID("Image", nextImage);
                        store.setWellSampleImageRef(imageID, 0, wellIndex, fieldIndex);
                        store.setWellSampleIndex(new NonNegativeInteger(Integer.valueOf(wellIndex * this.fieldCount + fieldIndex)), 0, wellIndex, fieldIndex);
                        String well = (char)(row + 65) + String.format("%02d", col + 1);
                        store.setImageName("Well " + well + " Field #" + (fieldIndex + 1), nextImage);
                        ++nextImage;
                    }
                }
            }
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            if (serialNumber != null) {
                store.setMicroscopeSerialNumber(serialNumber, 0);
            }
            for (int well = 0; well < wellCount; ++well) {
                this.parseWellLogFile(well, store);
            }
            for (int i = 0; i < this.core.length; ++i) {
                for (int c = 0; c < this.getSizeC(); ++c) {
                    if (c >= wavelengths.length) continue;
                    store.setChannelName(wavelengths[c], i, c);
                }
            }
        }
    }

    private int getWell(int seriesIndex) {
        int wellIndex = seriesIndex / this.fieldCount;
        int counter = -1;
        for (int row = 0; row < this.wellFiles.length; ++row) {
            for (int col = 0; col < this.wellFiles[row].length; ++col) {
                if (this.wellFiles[row][col] != null) {
                    ++counter;
                }
                if (counter != wellIndex) continue;
                return row * this.wellFiles[row].length + col;
            }
        }
        return -1;
    }

    private int getWellRow(int seriesIndex) {
        int well = this.getWell(seriesIndex);
        return well / this.wellFiles[0].length;
    }

    private int getWellColumn(int seriesIndex) {
        int well = this.getWell(seriesIndex);
        return well % this.wellFiles[0].length;
    }

    private String getPNLFile(int seriesIndex) {
        return this.wellFiles[this.getWellRow(seriesIndex)][this.getWellColumn(seriesIndex)];
    }

    private void parseWellLogFile(int wellIndex, MetadataStore store) throws IOException {
        String[] lines;
        int seriesIndex = wellIndex * this.fieldCount;
        int row = this.getWellRow(seriesIndex);
        int col = this.getWellColumn(seriesIndex);
        int well = row * this.wellFiles[0].length + col;
        String logFile = this.logFiles[row][col];
        LOGGER.debug("Parsing log file for well {}{}", (Object)Character.valueOf((char)(row + 65)), (Object)(col + 1));
        int oldSeries = this.getSeries();
        this.setSeries(seriesIndex);
        String data = DataTools.readFile((String)logFile);
        for (String line : lines = data.split("\n")) {
            String[] tokens;
            int end;
            int separator = (line = line.trim()).indexOf(":");
            if (separator < 0) continue;
            String key = line.substring(0, separator).trim();
            String value = line.substring(separator + 1).trim();
            this.addSeriesMeta(key, value);
            if (key.equals("Date")) {
                String date = DateTools.formatDate((String)value, (String)DATE_FORMAT);
                for (int field = 0; field < this.fieldCount; ++field) {
                    store.setImageAcquiredDate(date, seriesIndex + field);
                }
                continue;
            }
            if (key.equals("Scan Origin")) {
                String[] axes = value.split(",");
                for (int fieldRow = 0; fieldRow < this.fieldMap.length; ++fieldRow) {
                    for (int fieldCol = 0; fieldCol < this.fieldMap[fieldRow].length; ++fieldCol) {
                        if (!this.fieldMap[fieldRow][fieldCol] || this.wellFiles[row][col] == null) continue;
                        int field = fieldRow * this.fieldMap[fieldRow].length + fieldCol;
                        store.setWellSamplePositionX(new Double(axes[0]), 0, well, field);
                        store.setWellSamplePositionY(new Double(axes[1]), 0, well, field);
                        this.addGlobalMeta("X position for position #" + (field + 1), axes[0]);
                        this.addGlobalMeta("Y position for position #" + (field + 1), axes[1]);
                    }
                }
                continue;
            }
            if (key.equals("Scan Area")) {
                int s = value.indexOf("x");
                if (s <= 0) continue;
                end = value.indexOf(" ", s + 2);
                Double xSize = new Double(value.substring(0, s).trim());
                Double ySize = new Double(value.substring(s + 1, end).trim());
                for (int field = 0; field < this.fieldCount; ++field) {
                    int index = seriesIndex + field;
                    store.setPixelsPhysicalSizeX(xSize / (double)this.getSizeX(), index);
                    store.setPixelsPhysicalSizeY(ySize / (double)this.getSizeY(), index);
                }
                continue;
            }
            if (!key.startsWith("Channel")) continue;
            int start = key.indexOf(" ") + 1;
            end = key.indexOf(" ", start);
            if (end < 0) {
                end = key.length();
            }
            int index = Integer.parseInt(key.substring(start, end)) - 1;
            for (String token : tokens = value.split(",")) {
                int slash;
                if ((token = token.trim()).startsWith("gain")) {
                    String instrumentID = MetadataTools.createLSID("Instrument", 0);
                    Double gain = new Double(token.replaceAll("gain ", ""));
                    String detectorID = MetadataTools.createLSID("Detector", 0, 0);
                    store.setInstrumentID(instrumentID, 0);
                    store.setDetectorID(detectorID, 0, 0);
                    for (int field = 0; field < this.fieldCount; ++field) {
                        store.setImageInstrumentRef(instrumentID, seriesIndex + field);
                        store.setDetectorSettingsGain(gain, seriesIndex + field, index);
                        store.setDetectorSettingsID(detectorID, seriesIndex + field, index);
                    }
                    continue;
                }
                if (!token.startsWith("EX") || (slash = token.indexOf("/")) <= 0) continue;
                String ex = token.substring(0, slash).trim();
                String em = token.substring(slash + 1).trim();
                if (ex.indexOf(" ") > 0) {
                    ex = ex.substring(ex.indexOf(" ") + 1);
                }
                if (em.indexOf(" ") > 0 && (em = em.substring(em.indexOf(" ") + 1)).indexOf(" ") > 0) {
                    em = em.substring(0, em.indexOf(" "));
                }
                PositiveInteger exWave = new PositiveInteger(new Integer(ex));
                PositiveInteger emWave = new PositiveInteger(new Integer(em));
                for (int field = 0; field < this.fieldCount; ++field) {
                    store.setChannelExcitationWavelength(exWave, seriesIndex + field, index);
                    store.setChannelEmissionWavelength(emWave, seriesIndex + field, index);
                }
            }
        }
        this.setSeries(oldSeries);
    }
}

