/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.codec.BitBuffer;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;

public class BMPReader
extends FormatReader {
    public static final String BMP_MAGIC_STRING = "BM";
    private static final int RAW = 0;
    private static final int RLE_8 = 1;
    private static final int RLE_4 = 2;
    private static final int RGB_MASK = 3;
    private int bpp;
    private byte[][] palette;
    private int compression;
    private long global;
    private boolean invertY = false;

    public BMPReader() {
        super("Windows Bitmap", "bmp");
        this.domains = new String[]{"Graphics"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 2;
        if (!FormatTools.validStream(stream, 2, false)) {
            return false;
        }
        return stream.readString(2).startsWith(BMP_MAGIC_STRING);
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.palette;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (this.compression != 0) {
            throw new FormatException("Compression type " + this.compression + " not supported");
        }
        int rowsToSkip = this.invertY ? y : this.getSizeY() - (h + y);
        int rowLength = this.getSizeX() * (this.isIndexed() ? 1 : this.getSizeC());
        this.in.seek(this.global + (long)(rowsToSkip * rowLength));
        int pad = rowLength * this.bpp / 8 % 2;
        pad = pad == 0 ? rowLength * this.bpp / 8 % 4 : (pad *= this.getSizeC());
        int planeSize = this.getSizeX() * this.getSizeC() * this.getSizeY();
        planeSize = this.bpp >= 8 ? (planeSize *= this.bpp / 8) : (planeSize /= 8 / this.bpp);
        if ((long)(planeSize += pad * this.getSizeY()) + this.in.getFilePointer() > this.in.length()) {
            planeSize -= pad * this.getSizeY();
            pad = 0;
        }
        byte[] rawPlane = new byte[planeSize];
        this.in.read(rawPlane);
        BitBuffer bb = new BitBuffer(rawPlane);
        int effectiveC = this.palette != null && this.palette[0].length > 0 ? 1 : this.getSizeC();
        for (int row = h - 1; row >= 0; --row) {
            int rowIndex = this.invertY ? h - 1 - row : row;
            bb.skipBits(x * this.bpp * effectiveC);
            for (int i = 0; i < w * effectiveC; ++i) {
                buf[rowIndex * w * effectiveC + i] = (byte)(bb.getBits(this.bpp) & 0xFF);
            }
            if (row <= 0) continue;
            bb.skipBits((this.getSizeX() - w - x) * this.bpp * effectiveC + pad * 8);
        }
        if (this.getRGBChannelCount() > 1) {
            ImageTools.bgrToRgb(buf, this.isInterleaved(), 1, this.getRGBChannelCount());
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.compression = 0;
            this.bpp = 0;
            this.global = 0L;
            this.palette = null;
            this.invertY = false;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        LOGGER.info("Reading bitmap header");
        this.in.order(true);
        this.addGlobalMeta("Magic identifier", this.in.readString(2));
        this.addGlobalMeta("File size (in bytes)", this.in.readInt());
        this.in.skipBytes(4);
        this.global = this.in.readInt();
        this.in.skipBytes(4);
        this.core[0].sizeX = this.in.readInt();
        this.core[0].sizeY = this.in.readInt();
        if (this.getSizeX() < 1) {
            LOGGER.trace("Invalid width: {}; using the absolute value", (Object)this.getSizeX());
            this.core[0].sizeX = Math.abs(this.getSizeX());
        }
        if (this.getSizeY() < 1) {
            LOGGER.trace("Invalid height: {}; using the absolute value", (Object)this.getSizeY());
            this.core[0].sizeY = Math.abs(this.getSizeY());
            this.invertY = true;
        }
        this.addGlobalMeta("Color planes", this.in.readShort());
        this.bpp = this.in.readShort();
        this.compression = this.in.readInt();
        this.in.skipBytes(4);
        int pixelSizeX = this.in.readInt();
        int pixelSizeY = this.in.readInt();
        int nColors = this.in.readInt();
        if (nColors == 0 && this.bpp != 32 && this.bpp != 24) {
            nColors = this.bpp < 8 ? 1 << this.bpp : 256;
        }
        this.in.skipBytes(4);
        if (nColors != 0 && this.bpp == 8) {
            this.palette = new byte[3][256];
            for (int i = 0; i < nColors; ++i) {
                for (int j = this.palette.length - 1; j >= 0; --j) {
                    this.palette[j][i] = this.in.readByte();
                }
                this.in.skipBytes(1);
            }
        } else if (nColors != 0) {
            this.in.skipBytes(nColors * 4);
        }
        LOGGER.info("Populating metadata");
        int n = this.core[0].sizeC = this.bpp != 24 ? 1 : 3;
        if (this.bpp == 32) {
            this.core[0].sizeC = 4;
        }
        if (this.bpp > 8) {
            this.bpp /= this.getSizeC();
        }
        switch (this.bpp) {
            case 16: {
                this.core[0].pixelType = 3;
                break;
            }
            case 32: {
                this.core[0].pixelType = 5;
                break;
            }
            default: {
                this.core[0].pixelType = 1;
            }
        }
        this.core[0].rgb = this.getSizeC() > 1;
        this.core[0].littleEndian = true;
        this.core[0].interleaved = true;
        this.core[0].imageCount = 1;
        this.core[0].sizeZ = 1;
        this.core[0].sizeT = 1;
        this.core[0].dimensionOrder = "XYCTZ";
        this.core[0].metadataComplete = true;
        boolean bl = this.core[0].indexed = this.palette != null;
        if (this.isIndexed()) {
            this.core[0].sizeC = 1;
            this.core[0].rgb = false;
        }
        this.core[0].falseColor = false;
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            this.addGlobalMeta("Indexed color", this.palette != null);
            this.addGlobalMeta("Image width", this.getSizeX());
            this.addGlobalMeta("Image height", this.getSizeY());
            this.addGlobalMeta("Bits per pixel", this.bpp);
            String comp = "invalid";
            switch (this.compression) {
                case 0: {
                    comp = "None";
                    break;
                }
                case 1: {
                    comp = "8 bit run length encoding";
                    break;
                }
                case 2: {
                    comp = "4 bit run length encoding";
                    break;
                }
                case 3: {
                    comp = "RGB bitmap with mask";
                }
            }
            this.addGlobalMeta("Compression type", comp);
            this.addGlobalMeta("X resolution", pixelSizeX);
            this.addGlobalMeta("Y resolution", pixelSizeY);
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            double correctedX = pixelSizeX == 0 ? 0.0 : 1000000.0 / (double)pixelSizeX;
            double correctedY = pixelSizeY == 0 ? 0.0 : 1000000.0 / (double)pixelSizeY;
            store.setPixelsPhysicalSizeX(correctedX, 0);
            store.setPixelsPhysicalSizeY(correctedY, 0);
        }
    }
}

