/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.zip.CRC32;
import javax.imageio.ImageIO;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.gui.AWTImageTools;
import loci.formats.in.BIFormatReader;
import loci.formats.meta.MetadataStore;

public class APNGReader
extends BIFormatReader {
    private static final byte[] PNG_SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private Vector<PNGBlock> blocks;
    private Vector<int[]> frameCoordinates;
    private byte[][] lut;

    public APNGReader() {
        super("Animated PNG", "png");
        this.domains = new String[]{"Graphics"};
    }

    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.lut;
    }

    public Object openPlane(int no, int x, int y, int w, int h) throws FormatException, IOException {
        Object b;
        FormatTools.checkPlaneParameters(this, no, -1, x, y, w, h);
        if (no == 0) {
            this.in.seek(0L);
            DataInputStream dis = new DataInputStream(new BufferedInputStream((InputStream)this.in, 4096));
            return ImageIO.read(dis).getSubimage(x, y, w, h);
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        stream.write(PNG_SIGNATURE);
        boolean fdatValid = false;
        int fctlCount = 0;
        int[] coords = this.frameCoordinates.get(no);
        for (PNGBlock block : this.blocks) {
            if (!(block.type.equals("IDAT") || block.type.equals("fdAT") || block.type.equals("acTL") || block.type.equals("fcTL"))) {
                b = new byte[block.length + 12];
                DataTools.unpackBytes((long)block.length, (byte[])b, (int)0, (int)4, (boolean)this.isLittleEndian());
                byte[] typeBytes = block.type.getBytes();
                System.arraycopy(typeBytes, 0, b, 4, 4);
                this.in.seek(block.offset);
                this.in.read((byte[])b, 8, ((Object)b).length - 12);
                if (block.type.equals("IHDR")) {
                    DataTools.unpackBytes((long)coords[2], (byte[])b, (int)8, (int)4, (boolean)this.isLittleEndian());
                    DataTools.unpackBytes((long)coords[3], (byte[])b, (int)12, (int)4, (boolean)this.isLittleEndian());
                }
                int crc = (int)this.computeCRC((byte[])b, ((Object)b).length - 4);
                DataTools.unpackBytes((long)crc, (byte[])b, (int)(((Object)b).length - 4), (int)4, (boolean)this.isLittleEndian());
                stream.write((byte[])b);
                b = null;
                continue;
            }
            if (block.type.equals("fcTL")) {
                fdatValid = fctlCount == no;
                ++fctlCount;
                continue;
            }
            if (!block.type.equals("fdAT")) continue;
            this.in.seek(block.offset + 4L);
            if (!fdatValid) continue;
            b = new byte[block.length + 8];
            DataTools.unpackBytes((long)(block.length - 4), (byte[])b, (int)0, (int)4, (boolean)this.isLittleEndian());
            b[4] = 73;
            b[5] = 68;
            b[6] = 65;
            b[7] = 84;
            this.in.read((byte[])b, 8, ((Object)b).length - 12);
            int crc = (int)this.computeCRC((byte[])b, ((Object)b).length - 4);
            DataTools.unpackBytes((long)crc, (byte[])b, (int)(((Object)b).length - 4), (int)4, (boolean)this.isLittleEndian());
            stream.write((byte[])b);
            b = null;
        }
        RandomAccessInputStream s = new RandomAccessInputStream(stream.toByteArray());
        DataInputStream dis = new DataInputStream(new BufferedInputStream((InputStream)s, 4096));
        b = ImageIO.read(dis);
        dis.close();
        BufferedImage first = (BufferedImage)this.openPlane(0, 0, 0, this.getSizeX(), this.getSizeY());
        WritableRaster firstRaster = first.getRaster();
        WritableRaster currentRaster = ((BufferedImage)b).getRaster();
        firstRaster.setDataElements(coords[0], coords[1], currentRaster);
        return new BufferedImage(first.getColorModel(), firstRaster, false, null);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.lut = null;
            this.frameCoordinates = null;
            this.blocks = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        byte[] signature = new byte[8];
        this.in.read(signature);
        if (signature[0] != -119 || signature[1] != 80 || signature[2] != 78 || signature[3] != 71 || signature[4] != 13 || signature[5] != 10 || signature[6] != 26 || signature[7] != 10) {
            throw new FormatException("Invalid PNG signature.");
        }
        this.blocks = new Vector();
        this.frameCoordinates = new Vector();
        while (this.in.getFilePointer() < this.in.length()) {
            int length = this.in.readInt();
            String type = this.in.readString(4);
            PNGBlock block = new PNGBlock();
            block.length = length;
            block.type = type;
            block.offset = this.in.getFilePointer();
            this.blocks.add(block);
            if (type.equals("acTL")) {
                this.core[0].imageCount = this.in.readInt();
                int loop = this.in.readInt();
                this.addGlobalMeta("Loop count", loop);
            } else if (type.equals("fcTL")) {
                this.in.skipBytes(4);
                int w = this.in.readInt();
                int h = this.in.readInt();
                int x = this.in.readInt();
                int y = this.in.readInt();
                this.frameCoordinates.add(new int[]{x, y, w, h});
                this.in.skipBytes(length - 20);
            } else {
                this.in.skipBytes(length);
            }
            this.in.skipBytes(4);
        }
        if (this.core[0].imageCount == 0) {
            this.core[0].imageCount = 1;
        }
        this.core[0].sizeZ = 1;
        this.core[0].sizeT = this.getImageCount();
        this.core[0].dimensionOrder = "XYCTZ";
        this.core[0].interleaved = false;
        RandomAccessInputStream ras = new RandomAccessInputStream(this.currentId);
        DataInputStream dis = new DataInputStream((InputStream)ras);
        BufferedImage img = ImageIO.read(dis);
        dis.close();
        this.core[0].sizeX = img.getWidth();
        this.core[0].sizeY = img.getHeight();
        this.core[0].rgb = img.getRaster().getNumBands() > 1;
        this.core[0].sizeC = img.getRaster().getNumBands();
        this.core[0].pixelType = AWTImageTools.getPixelType(img);
        this.core[0].indexed = img.getColorModel() instanceof IndexColorModel;
        this.core[0].falseColor = false;
        if (this.isIndexed()) {
            this.lut = new byte[3][256];
            IndexColorModel model = (IndexColorModel)img.getColorModel();
            model.getReds(this.lut[0]);
            model.getGreens(this.lut[1]);
            model.getBlues(this.lut[2]);
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
    }

    private long computeCRC(byte[] buf, int len) {
        CRC32 crc = new CRC32();
        crc.update(buf, 0, len);
        return crc.getValue();
    }

    class PNGBlock {
        public long offset;
        public int length;
        public String type;

        PNGBlock() {
        }
    }
}

