/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.services.MDBService;

public class APLReader
extends FormatReader {
    private static final String[] METADATA_SUFFIXES = new String[]{"apl", "tnb", "mtb"};
    private String[] tiffFiles;
    private String[] xmlFiles;
    private MinimalTiffReader[] tiffReaders;
    private Vector<String> used;

    public APLReader() {
        super("Olympus APL", new String[]{"apl", "tnb", "mtb", "tif"});
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
        this.suffixSufficient = false;
    }

    public boolean isThisType(String name, boolean open) {
        Location file;
        Location parent;
        if (APLReader.checkSuffix(name, METADATA_SUFFIXES)) {
            return true;
        }
        if (APLReader.checkSuffix(name, "tif") && (parent = (file = new Location(name).getAbsoluteFile()).getParentFile()) != null && (parent = parent.getParentFile()) != null) {
            String[] list;
            for (String f : list = parent.list(true)) {
                if (!APLReader.checkSuffix(f, "mtb")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> files = new Vector<String>();
        files.addAll(this.used);
        if (this.getSeries() < this.xmlFiles.length && new Location(this.xmlFiles[this.getSeries()]).exists()) {
            files.add(this.xmlFiles[this.getSeries()]);
        }
        if (!noPixels && this.getSeries() < this.tiffFiles.length && new Location(this.tiffFiles[this.getSeries()]).exists()) {
            files.add(this.tiffFiles[this.getSeries()]);
        }
        return files.toArray(new String[files.size()]);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        return this.tiffReaders[this.series].openBytes(no, buf, x, y, w, h);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.tiffReaders != null) {
            for (MinimalTiffReader reader : this.tiffReaders) {
                reader.close(fileOnly);
            }
        }
        if (!fileOnly) {
            this.tiffReaders = null;
            this.tiffFiles = null;
            this.xmlFiles = null;
            this.used = null;
        }
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        Object[] columnNames;
        super.initFile(id);
        if (!APLReader.checkSuffix(id, "mtb")) {
            if (APLReader.checkSuffix(id, METADATA_SUFFIXES)) {
                String mtbFile;
                int underscore;
                int separator = id.lastIndexOf(File.separator);
                if (separator < 0) {
                    separator = 0;
                }
                if ((underscore = id.lastIndexOf("_")) < separator) {
                    underscore = id.lastIndexOf(".");
                }
                if (!new Location(mtbFile = id.substring(0, underscore) + "_d.mtb").exists()) {
                    throw new FormatException(".mtb file not found");
                }
                this.currentId = new Location(mtbFile).getAbsolutePath();
            } else {
                String[] list;
                Location parent = new Location(id).getAbsoluteFile().getParentFile();
                parent = parent.getParentFile();
                for (String f : list = parent.list(true)) {
                    if (!APLReader.checkSuffix(f, "mtb")) continue;
                    this.currentId = new Location(parent, f).getAbsolutePath();
                    break;
                }
                if (!APLReader.checkSuffix(this.currentId, "mtb")) {
                    throw new FormatException(".mtb file not found");
                }
            }
        }
        String mtb = new Location(this.currentId).getAbsolutePath();
        MDBService mdb = null;
        try {
            ServiceFactory factory = new ServiceFactory();
            mdb = (MDBService)factory.getInstance(MDBService.class);
        }
        catch (DependencyException de) {
            throw new FormatException("MDB Tools Java library not found", de);
        }
        mdb.initialize(mtb);
        Vector<String[]> rows = mdb.parseDatabase().get(0);
        Object[] tmpNames = columnNames = rows.get(0);
        columnNames = new String[tmpNames.length - 1];
        System.arraycopy(tmpNames, 1, columnNames, 0, columnNames.length);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            for (int i2 = 1; i2 < rows.size(); ++i2) {
                String[] row = rows.get(i2);
                for (int q = 0; q < row.length; ++q) {
                    this.addGlobalMeta(columnNames[q] + " " + i2, row[q]);
                }
            }
        }
        this.used = new Vector();
        this.used.add(mtb);
        String tnb = mtb.substring(0, mtb.lastIndexOf("."));
        if (tnb.lastIndexOf("_") > tnb.lastIndexOf(File.separator)) {
            tnb = tnb.substring(0, tnb.lastIndexOf("_"));
        }
        this.used.add(tnb + "_1.tnb");
        this.used.add(tnb + ".apl");
        String idPath = new Location(id).getAbsolutePath();
        if (!this.used.contains(idPath)) {
            this.used.add(idPath);
        }
        int calibrationUnit = DataTools.indexOf((Object[])columnNames, (Object)"Calibration Unit");
        int colorChannels = DataTools.indexOf((Object[])columnNames, (Object)"Color Channels");
        int frames = DataTools.indexOf((Object[])columnNames, (Object)"Frames");
        int calibratedHeight = DataTools.indexOf((Object[])columnNames, (Object)"Height");
        int calibratedWidth = DataTools.indexOf((Object[])columnNames, (Object)"Width");
        int path = DataTools.indexOf((Object[])columnNames, (Object)"Image Path");
        int filename = DataTools.indexOf((Object[])columnNames, (Object)"File Name");
        int magnification = DataTools.indexOf((Object[])columnNames, (Object)"Magnification");
        int width = DataTools.indexOf((Object[])columnNames, (Object)"X-Resolution");
        int height = DataTools.indexOf((Object[])columnNames, (Object)"Y-Resolution");
        int imageName = DataTools.indexOf((Object[])columnNames, (Object)"Image Name");
        int zLayers = DataTools.indexOf((Object[])columnNames, (Object)"Z-Layers");
        String parentDirectory = mtb.substring(0, mtb.lastIndexOf(File.separator));
        Location dir = new Location(parentDirectory);
        String[] list = dir.list(true);
        String topDirectory = null;
        for (String f : list) {
            Location file = new Location(dir, f);
            if (!file.isDirectory() || !f.endsWith("_DocumentFiles")) continue;
            topDirectory = file.getAbsolutePath();
        }
        if (topDirectory == null) {
            throw new FormatException("Could not find a directory with TIFF files.");
        }
        Vector<Integer> seriesIndexes = new Vector<Integer>();
        for (int i3 = 1; i3 < rows.size(); ++i3) {
            String file = rows.get(i3)[filename].trim();
            if (file.equals("") || !new Location(file = topDirectory + File.separator + file).exists() || !APLReader.checkSuffix(file, "tif")) continue;
            seriesIndexes.add(i3);
        }
        int seriesCount = seriesIndexes.size();
        this.core = new CoreMetadata[seriesCount];
        for (i = 0; i < seriesCount; ++i) {
            this.core[i] = new CoreMetadata();
        }
        this.tiffFiles = new String[seriesCount];
        this.xmlFiles = new String[seriesCount];
        this.tiffReaders = new MinimalTiffReader[seriesCount];
        for (i = 0; i < seriesCount; ++i) {
            int secondRow = (Integer)seriesIndexes.get(i);
            int firstRow = secondRow - 1;
            String[] row2 = rows.get(firstRow);
            String[] row3 = rows.get(secondRow);
            this.core[i].sizeT = this.parseDimension(row3[frames]);
            this.core[i].sizeZ = this.parseDimension(row3[zLayers]);
            this.core[i].sizeC = this.parseDimension(row3[colorChannels]);
            this.core[i].dimensionOrder = "XYCZT";
            if (this.core[i].sizeZ == 0) {
                this.core[i].sizeZ = 1;
            }
            if (this.core[i].sizeC == 0) {
                this.core[i].sizeC = 1;
            }
            if (this.core[i].sizeT == 0) {
                this.core[i].sizeT = 1;
            }
            this.xmlFiles[i] = topDirectory + File.separator + row2[filename];
            this.tiffFiles[i] = topDirectory + File.separator + row3[filename];
            this.tiffReaders[i] = new MinimalTiffReader();
            this.tiffReaders[i].setId(this.tiffFiles[i]);
            this.core[i].sizeX = this.tiffReaders[i].getSizeX();
            this.core[i].sizeY = this.tiffReaders[i].getSizeY();
            this.core[i].rgb = this.tiffReaders[i].isRGB();
            this.core[i].pixelType = this.tiffReaders[i].getPixelType();
            this.core[i].littleEndian = this.tiffReaders[i].isLittleEndian();
            this.core[i].indexed = this.tiffReaders[i].isIndexed();
            this.core[i].falseColor = this.tiffReaders[i].isFalseColor();
            this.core[i].imageCount = this.tiffReaders[i].getImageCount();
            if (this.core[i].sizeZ * this.core[i].sizeT * (this.core[i].rgb ? 1 : this.core[i].sizeC) == this.core[i].imageCount) continue;
            this.core[i].sizeT = this.core[i].imageCount / (this.core[i].rgb ? 1 : this.core[i].sizeC);
            this.core[i].sizeZ = 1;
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        for (int i4 = 0; i4 < seriesCount; ++i4) {
            String[] row = rows.get((Integer)seriesIndexes.get(i4));
            MetadataTools.setDefaultCreationDate(store, mtb, i4);
            store.setImageName(row[imageName], i4);
            if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) continue;
            double realWidth = Double.parseDouble(row[calibratedWidth]);
            double realHeight = Double.parseDouble(row[calibratedHeight]);
            String units = row[calibrationUnit];
            double px = realWidth / (double)this.core[i4].sizeX;
            double py = realHeight / (double)this.core[i4].sizeY;
            if (units.equals("mm")) {
                px *= 1000.0;
                py *= 1000.0;
            }
            store.setPixelsPhysicalSizeX(px, i4);
            store.setPixelsPhysicalSizeY(py, i4);
        }
    }

    private int parseDimension(String dim) {
        try {
            return Integer.parseInt(dim);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }
}

