/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.IOException;
import java.util.Arrays;
import loci.common.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ReaderWrapper;
import loci.formats.meta.IMinMaxStore;

public class MinMaxCalculator
extends ReaderWrapper {
    protected double[][] chanMin;
    protected double[][] chanMax;
    protected double[][] planeMin;
    protected double[][] planeMax;
    protected int[] minMaxDone;
    protected IMinMaxStore minMaxStore;

    public static MinMaxCalculator makeMinMaxCalculator(IFormatReader r) {
        if (r instanceof MinMaxCalculator) {
            return (MinMaxCalculator)r;
        }
        return new MinMaxCalculator(r);
    }

    public MinMaxCalculator() {
    }

    public MinMaxCalculator(IFormatReader r) {
        super(r);
    }

    public void setMinMaxStore(IMinMaxStore store) {
        this.minMaxStore = store;
    }

    public IMinMaxStore getMinMaxStore() {
        return this.minMaxStore;
    }

    public Double getChannelGlobalMinimum(int theC) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        if (theC < 0 || theC >= this.getSizeC()) {
            throw new FormatException("Invalid channel index: " + theC);
        }
        int series = this.getSeries();
        if (this.minMaxDone == null || this.minMaxDone[series] < this.getImageCount()) {
            return null;
        }
        return new Double(this.chanMin[series][theC]);
    }

    public Double getChannelGlobalMaximum(int theC) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        if (theC < 0 || theC >= this.getSizeC()) {
            throw new FormatException("Invalid channel index: " + theC);
        }
        int series = this.getSeries();
        if (this.minMaxDone == null || this.minMaxDone[series] < this.getImageCount()) {
            return null;
        }
        return new Double(this.chanMax[series][theC]);
    }

    public Double getChannelKnownMinimum(int theC) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.chanMin == null ? null : new Double(this.chanMin[this.getSeries()][theC]);
    }

    public Double getChannelKnownMaximum(int theC) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.chanMax == null ? null : new Double(this.chanMax[this.getSeries()][theC]);
    }

    public Double[] getPlaneMinimum(int no) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        if (this.planeMin == null) {
            return null;
        }
        int numRGB = this.getRGBChannelCount();
        int pBase = no * numRGB;
        int series = this.getSeries();
        if (Double.isNaN(this.planeMin[series][pBase])) {
            return null;
        }
        Double[] min = new Double[numRGB];
        for (int c = 0; c < numRGB; ++c) {
            min[c] = new Double(this.planeMin[series][pBase + c]);
        }
        return min;
    }

    public Double[] getPlaneMaximum(int no) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        if (this.planeMax == null) {
            return null;
        }
        int numRGB = this.getRGBChannelCount();
        int pBase = no * numRGB;
        int series = this.getSeries();
        if (Double.isNaN(this.planeMax[series][pBase])) {
            return null;
        }
        Double[] max = new Double[numRGB];
        for (int c = 0; c < numRGB; ++c) {
            max[c] = new Double(this.planeMax[series][pBase + c]);
        }
        return max;
    }

    public boolean isMinMaxPopulated() throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.minMaxDone != null && this.minMaxDone[this.getSeries()] == this.getImageCount();
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        return this.openBytes(no, 0, 0, this.getSizeX(), this.getSizeY());
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        return this.openBytes(no, buf, 0, 0, this.getSizeX(), this.getSizeY());
    }

    public byte[] openBytes(int no, int x, int y, int w, int h) throws FormatException, IOException {
        byte[] buf = new byte[w * h * this.getRGBChannelCount() * FormatTools.getBytesPerPixel(this.getPixelType())];
        return this.openBytes(no, buf, x, y, w, h);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        super.openBytes(no, buf, x, y, w, h);
        this.updateMinMax(buf, no);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        this.reader.close(fileOnly);
        if (!fileOnly) {
            this.chanMin = null;
            this.chanMax = null;
            this.planeMin = null;
            this.planeMax = null;
            this.minMaxDone = null;
        }
    }

    protected void updateMinMax(byte[] b, int ndx) throws FormatException, IOException {
        int c;
        if (b == null) {
            return;
        }
        this.initMinMax();
        int numRGB = this.getRGBChannelCount();
        int series = this.getSeries();
        if (!Double.isNaN(this.planeMin[series][ndx * numRGB])) {
            return;
        }
        boolean little = this.isLittleEndian();
        int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
        int pixels = b.length / (bytes * numRGB);
        boolean interleaved = this.isInterleaved();
        int[] coords = this.getZCTCoords(ndx);
        int cBase = coords[1] * numRGB;
        int pBase = ndx * numRGB;
        for (int c2 = 0; c2 < numRGB; ++c2) {
            this.planeMin[series][pBase + c2] = Double.POSITIVE_INFINITY;
            this.planeMax[series][pBase + c2] = Double.NEGATIVE_INFINITY;
        }
        int pixelType = this.getPixelType();
        boolean signed = FormatTools.isSigned(pixelType);
        long threshold = (long)Math.pow(2.0, bytes * 8 - 1);
        for (int i = 0; i < pixels; ++i) {
            for (int c3 = 0; c3 < numRGB; ++c3) {
                int idx = bytes * (interleaved ? i * numRGB + c3 : c3 * pixels + i);
                long bits = DataTools.bytesToLong((byte[])b, (int)idx, (int)bytes, (boolean)little);
                if (signed && bits >= threshold) {
                    bits -= 2L * threshold;
                }
                double v = bits;
                if (pixelType == 6) {
                    v = Float.intBitsToFloat((int)bits);
                } else if (pixelType == 7) {
                    v = Double.longBitsToDouble(bits);
                }
                if (v > this.chanMax[series][cBase + c3]) {
                    this.chanMax[series][cBase + c3] = v;
                }
                if (!(v < this.chanMin[series][cBase + c3])) continue;
                this.chanMin[series][cBase + c3] = v;
            }
        }
        for (c = 0; c < numRGB; ++c) {
            if (this.chanMin[series][cBase + c] < this.planeMin[series][pBase + c]) {
                this.planeMin[series][pBase + c] = this.chanMin[series][cBase + c];
            }
            if (!(this.chanMax[series][cBase + c] > this.planeMax[series][pBase + c])) continue;
            this.planeMax[series][pBase + c] = this.chanMax[series][cBase + c];
        }
        int n = series;
        this.minMaxDone[n] = this.minMaxDone[n] + 1;
        if (this.minMaxDone[this.getSeries()] == this.getImageCount() && this.minMaxStore != null) {
            for (c = 0; c < this.getSizeC(); ++c) {
                this.minMaxStore.setChannelGlobalMinMax(c, this.chanMin[this.getSeries()][c], this.chanMax[this.getSeries()][c], this.getSeries());
            }
        }
    }

    protected void initMinMax() throws FormatException, IOException {
        int numRGB;
        int i;
        int seriesCount = this.getSeriesCount();
        int oldSeries = this.getSeries();
        if (this.chanMin == null) {
            this.chanMin = new double[seriesCount][];
            for (i = 0; i < seriesCount; ++i) {
                this.setSeries(i);
                this.chanMin[i] = new double[this.getSizeC()];
                Arrays.fill(this.chanMin[i], Double.POSITIVE_INFINITY);
            }
            this.setSeries(oldSeries);
        }
        if (this.chanMax == null) {
            this.chanMax = new double[seriesCount][];
            for (i = 0; i < seriesCount; ++i) {
                this.setSeries(i);
                this.chanMax[i] = new double[this.getSizeC()];
                Arrays.fill(this.chanMax[i], Double.NEGATIVE_INFINITY);
            }
            this.setSeries(oldSeries);
        }
        if (this.planeMin == null) {
            this.planeMin = new double[seriesCount][];
            for (i = 0; i < seriesCount; ++i) {
                this.setSeries(i);
                numRGB = this.getRGBChannelCount();
                this.planeMin[i] = new double[this.getImageCount() * numRGB];
                Arrays.fill(this.planeMin[i], Double.NaN);
            }
            this.setSeries(oldSeries);
        }
        if (this.planeMax == null) {
            this.planeMax = new double[seriesCount][];
            for (i = 0; i < seriesCount; ++i) {
                this.setSeries(i);
                numRGB = this.getRGBChannelCount();
                this.planeMax[i] = new double[this.getImageCount() * numRGB];
                Arrays.fill(this.planeMax[i], Double.NaN);
            }
            this.setSeries(oldSeries);
        }
        if (this.minMaxDone == null) {
            this.minMaxDone = new int[seriesCount];
        }
    }
}

