/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FileInfo;
import loci.formats.FormatException;
import loci.formats.FormatHandler;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.DefaultMetadataOptions;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MetadataOptions;
import loci.formats.meta.DummyMetadata;
import loci.formats.meta.FilterMetadata;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import ome.xml.model.enums.AcquisitionMode;
import ome.xml.model.enums.ArcType;
import ome.xml.model.enums.Binning;
import ome.xml.model.enums.Compression;
import ome.xml.model.enums.ContrastMethod;
import ome.xml.model.enums.Correction;
import ome.xml.model.enums.DetectorType;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.ExperimentType;
import ome.xml.model.enums.FilamentType;
import ome.xml.model.enums.FillRule;
import ome.xml.model.enums.FilterType;
import ome.xml.model.enums.FontFamily;
import ome.xml.model.enums.FontStyle;
import ome.xml.model.enums.IlluminationType;
import ome.xml.model.enums.Immersion;
import ome.xml.model.enums.LaserMedium;
import ome.xml.model.enums.LaserType;
import ome.xml.model.enums.LineCap;
import ome.xml.model.enums.Marker;
import ome.xml.model.enums.Medium;
import ome.xml.model.enums.MicrobeamManipulationType;
import ome.xml.model.enums.MicroscopeType;
import ome.xml.model.enums.NamingConvention;
import ome.xml.model.enums.PixelType;
import ome.xml.model.enums.Pulse;
import ome.xml.model.enums.handlers.AcquisitionModeEnumHandler;
import ome.xml.model.enums.handlers.ArcTypeEnumHandler;
import ome.xml.model.enums.handlers.BinningEnumHandler;
import ome.xml.model.enums.handlers.CompressionEnumHandler;
import ome.xml.model.enums.handlers.ContrastMethodEnumHandler;
import ome.xml.model.enums.handlers.CorrectionEnumHandler;
import ome.xml.model.enums.handlers.DetectorTypeEnumHandler;
import ome.xml.model.enums.handlers.DimensionOrderEnumHandler;
import ome.xml.model.enums.handlers.ExperimentTypeEnumHandler;
import ome.xml.model.enums.handlers.FilamentTypeEnumHandler;
import ome.xml.model.enums.handlers.FillRuleEnumHandler;
import ome.xml.model.enums.handlers.FilterTypeEnumHandler;
import ome.xml.model.enums.handlers.FontFamilyEnumHandler;
import ome.xml.model.enums.handlers.FontStyleEnumHandler;
import ome.xml.model.enums.handlers.IlluminationTypeEnumHandler;
import ome.xml.model.enums.handlers.ImmersionEnumHandler;
import ome.xml.model.enums.handlers.LaserMediumEnumHandler;
import ome.xml.model.enums.handlers.LaserTypeEnumHandler;
import ome.xml.model.enums.handlers.LineCapEnumHandler;
import ome.xml.model.enums.handlers.MarkerEnumHandler;
import ome.xml.model.enums.handlers.MediumEnumHandler;
import ome.xml.model.enums.handlers.MicrobeamManipulationTypeEnumHandler;
import ome.xml.model.enums.handlers.MicroscopeTypeEnumHandler;
import ome.xml.model.enums.handlers.NamingConventionEnumHandler;
import ome.xml.model.enums.handlers.PixelTypeEnumHandler;
import ome.xml.model.enums.handlers.PulseEnumHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FormatReader
extends FormatHandler
implements IFormatReader {
    protected static final int THUMBNAIL_DIMENSION = 128;
    protected RandomAccessInputStream in;
    protected Hashtable<String, Object> metadata;
    protected int series = 0;
    protected CoreMetadata[] core;
    protected boolean suffixNecessary = true;
    protected boolean suffixSufficient = true;
    protected boolean hasCompanionFiles = false;
    protected boolean normalizeData;
    protected boolean filterMetadata;
    protected boolean saveOriginalMetadata = false;
    protected boolean indexedAsRGB = false;
    protected boolean group = true;
    protected String[] domains = new String[0];
    protected MetadataStore metadataStore = new DummyMetadata();
    protected MetadataOptions metadataOptions = new DefaultMetadataOptions();
    private ServiceFactory factory;
    private OMEXMLService service;

    public FormatReader(String format, String suffix) {
        super(format, suffix);
    }

    public FormatReader(String format, String[] suffixes) {
        super(format, suffixes);
    }

    protected void initFile(String id) throws FormatException, IOException {
        LOGGER.debug("{}.initFile({})", (Object)this.getClass().getName(), (Object)id);
        if (this.currentId != null) {
            String[] s = this.getUsedFiles();
            for (int i = 0; i < s.length; ++i) {
                if (!id.equals(s[i])) continue;
                return;
            }
        }
        this.series = 0;
        this.close();
        this.currentId = id;
        this.metadata = new Hashtable();
        this.core = new CoreMetadata[1];
        this.core[0] = new CoreMetadata();
        this.core[0].orderCertain = true;
        this.getMetadataStore().createRoot();
    }

    protected boolean isUsedFile(String file) {
        String[] usedFiles;
        for (String used : usedFiles = this.getUsedFiles()) {
            if (used.equals(file)) {
                return true;
            }
            String path = new Location(file).getAbsolutePath();
            if (!used.equals(path)) continue;
            return true;
        }
        return false;
    }

    protected void addMeta(String key, Object value, Hashtable<String, Object> meta) {
        String val;
        if (key == null || value == null || !this.isMetadataCollected()) {
            return;
        }
        key = key.trim();
        boolean string = value instanceof String || value instanceof Character;
        boolean simple = string || value instanceof Number || value instanceof Boolean;
        String string2 = val = string ? String.valueOf(value) : null;
        if (this.filterMetadata || this.saveOriginalMetadata && this.getMetadataStore() instanceof OMEXMLMetadata) {
            if (!simple) {
                return;
            }
            int maxLen = 8192;
            if (key.length() > maxLen) {
                return;
            }
            if (string && val.length() > maxLen) {
                return;
            }
            key = DataTools.sanitize((String)key);
            if (string) {
                val = DataTools.sanitize((String)val);
            }
            if (!key.matches(".*[a-zA-Z].*")) {
                return;
            }
            String[] invalidSequences = new String[]{"&lt;", "&gt;", "&amp;", "<", ">", "&"};
            for (int i = 0; i < invalidSequences.length; ++i) {
                key = key.replaceAll(invalidSequences[i], "");
                if (!string) continue;
                val = val.replaceAll(invalidSequences[i], "");
            }
            if (key.length() == 0) {
                return;
            }
            if (string && val.trim().length() == 0) {
                return;
            }
            if (string) {
                value = val;
            }
        }
        meta.put(key, val == null ? value : val);
    }

    protected void addGlobalMeta(String key, Object value) {
        this.addMeta(key, value, this.getGlobalMetadata());
    }

    protected void addGlobalMeta(String key, boolean value) {
        this.addGlobalMeta(key, new Boolean(value));
    }

    protected void addGlobalMeta(String key, byte value) {
        this.addGlobalMeta(key, new Byte(value));
    }

    protected void addGlobalMeta(String key, short value) {
        this.addGlobalMeta(key, new Short(value));
    }

    protected void addGlobalMeta(String key, int value) {
        this.addGlobalMeta(key, new Integer(value));
    }

    protected void addGlobalMeta(String key, long value) {
        this.addGlobalMeta(key, new Long(value));
    }

    protected void addGlobalMeta(String key, float value) {
        this.addGlobalMeta(key, new Float(value));
    }

    protected void addGlobalMeta(String key, double value) {
        this.addGlobalMeta(key, new Double(value));
    }

    protected void addGlobalMeta(String key, char value) {
        this.addGlobalMeta(key, new Character(value));
    }

    protected Object getGlobalMeta(String key) {
        return this.metadata.get(key);
    }

    protected void addSeriesMeta(String key, Object value) {
        this.addMeta(key, value, this.core[this.series].seriesMetadata);
    }

    protected void addSeriesMeta(String key, boolean value) {
        this.addSeriesMeta(key, new Boolean(value));
    }

    protected void addSeriesMeta(String key, byte value) {
        this.addSeriesMeta(key, new Byte(value));
    }

    protected void addSeriesMeta(String key, short value) {
        this.addSeriesMeta(key, new Short(value));
    }

    protected void addSeriesMeta(String key, int value) {
        this.addSeriesMeta(key, new Integer(value));
    }

    protected void addSeriesMeta(String key, long value) {
        this.addSeriesMeta(key, new Long(value));
    }

    protected void addSeriesMeta(String key, float value) {
        this.addSeriesMeta(key, new Float(value));
    }

    protected void addSeriesMeta(String key, double value) {
        this.addSeriesMeta(key, new Double(value));
    }

    protected void addSeriesMeta(String key, char value) {
        this.addSeriesMeta(key, new Character(value));
    }

    protected Object getSeriesMeta(String key) {
        return this.core[this.series].seriesMetadata.get(key);
    }

    protected byte[] readPlane(RandomAccessInputStream s, int x, int y, int w, int h, byte[] buf) throws IOException {
        return this.readPlane(s, x, y, w, h, 0, buf);
    }

    protected byte[] readPlane(RandomAccessInputStream s, int x, int y, int w, int h, int scanlinePad, byte[] buf) throws IOException {
        int c = this.getRGBChannelCount();
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        if (x == 0 && y == 0 && w == this.getSizeX() && h == this.getSizeY() && scanlinePad == 0) {
            s.read(buf);
        } else if (x == 0 && w == this.getSizeX() && scanlinePad == 0) {
            if (this.isInterleaved()) {
                s.skipBytes(y * w * bpp * c);
                s.read(buf, 0, h * w * bpp * c);
            } else {
                int rowLen = w * bpp;
                for (int channel = 0; channel < c; ++channel) {
                    s.skipBytes(y * rowLen);
                    s.read(buf, channel * h * rowLen, h * rowLen);
                    if (channel >= c - 1) continue;
                    s.skipBytes((this.getSizeY() - y - h) * rowLen);
                }
            }
        } else {
            int scanlineWidth = this.getSizeX() + scanlinePad;
            if (this.isInterleaved()) {
                s.skipBytes(y * scanlineWidth * bpp * c);
                for (int row = 0; row < h; ++row) {
                    s.skipBytes(x * bpp * c);
                    s.read(buf, row * w * bpp * c, w * bpp * c);
                    if (row >= h - 1) continue;
                    s.skipBytes(bpp * c * (scanlineWidth - w - x));
                }
            } else {
                for (int channel = 0; channel < c; ++channel) {
                    s.skipBytes(y * scanlineWidth * bpp);
                    for (int row = 0; row < h; ++row) {
                        s.skipBytes(x * bpp);
                        s.read(buf, channel * w * h * bpp + row * w * bpp, w * bpp);
                        if (row >= h - 1 && channel >= c - 1) continue;
                        s.skipBytes(bpp * (scanlineWidth - w - x));
                    }
                    if (channel >= c - 1) continue;
                    s.skipBytes(scanlineWidth * bpp * (this.getSizeY() - y - h));
                }
            }
        }
        return buf;
    }

    protected MetadataStore makeFilterMetadata() {
        return new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
    }

    @Override
    public Set<MetadataLevel> getSupportedMetadataLevels() {
        HashSet<MetadataLevel> supportedLevels = new HashSet<MetadataLevel>();
        supportedLevels.add(MetadataLevel.ALL);
        supportedLevels.add(MetadataLevel.NO_OVERLAYS);
        supportedLevels.add(MetadataLevel.MINIMUM);
        return supportedLevels;
    }

    @Override
    public MetadataOptions getMetadataOptions() {
        return this.metadataOptions;
    }

    @Override
    public void setMetadataOptions(MetadataOptions options) {
        this.metadataOptions = options;
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (!this.suffixSufficient && !open) {
            return false;
        }
        if (this.suffixNecessary || this.suffixSufficient) {
            boolean suffixMatch = super.isThisType(name);
            if (this.suffixNecessary && !suffixMatch) {
                return false;
            }
            if (suffixMatch && this.suffixSufficient) {
                return true;
            }
        }
        if (!open) {
            return false;
        }
        try {
            RandomAccessInputStream stream = new RandomAccessInputStream(name);
            boolean isThisType = this.isThisType(stream);
            stream.close();
            return isThisType;
        }
        catch (IOException exc) {
            LOGGER.debug("", (Throwable)exc);
            return false;
        }
    }

    @Override
    public boolean isThisType(byte[] block) {
        try {
            RandomAccessInputStream stream = new RandomAccessInputStream(block);
            boolean isThisType = this.isThisType(stream);
            stream.close();
            return isThisType;
        }
        catch (IOException e) {
            LOGGER.debug("", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return false;
    }

    @Override
    public int getImageCount() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].imageCount;
    }

    @Override
    public boolean isRGB() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].rgb;
    }

    @Override
    public int getSizeX() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].sizeX;
    }

    @Override
    public int getSizeY() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].sizeY;
    }

    @Override
    public int getSizeZ() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].sizeZ;
    }

    @Override
    public int getSizeC() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].sizeC;
    }

    @Override
    public int getSizeT() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].sizeT;
    }

    @Override
    public int getPixelType() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].pixelType;
    }

    @Override
    public int getBitsPerPixel() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.core[this.series].bitsPerPixel == 0) {
            this.core[this.series].bitsPerPixel = FormatTools.getBytesPerPixel(this.getPixelType()) * 8;
        }
        return this.core[this.series].bitsPerPixel;
    }

    @Override
    public int getEffectiveSizeC() {
        int sizeZT = this.getSizeZ() * this.getSizeT();
        if (sizeZT == 0) {
            return 0;
        }
        return this.getImageCount() / sizeZT;
    }

    @Override
    public int getRGBChannelCount() {
        int effSizeC = this.getEffectiveSizeC();
        if (effSizeC == 0) {
            return 0;
        }
        return this.getSizeC() / effSizeC;
    }

    @Override
    public boolean isIndexed() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].indexed;
    }

    @Override
    public boolean isFalseColor() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].falseColor;
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        return null;
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        return null;
    }

    @Override
    public int[] getChannelDimLengths() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.core[this.series].cLengths == null) {
            return new int[]{this.core[this.series].sizeC};
        }
        return this.core[this.series].cLengths;
    }

    @Override
    public String[] getChannelDimTypes() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.core[this.series].cTypes == null) {
            return new String[]{"Channel"};
        }
        return this.core[this.series].cTypes;
    }

    @Override
    public int getThumbSizeX() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.core[this.series].thumbSizeX == 0) {
            int sx = this.getSizeX();
            int sy = this.getSizeY();
            int thumbSizeX = 0;
            if (sx > sy) {
                thumbSizeX = 128;
            } else if (sy > 0) {
                thumbSizeX = sx * 128 / sy;
            }
            if (thumbSizeX == 0) {
                thumbSizeX = 1;
            }
            return thumbSizeX;
        }
        return this.core[this.series].thumbSizeX;
    }

    @Override
    public int getThumbSizeY() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.core[this.series].thumbSizeY == 0) {
            int sx = this.getSizeX();
            int sy = this.getSizeY();
            int thumbSizeY = 1;
            if (sy > sx) {
                thumbSizeY = 128;
            } else if (sx > 0) {
                thumbSizeY = sy * 128 / sx;
            }
            if (thumbSizeY == 0) {
                thumbSizeY = 1;
            }
            return thumbSizeY;
        }
        return this.core[this.series].thumbSizeY;
    }

    @Override
    public boolean isLittleEndian() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].littleEndian;
    }

    @Override
    public String getDimensionOrder() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].dimensionOrder;
    }

    @Override
    public boolean isOrderCertain() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].orderCertain;
    }

    @Override
    public boolean isThumbnailSeries() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].thumbnail;
    }

    @Override
    public boolean isInterleaved() {
        return this.isInterleaved(0);
    }

    @Override
    public boolean isInterleaved(int subC) {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].interleaved;
    }

    @Override
    public byte[] openBytes(int no) throws FormatException, IOException {
        return this.openBytes(no, 0, 0, this.getSizeX(), this.getSizeY());
    }

    @Override
    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        return this.openBytes(no, buf, 0, 0, this.getSizeX(), this.getSizeY());
    }

    @Override
    public byte[] openBytes(int no, int x, int y, int w, int h) throws FormatException, IOException {
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int ch = this.getRGBChannelCount();
        byte[] newBuffer = new byte[w * h * ch * bpp];
        return this.openBytes(no, newBuffer, x, y, w, h);
    }

    @Override
    public abstract byte[] openBytes(int var1, byte[] var2, int var3, int var4, int var5, int var6) throws FormatException, IOException;

    @Override
    public Object openPlane(int no, int x, int y, int w, int h) throws FormatException, IOException {
        return this.openBytes(no, x, y, w, h);
    }

    @Override
    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return FormatTools.openThumbBytes(this, no);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        if (!fileOnly) {
            this.in = null;
            this.currentId = null;
        }
    }

    @Override
    public int getSeriesCount() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core.length;
    }

    @Override
    public void setSeries(int no) {
        if (no < 0 || no >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Invalid series: " + no);
        }
        this.series = no;
    }

    @Override
    public int getSeries() {
        return this.series;
    }

    @Override
    public void setGroupFiles(boolean groupFiles) {
        FormatTools.assertId(this.currentId, false, 1);
        this.group = groupFiles;
    }

    @Override
    public boolean isGroupFiles() {
        return this.group;
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 2;
    }

    @Override
    public boolean isMetadataComplete() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].metadataComplete;
    }

    @Override
    public void setNormalized(boolean normalize) {
        FormatTools.assertId(this.currentId, false, 1);
        this.normalizeData = normalize;
    }

    @Override
    public boolean isNormalized() {
        return this.normalizeData;
    }

    @Override
    public void setMetadataCollected(boolean collect) {
        FormatTools.assertId(this.currentId, false, 1);
        MetadataLevel level = collect ? MetadataLevel.ALL : MetadataLevel.MINIMUM;
        this.setMetadataOptions(new DefaultMetadataOptions(level));
    }

    @Override
    public boolean isMetadataCollected() {
        return this.getMetadataOptions().getMetadataLevel() == MetadataLevel.ALL;
    }

    @Override
    public void setOriginalMetadataPopulated(boolean populate) {
        FormatTools.assertId(this.currentId, false, 1);
        this.saveOriginalMetadata = populate;
    }

    @Override
    public boolean isOriginalMetadataPopulated() {
        return this.saveOriginalMetadata;
    }

    @Override
    public String[] getUsedFiles() {
        return this.getUsedFiles(false);
    }

    @Override
    public String[] getUsedFiles(boolean noPixels) {
        int oldSeries = this.getSeries();
        Vector<String> files = new Vector<String>();
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            this.setSeries(i);
            String[] s = this.getSeriesUsedFiles(noPixels);
            if (s == null) continue;
            for (String file : s) {
                if (files.contains(file)) continue;
                files.add(file);
            }
        }
        this.setSeries(oldSeries);
        return files.toArray(new String[files.size()]);
    }

    @Override
    public String[] getSeriesUsedFiles() {
        return this.getSeriesUsedFiles(false);
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        String[] stringArray;
        if (noPixels) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.currentId;
        }
        return stringArray;
    }

    @Override
    public FileInfo[] getAdvancedUsedFiles(boolean noPixels) {
        String[] files = this.getUsedFiles(noPixels);
        if (files == null) {
            return null;
        }
        FileInfo[] infos = new FileInfo[files.length];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = new FileInfo();
            infos[i].filename = files[i];
            infos[i].reader = this.getClass();
            infos[i].usedToInitialize = files[i].endsWith(this.getCurrentFile());
        }
        return infos;
    }

    @Override
    public FileInfo[] getAdvancedSeriesUsedFiles(boolean noPixels) {
        String[] files = this.getSeriesUsedFiles(noPixels);
        if (files == null) {
            return null;
        }
        FileInfo[] infos = new FileInfo[files.length];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = new FileInfo();
            infos[i].filename = files[i];
            infos[i].reader = this.getClass();
            infos[i].usedToInitialize = files[i].endsWith(this.getCurrentFile());
        }
        return infos;
    }

    @Override
    public String getCurrentFile() {
        return this.currentId;
    }

    @Override
    public int getIndex(int z, int c, int t) {
        FormatTools.assertId(this.currentId, true, 1);
        return FormatTools.getIndex(this, z, c, t);
    }

    @Override
    public int[] getZCTCoords(int index) {
        FormatTools.assertId(this.currentId, true, 1);
        return FormatTools.getZCTCoords(this, index);
    }

    @Override
    public Object getMetadataValue(String field) {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getGlobalMeta(field);
    }

    @Override
    public Object getSeriesMetadataValue(String field) {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getSeriesMeta(field);
    }

    @Override
    public Hashtable<String, Object> getGlobalMetadata() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.metadata;
    }

    @Override
    public Hashtable<String, Object> getSeriesMetadata() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core[this.series].seriesMetadata;
    }

    @Override
    public Hashtable<String, Object> getMetadata() {
        FormatTools.assertId(this.currentId, true, 1);
        Hashtable<String, Object> h = new Hashtable<String, Object>(this.getGlobalMetadata());
        int oldSeries = this.getSeries();
        IMetadata meta = this.getMetadataStore() instanceof IMetadata ? (IMetadata)this.getMetadataStore() : null;
        for (int series = 0; series < this.getSeriesCount(); ++series) {
            String realName;
            String name = "Series " + series;
            if (meta != null && (realName = meta.getImageName(series)) != null && realName.trim().length() != 0) {
                name = realName;
            }
            this.setSeries(series);
            MetadataTools.merge(this.getSeriesMetadata(), h, name + " ");
        }
        this.setSeries(oldSeries);
        return h;
    }

    @Override
    public CoreMetadata[] getCoreMetadata() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core;
    }

    @Override
    public void setMetadataFiltered(boolean filter) {
        FormatTools.assertId(this.currentId, false, 1);
        this.filterMetadata = filter;
    }

    @Override
    public boolean isMetadataFiltered() {
        return this.filterMetadata;
    }

    @Override
    public void setMetadataStore(MetadataStore store) {
        FormatTools.assertId(this.currentId, false, 1);
        if (store == null) {
            throw new IllegalArgumentException("Metadata object cannot be null; use loci.formats.meta.DummyMetadata instead");
        }
        this.metadataStore = store;
    }

    @Override
    public MetadataStore getMetadataStore() {
        return this.metadataStore;
    }

    @Override
    public Object getMetadataStoreRoot() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getMetadataStore().getRoot();
    }

    @Override
    public IFormatReader[] getUnderlyingReaders() {
        return null;
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return true;
    }

    @Override
    public boolean hasCompanionFiles() {
        return this.hasCompanionFiles;
    }

    @Override
    public String[] getPossibleDomains(String id) throws FormatException, IOException {
        return this.domains;
    }

    @Override
    public String[] getDomains() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.domains;
    }

    @Override
    public boolean isThisType(String name) {
        return this.isThisType(name, true);
    }

    @Override
    public void setId(String id) throws FormatException, IOException {
        if (!id.equals(this.currentId)) {
            MetadataStore store;
            this.initFile(id);
            if (this.saveOriginalMetadata && (store = this.getMetadataStore()) instanceof OMEXMLMetadata) {
                try {
                    if (this.factory == null) {
                        this.factory = new ServiceFactory();
                    }
                    if (this.service == null) {
                        this.service = (OMEXMLService)this.factory.getInstance(OMEXMLService.class);
                    }
                    this.service.populateOriginalMetadata((OMEXMLMetadata)store, this.metadata);
                }
                catch (DependencyException e) {
                    LOGGER.warn("OMEXMLService not available.", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.close(false);
    }

    protected AcquisitionMode getAcquisitionMode(String value) throws FormatException {
        AcquisitionModeEnumHandler handler = new AcquisitionModeEnumHandler();
        try {
            return (AcquisitionMode)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("AcquisitionMode creation failed", e);
        }
    }

    protected ArcType getArcType(String value) throws FormatException {
        ArcTypeEnumHandler handler = new ArcTypeEnumHandler();
        try {
            return (ArcType)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("ArcType creation failed", e);
        }
    }

    protected Binning getBinning(String value) throws FormatException {
        BinningEnumHandler handler = new BinningEnumHandler();
        try {
            return (Binning)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("Binning creation failed", e);
        }
    }

    protected Compression getCompression(String value) throws FormatException {
        CompressionEnumHandler handler = new CompressionEnumHandler();
        try {
            return (Compression)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("Compression creation failed", e);
        }
    }

    protected ContrastMethod getContrastMethod(String value) throws FormatException {
        ContrastMethodEnumHandler handler = new ContrastMethodEnumHandler();
        try {
            return (ContrastMethod)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("ContrastMethod creation failed", e);
        }
    }

    protected Correction getCorrection(String value) throws FormatException {
        CorrectionEnumHandler handler = new CorrectionEnumHandler();
        try {
            return (Correction)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("Correction creation failed", e);
        }
    }

    protected DetectorType getDetectorType(String value) throws FormatException {
        DetectorTypeEnumHandler handler = new DetectorTypeEnumHandler();
        try {
            return (DetectorType)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("DetectorType creation failed", e);
        }
    }

    protected DimensionOrder getDimensionOrder(String value) throws FormatException {
        DimensionOrderEnumHandler handler = new DimensionOrderEnumHandler();
        try {
            return (DimensionOrder)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("DimensionOrder creation failed", e);
        }
    }

    protected ExperimentType getExperimentType(String value) throws FormatException {
        ExperimentTypeEnumHandler handler = new ExperimentTypeEnumHandler();
        try {
            return (ExperimentType)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("ExperimentType creation failed", e);
        }
    }

    protected FilamentType getFilamentType(String value) throws FormatException {
        FilamentTypeEnumHandler handler = new FilamentTypeEnumHandler();
        try {
            return (FilamentType)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("FilamentType creation failed", e);
        }
    }

    protected FillRule getFillRule(String value) throws FormatException {
        FillRuleEnumHandler handler = new FillRuleEnumHandler();
        try {
            return (FillRule)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("FillRule creation failed", e);
        }
    }

    protected FilterType getFilterType(String value) throws FormatException {
        FilterTypeEnumHandler handler = new FilterTypeEnumHandler();
        try {
            return (FilterType)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("FilterType creation failed", e);
        }
    }

    protected FontFamily getFontFamily(String value) throws FormatException {
        FontFamilyEnumHandler handler = new FontFamilyEnumHandler();
        try {
            return (FontFamily)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("FontFamily creation failed", e);
        }
    }

    protected FontStyle getFontStyle(String value) throws FormatException {
        FontStyleEnumHandler handler = new FontStyleEnumHandler();
        try {
            return (FontStyle)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("FontStyle creation failed", e);
        }
    }

    protected IlluminationType getIlluminationType(String value) throws FormatException {
        IlluminationTypeEnumHandler handler = new IlluminationTypeEnumHandler();
        try {
            return (IlluminationType)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("IlluminationType creation failed", e);
        }
    }

    protected Immersion getImmersion(String value) throws FormatException {
        ImmersionEnumHandler handler = new ImmersionEnumHandler();
        try {
            return (Immersion)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("Immersion creation failed", e);
        }
    }

    protected LaserMedium getLaserMedium(String value) throws FormatException {
        LaserMediumEnumHandler handler = new LaserMediumEnumHandler();
        try {
            return (LaserMedium)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("LaserMedium creation failed", e);
        }
    }

    protected LaserType getLaserType(String value) throws FormatException {
        LaserTypeEnumHandler handler = new LaserTypeEnumHandler();
        try {
            return (LaserType)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("LaserType creation failed", e);
        }
    }

    protected LineCap getLineCap(String value) throws FormatException {
        LineCapEnumHandler handler = new LineCapEnumHandler();
        try {
            return (LineCap)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("LineCap creation failed", e);
        }
    }

    protected Marker getMarker(String value) throws FormatException {
        MarkerEnumHandler handler = new MarkerEnumHandler();
        try {
            return (Marker)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("Marker creation failed", e);
        }
    }

    protected Medium getMedium(String value) throws FormatException {
        MediumEnumHandler handler = new MediumEnumHandler();
        try {
            return (Medium)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("Medium creation failed", e);
        }
    }

    protected MicrobeamManipulationType getMicrobeamManipulationType(String value) throws FormatException {
        MicrobeamManipulationTypeEnumHandler handler = new MicrobeamManipulationTypeEnumHandler();
        try {
            return (MicrobeamManipulationType)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("MicrobeamManipulationType creation failed", e);
        }
    }

    protected MicroscopeType getMicroscopeType(String value) throws FormatException {
        MicroscopeTypeEnumHandler handler = new MicroscopeTypeEnumHandler();
        try {
            return (MicroscopeType)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("MicroscopeType creation failed", e);
        }
    }

    protected NamingConvention getNamingConvention(String value) throws FormatException {
        NamingConventionEnumHandler handler = new NamingConventionEnumHandler();
        try {
            return (NamingConvention)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("NamingConvention creation failed", e);
        }
    }

    protected PixelType getPixelType(String value) throws FormatException {
        PixelTypeEnumHandler handler = new PixelTypeEnumHandler();
        try {
            return (PixelType)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("PixelType creation failed", e);
        }
    }

    protected Pulse getPulse(String value) throws FormatException {
        PulseEnumHandler handler = new PulseEnumHandler();
        try {
            return (Pulse)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("Pulse creation failed", e);
        }
    }
}

