/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.List;
import ome.xml.model.ManufacturerSpec;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class LightSource
extends ManufacturerSpec {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2010-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(LightSource.class);
    private String id;
    private Double power;

    public LightSource() {
    }

    public LightSource(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> LightEmittingDiode_nodeList;
        List<Element> Arc_nodeList;
        List<Element> Filament_nodeList;
        List<Element> Laser_nodeList;
        super.update(element, model);
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("LightSource missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("Power")) {
            this.setPower(Double.valueOf(element.getAttribute("Power")));
        }
        if ((Laser_nodeList = LightSource.getChildrenByTagName(element, "Laser")).size() > 1) {
            throw new RuntimeException(String.format("Laser node list size %d != 1", Laser_nodeList.size()));
        }
        if (Laser_nodeList.size() != 0) {
            // empty if block
        }
        if ((Filament_nodeList = LightSource.getChildrenByTagName(element, "Filament")).size() > 1) {
            throw new RuntimeException(String.format("Filament node list size %d != 1", Filament_nodeList.size()));
        }
        if (Filament_nodeList.size() != 0) {
            // empty if block
        }
        if ((Arc_nodeList = LightSource.getChildrenByTagName(element, "Arc")).size() > 1) {
            throw new RuntimeException(String.format("Arc node list size %d != 1", Arc_nodeList.size()));
        }
        if (Arc_nodeList.size() != 0) {
            // empty if block
        }
        if ((LightEmittingDiode_nodeList = LightSource.getChildrenByTagName(element, "LightEmittingDiode")).size() > 1) {
            throw new RuntimeException(String.format("LightEmittingDiode node list size %d != 1", LightEmittingDiode_nodeList.size()));
        }
        if (LightEmittingDiode_nodeList.size() != 0) {
            // empty if block
        }
    }

    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public Double getPower() {
        return this.power;
    }

    public void setPower(Double power) {
        this.power = power;
    }

    protected Element asXMLElement(Document document, Element LightSource_element) {
        if (!"LightSource".equals(LightSource_element.getTagName())) {
            Element abstractElement = document.createElementNS(NAMESPACE, "LightSource");
            abstractElement.appendChild(LightSource_element);
            LightSource_element = abstractElement;
        }
        if (LightSource_element == null) {
            LightSource_element = document.createElementNS(NAMESPACE, "LightSource");
        }
        if (this.id != null) {
            LightSource_element.setAttribute("ID", this.id.toString());
        }
        if (this.power != null) {
            LightSource_element.setAttribute("Power", this.power.toString());
        }
        return super.asXMLElement(document, LightSource_element);
    }
}

