/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo;

import Ice.Current;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import ome.services.blitz.impl.AbstractAmdServant;
import omero.ApiUsageException;
import omero.InternalException;
import omero.ResourceError;
import omero.ServerError;
import omero.api.AMD_RawFileStore_exists;
import omero.api.AMD_RawFileStore_read;
import omero.api.AMD_RawFileStore_save;
import omero.api.AMD_RawFileStore_setFileId;
import omero.api.AMD_RawFileStore_size;
import omero.api.AMD_RawFileStore_truncate;
import omero.api.AMD_RawFileStore_write;
import omero.api._RawFileStoreOperations;
import omero.util.IceMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepoRawFileStoreI
extends AbstractAmdServant
implements _RawFileStoreOperations {
    private static final Log log = LogFactory.getLog(RepoRawFileStoreI.class);
    private final long fileId;
    private final File file;
    private final RandomAccessFile rafile;

    public RepoRawFileStoreI(long fileId, File file) {
        super(null, null);
        this.fileId = fileId;
        this.file = file;
        try {
            this.rafile = new RandomAccessFile(file, "r");
            log.info((Object)("Opened " + this.rafile));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void setFileId_async(AMD_RawFileStore_setFileId __cb, long fileId, Current __current) throws ServerError {
        ApiUsageException aue = new ApiUsageException();
        aue.message = "Cannot reset id from " + this.fileId + " to " + fileId;
        __cb.ice_exception((Exception)aue);
    }

    public void exists_async(AMD_RawFileStore_exists __cb, Current __current) throws ServerError {
        try {
            __cb.ice_response(this.file.exists());
        }
        catch (Exception e) {
            __cb.ice_exception(e);
        }
    }

    public void read_async(AMD_RawFileStore_read __cb, long position, int length, Current __current) throws ServerError {
        if (length > 64000000) {
            __cb.ice_exception((Exception)new ApiUsageException(null, null, "Too big: " + length));
            return;
        }
        try {
            byte[] array = new byte[length];
            ByteBuffer buffer = ByteBuffer.wrap(array);
            this.rafile.getChannel().read(buffer, position);
            __cb.ice_response(array);
        }
        catch (Throwable t) {
            __cb.ice_exception((Exception)((Object)this.convert(t)));
        }
    }

    public void size_async(AMD_RawFileStore_size __cb, Current __current) throws ServerError {
        try {
            long size = this.rafile.getChannel().size();
            __cb.ice_response(size);
        }
        catch (Throwable t) {
            __cb.ice_exception((Exception)((Object)this.convert(t)));
        }
    }

    public void truncate_async(AMD_RawFileStore_truncate __cb, long length, Current __current) throws ServerError {
        __cb.ice_exception((Exception)new ApiUsageException(null, null, "Currently disabled."));
    }

    public void write_async(AMD_RawFileStore_write __cb, byte[] buf, long position, int length, Current __current) throws ServerError {
        __cb.ice_exception((Exception)new ApiUsageException(null, null, "Currently disabled."));
    }

    public void save_async(AMD_RawFileStore_save __cb, Current __current) throws ServerError {
        __cb.ice_response(null);
    }

    protected void preClose() {
        log.info((Object)("Closing " + this.rafile));
        try {
            this.rafile.close();
        }
        catch (Exception e) {
            log.error((Object)"Failed to close rafile", (Throwable)e);
        }
    }

    private ServerError convert(Throwable t) {
        if (t instanceof ServerError) {
            return (ServerError)t;
        }
        ResourceError se = null;
        se = t instanceof IOException ? new ResourceError() : new InternalException();
        IceMapper.fillServerError((ServerError)((Object)se), (Throwable)t);
        return se;
    }
}

