/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.gui;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import ome.formats.importer.gui.ImportCellRenderer;
import ome.formats.importer.gui.ImportEntry;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.jdesktop.swingx.VerticalLayout;

public class HistoryTaskBar
extends JXPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    JXTaskPaneContainer tpContainer = new JXTaskPaneContainer();
    DefaultListModel today = new DefaultListModel();
    DefaultListModel yesterday = new DefaultListModel();
    DefaultListModel thisWeek = new DefaultListModel();
    DefaultListModel lastWeek = new DefaultListModel();
    DefaultListModel thisMonth = new DefaultListModel();

    public HistoryTaskBar() {
        double[][] table = new double[][]{{158.0}, {-2.0}};
        TableLayout layout = new TableLayout((double[][])table);
        this.setLayout((LayoutManager)layout);
        this.tpContainer.setBorder(null);
        this.tpContainer.setLayout((LayoutManager)new VerticalLayout(0));
        this.add((Component)this.tpContainer, "0,0");
    }

    public void addTaskPane(String name, JList list) {
        JXTaskPane taskPane = new JXTaskPane();
        taskPane.setTitle(name);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(list);
        taskPane.getContentPane().getParent().add(scrollPane);
        taskPane.setCollapsed(true);
        this.tpContainer.add(taskPane);
    }

    public JList getList(JList list) {
        list.setCellRenderer(new ImportCellRenderer());
        list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                int index;
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() > 0 && (index = list.locationToIndex(evt.getPoint())) >= 0) {
                    ImportEntry entry = (ImportEntry)list.getModel().getElementAt(index);
                    HistoryTaskBar.this.firePropertyChange("QUICK_HISTORY", -1, entry.importKey);
                }
            }
        });
        return list;
    }

    public void updateList(JList list, DefaultListModel mine, DefaultListModel theirs) {
        mine.clear();
        for (int i = 0; i < theirs.size(); ++i) {
            mine.addElement(theirs.get(i));
        }
        list.validate();
        this.tpContainer.validate();
    }

    public void actionPerformed(ActionEvent event) {
    }
}

