/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.netcdf3;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.unidata.io.RandomAccessFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class N3header {
    static final byte[] MAGIC = new byte[]{67, 68, 70, 1};
    static final int MAGIC_DIM = 10;
    static final int MAGIC_VAR = 11;
    static final int MAGIC_ATT = 12;
    public static boolean disallowFileTruncation = false;
    public static boolean debugHeaderSize = false;
    private boolean debug = false;
    private boolean debugPos = false;
    private boolean debugString = false;
    private boolean debugVariablePos = false;
    private RandomAccessFile raf;
    private NetcdfFile ncfile;
    private PrintStream out = System.out;
    private List<Variable> uvars = new ArrayList<Variable>();
    private Dimension udim;
    boolean isStreaming = false;
    int numrecs = 0;
    int recsize = 0;
    long dataStart = Long.MAX_VALUE;
    long recStart = Integer.MAX_VALUE;
    private long nonRecordData = 0L;
    private long globalAttsPos = 0L;

    public static boolean isValidFile(RandomAccessFile raf) throws IOException {
        raf.seek(0L);
        byte[] b = new byte[4];
        raf.read(b);
        for (int i = 0; i < 3; ++i) {
            if (b[i] == MAGIC[i]) continue;
            return false;
        }
        return b[3] == 1 || b[3] == 2;
    }

    void read(RandomAccessFile raf, NetcdfFile ncfile, PrintStream out) throws IOException {
        long calcSize;
        this.raf = raf;
        this.ncfile = ncfile;
        if (out == null) {
            out = System.out;
        }
        this.out = out;
        long actualSize = raf.length();
        long pos = 0L;
        raf.seek(pos);
        byte[] b = new byte[4];
        raf.read(b);
        for (int i = 0; i < 3; ++i) {
            if (b[i] == MAGIC[i]) continue;
            throw new IOException("Not a netCDF file");
        }
        if (b[3] != 1 && b[3] != 2) {
            throw new IOException("Not a netCDF file");
        }
        boolean useLongOffset = b[3] == 2;
        this.numrecs = raf.readInt();
        if (this.debug) {
            out.println("numrecs= " + this.numrecs);
        }
        if (this.numrecs == -1) {
            this.isStreaming = true;
            this.numrecs = 0;
        }
        int numdims = 0;
        int magic = raf.readInt();
        if (magic == 0) {
            raf.readInt();
        } else {
            if (magic != 10) {
                throw new IOException("Misformed netCDF file - dim magic number wrong");
            }
            numdims = raf.readInt();
            if (this.debug) {
                out.println("numdims= " + numdims);
            }
        }
        for (int i = 0; i < numdims; ++i) {
            Dimension dim;
            if (this.debugPos) {
                out.println("  dim " + i + " pos= " + raf.getFilePointer());
            }
            String name = this.readString();
            int len = raf.readInt();
            if (len == 0) {
                this.udim = dim = new Dimension(name, this.numrecs, true, true, false);
            } else {
                dim = new Dimension(name, len, true, false, false);
            }
            ncfile.addDimension(null, dim);
            if (!this.debug) continue;
            out.println(" added dimension " + dim);
        }
        this.globalAttsPos = raf.getFilePointer();
        this.readAtts(ncfile.getRootGroup().getAttributes());
        int nvars = 0;
        magic = raf.readInt();
        if (magic == 0) {
            raf.readInt();
        } else {
            if (magic != 11) {
                throw new IOException("Misformed netCDF file  - var magic number wrong");
            }
            nvars = raf.readInt();
            if (this.debug) {
                out.println("numdims= " + numdims);
            }
        }
        if (this.debug) {
            out.println("num variables= " + nvars);
        }
        for (int i = 0; i < nvars; ++i) {
            long begin;
            int j;
            String name = this.readString();
            Variable var = new Variable(ncfile, ncfile.getRootGroup(), null, name);
            int velems = 1;
            boolean isRecord = false;
            int rank = raf.readInt();
            ArrayList<Dimension> dims = new ArrayList<Dimension>();
            for (j = 0; j < rank; ++j) {
                int dimIndex = raf.readInt();
                Dimension dim = ncfile.getRootGroup().getDimensions().get(dimIndex);
                if (dim.isUnlimited()) {
                    isRecord = true;
                    this.uvars.add(var);
                } else {
                    velems *= dim.getLength();
                }
                dims.add(dim);
            }
            var.setDimensions(dims);
            if (this.debug) {
                out.print("---name=<" + name + "> dims = [");
                for (j = 0; j < rank; ++j) {
                    Dimension dim = (Dimension)dims.get(j);
                    out.print(dim.getName() + " ");
                }
                out.println("]");
            }
            long varAttsPos = raf.getFilePointer();
            this.readAtts(var.getAttributes());
            int type = raf.readInt();
            var.setDataType(this.getDataType(type));
            int vsize = raf.readInt();
            long l = begin = useLongOffset ? raf.readLong() : (long)raf.readInt();
            if (this.debug) {
                out.println(" name= " + name + " type=" + type + " vsize=" + vsize + " velems=" + velems + " begin= " + begin + " isRecord=" + isRecord + " attsPos= " + varAttsPos + "\n");
            }
            var.setSPobject(new Vinfo(vsize, begin, isRecord, varAttsPos));
            if (isRecord) {
                this.recsize += vsize;
                this.recStart = Math.min(this.recStart, (long)((int)begin));
            } else {
                this.nonRecordData = Math.max(this.nonRecordData, begin + (long)vsize);
            }
            this.dataStart = Math.min(this.dataStart, (long)((int)begin));
            if (this.debugVariablePos) {
                System.out.println(var.getName() + " begin at = " + begin + " end=" + (begin + (long)vsize) + " isRecord=" + isRecord + " nonRecordData=" + this.nonRecordData);
            }
            ncfile.addVariable(null, var);
        }
        pos = (int)raf.getFilePointer();
        if (this.nonRecordData > 0L) {
            this.nonRecordData -= this.dataStart;
        }
        if (this.uvars.size() == 0) {
            this.recStart = 0L;
        }
        if (debugHeaderSize) {
            System.out.println("  filePointer = " + pos + " dataStart=" + this.dataStart);
            System.out.println("  recStart = " + this.recStart + " dataStart+nonRecordData =" + (this.dataStart + this.nonRecordData));
            System.out.println("  nonRecordData size= " + this.nonRecordData);
            System.out.println("  recsize= " + this.recsize);
            System.out.println("  numrecs= " + this.numrecs);
        }
        if (this.isStreaming) {
            long recordSpace = actualSize - this.dataStart - this.nonRecordData;
            if (this.debug) {
                System.out.println(" isStreaming recordSpace=" + recordSpace + " has extra bytes = " + recordSpace % (long)this.recsize);
            }
            this.numrecs = (int)(recordSpace / (long)this.recsize);
            if (this.udim != null) {
                this.udim.setLength(this.numrecs);
                for (Variable uvar : this.uvars) {
                    uvar.resetShape();
                    uvar.invalidateCache();
                }
            }
        }
        if ((calcSize = this.dataStart + this.nonRecordData + (long)(this.recsize * this.numrecs)) > actualSize + 3L) {
            if (disallowFileTruncation) {
                throw new IOException("File is truncated calculated size= " + calcSize + " actual = " + actualSize);
            }
            raf.setExtendMode();
        }
    }

    synchronized boolean removeRecordStructure() {
        boolean found = false;
        for (Variable v : this.uvars) {
            if (!v.getName().equals("record")) continue;
            this.uvars.remove(v);
            this.ncfile.getRootGroup().getVariables().remove(v);
            found = true;
            break;
        }
        this.ncfile.finish();
        return found;
    }

    synchronized boolean addRecordStructure() {
        if (this.uvars.size() > 0) {
            Structure recordStructure = new Structure(this.ncfile, this.ncfile.getRootGroup(), null, "record");
            recordStructure.setDimensions(this.udim.getName());
            for (Variable v : this.uvars) {
                Variable memberV = new Variable(v);
                memberV.setParentStructure(recordStructure);
                ArrayList<Dimension> dims = new ArrayList<Dimension>(v.getDimensions());
                dims.remove(0);
                memberV.setDimensions(dims);
                recordStructure.addMemberVariable(memberV);
            }
            this.uvars.add(recordStructure);
            this.ncfile.getRootGroup().addVariable(recordStructure);
            this.ncfile.finish();
            return true;
        }
        return false;
    }

    private int readAtts(List<Attribute> atts) throws IOException {
        int natts = 0;
        int magic = this.raf.readInt();
        if (magic == 0) {
            this.raf.readInt();
        } else {
            if (magic != 12) {
                throw new IOException("Misformed netCDF file  - att magic number wrong");
            }
            natts = this.raf.readInt();
        }
        if (this.debug) {
            this.out.println(" num atts= " + natts);
        }
        for (int i = 0; i < natts; ++i) {
            Attribute att;
            if (this.debugPos) {
                this.out.println("***att " + i + " pos= " + this.raf.getFilePointer());
            }
            String name = this.readString();
            int type = this.raf.readInt();
            if (type == 2) {
                if (this.debugPos) {
                    this.out.println(" begin read String val pos= " + this.raf.getFilePointer());
                }
                String val = this.readString();
                if (this.debugPos) {
                    this.out.println(" end read String val pos= " + this.raf.getFilePointer());
                }
                att = new Attribute(name, val);
            } else {
                if (this.debugPos) {
                    this.out.println(" begin read val pos= " + this.raf.getFilePointer());
                }
                int nelems = this.raf.readInt();
                DataType dtype = this.getDataType(type);
                int[] shape = new int[]{nelems};
                Array arr = Array.factory(dtype.getPrimitiveClassType(), shape);
                IndexIterator ii = arr.getIndexIterator();
                int nbytes = 0;
                for (int j = 0; j < nelems; ++j) {
                    nbytes += this.readAttributeValue(dtype, ii);
                }
                att = new Attribute(name, arr);
                this.skip(nbytes);
                if (this.debugPos) {
                    this.out.println(" end read val pos= " + this.raf.getFilePointer());
                }
            }
            atts.add(att);
            if (!this.debug) continue;
            this.out.println("  " + att.toString() + "\n");
        }
        return natts;
    }

    private int readAttributeValue(DataType type, IndexIterator ii) throws IOException {
        if (type == DataType.BYTE) {
            byte b = (byte)this.raf.read();
            ii.setByteNext(b);
            return 1;
        }
        if (type == DataType.CHAR) {
            char c = (char)this.raf.read();
            ii.setCharNext(c);
            return 1;
        }
        if (type == DataType.SHORT) {
            short s = this.raf.readShort();
            ii.setShortNext(s);
            return 2;
        }
        if (type == DataType.INT) {
            int i = this.raf.readInt();
            ii.setIntNext(i);
            return 4;
        }
        if (type == DataType.FLOAT) {
            float f = this.raf.readFloat();
            ii.setFloatNext(f);
            return 4;
        }
        if (type == DataType.DOUBLE) {
            double d = this.raf.readDouble();
            ii.setDoubleNext(d);
            return 8;
        }
        return 0;
    }

    private String readString() throws IOException {
        int nelems = this.raf.readInt();
        if (this.debugString) {
            this.printBytes(nelems);
        }
        byte[] b = new byte[nelems];
        this.raf.read(b);
        this.skip(nelems);
        return new String(b, "UTF-8");
    }

    private void skip(int nbytes) throws IOException {
        int pad = N3header.padding(nbytes);
        if (pad > 0) {
            this.raf.seek(this.raf.getFilePointer() + (long)pad);
        }
    }

    static int padding(int nbytes) {
        int pad = nbytes % 4;
        if (pad != 0) {
            pad = 4 - pad;
        }
        return pad;
    }

    private void printBytes(int n) throws IOException {
        long savePos;
        long pos;
        for (pos = savePos = this.raf.getFilePointer(); pos < savePos + (long)n - 9L; pos += 10L) {
            this.out.print(pos + ": ");
            this._printBytes(10);
        }
        if (pos < savePos + (long)n) {
            this.out.print(pos + ": ");
            this._printBytes((int)(savePos + (long)n - pos));
        }
        this.raf.seek(savePos);
    }

    private void _printBytes(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            int b = this.raf.read();
            int ub = b < 0 ? b + 256 : b;
            this.out.print(ub + "(");
            this.out.write(b);
            this.out.print(") ");
        }
        this.out.println();
    }

    private DataType getDataType(int type) {
        switch (type) {
            case 1: {
                return DataType.BYTE;
            }
            case 2: {
                return DataType.CHAR;
            }
            case 3: {
                return DataType.SHORT;
            }
            case 4: {
                return DataType.INT;
            }
            case 5: {
                return DataType.FLOAT;
            }
            case 6: {
                return DataType.DOUBLE;
            }
        }
        throw new IllegalArgumentException("unknown type == " + type);
    }

    static int getType(DataType dt) {
        if (dt == DataType.BYTE) {
            return 1;
        }
        if (dt == DataType.CHAR || dt == DataType.STRING) {
            return 2;
        }
        if (dt == DataType.SHORT) {
            return 3;
        }
        if (dt == DataType.INT) {
            return 4;
        }
        if (dt == DataType.FLOAT) {
            return 5;
        }
        if (dt == DataType.DOUBLE) {
            return 6;
        }
        throw new IllegalArgumentException("unknown DataType == " + dt);
    }

    void create(RandomAccessFile raf, NetcdfFile ncfile, boolean fill, PrintStream out) throws IOException {
        Vinfo vinfo;
        this.raf = raf;
        this.ncfile = ncfile;
        if (out != null) {
            this.out = out;
        }
        raf.seek(0L);
        raf.write(MAGIC);
        raf.writeInt(0);
        List<Dimension> dims = ncfile.getDimensions();
        int numdims = dims.size();
        if (numdims == 0) {
            raf.writeInt(0);
            raf.writeInt(0);
        } else {
            raf.writeInt(10);
            raf.writeInt(numdims);
        }
        for (int i = 0; i < numdims; ++i) {
            Dimension dim = dims.get(i);
            if (this.debugPos && out != null) {
                out.println("  dim " + i + " pos= " + raf.getFilePointer());
            }
            this.writeString(dim.getName());
            raf.writeInt(dim.isUnlimited() ? 0 : dim.getLength());
            if (!dim.isUnlimited()) continue;
            this.udim = dim;
        }
        this.globalAttsPos = raf.getFilePointer();
        this.writeAtts(ncfile.getGlobalAttributes());
        List<Variable> vars = ncfile.getVariables();
        this.writeVars(vars);
        long pos = this.dataStart = raf.getFilePointer();
        for (Variable var : vars) {
            vinfo = (Vinfo)var.getSPobject();
            if (vinfo.isRecord) continue;
            raf.seek(vinfo.begin);
            raf.writeInt((int)pos);
            vinfo.begin = pos;
            if (this.debugVariablePos) {
                System.out.println(var.getName() + " begin at = " + vinfo.begin + " end=" + (vinfo.begin + (long)vinfo.vsize));
            }
            pos += (long)vinfo.vsize;
        }
        this.recStart = pos;
        for (Variable var : vars) {
            vinfo = (Vinfo)var.getSPobject();
            if (!vinfo.isRecord) continue;
            raf.seek(vinfo.begin);
            raf.writeInt((int)pos);
            vinfo.begin = pos;
            if (this.debug) {
                System.out.println(var.getName() + " record begin at = " + this.dataStart);
            }
            pos += (long)vinfo.vsize;
            this.uvars.add(var);
        }
    }

    void updateAttribute(Variable v2, Attribute att) throws IOException {
        long pos;
        if (v2 == null) {
            pos = this.findAtt(this.globalAttsPos, att.getName());
        } else {
            Vinfo vinfo = (Vinfo)v2.getSPobject();
            pos = this.findAtt(vinfo.attsPos, att.getName());
        }
        this.raf.seek(pos);
        int type = this.raf.readInt();
        DataType have = this.getDataType(type);
        DataType want = att.getDataType();
        if (want == DataType.STRING) {
            want = DataType.CHAR;
        }
        if (want != have) {
            throw new IllegalArgumentException("Update Attribute must have same type or original = " + have);
        }
        if (type == 2) {
            String s = att.getStringValue();
            int org = this.raf.readInt();
            int size = org + N3header.padding(org);
            int max = Math.min(size, s.length());
            if (max > org) {
                this.raf.seek(pos + 4L);
                this.raf.writeInt(max);
            }
            byte[] b = new byte[size];
            for (int i = 0; i < max; ++i) {
                b[i] = (byte)s.charAt(i);
            }
            this.raf.write(b);
        } else {
            int nelems = this.raf.readInt();
            int max = Math.min(nelems, att.getLength());
            for (int j = 0; j < max; ++j) {
                this.writeAttributeValue(att.getNumericValue(j));
            }
        }
    }

    private long findAtt(long start_pos, String want) throws IOException {
        this.raf.seek(start_pos + 4L);
        int natts = this.raf.readInt();
        for (int i = 0; i < natts; ++i) {
            String name = this.readString();
            if (name.equals(want)) {
                return this.raf.getFilePointer();
            }
            int type = this.raf.readInt();
            if (type == 2) {
                this.readString();
                continue;
            }
            int nelems = this.raf.readInt();
            DataType dtype = this.getDataType(type);
            int[] shape = new int[]{nelems};
            Array arr = Array.factory(dtype.getPrimitiveClassType(), shape);
            IndexIterator ii = arr.getIndexIterator();
            int nbytes = 0;
            for (int j = 0; j < nelems; ++j) {
                nbytes += this.readAttributeValue(dtype, ii);
            }
            this.skip(nbytes);
        }
        throw new IllegalArgumentException("no such attribute " + want);
    }

    private void writeAtts(List<Attribute> atts) throws IOException {
        int n = atts.size();
        if (n == 0) {
            this.raf.writeInt(0);
            this.raf.writeInt(0);
        } else {
            this.raf.writeInt(12);
            this.raf.writeInt(n);
        }
        for (int i = 0; i < n; ++i) {
            if (this.debugPos) {
                this.out.println("***att " + i + " pos= " + this.raf.getFilePointer());
            }
            Attribute att = atts.get(i);
            this.writeString(att.getName());
            int type = N3header.getType(att.getDataType());
            this.raf.writeInt(type);
            if (type == 2) {
                this.writeStringValues(att);
            } else {
                int nelems = att.getLength();
                this.raf.writeInt(nelems);
                int nbytes = 0;
                for (int j = 0; j < nelems; ++j) {
                    nbytes += this.writeAttributeValue(att.getNumericValue(j));
                }
                this.pad(nbytes, (byte)0);
                if (this.debugPos) {
                    this.out.println(" end write val pos= " + this.raf.getFilePointer());
                }
            }
            if (!this.debug) continue;
            this.out.println("  " + att.toString() + "\n");
        }
    }

    private void writeStringValues(Attribute att) throws IOException {
        int n = att.getLength();
        if (n == 1) {
            this.writeString(att.getStringValue());
        } else {
            StringBuffer values = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                values.append(att.getStringValue(i));
            }
            this.writeString(values.toString());
        }
    }

    private int writeAttributeValue(Number numValue) throws IOException {
        if (numValue instanceof Byte) {
            this.raf.write(numValue.byteValue());
            return 1;
        }
        if (numValue instanceof Short) {
            this.raf.writeShort(numValue.shortValue());
            return 2;
        }
        if (numValue instanceof Integer) {
            this.raf.writeInt(numValue.intValue());
            return 4;
        }
        if (numValue instanceof Float) {
            this.raf.writeFloat(numValue.floatValue());
            return 4;
        }
        if (numValue instanceof Double) {
            this.raf.writeDouble(numValue.doubleValue());
            return 8;
        }
        throw new IllegalStateException("unknown attribute type == " + numValue.getClass().getName());
    }

    private void writeVars(List<Variable> vars) throws IOException {
        int n = vars.size();
        if (n == 0) {
            this.raf.writeInt(0);
            this.raf.writeInt(0);
        } else {
            this.raf.writeInt(11);
            this.raf.writeInt(n);
        }
        for (int i = 0; i < n; ++i) {
            Variable var = vars.get(i);
            this.writeString(var.getName());
            int vsize = var.getDataType().getSize();
            List<Dimension> dims = var.getDimensions();
            this.raf.writeInt(dims.size());
            for (Dimension dim : dims) {
                int dimIndex = this.findDimensionIndex(this.ncfile, dim);
                this.raf.writeInt(dimIndex);
                if (dim.isUnlimited()) continue;
                vsize *= dim.getLength();
            }
            vsize += N3header.padding(vsize);
            long varAttsPos = this.raf.getFilePointer();
            this.writeAtts(var.getAttributes());
            int type = N3header.getType(var.getDataType());
            this.raf.writeInt(type);
            this.raf.writeInt(vsize);
            long pos = this.raf.getFilePointer();
            this.raf.writeInt(0);
            var.setSPobject(new Vinfo(vsize, pos, var.isUnlimited(), varAttsPos));
            if (!var.isUnlimited()) continue;
            this.recsize += vsize;
        }
    }

    private void writeString(String s) throws IOException {
        byte[] b = s.getBytes("UTF-8");
        this.raf.writeInt(b.length);
        this.raf.write(b);
        this.pad(b.length, (byte)0);
    }

    private int findDimensionIndex(NetcdfFile ncfile, Dimension wantDim) {
        List<Dimension> dims = ncfile.getDimensions();
        for (int i = 0; i < dims.size(); ++i) {
            Dimension dim = dims.get(i);
            if (!dim.equals(wantDim)) continue;
            return i;
        }
        throw new IllegalStateException("unknown Dimension == " + wantDim);
    }

    private void pad(int nbytes, byte fill) throws IOException {
        int pad = N3header.padding(nbytes);
        for (int i = 0; i < pad; ++i) {
            this.raf.write(fill);
        }
    }

    void writeNumrecs() throws IOException {
        this.raf.seek(4L);
        this.raf.writeInt(this.numrecs);
    }

    void setNumrecs(int n) throws IOException {
        this.numrecs = n;
    }

    synchronized boolean synchNumrecs() throws IOException {
        int n = this.raf.readIntUnbuffered(4L);
        if (n == this.numrecs) {
            return false;
        }
        this.numrecs = n;
        this.udim.setLength(this.numrecs);
        for (Variable uvar : this.uvars) {
            uvar.resetShape();
            uvar.invalidateCache();
        }
        return true;
    }

    static class Vinfo {
        int vsize;
        long begin;
        boolean isRecord;
        long attsPos = 0L;

        Vinfo(int vsize, long begin, boolean isRecord, long attsPos) {
            this.vsize = vsize;
            this.begin = begin;
            this.isRecord = isRecord;
            this.attsPos = attsPos;
        }
    }
}

