/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.BinData;
import ome.xml.model.Channel;
import ome.xml.model.MetadataOnly;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Plane;
import ome.xml.model.Reference;
import ome.xml.model.TiffData;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.PositiveInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pixels
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2010-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Pixels.class);
    private PositiveInteger sizeT;
    private DimensionOrder dimensionOrder;
    private Double timeIncrement;
    private Double physicalSizeY;
    private Double physicalSizeX;
    private Double physicalSizeZ;
    private PositiveInteger sizeX;
    private PositiveInteger sizeY;
    private PositiveInteger sizeZ;
    private PositiveInteger sizeC;
    private PixelType type;
    private String id;
    private List<Channel> channelList = new ArrayList<Channel>();
    private List<BinData> binDataList = new ArrayList<BinData>();
    private List<TiffData> tiffDataList = new ArrayList<TiffData>();
    private MetadataOnly metadataOnly;
    private List<Plane> planeList = new ArrayList<Plane>();
    private List<Annotation> annotationList = new ArrayList<Annotation>();

    public Pixels() {
    }

    public Pixels(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Pixels".equals(tagName)) {
            LOGGER.debug("Expecting node name of Pixels got {}", (Object)tagName);
        }
        if (element.hasAttribute("SizeT")) {
            this.setSizeT(PositiveInteger.valueOf(element.getAttribute("SizeT")));
        }
        if (element.hasAttribute("DimensionOrder")) {
            this.setDimensionOrder(DimensionOrder.fromString(element.getAttribute("DimensionOrder")));
        }
        if (element.hasAttribute("TimeIncrement")) {
            this.setTimeIncrement(Double.valueOf(element.getAttribute("TimeIncrement")));
        }
        if (element.hasAttribute("PhysicalSizeY")) {
            this.setPhysicalSizeY(Double.valueOf(element.getAttribute("PhysicalSizeY")));
        }
        if (element.hasAttribute("PhysicalSizeX")) {
            this.setPhysicalSizeX(Double.valueOf(element.getAttribute("PhysicalSizeX")));
        }
        if (element.hasAttribute("PhysicalSizeZ")) {
            this.setPhysicalSizeZ(Double.valueOf(element.getAttribute("PhysicalSizeZ")));
        }
        if (element.hasAttribute("SizeX")) {
            this.setSizeX(PositiveInteger.valueOf(element.getAttribute("SizeX")));
        }
        if (element.hasAttribute("SizeY")) {
            this.setSizeY(PositiveInteger.valueOf(element.getAttribute("SizeY")));
        }
        if (element.hasAttribute("SizeZ")) {
            this.setSizeZ(PositiveInteger.valueOf(element.getAttribute("SizeZ")));
        }
        if (element.hasAttribute("SizeC")) {
            this.setSizeC(PositiveInteger.valueOf(element.getAttribute("SizeC")));
        }
        if (element.hasAttribute("Type")) {
            this.setType(PixelType.fromString(element.getAttribute("Type")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Pixels missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        List<Element> Channel_nodeList = Pixels.getChildrenByTagName(element, "Channel");
        for (Element Channel_element : Channel_nodeList) {
            this.addChannel(new Channel(Channel_element, model));
        }
        List<Element> BinData_nodeList = Pixels.getChildrenByTagName(element, "BinData");
        for (Element BinData_element : BinData_nodeList) {
            this.addBinData(new BinData(BinData_element, model));
        }
        List<Element> TiffData_nodeList = Pixels.getChildrenByTagName(element, "TiffData");
        for (Element TiffData_element : TiffData_nodeList) {
            this.addTiffData(new TiffData(TiffData_element, model));
        }
        List<Element> MetadataOnly_nodeList = Pixels.getChildrenByTagName(element, "MetadataOnly");
        if (MetadataOnly_nodeList.size() > 1) {
            throw new RuntimeException(String.format("MetadataOnly node list size %d != 1", MetadataOnly_nodeList.size()));
        }
        if (MetadataOnly_nodeList.size() != 0) {
            this.setMetadataOnly(new MetadataOnly(MetadataOnly_nodeList.get(0), model));
        }
        List<Element> Plane_nodeList = Pixels.getChildrenByTagName(element, "Plane");
        for (Element Plane_element : Plane_nodeList) {
            this.addPlane(new Plane(Plane_element, model));
        }
        List<Element> AnnotationRef_nodeList = Pixels.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationList_reference = new AnnotationRef();
            annotationList_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationList_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkPixels(this);
            this.annotationList.add(o_casted);
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public PositiveInteger getSizeT() {
        return this.sizeT;
    }

    public void setSizeT(PositiveInteger sizeT) {
        this.sizeT = sizeT;
    }

    public DimensionOrder getDimensionOrder() {
        return this.dimensionOrder;
    }

    public void setDimensionOrder(DimensionOrder dimensionOrder) {
        this.dimensionOrder = dimensionOrder;
    }

    public Double getTimeIncrement() {
        return this.timeIncrement;
    }

    public void setTimeIncrement(Double timeIncrement) {
        this.timeIncrement = timeIncrement;
    }

    public Double getPhysicalSizeY() {
        return this.physicalSizeY;
    }

    public void setPhysicalSizeY(Double physicalSizeY) {
        this.physicalSizeY = physicalSizeY;
    }

    public Double getPhysicalSizeX() {
        return this.physicalSizeX;
    }

    public void setPhysicalSizeX(Double physicalSizeX) {
        this.physicalSizeX = physicalSizeX;
    }

    public Double getPhysicalSizeZ() {
        return this.physicalSizeZ;
    }

    public void setPhysicalSizeZ(Double physicalSizeZ) {
        this.physicalSizeZ = physicalSizeZ;
    }

    public PositiveInteger getSizeX() {
        return this.sizeX;
    }

    public void setSizeX(PositiveInteger sizeX) {
        this.sizeX = sizeX;
    }

    public PositiveInteger getSizeY() {
        return this.sizeY;
    }

    public void setSizeY(PositiveInteger sizeY) {
        this.sizeY = sizeY;
    }

    public PositiveInteger getSizeZ() {
        return this.sizeZ;
    }

    public void setSizeZ(PositiveInteger sizeZ) {
        this.sizeZ = sizeZ;
    }

    public PositiveInteger getSizeC() {
        return this.sizeC;
    }

    public void setSizeC(PositiveInteger sizeC) {
        this.sizeC = sizeC;
    }

    public PixelType getType() {
        return this.type;
    }

    public void setType(PixelType type) {
        this.type = type;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public int sizeOfChannelList() {
        return this.channelList.size();
    }

    public List<Channel> copyChannelList() {
        return new ArrayList<Channel>(this.channelList);
    }

    public Channel getChannel(int index) {
        return this.channelList.get(index);
    }

    public Channel setChannel(int index, Channel channel) {
        return this.channelList.set(index, channel);
    }

    public void addChannel(Channel channel) {
        this.channelList.add(channel);
    }

    public void removeChannel(Channel channel) {
        this.channelList.remove(channel);
    }

    public int sizeOfBinDataList() {
        return this.binDataList.size();
    }

    public List<BinData> copyBinDataList() {
        return new ArrayList<BinData>(this.binDataList);
    }

    public BinData getBinData(int index) {
        return this.binDataList.get(index);
    }

    public BinData setBinData(int index, BinData binData) {
        return this.binDataList.set(index, binData);
    }

    public void addBinData(BinData binData) {
        this.binDataList.add(binData);
    }

    public void removeBinData(BinData binData) {
        this.binDataList.remove(binData);
    }

    public int sizeOfTiffDataList() {
        return this.tiffDataList.size();
    }

    public List<TiffData> copyTiffDataList() {
        return new ArrayList<TiffData>(this.tiffDataList);
    }

    public TiffData getTiffData(int index) {
        return this.tiffDataList.get(index);
    }

    public TiffData setTiffData(int index, TiffData tiffData) {
        return this.tiffDataList.set(index, tiffData);
    }

    public void addTiffData(TiffData tiffData) {
        this.tiffDataList.add(tiffData);
    }

    public void removeTiffData(TiffData tiffData) {
        this.tiffDataList.remove(tiffData);
    }

    public MetadataOnly getMetadataOnly() {
        return this.metadataOnly;
    }

    public void setMetadataOnly(MetadataOnly metadataOnly) {
        this.metadataOnly = metadataOnly;
    }

    public int sizeOfPlaneList() {
        return this.planeList.size();
    }

    public List<Plane> copyPlaneList() {
        return new ArrayList<Plane>(this.planeList);
    }

    public Plane getPlane(int index) {
        return this.planeList.get(index);
    }

    public Plane setPlane(int index, Plane plane) {
        return this.planeList.set(index, plane);
    }

    public void addPlane(Plane plane) {
        this.planeList.add(plane);
    }

    public void removePlane(Plane plane) {
        this.planeList.remove(plane);
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationList.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationList);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationList.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationList.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkPixels(this);
        return this.annotationList.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkPixels(this);
        return this.annotationList.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element Pixels_element) {
        if (Pixels_element == null) {
            Pixels_element = document.createElementNS(NAMESPACE, "Pixels");
        }
        if (this.sizeT != null) {
            Pixels_element.setAttribute("SizeT", this.sizeT.toString());
        }
        if (this.dimensionOrder != null) {
            Pixels_element.setAttribute("DimensionOrder", this.dimensionOrder.toString());
        }
        if (this.timeIncrement != null) {
            Pixels_element.setAttribute("TimeIncrement", this.timeIncrement.toString());
        }
        if (this.physicalSizeY != null) {
            Pixels_element.setAttribute("PhysicalSizeY", this.physicalSizeY.toString());
        }
        if (this.physicalSizeX != null) {
            Pixels_element.setAttribute("PhysicalSizeX", this.physicalSizeX.toString());
        }
        if (this.physicalSizeZ != null) {
            Pixels_element.setAttribute("PhysicalSizeZ", this.physicalSizeZ.toString());
        }
        if (this.sizeX != null) {
            Pixels_element.setAttribute("SizeX", this.sizeX.toString());
        }
        if (this.sizeY != null) {
            Pixels_element.setAttribute("SizeY", this.sizeY.toString());
        }
        if (this.sizeZ != null) {
            Pixels_element.setAttribute("SizeZ", this.sizeZ.toString());
        }
        if (this.sizeC != null) {
            Pixels_element.setAttribute("SizeC", this.sizeC.toString());
        }
        if (this.type != null) {
            Pixels_element.setAttribute("Type", this.type.toString());
        }
        if (this.id != null) {
            Pixels_element.setAttribute("ID", this.id.toString());
        }
        if (this.channelList != null) {
            for (Channel channelList_value : this.channelList) {
                Pixels_element.appendChild(channelList_value.asXMLElement(document));
            }
        }
        if (this.binDataList != null) {
            for (BinData binDataList_value : this.binDataList) {
                Pixels_element.appendChild(binDataList_value.asXMLElement(document));
            }
        }
        if (this.tiffDataList != null) {
            for (TiffData tiffDataList_value : this.tiffDataList) {
                Pixels_element.appendChild(tiffDataList_value.asXMLElement(document));
            }
        }
        if (this.metadataOnly != null) {
            Pixels_element.appendChild(this.metadataOnly.asXMLElement(document));
        }
        if (this.planeList != null) {
            for (Plane planeList_value : this.planeList) {
                Pixels_element.appendChild(planeList_value.asXMLElement(document));
            }
        }
        if (this.annotationList != null) {
            for (Annotation annotationList_value : this.annotationList) {
                AnnotationRef o = new AnnotationRef();
                o.setID(annotationList_value.getID());
                Pixels_element.appendChild(o.asXMLElement(document));
            }
        }
        return super.asXMLElement(document, Pixels_element);
    }
}

