/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.Dataset;
import ome.xml.model.Experiment;
import ome.xml.model.Group;
import ome.xml.model.GroupRef;
import ome.xml.model.Image;
import ome.xml.model.MicrobeamManipulation;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Project;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Experimenter
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2010-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Experimenter.class);
    private String userName;
    private String displayName;
    private String firstName;
    private String middleName;
    private String lastName;
    private String email;
    private String institution;
    private String id;
    private List<Group> groupList = new ArrayList<Group>();
    private List<Annotation> annotationList = new ArrayList<Annotation>();
    private List<Image> image_BackReferenceList = new ArrayList<Image>();
    private List<MicrobeamManipulation> microbeamManipulation_BackReferenceList = new ArrayList<MicrobeamManipulation>();
    private List<Project> project_BackReferenceList = new ArrayList<Project>();
    private List<Dataset> dataset_BackReferenceList = new ArrayList<Dataset>();
    private List<Experiment> experiment_BackReferenceList = new ArrayList<Experiment>();

    public Experimenter() {
    }

    public Experimenter(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Experimenter".equals(tagName)) {
            LOGGER.debug("Expecting node name of Experimenter got {}", (Object)tagName);
        }
        if (element.hasAttribute("UserName")) {
            this.setUserName(String.valueOf(element.getAttribute("UserName")));
        }
        if (element.hasAttribute("DisplayName")) {
            this.setDisplayName(String.valueOf(element.getAttribute("DisplayName")));
        }
        if (element.hasAttribute("FirstName")) {
            this.setFirstName(String.valueOf(element.getAttribute("FirstName")));
        }
        if (element.hasAttribute("MiddleName")) {
            this.setMiddleName(String.valueOf(element.getAttribute("MiddleName")));
        }
        if (element.hasAttribute("LastName")) {
            this.setLastName(String.valueOf(element.getAttribute("LastName")));
        }
        if (element.hasAttribute("Email")) {
            this.setEmail(String.valueOf(element.getAttribute("Email")));
        }
        if (element.hasAttribute("Institution")) {
            this.setInstitution(String.valueOf(element.getAttribute("Institution")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Experimenter missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        List<Element> GroupRef_nodeList = Experimenter.getChildrenByTagName(element, "GroupRef");
        for (Element GroupRef_element : GroupRef_nodeList) {
            GroupRef groupList_reference = new GroupRef();
            groupList_reference.setID(GroupRef_element.getAttribute("ID"));
            model.addReference(this, groupList_reference);
        }
        List<Element> AnnotationRef_nodeList = Experimenter.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationList_reference = new AnnotationRef();
            annotationList_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationList_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof GroupRef) {
            Group o_casted = (Group)o;
            o_casted.linkExperimenter(this);
            this.groupList.add(o_casted);
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkExperimenter(this);
            this.annotationList.add(o_casted);
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getInstitution() {
        return this.institution;
    }

    public void setInstitution(String institution) {
        this.institution = institution;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public int sizeOfLinkedGroupList() {
        return this.groupList.size();
    }

    public List<Group> copyLinkedGroupList() {
        return new ArrayList<Group>(this.groupList);
    }

    public Group getLinkedGroup(int index) {
        return this.groupList.get(index);
    }

    public Group setLinkedGroup(int index, Group o) {
        return this.groupList.set(index, o);
    }

    public boolean linkGroup(Group o) {
        o.linkExperimenter(this);
        return this.groupList.add(o);
    }

    public boolean unlinkGroup(Group o) {
        o.unlinkExperimenter(this);
        return this.groupList.remove(o);
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationList.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationList);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationList.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationList.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkExperimenter(this);
        return this.annotationList.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkExperimenter(this);
        return this.annotationList.remove(o);
    }

    public int sizeOfLinkedImageList() {
        return this.image_BackReferenceList.size();
    }

    public List<Image> copyLinkedImageList() {
        return new ArrayList<Image>(this.image_BackReferenceList);
    }

    public Image getLinkedImage(int index) {
        return this.image_BackReferenceList.get(index);
    }

    public Image setLinkedImage(int index, Image o) {
        return this.image_BackReferenceList.set(index, o);
    }

    public boolean linkImage(Image o) {
        return this.image_BackReferenceList.add(o);
    }

    public boolean unlinkImage(Image o) {
        return this.image_BackReferenceList.remove(o);
    }

    public int sizeOfLinkedMicrobeamManipulationList() {
        return this.microbeamManipulation_BackReferenceList.size();
    }

    public List<MicrobeamManipulation> copyLinkedMicrobeamManipulationList() {
        return new ArrayList<MicrobeamManipulation>(this.microbeamManipulation_BackReferenceList);
    }

    public MicrobeamManipulation getLinkedMicrobeamManipulation(int index) {
        return this.microbeamManipulation_BackReferenceList.get(index);
    }

    public MicrobeamManipulation setLinkedMicrobeamManipulation(int index, MicrobeamManipulation o) {
        return this.microbeamManipulation_BackReferenceList.set(index, o);
    }

    public boolean linkMicrobeamManipulation(MicrobeamManipulation o) {
        return this.microbeamManipulation_BackReferenceList.add(o);
    }

    public boolean unlinkMicrobeamManipulation(MicrobeamManipulation o) {
        return this.microbeamManipulation_BackReferenceList.remove(o);
    }

    public int sizeOfLinkedProjectList() {
        return this.project_BackReferenceList.size();
    }

    public List<Project> copyLinkedProjectList() {
        return new ArrayList<Project>(this.project_BackReferenceList);
    }

    public Project getLinkedProject(int index) {
        return this.project_BackReferenceList.get(index);
    }

    public Project setLinkedProject(int index, Project o) {
        return this.project_BackReferenceList.set(index, o);
    }

    public boolean linkProject(Project o) {
        return this.project_BackReferenceList.add(o);
    }

    public boolean unlinkProject(Project o) {
        return this.project_BackReferenceList.remove(o);
    }

    public int sizeOfLinkedDatasetList() {
        return this.dataset_BackReferenceList.size();
    }

    public List<Dataset> copyLinkedDatasetList() {
        return new ArrayList<Dataset>(this.dataset_BackReferenceList);
    }

    public Dataset getLinkedDataset(int index) {
        return this.dataset_BackReferenceList.get(index);
    }

    public Dataset setLinkedDataset(int index, Dataset o) {
        return this.dataset_BackReferenceList.set(index, o);
    }

    public boolean linkDataset(Dataset o) {
        return this.dataset_BackReferenceList.add(o);
    }

    public boolean unlinkDataset(Dataset o) {
        return this.dataset_BackReferenceList.remove(o);
    }

    public int sizeOfLinkedExperimentList() {
        return this.experiment_BackReferenceList.size();
    }

    public List<Experiment> copyLinkedExperimentList() {
        return new ArrayList<Experiment>(this.experiment_BackReferenceList);
    }

    public Experiment getLinkedExperiment(int index) {
        return this.experiment_BackReferenceList.get(index);
    }

    public Experiment setLinkedExperiment(int index, Experiment o) {
        return this.experiment_BackReferenceList.set(index, o);
    }

    public boolean linkExperiment(Experiment o) {
        return this.experiment_BackReferenceList.add(o);
    }

    public boolean unlinkExperiment(Experiment o) {
        return this.experiment_BackReferenceList.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element Experimenter_element) {
        Reference o;
        if (Experimenter_element == null) {
            Experimenter_element = document.createElementNS(NAMESPACE, "Experimenter");
        }
        if (this.userName != null) {
            Experimenter_element.setAttribute("UserName", this.userName.toString());
        }
        if (this.displayName != null) {
            Experimenter_element.setAttribute("DisplayName", this.displayName.toString());
        }
        if (this.firstName != null) {
            Experimenter_element.setAttribute("FirstName", this.firstName.toString());
        }
        if (this.middleName != null) {
            Experimenter_element.setAttribute("MiddleName", this.middleName.toString());
        }
        if (this.lastName != null) {
            Experimenter_element.setAttribute("LastName", this.lastName.toString());
        }
        if (this.email != null) {
            Experimenter_element.setAttribute("Email", this.email.toString());
        }
        if (this.institution != null) {
            Experimenter_element.setAttribute("Institution", this.institution.toString());
        }
        if (this.id != null) {
            Experimenter_element.setAttribute("ID", this.id.toString());
        }
        if (this.groupList != null) {
            for (Group groupList_value : this.groupList) {
                o = new GroupRef();
                ((GroupRef)o).setID(groupList_value.getID());
                Experimenter_element.appendChild(((GroupRef)o).asXMLElement(document));
            }
        }
        if (this.annotationList != null) {
            for (Annotation annotationList_value : this.annotationList) {
                o = new AnnotationRef();
                ((AnnotationRef)o).setID(annotationList_value.getID());
                Experimenter_element.appendChild(((AnnotationRef)o).asXMLElement(document));
            }
        }
        if (this.image_BackReferenceList != null) {
            // empty if block
        }
        if (this.microbeamManipulation_BackReferenceList != null) {
            // empty if block
        }
        if (this.project_BackReferenceList != null) {
            // empty if block
        }
        if (this.dataset_BackReferenceList != null) {
            // empty if block
        }
        if (this.experiment_BackReferenceList != null) {
            // empty if block
        }
        return super.asXMLElement(document, Experimenter_element);
    }
}

