/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo;

import Ice.Communicator;
import Ice.Current;
import Ice.Identity;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import Ice.Util;
import java.io.File;
import java.sql.Timestamp;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import ome.model.IObject;
import ome.services.blitz.fire.Registry;
import ome.services.blitz.repo.FileMaker;
import ome.services.blitz.repo.PublicRepositoryI;
import ome.services.util.Executor;
import ome.system.Principal;
import ome.system.ServiceFactory;
import ome.util.Filterable;
import ome.util.SqlAction;
import omero.ServerError;
import omero.ValidationException;
import omero.api.RawFileStorePrx;
import omero.api.RawPixelsStorePrx;
import omero.api.RenderingEnginePrx;
import omero.api.ThumbnailStorePrx;
import omero.grid.RepositoryPrx;
import omero.grid.RepositoryPrxHelper;
import omero.grid._InternalRepositoryDisp;
import omero.model.OriginalFile;
import omero.model.OriginalFileI;
import omero.util.IceMapper;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractRepositoryI
extends _InternalRepositoryDisp {
    private static final Log log = LogFactory.getLog(AbstractRepositoryI.class);
    private final ObjectAdapter oa;
    private final Registry reg;
    private final Executor ex;
    private final Principal p;
    private final SqlAction sql;
    private final FileMaker fileMaker;
    private OriginalFile description;
    private RepositoryPrx proxy;
    private String repoUuid;
    private volatile AtomicReference<State> state = new AtomicReference();

    public AbstractRepositoryI(ObjectAdapter oa, Registry reg, Executor ex, SqlAction sql, String sessionUuid, String repoDir) {
        this(oa, reg, ex, sql, sessionUuid, new FileMaker(repoDir));
    }

    public AbstractRepositoryI(ObjectAdapter oa, Registry reg, Executor ex, SqlAction sql, String sessionUuid, FileMaker fileMaker) {
        this.state.set(State.EAGER);
        this.p = new Principal(sessionUuid, "system", "Internal");
        this.oa = oa;
        this.ex = ex;
        this.reg = reg;
        this.sql = sql;
        this.fileMaker = fileMaker;
        log.info((Object)("Initializing repository in " + fileMaker.getDir()));
    }

    public String generateRepoUuid() {
        return UUID.randomUUID().toString();
    }

    public boolean takeover() {
        if (!this.state.compareAndSet(State.EAGER, State.WAITING)) {
            log.debug((Object)"Skipping takeover");
            return false;
        }
        Object rv = null;
        try {
            rv = this.ex.execute(this.p, (Executor.Work)new GetOrCreateRepo(this));
            if (rv instanceof ome.model.core.OriginalFile) {
                ome.model.core.OriginalFile r = (ome.model.core.OriginalFile)rv;
                this.description = this.getDescription(r.getId());
                if (!this.state.compareAndSet(State.WAITING, State.ACTIVE)) {
                    log.debug((Object)"Could not set state to ACTIVE");
                }
                return true;
            }
            if (rv instanceof Exception) {
                log.error((Object)"Failed during repository takeover", (Throwable)((Exception)rv));
            } else {
                log.error((Object)("Unknown issue with repository takeover:" + rv));
            }
        }
        catch (Exception e) {
            log.error((Object)"Unexpected error in called executor on takeover", (Throwable)e);
        }
        this.state.compareAndSet(State.WAITING, State.EAGER);
        return false;
    }

    public void close() {
        this.state.set(State.CLOSED);
        log.info((Object)("Releasing " + this.fileMaker.getDir()));
        this.fileMaker.close();
    }

    public final String getRepoUuid() {
        return this.repoUuid;
    }

    public final Communicator getCommunicator() {
        return this.oa.getCommunicator();
    }

    public final ObjectAdapter getObjectAdapter() {
        return this.oa;
    }

    public final OriginalFile getDescription(Current __current) {
        return this.description;
    }

    public final RepositoryPrx getProxy(Current __current) {
        return this.proxy;
    }

    public abstract String getFilePath(OriginalFile var1, Current var2) throws ServerError;

    public RawFileStorePrx createRawFileStore(OriginalFile file, Current __current) {
        return null;
    }

    public RawPixelsStorePrx createRawPixelsStore(OriginalFile file, Current __current) {
        return null;
    }

    public RenderingEnginePrx createRenderingEngine(OriginalFile file, Current __current) {
        return null;
    }

    public ThumbnailStorePrx createThumbnailStore(OriginalFile file, Current __current) {
        return null;
    }

    protected OriginalFileI getDescription(final long id) throws ServerError {
        ome.model.core.OriginalFile file = (ome.model.core.OriginalFile)this.ex.execute(this.p, (Executor.Work)new Executor.SimpleWork((Object)this, "getDescription", new Object[]{id}){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return sf.getQueryService().findByQuery("select o from OriginalFile o where o.id = " + id, null);
            }
        });
        OriginalFileI rv = (OriginalFileI)new IceMapper().map((Filterable)file);
        return rv;
    }

    protected String getFileRepo(final OriginalFile file) throws ServerError {
        if (file == null || file.getId() == null) {
            throw new ValidationException(null, null, "Unmanaged file");
        }
        Map map = (Map)this.ex.executeSql((Executor.SqlWork)new Executor.SimpleSqlWork((Object)this, "getFileRepo", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(SqlAction sql) {
                return sql.repoFile(file.getId().getValue());
            }
        });
        if (map.size() == 0) {
            throw new ValidationException(null, null, "Unknown file: " + file.getId().getValue());
        }
        return (String)map.get("repo");
    }

    class GetOrCreateRepo
    extends Executor.SimpleWork {
        private final AbstractRepositoryI repo;

        public GetOrCreateRepo(AbstractRepositoryI repo) {
            super((Object)repo, "takeover", new Object[0]);
            this.repo = repo;
        }

        @Transactional(readOnly=false)
        public Object doWork(Session session, ServiceFactory sf) {
            ome.model.core.OriginalFile r = null;
            try {
                String line;
                if (AbstractRepositoryI.this.fileMaker.needsInit()) {
                    AbstractRepositoryI.this.fileMaker.init(sf.getConfigService().getDatabaseUuid());
                }
                if ((line = AbstractRepositoryI.this.fileMaker.getLine()) == null) {
                    AbstractRepositoryI.this.repoUuid = this.repo.generateRepoUuid();
                } else {
                    AbstractRepositoryI.this.repoUuid = line;
                }
                r = (ome.model.core.OriginalFile)sf.getQueryService().findByString(ome.model.core.OriginalFile.class, "sha1", AbstractRepositoryI.this.repoUuid);
                if (r == null) {
                    if (line != null) {
                        log.warn((Object)("Couldn't find repository object: " + line));
                    }
                    String path = FilenameUtils.normalize((String)new File(AbstractRepositoryI.this.fileMaker.getDir()).getAbsolutePath());
                    r = new ome.model.core.OriginalFile();
                    r.setSha1(AbstractRepositoryI.this.repoUuid);
                    r.setName(FilenameUtils.getName((String)path));
                    r.setPath(FilenameUtils.getFullPath((String)path));
                    Timestamp t = new Timestamp(System.currentTimeMillis());
                    r.setAtime(t);
                    r.setMtime(t);
                    r.setCtime(t);
                    r.setMimetype("Repository");
                    r.setSize(Long.valueOf(0L));
                    r = (ome.model.core.OriginalFile)sf.getUpdateService().saveAndReturnObject((IObject)r);
                    sf.getAdminService().moveToCommonSpace(new IObject[]{r});
                    AbstractRepositoryI.this.fileMaker.writeLine(AbstractRepositoryI.this.repoUuid);
                    log.info((Object)String.format("Registered new repository %s (uuid=%s)", r.getName(), AbstractRepositoryI.this.repoUuid));
                }
                sf.getAdminService().moveToCommonSpace(new IObject[]{r});
                log.info((Object)String.format("Opened repository %s (uuid=%s)", r.getName(), AbstractRepositoryI.this.repoUuid));
                PublicRepositoryI pr = new PublicRepositoryI(new File(AbstractRepositoryI.this.fileMaker.getDir()), r.getId(), AbstractRepositoryI.this.ex, AbstractRepositoryI.this.sql, AbstractRepositoryI.this.p);
                ObjectPrx internalObj = this.addOrReplace("InternalRepository-", (Ice.Object)this.repo);
                ObjectPrx externalObj = this.addOrReplace("PublicRepository-", (Ice.Object)pr);
                AbstractRepositoryI.this.oa.activate();
                AbstractRepositoryI.this.reg.addObject(internalObj);
                AbstractRepositoryI.this.reg.addObject(externalObj);
                AbstractRepositoryI.this.proxy = RepositoryPrxHelper.uncheckedCast((ObjectPrx)externalObj);
                log.info((Object)"Repository now active");
                return r;
            }
            catch (Exception e) {
                AbstractRepositoryI.this.fileMaker.close();
                return e;
            }
        }

        private ObjectPrx addOrReplace(String prefix, Ice.Object obj) {
            Identity id = Util.stringToIdentity((String)(prefix + AbstractRepositoryI.this.repoUuid));
            Ice.Object old = AbstractRepositoryI.this.oa.find(id);
            if (old != null) {
                AbstractRepositoryI.this.oa.remove(id);
                log.warn((Object)String.format("Found %s; removing: %s", id, old));
            }
            AbstractRepositoryI.this.oa.add(obj, id);
            return AbstractRepositoryI.this.oa.createDirectProxy(id);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        ACTIVE,
        EAGER,
        WAITING,
        CLOSED;

    }
}

