/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.util;

import java.util.ArrayList;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientKeepAlive
implements Runnable,
IObservable {
    private static Log log = LogFactory.getLog(ClientKeepAlive.class);
    private OMEROMetadataStoreClient client;
    private final ArrayList<IObserver> observers = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            OMEROMetadataStoreClient oMEROMetadataStoreClient = this.client;
            synchronized (oMEROMetadataStoreClient) {
                if (this.client != null) {
                    this.client.ping();
                }
            }
        }
        catch (Throwable t) {
            log.error((Object)"Exception while executing ping(), logging Connector out: ", t);
            try {
                this.client.logout();
                this.notifyObservers(new ImportEvent.LOGGED_OUT());
            }
            catch (Exception e) {
                log.error((Object)"Nested error on client.logout() while handling exception from ping()", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMEROMetadataStoreClient getClient() {
        OMEROMetadataStoreClient oMEROMetadataStoreClient = this.client;
        synchronized (oMEROMetadataStoreClient) {
            return this.client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClient(OMEROMetadataStoreClient client2) {
        OMEROMetadataStoreClient oMEROMetadataStoreClient = client2;
        synchronized (oMEROMetadataStoreClient) {
            this.client = client2;
        }
    }

    public boolean addObserver(IObserver object) {
        return this.observers.add(object);
    }

    public boolean deleteObserver(IObserver object) {
        return this.observers.remove(object);
    }

    public void notifyObservers(ImportEvent event) {
        for (IObserver observer : this.observers) {
            try {
                observer.update(this, event);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }
}

