/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.gui;

import java.util.Enumeration;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class LogAppender {
    private JTextPane t;
    private StyledDocument doc;
    private Style style;
    private static LogAppender soleInstance;

    public static LogAppender getInstance() {
        if (soleInstance == null) {
            soleInstance = new LogAppender();
        }
        return soleInstance;
    }

    private LogAppender() {
    }

    public void append(String string) {
        if (string != null && string.contains("loci.")) {
            return;
        }
        if (this.t == null) {
            return;
        }
        try {
            this.doc = (StyledDocument)this.t.getDocument();
            this.style = this.doc.addStyle("StyleName", null);
            StyleConstants.setFontFamily(this.style, "SansSerif");
            StyleConstants.setFontSize(this.style, 12);
            this.doc.insertString(this.doc.getLength(), string, this.style);
            int maxChars = 100000;
            if (this.doc.getLength() > maxChars) {
                this.doc.remove(0, this.doc.getLength() - maxChars);
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setTextArea(JTextPane debugTextPane) {
        this.t = debugTextPane;
    }

    public static void setLoggingLevel(Level level) {
        Enumeration loggers = LogManager.getCurrentLoggers();
        if (loggers != null) {
            while (loggers.hasMoreElements()) {
                Logger logger = (Logger)loggers.nextElement();
                logger.setLevel(level);
            }
        }
    }
}

