/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.gui;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import ome.formats.importer.gui.GuiImporter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GuiCommonElements {
    private static Log log = LogFactory.getLog(GuiCommonElements.class);

    public static boolean getIsMac() {
        String osName = System.getProperty("os.name");
        return osName.startsWith("Mac OS");
    }

    public static boolean isMotif() {
        String laf = UIManager.getLookAndFeel().getClass().getName();
        return laf.equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
    }

    public static JPanel addMainPanel(Container container, double[][] tableSize, int margin_top, int margin_left, int margin_bottom, int margin_right, boolean debug) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        TableLayout layout = new TableLayout(tableSize);
        panel.setLayout((LayoutManager)layout);
        panel.setBorder(BorderFactory.createEmptyBorder(margin_top, margin_left, margin_bottom, margin_right));
        if (debug) {
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), panel.getBorder()));
        }
        return panel;
    }

    public static JPanel addBorderedPanel(Container container, double[][] tableSize, String name, boolean debug) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        TableLayout layout = new TableLayout(tableSize);
        panel.setLayout((LayoutManager)layout);
        panel.setBorder(BorderFactory.createTitledBorder(name));
        if (debug) {
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), panel.getBorder()));
        }
        return panel;
    }

    public static JPanel addPlanePanel(Container container, double[][] tableSize, boolean debug) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        TableLayout layout = new TableLayout(tableSize);
        panel.setLayout((LayoutManager)layout);
        panel.setBorder(BorderFactory.createEmptyBorder());
        if (debug) {
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), panel.getBorder()));
        }
        return panel;
    }

    public static synchronized JTextPane addTextPane(Container container, String text, String placement, boolean debug) {
        StyleContext context = new StyleContext();
        DefaultStyledDocument document = new DefaultStyledDocument(context);
        Style style = context.getStyle("default");
        StyleConstants.setAlignment(style, 0);
        try {
            document.insertString(document.getLength(), text, null);
        }
        catch (BadLocationException e) {
            log.error((Object)"BadLocationException inserting text to document.");
        }
        JTextPane textPane = new JTextPane(document);
        textPane.setOpaque(false);
        textPane.setEditable(false);
        textPane.setFocusable(false);
        container.add((Component)textPane, placement);
        if (debug) {
            textPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), textPane.getBorder()));
        }
        return textPane;
    }

    public static synchronized JTextPane addTextPane(Container container, String text, String placement, StyleContext context, Style style, boolean debug) {
        DefaultStyledDocument document = new DefaultStyledDocument(context);
        try {
            document.insertString(document.getLength(), text, style);
        }
        catch (BadLocationException e) {
            log.error((Object)"BadLocationException inserting text to document.");
        }
        JTextPane textPane = new JTextPane(document);
        textPane.setOpaque(false);
        textPane.setEditable(false);
        textPane.setFocusable(false);
        container.add((Component)textPane, placement);
        if (debug) {
            textPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), textPane.getBorder()));
        }
        return textPane;
    }

    public static JTextField addTextField(Container container, String name, String initialValue, int mnemonic, String tooltip, String suffix, double labelWidth, String placement, boolean debug) {
        Object size = null;
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        size = suffix.equals("") ? (Object)new double[][]{{labelWidth, -1.0}, {30.0}} : (Object)new double[][]{{labelWidth, -1.0, -2.0}, {30.0}};
        TableLayout layout = new TableLayout((double[][])size);
        panel.setLayout((LayoutManager)layout);
        JLabel label = new JLabel(name);
        label.setDisplayedMnemonic(mnemonic);
        JTextField result = new JTextField(20);
        label.setLabelFor(result);
        label.setOpaque(false);
        result.setToolTipText(tooltip);
        if (initialValue != null) {
            result.setText(initialValue);
        }
        panel.add((Component)label, "0, 0, r, c");
        panel.add((Component)result, "1, 0, f, c");
        if (suffix.length() != 0) {
            JLabel suffixLabel = new JLabel(" " + suffix);
            panel.add((Component)suffixLabel, "2,0, l, c");
        }
        if (debug) {
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), panel.getBorder()));
        }
        container.add((Component)panel, placement);
        return result;
    }

    public static JPasswordField addPasswordField(Container container, String name, String initialValue, int mnemonic, String tooltip, String suffix, double labelWidth, String placement, boolean debug) {
        Object size = null;
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        size = suffix.equals("") ? (Object)new double[][]{{labelWidth, -1.0}, {30.0}} : (Object)new double[][]{{labelWidth, -1.0, -2.0}, {30.0}};
        TableLayout layout = new TableLayout((double[][])size);
        panel.setLayout((LayoutManager)layout);
        JLabel label = new JLabel(name);
        label.setDisplayedMnemonic(mnemonic);
        JPasswordField result = new JPasswordField(20);
        label.setLabelFor(result);
        label.setOpaque(false);
        result.setToolTipText(tooltip);
        if (initialValue != null) {
            result.setText(initialValue);
        }
        panel.add((Component)label, "0, 0, r, c");
        panel.add((Component)result, "1, 0, f, c");
        if (suffix.length() != 0) {
            JLabel suffixLabel = new JLabel(" " + suffix);
            panel.add((Component)suffixLabel, "2,0, l, c");
        }
        if (debug) {
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), panel.getBorder()));
        }
        container.add((Component)panel, placement);
        return result;
    }

    public static JTextArea addScrollingTextArea(Container container, String name, String text, int mnemonic, String placement, boolean debug) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        double[][] size = new double[][]{{-1.0}, {20.0, -1.0}};
        TableLayout layout = new TableLayout((double[][])size);
        panel.setLayout((LayoutManager)layout);
        JTextArea textArea = new JTextArea();
        textArea.setLineWrap(true);
        textArea.setOpaque(true);
        JScrollPane areaScrollPane = new JScrollPane(textArea);
        areaScrollPane.setVerticalScrollBarPolicy(20);
        if (debug) {
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), panel.getBorder()));
        }
        if (!name.equals("")) {
            JLabel label = new JLabel(name);
            label.setOpaque(false);
            label.setDisplayedMnemonic(mnemonic);
            panel.add((Component)label, "0, 0, l, c");
            panel.add((Component)areaScrollPane, "0, 1, f, f");
        } else {
            panel.add((Component)areaScrollPane, "0, 0, 0, 1");
        }
        container.add((Component)panel, placement);
        return textArea;
    }

    public static JButton addBasicButton(String name, String image, String tooltip) {
        JButton button = null;
        if (image == null) {
            button = new JButton(name);
        } else {
            URL imgURL = GuiImporter.class.getResource(image);
            if (imgURL != null) {
                button = new JButton(name, new ImageIcon(imgURL));
            } else {
                button = new JButton(name);
                log.warn((Object)("Couldn't find icon: " + image));
            }
        }
        button.setToolTipText(tooltip);
        return button;
    }

    public static JButton addButton(Container container, String label, int mnemonic, String tooltip, String placement, boolean debug) {
        JButton button = new JButton(label);
        button.setMnemonic(mnemonic);
        button.setToolTipText(tooltip);
        button.setOpaque(!GuiCommonElements.getIsMac());
        container.add((Component)button, placement);
        if (debug) {
            button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), button.getBorder()));
        }
        return button;
    }

    public static JButton addIconButton(Container container, String label, String image, Integer width, Integer height, Integer mnemonic, String tooltip, String placement, boolean debug) {
        JButton button = null;
        if (image == null) {
            button = new JButton(label);
        } else {
            URL imgURL = GuiImporter.class.getResource(image);
            if (imgURL != null && label.length() > 0) {
                button = new JButton(label, new ImageIcon(imgURL));
            } else if (imgURL != null) {
                button = new JButton(null, new ImageIcon(imgURL));
            } else {
                button = new JButton(label);
                log.error((Object)("Couldn't find icon: " + image));
            }
        }
        if (width != null && height != null && width > 0 && height > 0) {
            button.setMaximumSize(new Dimension(width, height));
            button.setPreferredSize(new Dimension(width, height));
            button.setMinimumSize(new Dimension(width, height));
            button.setSize(new Dimension(width, height));
        }
        if (mnemonic != null) {
            button.setMnemonic(mnemonic);
        }
        button.setOpaque(!GuiCommonElements.getIsMac());
        button.setToolTipText(tooltip);
        container.add((Component)button, placement);
        if (GuiCommonElements.isMotif()) {
            Border b = BorderFactory.createLineBorder(Color.gray);
            button.setMargin(new Insets(0, 0, 0, 0));
            button.setBorder(b);
        }
        if (debug) {
            button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), button.getBorder()));
        }
        return button;
    }

    public static void enterPressesWhenFocused(JButton button) {
        button.registerKeyboardAction(button.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, false)), KeyStroke.getKeyStroke(10, 0, false), 0);
        button.registerKeyboardAction(button.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, true)), KeyStroke.getKeyStroke(10, 0, true), 0);
    }

    public static JRadioButton addRadioButton(Container container, String label, int mnemonic, String tooltip, String placement, boolean debug) {
        JRadioButton button = new JRadioButton(label);
        button.setToolTipText(tooltip);
        container.add((Component)button, placement);
        button.setOpaque(false);
        return button;
    }

    public static JCheckBox addCheckBox(Container container, String label, String placement, boolean debug) {
        JCheckBox checkBox = new JCheckBox(label);
        container.add((Component)checkBox, placement);
        checkBox.setOpaque(false);
        return checkBox;
    }

    public static JComboBox addComboBox(Container container, String label, Object[] initialValues, int mnemonic, String tooltip, double labelWidth, String placement, boolean debug) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        double[][] size = new double[][]{{labelWidth, -1.0}, {-2.0}};
        TableLayout layout = new TableLayout((double[][])size);
        panel.setLayout((LayoutManager)layout);
        JLabel labelTxt = new JLabel(label);
        labelTxt.setDisplayedMnemonic(mnemonic);
        panel.add((Component)labelTxt, "0,0,L,C");
        JComboBox<Object> result = null;
        result = initialValues != null ? new JComboBox<Object>(initialValues) : new JComboBox();
        labelTxt.setLabelFor(result);
        result.setToolTipText(tooltip);
        panel.add(result, "1,0,F,C");
        container.add((Component)panel, placement);
        result.setOpaque(false);
        return result;
    }

    public static ImageIcon getImageIcon(String path) {
        if (path == null) {
            log.error((Object)"Icon path is null");
            return null;
        }
        URL imgURL = GuiImporter.class.getResource(path);
        if (imgURL == null) {
            log.error((Object)("Couldn't find icon: " + path));
            return null;
        }
        return new ImageIcon(imgURL);
    }

    public static boolean quitConfirmed(Component parent, String message) {
        if (message == null) {
            message = "Do you really want to close the application?\nDoing so will cancel any running imports.";
        }
        String s1 = "Yes";
        String s2 = "No";
        Object[] options = new Object[]{s2, s1};
        int n = JOptionPane.showOptionDialog(parent, message, "Exit Application", 0, 3, null, options, s1);
        return n != 0;
    }

    public static void restartNotice(Component frame, String message) {
        if (message == null) {
            message = "You must restart before your changes will take effect.";
        }
        JOptionPane.showMessageDialog(frame, message);
    }

    public static boolean validEmail(String emailAddress) {
        String[] parts = emailAddress.split("@");
        return parts.length == 2 && parts[0].length() != 0 && parts[1].length() != 0;
    }

    public static WholeNumberField addWholeNumberField(Container container, String prefexStr, String initialValue, String suffexStr, int mnemonic, String tooltip, int maxChars, int fieldWidth, String placement, boolean debug) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        double[][] table = new double[][]{{-2.0, fieldWidth, 5.0, -2.0}, {-2.0}};
        TableLayout layout = new TableLayout((double[][])table);
        panel.setLayout((LayoutManager)layout);
        JLabel prefex = new JLabel(prefexStr);
        prefex.setDisplayedMnemonic(mnemonic);
        panel.add((Component)prefex, "0,0");
        WholeNumberField result = new WholeNumberField(0, maxChars);
        result.setHorizontalAlignment(0);
        prefex.setLabelFor(result);
        result.setToolTipText(tooltip);
        if (initialValue != null) {
            result.setText(initialValue);
        }
        panel.add((Component)result, "1,0");
        JLabel suffex = new JLabel(suffexStr);
        panel.add((Component)suffex, "3,0");
        container.add((Component)panel, placement);
        return result;
    }

    public static DecimalNumberField addDecimalNumberField(Container container, String prefexStr, String initialValue, String suffexStr, int mnemonic, String tooltip, int maxChars, int fieldWidth, String placement, boolean debug) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        double[][] table = new double[][]{{-2.0, fieldWidth, 5.0, -2.0}, {-2.0}};
        TableLayout layout = new TableLayout((double[][])table);
        panel.setLayout((LayoutManager)layout);
        JLabel prefex = new JLabel(prefexStr);
        prefex.setDisplayedMnemonic(mnemonic);
        panel.add((Component)prefex, "0,0");
        DecimalNumberField result = new DecimalNumberField(null, maxChars);
        result.setHorizontalAlignment(0);
        prefex.setLabelFor(result);
        result.setToolTipText(tooltip);
        if (initialValue != null) {
            result.setText(initialValue);
        }
        panel.add((Component)result, "1,0");
        JLabel suffex = new JLabel(suffexStr);
        panel.add((Component)suffex, "3,0");
        container.add((Component)panel, placement);
        return result;
    }

    public static JPanel addImagePanel(JPanel container, String imageString, String placement, boolean debug) {
        ImageIcon icon = null;
        URL imgURL = GuiImporter.class.getResource(imageString);
        if (imgURL != null) {
            icon = new ImageIcon(imgURL);
        }
        ImagePanel panel = new ImagePanel(icon);
        if (debug) {
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), panel.getBorder()));
        } else {
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.gray), panel.getBorder()));
        }
        container.add((Component)panel, placement);
        return panel;
    }

    public static class ImagePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        ImageIcon image;

        public ImagePanel(ImageIcon icon) {
            this.image = icon;
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.image != null) {
                g.drawImage(this.image.getImage(), 0, 0, this);
            }
        }
    }

    public static class DecimalNumberField
    extends JTextField {
        private static final long serialVersionUID = 1L;
        private Toolkit toolkit = Toolkit.getDefaultToolkit();
        private NumberFormat formatter = NumberFormat.getNumberInstance(Locale.US);

        public DecimalNumberField(Double value, int columns) {
            super(columns);
            this.formatter.setParseIntegerOnly(false);
            this.setValue(value);
        }

        public Double getValue() {
            Double retVal = null;
            try {
                retVal = this.formatter.parse(this.getText()).doubleValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return retVal;
        }

        public void setValue(Double value) {
            if (value != null) {
                this.setText(this.formatter.format(value));
            }
        }

        protected Document createDefaultModel() {
            return new DecimalNumberDocument();
        }

        protected class DecimalNumberDocument
        extends PlainDocument {
            private static final long serialVersionUID = 1L;

            protected DecimalNumberDocument() {
            }

            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                char[] source = str.toCharArray();
                char[] result = new char[source.length];
                int j = 0;
                for (int i = 0; i < result.length; ++i) {
                    if (Character.isDigit(source[i]) || Character.toString(source[i]).equals(".")) {
                        result[j++] = source[i];
                        continue;
                    }
                    DecimalNumberField.this.toolkit.beep();
                }
                super.insertString(offs, new String(result, 0, j), a);
            }
        }
    }

    public static class WholeNumberField
    extends JTextField {
        private static final long serialVersionUID = 1L;
        private Toolkit toolkit = Toolkit.getDefaultToolkit();
        private NumberFormat integerFormatter = NumberFormat.getNumberInstance(Locale.US);

        public WholeNumberField(int value, int columns) {
            super(columns);
            this.integerFormatter.setParseIntegerOnly(true);
            this.setValue(value);
        }

        public int getValue() {
            int retVal = 0;
            try {
                retVal = this.integerFormatter.parse(this.getText()).intValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return retVal;
        }

        public void setValue(int value) {
            this.setText(this.integerFormatter.format(value));
        }

        protected Document createDefaultModel() {
            return new WholeNumberDocument();
        }

        protected class WholeNumberDocument
        extends PlainDocument {
            private static final long serialVersionUID = 1L;

            protected WholeNumberDocument() {
            }

            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                char[] source = str.toCharArray();
                char[] result = new char[source.length];
                int j = 0;
                for (int i = 0; i < result.length; ++i) {
                    if (Character.isDigit(source[i])) {
                        result[j++] = source[i];
                        continue;
                    }
                    WholeNumberField.this.toolkit.beep();
                }
                super.insertString(offs, new String(result, 0, j), a);
            }
        }
    }
}

