/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.model;

import java.util.LinkedHashMap;
import java.util.List;
import ome.formats.Index;
import ome.formats.model.IObjectContainerStore;
import ome.formats.model.ModelException;
import ome.formats.model.ModelProcessor;
import ome.util.LSID;
import omero.metadatastore.IObjectContainer;
import omero.model.Plate;
import omero.model.PlateAcquisition;
import omero.model.Well;
import omero.rtypes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WellProcessor
implements ModelProcessor {
    private Log log = LogFactory.getLog(WellProcessor.class);
    private IObjectContainerStore store;

    public void process(IObjectContainerStore store) throws ModelException {
        this.store = store;
        List<IObjectContainer> containers = store.getIObjectContainers(Well.class);
        for (IObjectContainer container : containers) {
            Integer plateIndex = (Integer)container.indexes.get(Index.PLATE_INDEX.getValue());
            Plate plate = this.validatePlate(plateIndex);
            Well well = (Well)container.sourceObject;
            if (well.getColumn() != null && well.getColumn().getValue() >= plate.getCols().getValue()) {
                plate.setCols(rtypes.rint((int)(well.getColumn().getValue() + 1)));
            }
            if (well.getRow() == null || well.getRow().getValue() < plate.getRows().getValue()) continue;
            plate.setRows(rtypes.rint((int)(well.getRow().getValue() + 1)));
        }
        containers = store.getIObjectContainers(PlateAcquisition.class);
        for (IObjectContainer container : containers) {
            this.validatePlateAcquisition(container);
        }
    }

    private Plate validatePlate(int plateIndex) {
        LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
        indexes.put(Index.PLATE_INDEX, plateIndex);
        IObjectContainer container = this.store.getIObjectContainer(Plate.class, indexes);
        Plate plate = (Plate)container.sourceObject;
        String userSpecifiedPlateName = this.store.getUserSpecifiedPlateName();
        String userSpecifiedPlateDescription = this.store.getUserSpecifiedPlateDescription();
        if (userSpecifiedPlateName != null) {
            plate.setName(rtypes.rstring((String)userSpecifiedPlateName));
        }
        if (userSpecifiedPlateDescription != null) {
            plate.setDescription(rtypes.rstring((String)userSpecifiedPlateDescription));
        }
        if (plate.getName() == null) {
            this.log.warn((Object)("Missing plate name for: " + container.LSID));
            plate.setName(rtypes.rstring((String)"Plate"));
        }
        if (plate.getRows() == null) {
            plate.setRows(rtypes.rint((int)1));
        }
        if (plate.getCols() == null) {
            plate.setCols(rtypes.rint((int)1));
        }
        return plate;
    }

    private void validatePlateAcquisition(IObjectContainer container) {
        PlateAcquisition o = (PlateAcquisition)container.sourceObject;
        if (o.getName() == null) {
            Integer plateIndex = (Integer)container.indexes.get(Index.PLATE_INDEX.getValue());
            Integer plateAcquisitionIndex = (Integer)container.indexes.get(Index.PLATE_ACQUISITION_INDEX.getValue());
            o.setName(rtypes.rstring((String)new LSID(PlateAcquisition.class, new int[]{plateIndex, plateAcquisitionIndex}).toString()));
        }
    }
}

