/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.model;

import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import loci.formats.IFormatReader;
import ome.formats.Index;
import ome.formats.model.IObjectContainerStore;
import ome.formats.model.ModelException;
import ome.formats.model.ModelProcessor;
import ome.util.LSID;
import omero.metadatastore.IObjectContainer;
import omero.model.Annotation;
import omero.model.IObject;
import omero.model.Image;
import omero.model.Pixels;
import omero.rtypes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PixelsProcessor
implements ModelProcessor {
    private Log log = LogFactory.getLog(PixelsProcessor.class);
    private Timestamp earliestMTime;
    private IFormatReader reader;

    public void process(IObjectContainerStore store) throws ModelException {
        this.reader = store.getReader();
        List<IObjectContainer> containers = store.getIObjectContainers(Pixels.class);
        for (IObjectContainer container : containers) {
            Integer imageIndex = (Integer)container.indexes.get(Index.IMAGE_INDEX.getValue());
            LSID imageLSID = new LSID(Image.class, new int[]{imageIndex});
            Image image = (Image)store.getSourceObject(imageLSID);
            Pixels pixels = (Pixels)container.sourceObject;
            Double[] physicalPixelSizes = store.getUserSpecifiedPhysicalPixelSizes();
            List<Annotation> annotations = store.getUserSpecifiedAnnotations();
            if (annotations == null) {
                annotations = new ArrayList<Annotation>();
            }
            Map<LSID, IObjectContainer> containerCache = store.getContainerCache();
            for (int i = 0; i < annotations.size(); ++i) {
                LSID annotationLSID = new LSID("UserSpecifiedAnnotation:" + i);
                IObjectContainer annotationContainer = new IObjectContainer();
                annotationContainer.LSID = annotationLSID.toString();
                annotationContainer.sourceObject = (IObject)annotations.get(i);
                containerCache.put(annotationLSID, annotationContainer);
                store.addReference(imageLSID, annotationLSID);
            }
            if (physicalPixelSizes != null) {
                if (physicalPixelSizes[0] != null && pixels.getPhysicalSizeX() == null) {
                    pixels.setPhysicalSizeX(rtypes.rdouble((double)physicalPixelSizes[0]));
                }
                if (physicalPixelSizes[1] != null && pixels.getPhysicalSizeY() == null) {
                    pixels.setPhysicalSizeY(rtypes.rdouble((double)physicalPixelSizes[1]));
                }
                if (physicalPixelSizes[2] != null && pixels.getPhysicalSizeZ() == null) {
                    pixels.setPhysicalSizeZ(rtypes.rdouble((double)physicalPixelSizes[2]));
                }
            }
            if (image == null) {
                LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
                indexes.put(Index.IMAGE_INDEX, imageIndex);
                container = store.getIObjectContainer(Image.class, indexes);
                image = (Image)container.sourceObject;
            }
            if (image.getAcquisitionDate() == null) {
                if (this.earliestMTime == null) {
                    String[] fileNameList = store.getReader().getUsedFiles();
                    long mtime = Long.MAX_VALUE;
                    for (int j = 0; j < fileNameList.length; ++j) {
                        File f = new File(fileNameList[j]);
                        if (f.lastModified() >= mtime) continue;
                        mtime = f.lastModified();
                    }
                    this.earliestMTime = new Timestamp(mtime);
                }
                image.setAcquisitionDate(rtypes.rtime((Date)this.earliestMTime));
            }
            String userSpecifiedName = store.getUserSpecifiedImageName();
            String saveName = "";
            if (image.getName() == null || image.getName().getValue().trim().length() == 0 || userSpecifiedName != null) {
                saveName = userSpecifiedName;
                if (this.reader.getSeriesCount() > 1) {
                    saveName = image.getName() == null ? saveName + " [" + imageIndex + "]" : (image.getName().getValue().trim().length() != 0 ? saveName + " [" + image.getName().getValue() + "]" : saveName + " [" + imageIndex + "]");
                }
            } else {
                saveName = image.getName().getValue();
            }
            image.setName(rtypes.rstring((String)saveName));
            String userSpecifiedDescription = store.getUserSpecifiedImageDescription();
            if (userSpecifiedDescription == null) continue;
            image.setDescription(rtypes.rstring((String)userSpecifiedDescription));
        }
    }
}

