/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.reactor;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportCandidates;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.ImportContainer;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.OMEROWrapper;
import ome.formats.importer.reactor.Connector;
import ome.formats.importer.reactor.Fileset;
import ome.formats.importer.reactor.ReactorEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportReactor
extends Thread
implements IObservable,
IObserver {
    private static final Log log = LogFactory.getLog(ImportReactor.class);
    private final List<Fileset> queue = new ArrayList<Fileset>();
    private final ImportConfig config;
    private final Connector connector;
    private final Set<IObserver> observers = new HashSet<IObserver>();
    private final OMEROWrapper reader;
    private volatile ReactorState reactorState = ReactorState.PAUSED;

    public ImportReactor(ImportConfig config, Connector connector) {
        this.config = config;
        this.reader = new OMEROWrapper(config);
        this.connector = connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setReactorState(ReactorState newState) {
        ReactorState reactorState = this.reactorState;
        synchronized (reactorState) {
            log.debug((Object)("Setting reactor state, current '" + (Object)((Object)this.reactorState) + "' new '" + (Object)((Object)newState) + "'"));
            if (this.reactorState == newState) {
                log.warn((Object)("Reactor already in state: " + (Object)((Object)newState)));
            }
            if (this.reactorState == ReactorState.PAUSING && newState == ReactorState.RUNNING) {
                log.error((Object)"Cannot switch from PAUSING to RUNNING; ignoring.");
            }
            this.reactorState = newState;
            this.notifyObservers(new ReactorEvent.REACTOR_STATE_CHANGE(this.reactorState));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compareAndSetReactorState(ReactorState expected, ReactorState update) {
        ReactorState reactorState = this.reactorState;
        synchronized (reactorState) {
            if (this.reactorState == expected) {
                this.reactorState = update;
                this.notifyObservers(new ReactorEvent.REACTOR_STATE_CHANGE(this.reactorState));
                return true;
            }
            return false;
        }
    }

    public synchronized void start() {
        if (this.config == null || this.config.canLogin()) {
            throw new IllegalStateException("The reactor requires valid configuration");
        }
        this.setReactorState(ReactorState.RUNNING);
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseReactor() {
        List<Fileset> list = this.queue;
        synchronized (list) {
            log.debug((Object)"Pausing reactor.");
            this.setReactorState(ReactorState.PAUSING);
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeReactor() {
        List<Fileset> list = this.queue;
        synchronized (list) {
            log.debug((Object)"Resuming reactor.");
            this.setReactorState(ReactorState.RUNNING);
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReactorState toggleReactorState() {
        boolean success = false;
        List<Fileset> list = this.queue;
        synchronized (list) {
            log.debug((Object)"Toggling reactor state.");
            if (!success) {
                success = this.compareAndSetReactorState(ReactorState.PAUSED, ReactorState.RUNNING);
            }
            if (!success) {
                success = this.compareAndSetReactorState(ReactorState.RUNNING, ReactorState.PAUSING);
            }
            if (!success) {
                log.warn((Object)("Unable to toggle state from: " + (Object)((Object)this.reactorState)));
            }
            this.queue.notify();
            return this.reactorState;
        }
    }

    public ReactorState getReactorState() {
        return this.reactorState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeAtomically(Runnable runnable) {
        List<Fileset> list = this.queue;
        synchronized (list) {
            runnable.run();
        }
    }

    public void run() {
        while (true) {
            this.runSingle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSingle() {
        Fileset currentCtx = null;
        List<Fileset> list = this.queue;
        synchronized (list) {
            while (!this.hasFilesetsWithState(Fileset.FilesetState.QUEUED) || this.reactorState != ReactorState.RUNNING) {
                try {
                    boolean transitioned = this.compareAndSetReactorState(ReactorState.PAUSING, ReactorState.PAUSED);
                    log.debug((Object)("Transitioned from PAUSING to PAUSED? " + transitioned));
                    log.debug((Object)"Waiting on queue monitor...");
                    this.queue.wait();
                    log.debug((Object)"Woke up from queue monitor...");
                }
                catch (InterruptedException e) {
                    log.warn((Object)"Interrupted waiting on upload queue.", (Throwable)e);
                }
            }
            for (Fileset ctx : this.queue) {
                if (ctx.getState() != Fileset.FilesetState.QUEUED) continue;
                currentCtx = ctx;
                break;
            }
        }
        try {
            this.process(currentCtx);
            if (!this.hasFilesetsWithState(Fileset.FilesetState.QUEUED)) {
                log.debug((Object)"All uploads in the queue finished.");
                boolean transitioned = this.compareAndSetReactorState(ReactorState.RUNNING, ReactorState.PAUSING);
                log.debug((Object)("Transitioned from RUNNING to PAUSING? " + transitioned));
                this.notifyObservers(new ReactorEvent.SUCCESS(currentCtx));
            }
        }
        catch (Exception e) {
            this.notifyObservers(new ReactorEvent.FAILURE(currentCtx));
            log.error((Object)"Unhandled error in import reactor.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(File file, String imageName, String imageDescription) {
        List<Fileset> list = this.queue;
        synchronized (list) {
            Fileset ctx = new Fileset(file, imageName, imageDescription);
            this.queue.add(ctx);
            this.notifyObservers(new ReactorEvent.QUEUE_APPEND(ctx));
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Fileset.FilesetState state) {
        List<Fileset> list = this.queue;
        synchronized (list) {
            ArrayList<Fileset> toRemove = new ArrayList<Fileset>();
            for (Fileset ctx : this.queue) {
                if (ctx.getState() != state) continue;
                toRemove.add(ctx);
            }
            for (Fileset ctx : toRemove) {
                this.remove(ctx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Fileset ctx) {
        List<Fileset> list = this.queue;
        synchronized (list) {
            int index = this.queue.indexOf(ctx);
            this.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int index) {
        List<Fileset> list = this.queue;
        synchronized (list) {
            try {
                Fileset ctx = this.queue.get(index);
                if (ctx.getState() != Fileset.FilesetState.QUEUED && ctx.getState() != Fileset.FilesetState.FINISHED && ctx.getState() != Fileset.FilesetState.FAILED) {
                    log.warn((Object)"Attempt to remove item not in QUEUED state; skipping.");
                    return;
                }
                this.queue.remove(index);
                this.notifyObservers(new ReactorEvent.QUEUE_REMOVE(ctx, index));
            }
            catch (Exception e) {
                log.error((Object)"Attempting to remove item not in queue.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int[] indexes) {
        List<Fileset> list = this.queue;
        synchronized (list) {
            int[] copyOfIndexes = new int[indexes.length];
            System.arraycopy(indexes, 0, copyOfIndexes, 0, indexes.length);
            Arrays.sort(copyOfIndexes);
            for (int i = indexes.length - 1; i >= 0; --i) {
                this.remove(copyOfIndexes[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Fileset ctx) {
        List<Fileset> list = this.queue;
        synchronized (list) {
            return this.queue.indexOf(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Fileset get(int index) {
        List<Fileset> list = this.queue;
        synchronized (list) {
            return this.queue.get(index);
        }
    }

    private void process(Fileset ctx) {
        String uuid;
        try {
            uuid = this.connector.openFileset(ctx);
            ctx.setFilesetUUID(uuid);
        }
        catch (Exception e) {
            log.error((Object)"Connector error opening fileset.", (Throwable)e);
            this.fail(ctx);
            return;
        }
        String path = ctx.getTarget().getAbsolutePath();
        ImportCandidates candidates = null;
        try {
            candidates = new ImportCandidates(this.reader, new String[]{path}, this);
            this.promote(ctx);
        }
        catch (Exception e) {
            this.failFileset(uuid, ctx, e, "Bio-Formats reader error.");
        }
        try {
            ctx.promote();
            for (ImportContainer container : candidates.getContainers()) {
                this.connector.handleContainer(uuid, container);
            }
            this.connector.closeFileset(uuid);
            this.promote(ctx);
        }
        catch (Exception e) {
            this.failFileset(uuid, ctx, e, "Connector error.");
        }
    }

    private void failFileset(String uuid, Fileset ctx, Exception e, String msg) {
        log.error((Object)msg, (Throwable)e);
        this.fail(ctx);
        try {
            this.connector.failFileset(uuid, e);
        }
        catch (Exception ex) {
            log.error((Object)"Connector error failing fileset.", (Throwable)ex);
        }
    }

    private void promote(Fileset ctx) {
        ctx.promote();
        this.notifyObservers(new ReactorEvent.QUEUE_STATE_CHANGE(ctx));
    }

    private void fail(Fileset ctx) {
        ctx.fail();
        this.notifyObservers(new ReactorEvent.QUEUE_STATE_CHANGE(ctx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFilesetsWithState(Fileset.FilesetState state) {
        List<Fileset> list = this.queue;
        synchronized (list) {
            for (Fileset ctx : this.queue) {
                if (ctx.getState() != state) continue;
                return true;
            }
            return false;
        }
    }

    public boolean addObserver(IObserver object) {
        return this.observers.add(object);
    }

    public boolean deleteObserver(IObserver object) {
        return this.observers.remove(object);
    }

    public void notifyObservers(ImportEvent event) {
        for (IObserver observer : this.observers) {
            observer.update(this, event);
        }
    }

    public void update(IObservable source, ImportEvent event) {
        if (log.isDebugEnabled() && !(event instanceof ImportEvent.IMPORT_STEP)) {
            log.debug((Object)event.toLog());
        }
        this.notifyObservers(event);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReactorState {
        RUNNING,
        PAUSING,
        PAUSED;

    }
}

