/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.gui;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.gui.GuiCommonElements;
import ome.formats.importer.gui.GuiImporter;
import ome.formats.importer.gui.HistoryTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openmicroscopy.shoola.util.ui.login.LoginCredentials;
import org.openmicroscopy.shoola.util.ui.login.ScreenLogin;
import org.openmicroscopy.shoola.util.ui.login.ScreenLogo;

public class LoginHandler
implements IObservable,
ActionListener,
WindowListener,
PropertyChangeListener,
WindowStateListener,
WindowFocusListener {
    public static final String LOGIN = "LOGIN";
    public static final String LOGIN_CANCELLED = "LOGIN_CANCELLED";
    private static Log log = LogFactory.getLog(LoginHandler.class);
    private static boolean NEW_LOGIN = true;
    private final ArrayList<IObserver> observers = new ArrayList();
    public volatile JFrame f;
    private GuiImporter viewer;
    private OMEROMetadataStoreClient store;
    public ScreenLogin view;
    public ScreenLogo viewTop;
    private LoginCredentials lc;
    private boolean modal;
    private boolean displayTop;
    private final HistoryTable historyTable;
    private final ImportConfig config;

    public LoginHandler(GuiImporter viewer, HistoryTable table) {
        this(viewer, table, false, true);
    }

    public LoginHandler(GuiImporter viewer, HistoryTable table, boolean modal, boolean displayTop) {
        this.viewer = viewer;
        this.modal = modal;
        this.config = viewer.getConfig();
        this.historyTable = table;
        if (this.historyTable != null) {
            this.addObserver(this.historyTable);
        }
        if (viewer.getFileQueueHandler().getTable() != null) {
            this.addObserver(viewer.getFileQueueHandler().getTable());
        }
        viewer.enableMenus(false);
        this.displayLogin(displayTop);
    }

    public void displayLogin(boolean displayTop) {
        this.displayTop = displayTop;
        boolean cancelled = this.displayLoginDialog(this, this.modal, displayTop);
        if (this.modal && cancelled) {
            this.loginCancelled();
        }
        if (this.modal && !cancelled) {
            this.tryLogin();
        }
    }

    public void tryLogin() {
        new Thread(){

            public void run() {
                if (!NEW_LOGIN) {
                    LoginHandler.this.viewer.setVisible(true);
                } else {
                    ((LoginHandler)LoginHandler.this).config.username.set(LoginHandler.this.lc.getUserName());
                    ((LoginHandler)LoginHandler.this).config.password.set(LoginHandler.this.lc.getPassword());
                    ((LoginHandler)LoginHandler.this).config.hostname.set(LoginHandler.this.lc.getHostName());
                    ((LoginHandler)LoginHandler.this).config.port.set(LoginHandler.this.lc.getPort());
                    ((LoginHandler)LoginHandler.this).config.group.set(LoginHandler.this.lc.getGroup());
                    ((LoginHandler)LoginHandler.this).config.encryptedConnection.set(LoginHandler.this.lc.isEncrypted());
                }
                LoginHandler.this.viewer.getStatusBar().setStatusIcon("gfx/server_trying16.png", "Trying to connect to " + (String)((LoginHandler)LoginHandler.this).config.hostname.get());
                LoginHandler.this.viewer.getStatusBar().setProgress(true, -1, "connecting....");
                try {
                    if (LoginHandler.this.isValidLogin()) {
                        if (NEW_LOGIN) {
                            LoginHandler.this.store.setCurrentGroup(LoginHandler.this.lc.getGroup());
                            try {
                                ScreenLogin.registerGroup(LoginHandler.this.store.mapUserGroups());
                            }
                            catch (Exception e) {
                                log.warn((Object)"Exception on ScreenLogin.registerGroup()", (Throwable)e);
                            }
                            LoginHandler.this.view.close();
                            LoginHandler.this.viewTop.close();
                            LoginHandler.this.viewer.setVisible(true);
                        }
                        LoginHandler.this.viewer.getStatusBar().setProgress(false, 0, "");
                        LoginHandler.this.viewer.appendToOutput("> Login Successful.\n");
                        LoginHandler.this.viewer.getFileQueueHandler().enableImports(true);
                        log.info((Object)"Login successful!");
                        LoginHandler.this.viewer.enableMenus(true);
                        LoginHandler.this.viewer.setImportEnabled(true);
                        LoginHandler.this.viewer.setLoggedIn(true);
                        LoginHandler.this.notifyObservers(new ImportEvent.LOGGED_IN());
                        String group = LoginHandler.this.store.getDefaultGroupName();
                        int groupLevel = LoginHandler.this.store.getDefaultGroupLevel();
                        LoginHandler.this.notifyObservers(new ImportEvent.GROUP_SET(group, groupLevel));
                        try {
                            long freeSpace = LoginHandler.this.store.getRepositorySpace();
                            NumberFormat formatter = NumberFormat.getInstance(Locale.US);
                            String freeMB = formatter.format(freeSpace / 1000L);
                            LoginHandler.this.viewer.getStatusBar().setStatusIcon("gfx/server_connect16.png", "Connected to " + (String)((LoginHandler)LoginHandler.this).config.hostname.get() + " (" + group + "). Free space: " + freeMB + " MB.");
                            return;
                        }
                        catch (Exception e) {
                            log.error((Object)"Exception retrieving repository free space.", (Throwable)e);
                            LoginHandler.this.viewer.getStatusBar().setStatusIcon("gfx/server_connect16.png", "Connected to " + (String)((LoginHandler)LoginHandler.this).config.hostname.get() + " (" + group + ").");
                            return;
                        }
                    }
                    if (NEW_LOGIN) {
                        LoginHandler.this.view.setAlwaysOnTop(false);
                    }
                    log.info((Object)"Login failed!");
                    LoginHandler.this.viewer.getStatusBar().setProgress(false, 0, "");
                    LoginHandler.this.viewer.getStatusBar().setStatusIcon("gfx/error_msg16.png", "Incorrect username/password. Server login failed, please try to log in again.");
                    JOptionPane.showMessageDialog(LoginHandler.this.viewer, "Incorrect username/password. Server login \nfailed, please try to log in again.");
                    LoginHandler.this.viewer.appendToOutput("> Login failed. Try to relog.\n");
                    LoginHandler.this.viewer.enableMenus(true);
                    LoginHandler.this.viewer.setLoggedIn(false);
                    if (NEW_LOGIN) {
                        LoginHandler.this.refreshNewLogin();
                    }
                    return;
                }
                catch (Exception e) {
                    log.error((Object)"Exception in LoginHandler.", (Throwable)e);
                    LoginHandler.this.viewer.getStatusBar().setProgress(false, 0, "");
                    LoginHandler.this.viewer.getStatusBar().setStatusIcon("gfx/error_msg16.png", "Server connection to " + (String)((LoginHandler)LoginHandler.this).config.hostname.get() + " failed. " + "Please try again.");
                    if (NEW_LOGIN) {
                        LoginHandler.this.view.setAlwaysOnTop(false);
                    }
                    JOptionPane.showMessageDialog(LoginHandler.this.viewer, "\nThe application failed to log in. The hostname may be wrong or \nthe server may be offline.\n\nPlease try again.");
                    LoginHandler.this.viewer.appendToOutput("> Login failed. Try to relog.\n");
                    LoginHandler.this.viewer.enableMenus(true);
                    LoginHandler.this.viewer.setLoggedIn(false);
                    if (NEW_LOGIN) {
                        LoginHandler.this.refreshNewLogin();
                    }
                    return;
                }
            }
        }.start();
    }

    void refreshNewLogin() {
        this.view.setAlwaysOnTop(true);
        this.view.requestFocusOnField();
    }

    void loginCancelled() {
        this.viewer.setLoggedIn(false);
        this.viewer.enableMenus(true);
        this.viewer.setVisible(true);
    }

    public boolean displayLoginDialog(Object viewer, boolean modal, boolean displayTop) {
        Image img = Toolkit.getDefaultToolkit().createImage("gfx/icon.png");
        ResourceBundle bundle = ResourceBundle.getBundle("omero");
        String omeroVersion = bundle.getString("omero.version");
        this.view = new ScreenLogin(this.config.getAppTitle(), (Icon)GuiCommonElements.getImageIcon("gfx/login_background.png"), img, omeroVersion, Integer.toString((Integer)this.config.port.get()));
        this.view.showConnectionSpeed(false);
        this.viewTop = new ScreenLogo(this.config.getAppTitle(), (Icon)GuiCommonElements.getImageIcon("gfx/importer_splash.png"), img);
        this.viewTop.setStatusVisible(false);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d = this.viewTop.getExtendedSize();
        Dimension dlogin = this.view.getPreferredSize();
        if (displayTop) {
            int totalHeight = d.height + dlogin.height;
            this.viewTop.setBounds((screenSize.width - d.width) / 2, (screenSize.height - totalHeight) / 2, d.width, this.viewTop.getSize().height);
            Rectangle r = this.viewTop.getBounds();
            this.viewTop.addPropertyChangeListener((PropertyChangeListener)viewer);
            this.viewTop.addWindowStateListener((WindowStateListener)viewer);
            this.viewTop.addWindowFocusListener((WindowFocusListener)viewer);
            this.view.setBounds(r.x, r.y + d.height, dlogin.width, dlogin.height);
        } else {
            int totalHeight = dlogin.height;
            this.view.setBounds((screenSize.width - d.width) / 2, (screenSize.height - totalHeight) / 2, dlogin.width, dlogin.height);
            this.view.setQuitButtonText("Canel");
        }
        this.view.addPropertyChangeListener((PropertyChangeListener)viewer);
        this.view.addWindowStateListener((WindowStateListener)viewer);
        this.view.addWindowFocusListener((WindowFocusListener)viewer);
        this.view.setAlwaysOnTop(!displayTop);
        this.viewTop.setVisible(displayTop);
        this.view.setVisible(true);
        return true;
    }

    protected boolean isValidLogin() throws Exception {
        try {
            this.store = this.config.createStore();
            this.store.getKeepAlive().addObserver(this.viewer);
        }
        catch (Exception e) {
            log.error((Object)"Login failure.", (Throwable)e);
            return false;
        }
        new Thread(){

            public void run() {
                try {
                    ((LoginHandler)LoginHandler.this).viewer.getHistoryTable().db.initialize(LoginHandler.this.store);
                    ((LoginHandler)LoginHandler.this).viewer.getHistoryTable().db.initializeDataSource();
                    if (!((LoginHandler)LoginHandler.this).viewer.getHistoryTable().db.historyEnabled) {
                        ((LoginHandler)LoginHandler.this).viewer.tPane.setEnabledAt(((LoginHandler)LoginHandler.this).viewer.historyTabIndex, false);
                    } else {
                        ((LoginHandler)LoginHandler.this).viewer.tPane.setEnabledAt(((LoginHandler)LoginHandler.this).viewer.historyTabIndex, true);
                    }
                    LoginHandler.this.viewer.checkHistoryEnable();
                }
                catch (Exception e) {
                    log.error((Object)"Error initializing historytablestore", (Throwable)e);
                }
            }
        }.start();
        return true;
    }

    public void logout() {
        this.store.logout();
        this.viewer.setLoggedIn(false);
    }

    public OMEROMetadataStoreClient getMetadataStore() {
        return this.store;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (!NEW_LOGIN) {
            if (prop.equals(LOGIN)) {
                this.tryLogin();
            }
            if (prop.equals(LOGIN_CANCELLED)) {
                this.loginCancelled();
            }
        } else if (prop.equals("login")) {
            this.lc = (LoginCredentials)evt.getNewValue();
            if (this.lc != null) {
                this.tryLogin();
            }
        } else if ("quit".equals(prop)) {
            if (this.displayTop) {
                System.exit(0);
            } else {
                this.view.dispose();
            }
        } else if ("toFront".equals(prop) || "moveFront".equals(prop)) {
            // empty if block
        }
    }

    public boolean addObserver(IObserver object) {
        return this.observers.add(object);
    }

    public boolean deleteObserver(IObserver object) {
        return this.observers.remove(object);
    }

    public void notifyObservers(ImportEvent event) {
        for (IObserver observer : this.observers) {
            try {
                observer.update(this, event);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowStateChanged(WindowEvent e) {
    }

    public void windowGainedFocus(WindowEvent e) {
    }

    public void windowLostFocus(WindowEvent e) {
    }
}

