/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Plane2D {
    public static final int INT8 = 0;
    public static final int UINT8 = 1;
    public static final int INT16 = 2;
    public static final int UINT16 = 3;
    public static final int INT32 = 4;
    public static final int UINT32 = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    private ByteBuffer data;
    private int bytesPerPixel;
    private int type;
    private int sizeX;
    private int sizeY;

    Plane2D(ByteBuffer data, int type, boolean isLittleEndian, int sizeX, int sizeY) {
        this.type = type;
        this.data = data;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.data.order(isLittleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        this.bytesPerPixel = Plane2D.getBytesPerPixel(type);
    }

    public double getPixelValue(int x, int y) {
        int offset = (this.sizeX * y + x) * this.bytesPerPixel;
        switch (this.type) {
            case 0: {
                return this.data.get(offset);
            }
            case 2: {
                return this.data.getShort(offset);
            }
            case 4: {
                return this.data.getInt(offset);
            }
            case 6: {
                return this.data.getFloat(offset);
            }
            case 7: {
                return this.data.getDouble(offset);
            }
            case 1: {
                return (short)(this.data.get(offset) & 0xFF);
            }
            case 3: {
                return this.data.getShort(offset) & 0xFFFF;
            }
            case 5: {
                return (long)this.data.getInt(offset) & 0xFFFFFFFFL;
            }
        }
        throw new RuntimeException("Woah nelly! Something is very wrong.");
    }

    public static int getBytesPerPixel(int pixelType) {
        switch (pixelType) {
            case 0: 
            case 1: {
                return 1;
            }
            case 2: 
            case 3: {
                return 2;
            }
            case 4: 
            case 5: 
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Unknown pixel type: " + pixelType);
    }

    public ByteBuffer getData() {
        return this.data;
    }
}

