/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import omero.model.Dichroic;
import omero.model.LightPath;
import omero.model.LightPathEmissionFilterLink;
import omero.model.LightPathExcitationFilterLink;
import pojos.DataObject;
import pojos.DichroicData;
import pojos.FilterData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LightPathData
extends DataObject {
    private List<FilterData> emissionFilters;
    private List<FilterData> excitationFilters;

    public LightPathData(LightPath lightPath) {
        if (lightPath == null) {
            throw new IllegalArgumentException("lightPath cannot null.");
        }
        this.setValue(lightPath);
    }

    public List<FilterData> getEmissionFilters() {
        LightPath path = (LightPath)this.asIObject();
        if (this.emissionFilters == null && path.sizeOfEmissionFilterLink() > 0) {
            this.emissionFilters = new ArrayList<FilterData>();
            List<LightPathEmissionFilterLink> l = path.copyEmissionFilterLink();
            Iterator<LightPathEmissionFilterLink> i = l.iterator();
            while (i.hasNext()) {
                this.emissionFilters.add(new FilterData(i.next().getChild()));
            }
        }
        return this.emissionFilters;
    }

    public List<FilterData> getExcitationFilters() {
        LightPath path = (LightPath)this.asIObject();
        if (this.excitationFilters == null && path.sizeOfExcitationFilterLink() > 0) {
            this.excitationFilters = new ArrayList<FilterData>();
            List<LightPathExcitationFilterLink> l = path.copyExcitationFilterLink();
            Iterator<LightPathExcitationFilterLink> i = l.iterator();
            while (i.hasNext()) {
                this.excitationFilters.add(new FilterData(i.next().getChild()));
            }
        }
        return this.excitationFilters;
    }

    public DichroicData getDichroic() {
        LightPath path = (LightPath)this.asIObject();
        Dichroic d = path.getDichroic();
        if (d == null) {
            return null;
        }
        return new DichroicData(d);
    }
}

