/*
 * Decompiled with CFR 0.152.
 */
package ome.model.roi;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.roi.Shape;
import ome.util.DetailsFieldBridge;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@DiscriminatorValue(value="rect")
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class Rect
extends Shape
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "rect_owner_filter";
    public static final String GROUP_FILTER = "rect_group_filter";
    public static final String EVENT_FILTER = "rect_event_filter";
    public static final String PERMS_FILTER = "rect_perms_filter";
    protected Double x = null;
    protected Double y = null;
    protected Double width = null;
    protected Double height = null;
    protected Double rx = null;
    protected String textValue = null;
    public static final String X = "ome.model.roi.Rect_x";
    public static final String Y = "ome.model.roi.Rect_y";
    public static final String WIDTH = "ome.model.roi.Rect_width";
    public static final String HEIGHT = "ome.model.roi.Rect_height";
    public static final String RX = "ome.model.roi.Rect_rx";
    public static final String TEXTVALUE = "ome.model.roi.Rect_textValue";
    public static final Set<String> FIELDS;

    public Rect() {
        this(null, true);
    }

    protected Rect(Long id) {
        this(id, true);
    }

    public Rect(Long id, boolean loaded) {
        super(id, loaded);
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="x", updatable=true)
    public Double getX() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.x;
    }

    public void setX(Double x) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.x = x;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="y", updatable=true)
    public Double getY() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.y;
    }

    public void setY(Double y) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.y = y;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="width", updatable=true)
    public Double getWidth() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.width;
    }

    public void setWidth(Double width) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.width = width;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="height", updatable=true)
    public Double getHeight() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.height;
    }

    public void setHeight(Double height) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.height = height;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="rx", updatable=true)
    public Double getRx() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.rx;
    }

    public void setRx(Double rx) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.rx = rx;
    }

    @Type(type="org.hibernate.type.TextType")
    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="textValue", updatable=true)
    public String getTextValue() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.textValue;
    }

    public void setTextValue(String textValue) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.textValue = textValue;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public Rect newInstance() {
        return new Rect();
    }

    public Rect proxy() {
        return new Rect(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.x = (Double)__filter.filter(X, this.x);
            this.y = (Double)__filter.filter(Y, this.y);
            this.width = (Double)__filter.filter(WIDTH, this.width);
            this.height = (Double)__filter.filter(HEIGHT, this.height);
            this.rx = (Double)__filter.filter(RX, this.rx);
            this.textValue = (String)__filter.filter(TEXTVALUE, this.textValue);
            return super.acceptFilter(__filter);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(X)) {
            return this.getX();
        }
        if (field.equals(Y)) {
            return this.getY();
        }
        if (field.equals(WIDTH)) {
            return this.getWidth();
        }
        if (field.equals(HEIGHT)) {
            return this.getHeight();
        }
        if (field.equals(RX)) {
            return this.getRx();
        }
        if (field.equals(TEXTVALUE)) {
            return this.getTextValue();
        }
        return super.retrieve(field);
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(X)) {
            this.setX((Double)value);
        } else if (field.equals(Y)) {
            this.setY((Double)value);
        } else if (field.equals(WIDTH)) {
            this.setWidth((Double)value);
        } else if (field.equals(HEIGHT)) {
            this.setHeight((Double)value);
        } else if (field.equals(RX)) {
            this.setRx((Double)value);
        } else if (field.equals(TEXTVALUE)) {
            this.setTextValue((String)value);
        } else {
            super.putAt(field, value);
        }
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.x = null;
        this.y = null;
        this.width = null;
        this.height = null;
        this.rx = null;
        this.textValue = null;
        super.unload();
    }

    @Override
    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(X);
        raw.addAll(Shape.FIELDS);
        raw.add(Y);
        raw.addAll(Shape.FIELDS);
        raw.add(WIDTH);
        raw.addAll(Shape.FIELDS);
        raw.add(HEIGHT);
        raw.addAll(Shape.FIELDS);
        raw.add(RX);
        raw.addAll(Shape.FIELDS);
        raw.add(TEXTVALUE);
        raw.addAll(Shape.FIELDS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

