/*
 * Decompiled with CFR 0.152.
 */
package ome.model.meta;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IAnnotated;
import ome.model.IGlobal;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.model.annotations.ExperimenterGroupAnnotationLink;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Experimenter;
import ome.model.meta.ExternalInfo;
import ome.model.meta.GroupExperimenterMap;
import ome.util.CBlock;
import ome.util.CountCollectionPersister;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="experimentergroup", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_experimentergroup", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_experimentergroup"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class ExperimenterGroup
implements Serializable,
IObject,
IGlobal,
IMutable,
IAnnotated {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String ID = "ome.model.meta.ExperimenterGroup_id";
    protected Long id;
    public static final String VERSION = "ome.model.meta.ExperimenterGroup_version";
    protected Integer version = 0;
    protected String name = null;
    protected Set<GroupExperimenterMap> groupExperimenterMap = new HashSet<GroupExperimenterMap>();
    protected Set<ExperimenterGroupAnnotationLink> annotationLinks = new HashSet<ExperimenterGroupAnnotationLink>();
    public static final String OWNER_FILTER_ANNOTATIONLINKS = "experimentergroup_owner_filter_ANNOTATIONLINKS";
    public static final String GROUP_FILTER_ANNOTATIONLINKS = "experimentergroup_group_filter_ANNOTATIONLINKS";
    public static final String EVENT_FILTER_ANNOTATIONLINKS = "experimentergroup_event_filter_ANNOTATIONLINKS";
    public static final String PERMS_FILTER_ANNOTATIONLINKS = "experimentergroup_perms_filter_ANNOTATIONLINKS";
    private Map<Long, Long> annotationLinksCountPerOwner = null;
    protected String description = null;
    protected ome.model.internal.Details details = new Details();
    public static final String NAME = "ome.model.meta.ExperimenterGroup_name";
    public static final String GROUPEXPERIMENTERMAP = "ome.model.meta.ExperimenterGroup_groupExperimenterMap";
    public static final String ANNOTATIONLINKSCOUNTPEROWNER = "ome.model.meta.ExperimenterGroup_annotationLinksCountPerOwner";
    public static final String ANNOTATIONLINKS = "ome.model.meta.ExperimenterGroup_annotationLinks";
    public static final String DESCRIPTION = "ome.model.meta.ExperimenterGroup_description";
    public static final String DETAILS = "ome.model.meta.ExperimenterGroup_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public ExperimenterGroup() {
        this(null, true);
    }

    protected ExperimenterGroup(Long id) {
        this(id, true);
    }

    public ExperimenterGroup(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public ExperimenterGroup(String _name) {
        this(null, true);
        this.setName(_name);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_experimentergroup")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=true, name="name", updatable=true)
    public String getName() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.name;
    }

    public void setName(String name) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.name = name;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    protected Set<GroupExperimenterMap> getGroupExperimenterMap() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.groupExperimenterMap;
    }

    protected void setGroupExperimenterMap(Set<GroupExperimenterMap> groupExperimenterMap) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.groupExperimenterMap = groupExperimenterMap;
    }

    public int sizeOfGroupExperimenterMap() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.groupExperimenterMap == null ? -1 : this.groupExperimenterMap.size();
    }

    public Iterator<GroupExperimenterMap> iterateGroupExperimenterMap() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getGroupExperimenterMap() == null) {
            return new EmptyIterator<GroupExperimenterMap>();
        }
        return this.getGroupExperimenterMap().iterator();
    }

    public Collection<GroupExperimenterMap> unmodifiableGroupExperimenterMap() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getGroupExperimenterMap() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getGroupExperimenterMap());
    }

    public <E> List<E> collectGroupExperimenterMap(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<GroupExperimenterMap> it = this.iterateGroupExperimenterMap();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addGroupExperimenterMap(GroupExperimenterMap target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getGroupExperimenterMap() == null) {
            this.throwNullCollectionException("GroupExperimenterMap");
        }
        this.getGroupExperimenterMap().add(target);
        if (target != null) {
            target.setParent(this);
        }
    }

    public void addGroupExperimenterMapSet(Collection<GroupExperimenterMap> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getGroupExperimenterMap() == null) {
            this.throwNullCollectionException("GroupExperimenterMap");
        }
        this.getGroupExperimenterMap().addAll(targets);
        for (GroupExperimenterMap target : targets) {
            if (target == null) continue;
            target.setParent(this);
        }
    }

    public void removeGroupExperimenterMap(GroupExperimenterMap target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getGroupExperimenterMap() == null) {
            this.throwNullCollectionException("GroupExperimenterMap");
        }
        this.getGroupExperimenterMap().remove(target);
        target.setParent(null);
    }

    public void removeGroupExperimenterMapSet(Collection<GroupExperimenterMap> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getGroupExperimenterMap() == null) {
            this.throwNullCollectionException("GroupExperimenterMap");
        }
        this.getGroupExperimenterMap().removeAll(targets);
        for (GroupExperimenterMap target : targets) {
            target.setParent(null);
        }
    }

    public GroupExperimenterMap linkExperimenter(Experimenter addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        GroupExperimenterMap link = new GroupExperimenterMap();
        link.link(this, addition);
        this.addGroupExperimenterMap(link, true);
        return link;
    }

    public void addGroupExperimenterMap(GroupExperimenterMap link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getGroupExperimenterMap() == null) {
            this.throwNullCollectionException("GroupExperimenterMap");
        }
        this.getGroupExperimenterMap().add(link);
        if (bothSides && link.child().isLoaded()) {
            link.child().addGroupExperimenterMap(link, false);
        }
    }

    public Iterator<Experimenter> linkedExperimenterIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getGroupExperimenterMap() == null) {
            return new EmptyIterator<Experimenter>();
        }
        final Iterator<GroupExperimenterMap> it = this.getGroupExperimenterMap().iterator();
        return new Iterator<Experimenter>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Experimenter next() {
                if (it == null) {
                    throw new NoSuchElementException("groupExperimenterMap is null; no elements.");
                }
                GroupExperimenterMap link = (GroupExperimenterMap)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<GroupExperimenterMap> findGroupExperimenterMap(Experimenter target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<GroupExperimenterMap> it = this.iterateGroupExperimenterMap();
        HashSet<GroupExperimenterMap> result = new HashSet<GroupExperimenterMap>();
        while (it.hasNext()) {
            GroupExperimenterMap link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    public List<Experimenter> linkedExperimenterList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Experimenter> it = this.linkedExperimenterIterator();
        ArrayList<Experimenter> list = new ArrayList<Experimenter>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public <E> List<E> eachLinkedExperimenter(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Experimenter> it = this.linkedExperimenterIterator();
        while (it.hasNext()) {
            Experimenter obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void unlinkExperimenter(Experimenter removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<GroupExperimenterMap> toRemove = this.findGroupExperimenterMap(removal);
        Iterator<GroupExperimenterMap> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeGroupExperimenterMap(it.next(), true);
        }
    }

    public void removeGroupExperimenterMap(GroupExperimenterMap link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getGroupExperimenterMap() == null) {
            this.throwNullCollectionException("GroupExperimenterMap");
        }
        this.getGroupExperimenterMap().remove(link);
        if (bothSides && link.child().isLoaded()) {
            link.child().removeGroupExperimenterMap(link, false);
        }
    }

    public void clearExperimenterLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<GroupExperimenterMap> list = new ArrayList<GroupExperimenterMap>(this.getGroupExperimenterMap());
        for (GroupExperimenterMap link : list) {
            this.removeGroupExperimenterMap(link, true);
        }
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="experimentergroup_owner_filter_ANNOTATIONLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="experimentergroup_group_filter_ANNOTATIONLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="experimentergroup_event_filter_ANNOTATIONLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="experimentergroup_perms_filter_ANNOTATIONLINKS", condition=":permsStr = permissions")})
    protected Set<ExperimenterGroupAnnotationLink> getAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks;
    }

    protected void setAnnotationLinks(Set<ExperimenterGroupAnnotationLink> annotationLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.annotationLinks = annotationLinks;
    }

    @Override
    public int sizeOfAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks == null ? -1 : this.annotationLinks.size();
    }

    public Iterator<ExperimenterGroupAnnotationLink> iterateAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<ExperimenterGroupAnnotationLink>();
        }
        return this.getAnnotationLinks().iterator();
    }

    public Collection<ExperimenterGroupAnnotationLink> unmodifiableAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getAnnotationLinks());
    }

    @Override
    public <E> List<E> collectAnnotationLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<ExperimenterGroupAnnotationLink> it = this.iterateAnnotationLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addExperimenterGroupAnnotationLink(ExperimenterGroupAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(target);
        if (target != null) {
            target.setParent(this);
        }
    }

    public void addExperimenterGroupAnnotationLinkSet(Collection<ExperimenterGroupAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().addAll(targets);
        for (ExperimenterGroupAnnotationLink target : targets) {
            if (target == null) continue;
            target.setParent(this);
        }
    }

    public void removeExperimenterGroupAnnotationLink(ExperimenterGroupAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(target);
        target.setParent(null);
    }

    public void removeExperimenterGroupAnnotationLinkSet(Collection<ExperimenterGroupAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().removeAll(targets);
        for (ExperimenterGroupAnnotationLink target : targets) {
            target.setParent(null);
        }
    }

    public ExperimenterGroupAnnotationLink linkAnnotation(Annotation addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ExperimenterGroupAnnotationLink link = new ExperimenterGroupAnnotationLink();
        link.link(this, addition);
        this.addExperimenterGroupAnnotationLink(link, true);
        return link;
    }

    public void addExperimenterGroupAnnotationLink(ExperimenterGroupAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(link);
    }

    @Override
    public Iterator<Annotation> linkedAnnotationIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<Annotation>();
        }
        final Iterator<ExperimenterGroupAnnotationLink> it = this.getAnnotationLinks().iterator();
        return new Iterator<Annotation>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Annotation next() {
                if (it == null) {
                    throw new NoSuchElementException("annotationLinks is null; no elements.");
                }
                ExperimenterGroupAnnotationLink link = (ExperimenterGroupAnnotationLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<ExperimenterGroupAnnotationLink> findExperimenterGroupAnnotationLink(Annotation target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<ExperimenterGroupAnnotationLink> it = this.iterateAnnotationLinks();
        HashSet<ExperimenterGroupAnnotationLink> result = new HashSet<ExperimenterGroupAnnotationLink>();
        while (it.hasNext()) {
            ExperimenterGroupAnnotationLink link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public List<Annotation> linkedAnnotationList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Override
    public <E> List<E> eachLinkedAnnotation(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        while (it.hasNext()) {
            Annotation obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<ExperimenterGroupAnnotationLink> toRemove = this.findExperimenterGroupAnnotationLink(removal);
        Iterator<ExperimenterGroupAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeExperimenterGroupAnnotationLink(it.next(), true);
        }
    }

    public void removeExperimenterGroupAnnotationLink(ExperimenterGroupAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(link);
    }

    @Override
    public void clearAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<ExperimenterGroupAnnotationLink> list = new ArrayList<ExperimenterGroupAnnotationLink>(this.getAnnotationLinks());
        for (ExperimenterGroupAnnotationLink link : list) {
            this.removeExperimenterGroupAnnotationLink(link, true);
        }
    }

    protected void setAnnotationLinksCountPerOwner(Map<Long, Long> map) {
        this.annotationLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_ExperimenterGroup_annotationLinks")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_ExperimenterGroup_annotationLinks_by_owner", joinColumns={@JoinColumn(name="ExperimenterGroup_id")})
    public Map<Long, Long> getAnnotationLinksCountPerOwner() {
        return this.annotationLinksCountPerOwner;
    }

    @Type(type="org.hibernate.type.TextType")
    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="description", updatable=true)
    public String getDescription() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.description;
    }

    public void setDescription(String description) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.description = description;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public ExperimenterGroup newInstance() {
        return new ExperimenterGroup();
    }

    public ExperimenterGroup proxy() {
        return new ExperimenterGroup(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.name = (String)__filter.filter(NAME, this.name);
            this.groupExperimenterMap = (Set)__filter.filter(GROUPEXPERIMENTERMAP, this.groupExperimenterMap);
            this.annotationLinksCountPerOwner = __filter.filter(ANNOTATIONLINKSCOUNTPEROWNER, this.annotationLinksCountPerOwner);
            this.annotationLinks = (Set)__filter.filter(ANNOTATIONLINKS, this.annotationLinks);
            this.description = (String)__filter.filter(DESCRIPTION, this.description);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(NAME)) {
            return this.getName();
        }
        if (field.equals(GROUPEXPERIMENTERMAP)) {
            return this.getGroupExperimenterMap();
        }
        if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            return this.getAnnotationLinksCountPerOwner();
        }
        if (field.equals(ANNOTATIONLINKS)) {
            return this.getAnnotationLinks();
        }
        if (field.equals(DESCRIPTION)) {
            return this.getDescription();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(NAME)) {
            this.setName((String)value);
        } else if (field.equals(GROUPEXPERIMENTERMAP)) {
            this.setGroupExperimenterMap((Set)value);
        } else if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            this.setAnnotationLinksCountPerOwner((Map)value);
        } else if (field.equals(ANNOTATIONLINKS)) {
            this.setAnnotationLinks((Set)value);
        } else if (field.equals(DESCRIPTION)) {
            this.setDescription((String)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.name = null;
        this.groupExperimenterMap = null;
        this.annotationLinksCountPerOwner = null;
        this.annotationLinks = null;
        this.description = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(NAME);
        raw.add(GROUPEXPERIMENTERMAP);
        raw.add(ANNOTATIONLINKSCOUNTPEROWNER);
        raw.add(ANNOTATIONLINKS);
        raw.add(DESCRIPTION);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public ome.model.internal.Details newInstance() {
            return new Details();
        }

        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=false)
        @ForeignKey(name="FKexperimentergroup_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }
    }
}

