/*
 * Decompiled with CFR 0.152.
 */
package ome.model.acquisition;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.acquisition.FilterSet;
import ome.model.acquisition.Instrument;
import ome.model.acquisition.Objective;
import ome.model.enums.PixelsType;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.util.DetailsFieldBridge;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Target;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FilterDefs(value={@FilterDef(name="otf_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="otf_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="otf_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="otf_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="otf_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="otf_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="otf_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="otf_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="securityFilter")})
@Entity
@Table(name="otf", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_otf", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_otf"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class OTF
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "otf_owner_filter";
    public static final String GROUP_FILTER = "otf_group_filter";
    public static final String EVENT_FILTER = "otf_event_filter";
    public static final String PERMS_FILTER = "otf_perms_filter";
    public static final String ID = "ome.model.acquisition.OTF_id";
    protected Long id;
    public static final String VERSION = "ome.model.acquisition.OTF_version";
    protected Integer version = 0;
    protected Integer sizeX = null;
    protected Integer sizeY = null;
    protected Boolean opticalAxisAveraged = null;
    protected PixelsType pixelsType = null;
    protected String path = null;
    protected FilterSet filterSet = null;
    protected Objective objective = null;
    protected Instrument instrument = null;
    protected ome.model.internal.Details details = new Details();
    public static final String SIZEX = "ome.model.acquisition.OTF_sizeX";
    public static final String SIZEY = "ome.model.acquisition.OTF_sizeY";
    public static final String OPTICALAXISAVERAGED = "ome.model.acquisition.OTF_opticalAxisAveraged";
    public static final String PIXELSTYPE = "ome.model.acquisition.OTF_pixelsType";
    public static final String PATH = "ome.model.acquisition.OTF_path";
    public static final String FILTERSET = "ome.model.acquisition.OTF_filterSet";
    public static final String OBJECTIVE = "ome.model.acquisition.OTF_objective";
    public static final String INSTRUMENT = "ome.model.acquisition.OTF_instrument";
    public static final String DETAILS = "ome.model.acquisition.OTF_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public OTF() {
        this(null, true);
    }

    protected OTF(Long id) {
        this(id, true);
    }

    public OTF(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public OTF(Integer _sizeX, Integer _sizeY, Boolean _opticalAxisAveraged, PixelsType _pixelsType, String _path, Objective _objective, Instrument _instrument) {
        this(null, true);
        this.setSizeX(_sizeX);
        this.setSizeY(_sizeY);
        this.setOpticalAxisAveraged(_opticalAxisAveraged);
        this.setPixelsType(_pixelsType);
        this.setPath(_path);
        this.setObjective(_objective);
        this.setInstrument(_instrument);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_otf")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="sizeX", updatable=true)
    public Integer getSizeX() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.sizeX;
    }

    public void setSizeX(Integer sizeX) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.sizeX = sizeX;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="sizeY", updatable=true)
    public Integer getSizeY() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.sizeY;
    }

    public void setSizeY(Integer sizeY) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.sizeY = sizeY;
    }

    @Column(columnDefinition="", nullable=false, unique=false, name="opticalAxisAveraged", updatable=true)
    public Boolean getOpticalAxisAveraged() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.opticalAxisAveraged;
    }

    public void setOpticalAxisAveraged(Boolean opticalAxisAveraged) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.opticalAxisAveraged = opticalAxisAveraged;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=PixelsType.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="pixelsType", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKotf_pixelsType_pixelstype")
    public PixelsType getPixelsType() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.pixelsType;
    }

    public void setPixelsType(PixelsType pixelsType) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.pixelsType = pixelsType;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="path", updatable=true)
    public String getPath() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.path;
    }

    public void setPath(String path) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.path = path;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=FilterSet.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="filterSet", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKotf_filterSet_filterset")
    public FilterSet getFilterSet() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.filterSet;
    }

    public void setFilterSet(FilterSet filterSet) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.filterSet = filterSet;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Objective.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="objective", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKotf_objective_objective")
    public Objective getObjective() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.objective;
    }

    public void setObjective(Objective objective) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.objective = objective;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Instrument.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="instrument", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKotf_instrument_instrument")
    public Instrument getInstrument() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.instrument;
    }

    public void setInstrument(Instrument instrument) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.instrument = instrument;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public OTF newInstance() {
        return new OTF();
    }

    public OTF proxy() {
        return new OTF(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.sizeX = (Integer)__filter.filter(SIZEX, this.sizeX);
            this.sizeY = (Integer)__filter.filter(SIZEY, this.sizeY);
            this.opticalAxisAveraged = (Boolean)__filter.filter(OPTICALAXISAVERAGED, this.opticalAxisAveraged);
            this.pixelsType = (PixelsType)__filter.filter(PIXELSTYPE, this.pixelsType);
            this.path = (String)__filter.filter(PATH, this.path);
            this.filterSet = (FilterSet)__filter.filter(FILTERSET, this.filterSet);
            this.objective = (Objective)__filter.filter(OBJECTIVE, this.objective);
            this.instrument = (Instrument)__filter.filter(INSTRUMENT, this.instrument);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(SIZEX)) {
            return this.getSizeX();
        }
        if (field.equals(SIZEY)) {
            return this.getSizeY();
        }
        if (field.equals(OPTICALAXISAVERAGED)) {
            return this.getOpticalAxisAveraged();
        }
        if (field.equals(PIXELSTYPE)) {
            return this.getPixelsType();
        }
        if (field.equals(PATH)) {
            return this.getPath();
        }
        if (field.equals(FILTERSET)) {
            return this.getFilterSet();
        }
        if (field.equals(OBJECTIVE)) {
            return this.getObjective();
        }
        if (field.equals(INSTRUMENT)) {
            return this.getInstrument();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(SIZEX)) {
            this.setSizeX((Integer)value);
        } else if (field.equals(SIZEY)) {
            this.setSizeY((Integer)value);
        } else if (field.equals(OPTICALAXISAVERAGED)) {
            this.setOpticalAxisAveraged((Boolean)value);
        } else if (field.equals(PIXELSTYPE)) {
            this.setPixelsType((PixelsType)value);
        } else if (field.equals(PATH)) {
            this.setPath((String)value);
        } else if (field.equals(FILTERSET)) {
            this.setFilterSet((FilterSet)value);
        } else if (field.equals(OBJECTIVE)) {
            this.setObjective((Objective)value);
        } else if (field.equals(INSTRUMENT)) {
            this.setInstrument((Instrument)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.sizeX = null;
        this.sizeY = null;
        this.opticalAxisAveraged = null;
        this.pixelsType = null;
        this.path = null;
        this.filterSet = null;
        this.objective = null;
        this.instrument = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(SIZEX);
        raw.add(SIZEY);
        raw.add(OPTICALAXISAVERAGED);
        raw.add(PIXELSTYPE);
        raw.add(PATH);
        raw.add(FILTERSET);
        raw.add(OBJECTIVE);
        raw.add(INSTRUMENT);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public ome.model.internal.Details newInstance() {
            return new Details();
        }

        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=false)
        @ForeignKey(name="FKotf_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKotf_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKotf_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKotf_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKotf_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

