/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Identity;
import Ice.LocatorPrx;
import Ice.LocatorPrxHelper;
import Ice.Properties;
import IceInternal.LocatorInfo;
import IceInternal.LocatorTable;
import java.util.HashMap;

public final class LocatorManager {
    private final boolean _background;
    private HashMap<LocatorPrx, LocatorInfo> _table = new HashMap();
    private HashMap<Identity, LocatorTable> _locatorTables = new HashMap();

    LocatorManager(Properties properties) {
        this._background = properties.getPropertyAsInt("Ice.BackgroundLocatorCacheUpdates") > 0;
    }

    synchronized void destroy() {
        for (LocatorInfo info : this._table.values()) {
            info.destroy();
        }
        this._table.clear();
        this._locatorTables.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocatorInfo get(LocatorPrx loc) {
        if (loc == null) {
            return null;
        }
        LocatorPrx locator = LocatorPrxHelper.uncheckedCast(loc.ice_locator(null));
        LocatorManager locatorManager = this;
        synchronized (locatorManager) {
            LocatorInfo info = this._table.get(locator);
            if (info == null) {
                LocatorTable table = this._locatorTables.get(locator.ice_getIdentity());
                if (table == null) {
                    table = new LocatorTable();
                    this._locatorTables.put(locator.ice_getIdentity(), table);
                }
                info = new LocatorInfo(locator, table, this._background);
                this._table.put(locator, info);
            }
            return info;
        }
    }
}

