/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AlreadyRegisteredException;
import Ice.CompressionException;
import Ice.EncapsulationException;
import Ice.IllegalMessageSizeException;
import Ice.MarshalException;
import Ice.MemoryLimitException;
import Ice.NegativeSizeException;
import Ice.NoObjectFactoryException;
import Ice.Object;
import Ice.ObjectFactory;
import Ice.ObjectImpl;
import Ice.ObjectPrx;
import Ice.SyscallException;
import Ice.UnmarshalOutOfBoundsException;
import Ice.UnsupportedEncodingException;
import Ice.UserException;
import IceInternal.Buffer;
import IceInternal.InputStreamWrapper;
import IceInternal.Instance;
import IceInternal.OutputStreamWrapper;
import IceInternal.Patcher;
import IceInternal.TraceUtil;
import IceInternal.UserExceptionFactory;
import IceUtilInternal.OutputBase;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicStream {
    private static final byte[] _encapsBlob = new byte[]{0, 0, 0, 0, 1, 0};
    static final Charset _utf8 = Charset.forName("UTF8");
    private CharsetEncoder _charEncoder = null;
    private Instance _instance;
    private Buffer _buf;
    private java.lang.Object _closure;
    private byte[] _stringBytes;
    private char[] _stringChars;
    private ReadEncaps _readEncapsStack;
    private WriteEncaps _writeEncapsStack;
    private ReadEncaps _readEncapsCache;
    private WriteEncaps _writeEncapsCache;
    private int _readSlice;
    private int _writeSlice;
    private int _traceSlicing;
    private String _slicingCat;
    private boolean _sliceObjects;
    private int _messageSizeMax;
    private boolean _unlimited;
    SeqData _seqDataStack;
    private ArrayList<Object> _objectList;
    private static HashMap<String, UserExceptionFactory> _exceptionFactories = new HashMap();
    private static java.lang.Object _factoryMutex = new java.lang.Object();
    private static Constructor<?> _bzInputStreamCtor;
    private static Constructor<?> _bzOutputStreamCtor;

    public BasicStream(Instance instance) {
        this.initialize(instance, false);
    }

    public BasicStream(Instance instance, boolean unlimited) {
        this.initialize(instance, unlimited);
    }

    private void initialize(Instance instance, boolean unlimited) {
        this._instance = instance;
        this._buf = new Buffer(this._instance.messageSizeMax());
        this._closure = null;
        this._unlimited = unlimited;
        this._readEncapsStack = null;
        this._writeEncapsStack = null;
        this._readEncapsCache = null;
        this._writeEncapsCache = null;
        this._traceSlicing = -1;
        this._sliceObjects = true;
        this._messageSizeMax = this._instance.messageSizeMax();
        this._seqDataStack = null;
        this._objectList = null;
    }

    public void reset() {
        this._buf.reset();
        if (this._readEncapsStack != null) {
            assert (this._readEncapsStack.next == null);
            this._readEncapsStack.next = this._readEncapsCache;
            this._readEncapsCache = this._readEncapsStack;
            this._readEncapsStack = null;
            this._readEncapsCache.reset();
        }
        if (this._objectList != null) {
            this._objectList.clear();
        }
        this._sliceObjects = true;
    }

    public Instance instance() {
        return this._instance;
    }

    public java.lang.Object closure() {
        return this._closure;
    }

    public java.lang.Object closure(java.lang.Object p) {
        java.lang.Object prev = this._closure;
        this._closure = p;
        return prev;
    }

    public void swap(BasicStream other) {
        assert (this._instance == other._instance);
        java.lang.Object tmpClosure = other._closure;
        other._closure = this._closure;
        this._closure = tmpClosure;
        Buffer tmpBuf = other._buf;
        other._buf = this._buf;
        this._buf = tmpBuf;
        ReadEncaps tmpRead = other._readEncapsStack;
        other._readEncapsStack = this._readEncapsStack;
        this._readEncapsStack = tmpRead;
        tmpRead = other._readEncapsCache;
        other._readEncapsCache = this._readEncapsCache;
        this._readEncapsCache = tmpRead;
        WriteEncaps tmpWrite = other._writeEncapsStack;
        other._writeEncapsStack = this._writeEncapsStack;
        this._writeEncapsStack = tmpWrite;
        tmpWrite = other._writeEncapsCache;
        other._writeEncapsCache = this._writeEncapsCache;
        this._writeEncapsCache = tmpWrite;
        int tmpReadSlice = other._readSlice;
        other._readSlice = this._readSlice;
        this._readSlice = tmpReadSlice;
        int tmpWriteSlice = other._writeSlice;
        other._writeSlice = this._writeSlice;
        this._writeSlice = tmpWriteSlice;
        SeqData tmpSeqDataStack = other._seqDataStack;
        other._seqDataStack = this._seqDataStack;
        this._seqDataStack = tmpSeqDataStack;
        ArrayList<Object> tmpObjectList = other._objectList;
        other._objectList = this._objectList;
        this._objectList = tmpObjectList;
        boolean tmpUnlimited = other._unlimited;
        other._unlimited = this._unlimited;
        this._unlimited = tmpUnlimited;
    }

    public void resize(int sz, boolean reading) {
        if (!this._unlimited && sz > this._messageSizeMax) {
            throw new MemoryLimitException();
        }
        this._buf.resize(sz, reading);
        this._buf.b.position(sz);
    }

    public Buffer prepareWrite() {
        this._buf.b.limit(this._buf.size());
        this._buf.b.position(0);
        return this._buf;
    }

    public Buffer getBuffer() {
        return this._buf;
    }

    public void startSeq(int numElements, int minSize) {
        if (numElements == 0) {
            return;
        }
        SeqData sd = new SeqData(numElements, minSize);
        sd.previous = this._seqDataStack;
        this._seqDataStack = sd;
        int bytesLeft = this._buf.b.remaining();
        if (this._seqDataStack.previous == null) {
            if (numElements * minSize > bytesLeft) {
                throw new UnmarshalOutOfBoundsException();
            }
        } else {
            this.checkSeq(bytesLeft);
        }
    }

    public void checkSeq() {
        this.checkSeq(this._buf.b.remaining());
    }

    public void checkSeq(int bytesLeft) {
        int size = 0;
        SeqData sd = this._seqDataStack;
        do {
            size += (sd.numElements - 1) * sd.minSize;
        } while ((sd = sd.previous) != null);
        if (size > bytesLeft) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void checkFixedSeq(int numElements, int elemSize) {
        int bytesLeft = this._buf.b.remaining();
        if (this._seqDataStack == null) {
            if (numElements * elemSize > bytesLeft) {
                throw new UnmarshalOutOfBoundsException();
            }
        } else {
            this.checkSeq(bytesLeft - numElements * elemSize);
        }
    }

    public void endSeq(int sz) {
        if (sz == 0) {
            return;
        }
        SeqData oldSeqData = this._seqDataStack;
        assert (oldSeqData != null);
        this._seqDataStack = oldSeqData.previous;
    }

    public void endElement() {
        assert (this._seqDataStack != null);
        --this._seqDataStack.numElements;
    }

    public void startWriteEncaps() {
        WriteEncaps curr = this._writeEncapsCache;
        if (curr != null) {
            curr.reset();
            this._writeEncapsCache = this._writeEncapsCache.next;
        } else {
            curr = new WriteEncaps();
        }
        curr.next = this._writeEncapsStack;
        this._writeEncapsStack = curr;
        this._writeEncapsStack.start = this._buf.size();
        this.writeBlob(_encapsBlob);
    }

    public void endWriteEncaps() {
        assert (this._writeEncapsStack != null);
        int start = this._writeEncapsStack.start;
        int sz = this._buf.size() - start;
        this._buf.b.putInt(start, sz);
        WriteEncaps curr = this._writeEncapsStack;
        this._writeEncapsStack = curr.next;
        curr.next = this._writeEncapsCache;
        this._writeEncapsCache = curr;
        this._writeEncapsCache.reset();
    }

    public void endWriteEncapsChecked() {
        if (this._writeEncapsStack == null) {
            throw new EncapsulationException("not in an encapsulation");
        }
        this.endWriteEncaps();
    }

    public void startReadEncaps() {
        ReadEncaps curr = this._readEncapsCache;
        if (curr != null) {
            curr.reset();
            this._readEncapsCache = this._readEncapsCache.next;
        } else {
            curr = new ReadEncaps();
        }
        curr.next = this._readEncapsStack;
        this._readEncapsStack = curr;
        this._readEncapsStack.start = this._buf.b.position();
        int sz = this.readInt();
        if (sz < 0) {
            throw new NegativeSizeException();
        }
        if (sz - 4 > this._buf.b.limit()) {
            throw new UnmarshalOutOfBoundsException();
        }
        this._readEncapsStack.sz = sz;
        int eMajor = this.readByte();
        int eMinor = this.readByte();
        if (eMajor != 1 || eMinor > 0) {
            UnsupportedEncodingException e = new UnsupportedEncodingException();
            e.badMajor = eMajor < 0 ? eMajor + 256 : eMajor;
            e.badMinor = eMinor < 0 ? eMinor + 256 : eMinor;
            e.major = 1;
            e.minor = 0;
            throw e;
        }
        this._readEncapsStack.encodingMajor = eMajor;
        this._readEncapsStack.encodingMinor = eMinor;
    }

    public void endReadEncaps() {
        assert (this._readEncapsStack != null);
        if (this._buf.b.position() != this._readEncapsStack.start + this._readEncapsStack.sz) {
            if (this._buf.b.position() + 1 != this._readEncapsStack.start + this._readEncapsStack.sz) {
                throw new EncapsulationException();
            }
            try {
                this._buf.b.get();
            }
            catch (BufferUnderflowException ex) {
                throw new UnmarshalOutOfBoundsException();
            }
        }
        ReadEncaps curr = this._readEncapsStack;
        this._readEncapsStack = curr.next;
        curr.next = this._readEncapsCache;
        this._readEncapsCache = curr;
        this._readEncapsCache.reset();
    }

    public void skipEmptyEncaps() {
        int sz = this.readInt();
        if (sz < 0) {
            throw new NegativeSizeException();
        }
        if (sz != 6) {
            throw new EncapsulationException();
        }
        try {
            this._buf.b.position(this._buf.b.position() + 2);
        }
        catch (IllegalArgumentException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void endReadEncapsChecked() {
        if (this._readEncapsStack == null) {
            throw new EncapsulationException("not in an encapsulation");
        }
        this.endReadEncaps();
    }

    public int getReadEncapsSize() {
        assert (this._readEncapsStack != null);
        return this._readEncapsStack.sz - 6;
    }

    public void skipEncaps() {
        int sz = this.readInt();
        if (sz < 0) {
            throw new NegativeSizeException();
        }
        try {
            this._buf.b.position(this._buf.b.position() + sz - 4);
        }
        catch (IllegalArgumentException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void startWriteSlice() {
        this.writeInt(0);
        this._writeSlice = this._buf.size();
    }

    public void endWriteSlice() {
        int sz = this._buf.size() - this._writeSlice + 4;
        this._buf.b.putInt(this._writeSlice - 4, sz);
    }

    public void startReadSlice() {
        int sz = this.readInt();
        if (sz < 0) {
            throw new NegativeSizeException();
        }
        this._readSlice = this._buf.b.position();
    }

    public void endReadSlice() {
    }

    public void skipSlice() {
        int sz = this.readInt();
        if (sz < 0) {
            throw new NegativeSizeException();
        }
        try {
            this._buf.b.position(this._buf.b.position() + sz - 4);
        }
        catch (IllegalArgumentException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void writeSize(int v) {
        if (v > 254) {
            this.expand(5);
            this._buf.b.put((byte)-1);
            this._buf.b.putInt(v);
        } else {
            this.expand(1);
            this._buf.b.put((byte)v);
        }
    }

    public int readSize() {
        try {
            int b = this._buf.b.get();
            if (b == -1) {
                int v = this._buf.b.getInt();
                if (v < 0) {
                    throw new NegativeSizeException();
                }
                return v;
            }
            return b < 0 ? b + 256 : b;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void writeTypeId(String id) {
        if (this._writeEncapsStack == null || this._writeEncapsStack.typeIdMap == null) {
            throw new MarshalException("type ids require an encapsulation");
        }
        Integer index = this._writeEncapsStack.typeIdMap.get(id);
        if (index != null) {
            this.writeBool(true);
            this.writeSize(index);
        } else {
            index = new Integer(++this._writeEncapsStack.typeIdIndex);
            this._writeEncapsStack.typeIdMap.put(id, index);
            this.writeBool(false);
            this.writeString(id);
        }
    }

    public String readTypeId() {
        String id;
        if (this._readEncapsStack == null || this._readEncapsStack.typeIdMap == null) {
            throw new MarshalException("type ids require an encapsulation");
        }
        boolean isIndex = this.readBool();
        if (isIndex) {
            Integer index = new Integer(this.readSize());
            id = this._readEncapsStack.typeIdMap.get(index);
            if (id == null) {
                throw new UnmarshalOutOfBoundsException();
            }
        } else {
            id = this.readString();
            Integer index = new Integer(++this._readEncapsStack.typeIdIndex);
            this._readEncapsStack.typeIdMap.put(index, id);
        }
        return id;
    }

    public void writeBlob(byte[] v) {
        this.expand(v.length);
        this._buf.b.put(v);
    }

    public void writeBlob(byte[] v, int off, int len) {
        this.expand(len);
        this._buf.b.put(v, off, len);
    }

    public byte[] readBlob(int sz) {
        byte[] v = new byte[sz];
        try {
            this._buf.b.get(v);
            return v;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void writeByte(byte v) {
        this.expand(1);
        this._buf.b.put(v);
    }

    public void writeByte(byte v, int end) {
        if (v < 0 || v >= end) {
            throw new MarshalException("enumerator out of range");
        }
        this.writeByte(v);
    }

    public void writeByteSeq(byte[] v) {
        if (v == null) {
            this.writeSize(0);
        } else {
            this.writeSize(v.length);
            this.expand(v.length);
            this._buf.b.put(v);
        }
    }

    public void writeSerializable(Serializable o) {
        if (o == null) {
            this.writeSize(0);
            return;
        }
        try {
            OutputStreamWrapper w = new OutputStreamWrapper(this);
            ObjectOutputStream out = new ObjectOutputStream(w);
            out.writeObject(o);
            out.close();
            w.close();
        }
        catch (Exception ex) {
            throw new MarshalException("cannot serialize object: " + ex);
        }
    }

    public byte readByte() {
        try {
            return this._buf.b.get();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public byte readByte(int end) {
        byte v = this.readByte();
        if (v < 0 || v >= end) {
            throw new MarshalException("enumerator out of range");
        }
        return v;
    }

    public byte[] readByteSeq() {
        try {
            int sz = this.readSize();
            this.checkFixedSeq(sz, 1);
            byte[] v = new byte[sz];
            this._buf.b.get(v);
            return v;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public Serializable readSerializable() {
        int sz = this.readSize();
        if (sz == 0) {
            return null;
        }
        this.checkFixedSeq(sz, 1);
        try {
            InputStreamWrapper w = new InputStreamWrapper(sz, this);
            ObjectInputStream in = new ObjectInputStream(w);
            return (Serializable)in.readObject();
        }
        catch (Exception ex) {
            throw new MarshalException("cannot deserialize object: " + ex);
        }
    }

    public void writeBool(boolean v) {
        this.expand(1);
        this._buf.b.put(v ? (byte)1 : 0);
    }

    public void writeBoolSeq(boolean[] v) {
        if (v == null) {
            this.writeSize(0);
        } else {
            this.writeSize(v.length);
            this.expand(v.length);
            for (int i = 0; i < v.length; ++i) {
                this._buf.b.put(v[i] ? (byte)1 : 0);
            }
        }
    }

    public boolean readBool() {
        try {
            return this._buf.b.get() == 1;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public boolean[] readBoolSeq() {
        try {
            int sz = this.readSize();
            this.checkFixedSeq(sz, 1);
            boolean[] v = new boolean[sz];
            for (int i = 0; i < sz; ++i) {
                v[i] = this._buf.b.get() == 1;
            }
            return v;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void writeShort(short v) {
        this.expand(2);
        this._buf.b.putShort(v);
    }

    public void writeShort(short v, int end) {
        if (v < 0 || v >= end) {
            throw new MarshalException("enumerator out of range");
        }
        this.writeShort(v);
    }

    public void writeShortSeq(short[] v) {
        if (v == null) {
            this.writeSize(0);
        } else {
            this.writeSize(v.length);
            this.expand(v.length * 2);
            ShortBuffer shortBuf = this._buf.b.asShortBuffer();
            shortBuf.put(v);
            this._buf.b.position(this._buf.b.position() + v.length * 2);
        }
    }

    public short readShort() {
        try {
            return this._buf.b.getShort();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public short readShort(int end) {
        short v = this.readShort();
        if (v < 0 || v >= end) {
            throw new MarshalException("enumerator out of range");
        }
        return v;
    }

    public short[] readShortSeq() {
        try {
            int sz = this.readSize();
            this.checkFixedSeq(sz, 2);
            short[] v = new short[sz];
            ShortBuffer shortBuf = this._buf.b.asShortBuffer();
            shortBuf.get(v);
            this._buf.b.position(this._buf.b.position() + sz * 2);
            return v;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void writeInt(int v) {
        this.expand(4);
        this._buf.b.putInt(v);
    }

    public void writeInt(int v, int end) {
        if (v < 0 || v >= end) {
            throw new MarshalException("enumerator out of range");
        }
        this.writeInt(v);
    }

    public void writeIntSeq(int[] v) {
        if (v == null) {
            this.writeSize(0);
        } else {
            this.writeSize(v.length);
            this.expand(v.length * 4);
            IntBuffer intBuf = this._buf.b.asIntBuffer();
            intBuf.put(v);
            this._buf.b.position(this._buf.b.position() + v.length * 4);
        }
    }

    public int readInt() {
        try {
            return this._buf.b.getInt();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public int readInt(int end) {
        int v = this.readInt();
        if (v < 0 || v >= end) {
            throw new MarshalException("enumerator out of range");
        }
        return v;
    }

    public int[] readIntSeq() {
        try {
            int sz = this.readSize();
            this.checkFixedSeq(sz, 4);
            int[] v = new int[sz];
            IntBuffer intBuf = this._buf.b.asIntBuffer();
            intBuf.get(v);
            this._buf.b.position(this._buf.b.position() + sz * 4);
            return v;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void writeLong(long v) {
        this.expand(8);
        this._buf.b.putLong(v);
    }

    public void writeLongSeq(long[] v) {
        if (v == null) {
            this.writeSize(0);
        } else {
            this.writeSize(v.length);
            this.expand(v.length * 8);
            LongBuffer longBuf = this._buf.b.asLongBuffer();
            longBuf.put(v);
            this._buf.b.position(this._buf.b.position() + v.length * 8);
        }
    }

    public long readLong() {
        try {
            return this._buf.b.getLong();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public long[] readLongSeq() {
        try {
            int sz = this.readSize();
            this.checkFixedSeq(sz, 8);
            long[] v = new long[sz];
            LongBuffer longBuf = this._buf.b.asLongBuffer();
            longBuf.get(v);
            this._buf.b.position(this._buf.b.position() + sz * 8);
            return v;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void writeFloat(float v) {
        this.expand(4);
        this._buf.b.putFloat(v);
    }

    public void writeFloatSeq(float[] v) {
        if (v == null) {
            this.writeSize(0);
        } else {
            this.writeSize(v.length);
            this.expand(v.length * 4);
            FloatBuffer floatBuf = this._buf.b.asFloatBuffer();
            floatBuf.put(v);
            this._buf.b.position(this._buf.b.position() + v.length * 4);
        }
    }

    public float readFloat() {
        try {
            return this._buf.b.getFloat();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public float[] readFloatSeq() {
        try {
            int sz = this.readSize();
            this.checkFixedSeq(sz, 4);
            float[] v = new float[sz];
            FloatBuffer floatBuf = this._buf.b.asFloatBuffer();
            floatBuf.get(v);
            this._buf.b.position(this._buf.b.position() + sz * 4);
            return v;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void writeDouble(double v) {
        this.expand(8);
        this._buf.b.putDouble(v);
    }

    public void writeDoubleSeq(double[] v) {
        if (v == null) {
            this.writeSize(0);
        } else {
            this.writeSize(v.length);
            this.expand(v.length * 8);
            DoubleBuffer doubleBuf = this._buf.b.asDoubleBuffer();
            doubleBuf.put(v);
            this._buf.b.position(this._buf.b.position() + v.length * 8);
        }
    }

    public double readDouble() {
        try {
            return this._buf.b.getDouble();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public double[] readDoubleSeq() {
        try {
            int sz = this.readSize();
            this.checkFixedSeq(sz, 8);
            double[] v = new double[sz];
            DoubleBuffer doubleBuf = this._buf.b.asDoubleBuffer();
            doubleBuf.get(v);
            this._buf.b.position(this._buf.b.position() + sz * 8);
            return v;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void writeString(String v) {
        if (v == null) {
            this.writeSize(0);
        } else {
            int len = v.length();
            if (len > 0) {
                if (this._stringBytes == null || len > this._stringBytes.length) {
                    this._stringBytes = new byte[len];
                }
                if (this._stringChars == null || len > this._stringChars.length) {
                    this._stringChars = new char[len];
                }
                v.getChars(0, len, this._stringChars, 0);
                for (int i = 0; i < len; ++i) {
                    if (this._stringChars[i] > '\u007f') {
                        if (this._charEncoder == null) {
                            this._charEncoder = _utf8.newEncoder();
                        }
                        ByteBuffer b = null;
                        try {
                            b = this._charEncoder.encode(CharBuffer.wrap(this._stringChars, 0, len));
                        }
                        catch (CharacterCodingException ex) {
                            MarshalException e = new MarshalException();
                            e.initCause(ex);
                            throw e;
                        }
                        this.writeSize(b.limit());
                        this.expand(b.limit());
                        this._buf.b.put(b);
                        return;
                    }
                    this._stringBytes[i] = (byte)this._stringChars[i];
                }
                this.writeSize(len);
                this.expand(len);
                this._buf.b.put(this._stringBytes, 0, len);
            } else {
                this.writeSize(0);
            }
        }
    }

    public void writeStringSeq(String[] v) {
        if (v == null) {
            this.writeSize(0);
        } else {
            this.writeSize(v.length);
            for (int i = 0; i < v.length; ++i) {
                this.writeString(v[i]);
            }
        }
    }

    public String readString() {
        int len = this.readSize();
        if (len == 0) {
            return "";
        }
        try {
            if (this._stringBytes == null || len > this._stringBytes.length) {
                this._stringBytes = new byte[len];
            }
            if (this._stringChars == null || len > this._stringChars.length) {
                this._stringChars = new char[len];
            }
            this._buf.b.get(this._stringBytes, 0, len);
            for (int i = 0; i < len; ++i) {
                if (this._stringBytes[i] < 0) {
                    return new String(this._stringBytes, 0, len, "UTF8");
                }
                this._stringChars[i] = (char)this._stringBytes[i];
            }
            return new String(this._stringChars, 0, len);
        }
        catch (java.io.UnsupportedEncodingException ex) {
            assert (false);
            return "";
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public String[] readStringSeq() {
        int sz = this.readSize();
        this.startSeq(sz, 1);
        String[] v = new String[sz];
        for (int i = 0; i < sz; ++i) {
            v[i] = this.readString();
            this.checkSeq();
            this.endElement();
        }
        this.endSeq(sz);
        return v;
    }

    public void writeProxy(ObjectPrx v) {
        this._instance.proxyFactory().proxyToStream(v, this);
    }

    public ObjectPrx readProxy() {
        return this._instance.proxyFactory().streamToProxy(this);
    }

    public void writeObject(Object v) {
        if (this._writeEncapsStack == null) {
            this._writeEncapsStack = this._writeEncapsCache;
            if (this._writeEncapsStack != null) {
                this._writeEncapsCache = this._writeEncapsCache.next;
            } else {
                this._writeEncapsStack = new WriteEncaps();
            }
        }
        if (this._writeEncapsStack.toBeMarshaledMap == null) {
            this._writeEncapsStack.toBeMarshaledMap = new IdentityHashMap();
            this._writeEncapsStack.marshaledMap = new IdentityHashMap();
            this._writeEncapsStack.typeIdMap = new TreeMap();
        }
        if (v != null) {
            Integer p = this._writeEncapsStack.toBeMarshaledMap.get(v);
            if (p == null) {
                Integer q = this._writeEncapsStack.marshaledMap.get(v);
                if (q == null) {
                    q = new Integer(++this._writeEncapsStack.writeIndex);
                    this._writeEncapsStack.toBeMarshaledMap.put(v, q);
                }
                p = q;
            }
            this.writeInt(-p.intValue());
        } else {
            this.writeInt(0);
        }
    }

    public void readObject(Patcher patcher) {
        int index;
        Object v;
        block17: {
            v = null;
            if (this._readEncapsStack == null) {
                this._readEncapsStack = this._readEncapsCache;
                if (this._readEncapsStack != null) {
                    this._readEncapsCache = this._readEncapsCache.next;
                } else {
                    this._readEncapsStack = new ReadEncaps();
                }
            }
            if (this._readEncapsStack.patchMap == null) {
                this._readEncapsStack.patchMap = new TreeMap();
                this._readEncapsStack.unmarshaledMap = new TreeMap();
                this._readEncapsStack.typeIdMap = new TreeMap();
            }
            index = this.readInt();
            if (patcher != null) {
                if (index == 0) {
                    patcher.patch(null);
                    return;
                }
                if (index < 0) {
                    Integer i = new Integer(-index);
                    LinkedList<Patcher> patchlist = this._readEncapsStack.patchMap.get(i);
                    if (patchlist == null) {
                        patchlist = new LinkedList();
                        this._readEncapsStack.patchMap.put(i, patchlist);
                    }
                    patchlist.add(patcher);
                    this.patchReferences(null, i);
                    return;
                }
            }
            if (index < 0) {
                throw new MarshalException("Invalid class instance index");
            }
            String mostDerivedId = this.readTypeId();
            String id = new String(mostDerivedId);
            while (true) {
                if (id.equals(ObjectImpl.ice_staticId())) {
                    throw new NoObjectFactoryException("", mostDerivedId);
                }
                ObjectFactory userFactory = this._instance.servantFactoryManager().find(id);
                if (userFactory != null) {
                    v = userFactory.create(id);
                }
                if (v == null && (userFactory = this._instance.servantFactoryManager().find("")) != null) {
                    v = userFactory.create(id);
                }
                if (v == null && (userFactory = this.loadObjectFactory(id)) != null) {
                    v = userFactory.create(id);
                }
                if (v != null) break block17;
                if (!this._sliceObjects) break;
                if (this._traceSlicing == -1) {
                    this._traceSlicing = this._instance.traceLevels().slicing;
                    this._slicingCat = this._instance.traceLevels().slicingCat;
                }
                if (this._traceSlicing > 0) {
                    TraceUtil.traceSlicing("class", id, this._slicingCat, this._instance.initializationData().logger);
                }
                this.skipSlice();
                id = this.readTypeId();
            }
            NoObjectFactoryException ex = new NoObjectFactoryException();
            ex.type = id;
            throw ex;
        }
        Integer i = new Integer(index);
        this._readEncapsStack.unmarshaledMap.put(i, v);
        if (this._objectList == null) {
            this._objectList = new ArrayList();
        }
        this._objectList.add(v);
        v.__read(this, false);
        this.patchReferences(i, null);
    }

    public void writeUserException(UserException v) {
        this.writeBool(v.__usesClasses());
        v.__write(this);
        if (v.__usesClasses()) {
            this.writePendingObjects();
        }
    }

    public void throwException() throws UserException {
        String id;
        boolean usesClasses = this.readBool();
        String origId = id = this.readString();
        while (true) {
            UserExceptionFactory factory;
            if ((factory = this.getUserExceptionFactory(id)) != null) {
                try {
                    factory.createAndThrow();
                }
                catch (UserException ex) {
                    ex.__read(this, false);
                    if (usesClasses) {
                        this.readPendingObjects();
                    }
                    throw ex;
                }
            }
            if (this._traceSlicing == -1) {
                this._traceSlicing = this._instance.traceLevels().slicing;
                this._slicingCat = this._instance.traceLevels().slicingCat;
            }
            if (this._traceSlicing > 0) {
                TraceUtil.traceSlicing("exception", id, this._slicingCat, this._instance.initializationData().logger);
            }
            this.skipSlice();
            try {
                id = this.readString();
            }
            catch (UnmarshalOutOfBoundsException ex) {
                UnmarshalOutOfBoundsException e = new UnmarshalOutOfBoundsException();
                e.reason = "unknown exception type `" + origId + "'";
                e.initCause(ex);
                throw e;
            }
        }
    }

    public void writePendingObjects() {
        if (this._writeEncapsStack != null && this._writeEncapsStack.toBeMarshaledMap != null) {
            while (this._writeEncapsStack.toBeMarshaledMap.size() > 0) {
                IdentityHashMap<Object, Integer> savedMap = new IdentityHashMap<Object, Integer>(this._writeEncapsStack.toBeMarshaledMap);
                this.writeSize(savedMap.size());
                for (Map.Entry<Object, Integer> e : savedMap.entrySet()) {
                    this._writeEncapsStack.marshaledMap.put(e.getKey(), e.getValue());
                    this.writeInstance(e.getKey(), e.getValue());
                }
                Iterator<Object> q = savedMap.keySet().iterator();
                while (q.hasNext()) {
                    this._writeEncapsStack.toBeMarshaledMap.remove(q.next());
                }
            }
        }
        this.writeSize(0);
    }

    public void readPendingObjects() {
        int num;
        do {
            for (int k = num = this.readSize(); k > 0; --k) {
                this.readObject(null);
            }
        } while (num > 0);
        if (this._readEncapsStack != null && this._readEncapsStack.patchMap != null && this._readEncapsStack.patchMap.size() != 0) {
            throw new MarshalException("Index for class received, but no instance");
        }
        if (this._objectList != null) {
            for (Object obj : this._objectList) {
                try {
                    obj.ice_postUnmarshal();
                }
                catch (Exception ex) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    OutputBase out = new OutputBase(pw);
                    out.setUseTab(false);
                    out.print("exception raised by ice_postUnmarshal:\n");
                    ex.printStackTrace(pw);
                    pw.flush();
                    this._instance.initializationData().logger.warning(sw.toString());
                }
            }
        }
    }

    public void sliceObjects(boolean b) {
        this._sliceObjects = b;
    }

    void writeInstance(Object v, Integer index) {
        this.writeInt(index);
        try {
            v.ice_preMarshal();
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            OutputBase out = new OutputBase(pw);
            out.setUseTab(false);
            out.print("exception raised by ice_preMarshal:\n");
            ex.printStackTrace(pw);
            pw.flush();
            this._instance.initializationData().logger.warning(sw.toString());
        }
        v.__write(this);
    }

    void patchReferences(Integer instanceIndex, Integer patchIndex) {
        Object v;
        LinkedList<Patcher> patchlist;
        assert (instanceIndex != null && patchIndex == null || instanceIndex == null && patchIndex != null);
        if (instanceIndex != null) {
            patchlist = this._readEncapsStack.patchMap.get(instanceIndex);
            if (patchlist == null) {
                return;
            }
            v = this._readEncapsStack.unmarshaledMap.get(instanceIndex);
            patchIndex = instanceIndex;
        } else {
            v = this._readEncapsStack.unmarshaledMap.get(patchIndex);
            if (v == null) {
                return;
            }
            patchlist = this._readEncapsStack.patchMap.get(patchIndex);
        }
        assert (patchlist != null && patchlist.size() > 0);
        assert (v != null);
        for (Patcher p : patchlist) {
            try {
                p.patch(v);
            }
            catch (ClassCastException ex) {
                NoObjectFactoryException nof = new NoObjectFactoryException();
                nof.type = p.type();
                nof.initCause(ex);
                throw nof;
            }
        }
        this._readEncapsStack.patchMap.remove(patchIndex);
    }

    public int pos() {
        return this._buf.b.position();
    }

    public void pos(int n) {
        this._buf.b.position(n);
    }

    public int size() {
        return this._buf.size();
    }

    public boolean isEmpty() {
        return this._buf.empty();
    }

    public BasicStream compress(int headerSize, int compressionLevel) {
        assert (BasicStream.compressible());
        int uncompressedLen = this.size() - headerSize;
        int compressedLen = (int)((double)uncompressedLen * 1.01 + 600.0);
        byte[] compressed = new byte[compressedLen];
        byte[] data = null;
        int offset = 0;
        try {
            data = this._buf.b.array();
            offset = this._buf.b.arrayOffset();
        }
        catch (Exception ex) {
            data = new byte[this.size()];
            this._buf.b.get(data);
        }
        try {
            BufferedOutputStream bos = new BufferedOutputStream(compressed);
            bos.write(66);
            bos.write(90);
            java.lang.Object[] args = new java.lang.Object[]{bos, new Integer(compressionLevel)};
            OutputStream os = (OutputStream)_bzOutputStreamCtor.newInstance(args);
            os.write(data, offset + headerSize, uncompressedLen);
            os.close();
            compressedLen = bos.pos();
        }
        catch (Exception ex) {
            CompressionException e = new CompressionException();
            e.reason = "bzip2 compression failure";
            e.initCause(ex);
            throw e;
        }
        if (compressedLen >= uncompressedLen) {
            return null;
        }
        BasicStream cstream = new BasicStream(this._instance);
        cstream.resize(headerSize + 4 + compressedLen, false);
        cstream.pos(0);
        cstream._buf.b.put(data, offset, headerSize);
        cstream.writeInt(this.size());
        cstream._buf.b.put(compressed, 0, compressedLen);
        return cstream;
    }

    public BasicStream uncompress(int headerSize) {
        assert (BasicStream.compressible());
        this.pos(headerSize);
        int uncompressedSize = this.readInt();
        if (uncompressedSize <= headerSize) {
            throw new IllegalMessageSizeException();
        }
        int compressedLen = this.size() - headerSize - 4;
        byte[] compressed = null;
        int offset = 0;
        try {
            compressed = this._buf.b.array();
            offset = this._buf.b.arrayOffset();
        }
        catch (Exception ex) {
            compressed = new byte[this.size()];
            this._buf.b.get(compressed);
        }
        BasicStream ucStream = new BasicStream(this._instance);
        ucStream.resize(uncompressedSize, false);
        try {
            int n;
            ByteArrayInputStream bais = new ByteArrayInputStream(compressed, offset + headerSize + 4, compressedLen);
            byte magicB = (byte)bais.read();
            byte magicZ = (byte)bais.read();
            if (magicB != 66 || magicZ != 90) {
                CompressionException e = new CompressionException();
                e.reason = "bzip2 uncompression failure: invalid magic bytes";
                throw e;
            }
            java.lang.Object[] args = new java.lang.Object[]{bais};
            InputStream is = (InputStream)_bzInputStreamCtor.newInstance(args);
            ucStream.pos(headerSize);
            byte[] arr = new byte[8192];
            while ((n = is.read(arr)) != -1) {
                ucStream.writeBlob(arr, 0, n);
            }
            is.close();
        }
        catch (Exception ex) {
            CompressionException e = new CompressionException();
            e.reason = "bzip2 uncompression failure";
            e.initCause(ex);
            throw e;
        }
        ucStream.pos(0);
        ucStream._buf.b.put(compressed, offset, headerSize);
        return ucStream;
    }

    public void expand(int n) {
        if (!this._unlimited && this._buf.b != null && this._buf.b.position() + n > this._messageSizeMax) {
            throw new MemoryLimitException();
        }
        this._buf.expand(n);
    }

    private ObjectFactory loadObjectFactory(String id) {
        ObjectFactory factory = null;
        try {
            Class<?> c = this.findClass(id);
            if (c != null) {
                DynamicObjectFactory dynamicFactory = new DynamicObjectFactory(c);
                while (factory == null) {
                    try {
                        this._instance.servantFactoryManager().add(dynamicFactory, id);
                        factory = dynamicFactory;
                    }
                    catch (AlreadyRegisteredException ex) {
                        factory = this._instance.servantFactoryManager().find(id);
                    }
                }
            }
        }
        catch (LinkageError ex) {
            NoObjectFactoryException e = new NoObjectFactoryException();
            e.type = id;
            e.initCause(ex);
            throw e;
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserExceptionFactory getUserExceptionFactory(String id) {
        UserExceptionFactory factory = null;
        java.lang.Object object = _factoryMutex;
        synchronized (object) {
            factory = _exceptionFactories.get(id);
        }
        if (factory == null) {
            try {
                Class<?> c = this.findClass(id);
                if (c != null) {
                    factory = new DynamicUserExceptionFactory(c);
                }
            }
            catch (LinkageError ex) {
                MarshalException e = new MarshalException();
                e.initCause(ex);
                throw e;
            }
            if (factory != null) {
                object = _factoryMutex;
                synchronized (object) {
                    _exceptionFactories.put(id, factory);
                }
            }
        }
        return factory;
    }

    private Class<?> findClass(String id) throws LinkageError {
        String pkg;
        int pos;
        Class<?> c = null;
        String className = this.typeToClass(id);
        c = this.getConcreteClass(className);
        if (c == null && (pos = id.indexOf(58, 2)) != -1) {
            String topLevelModule = id.substring(2, pos);
            String pkg2 = this._instance.initializationData().properties.getProperty("Ice.Package." + topLevelModule);
            if (pkg2.length() > 0) {
                c = this.getConcreteClass(pkg2 + "." + className);
            }
        }
        if (c == null && (pkg = this._instance.initializationData().properties.getProperty("Ice.Default.Package")).length() > 0) {
            c = this.getConcreteClass(pkg + "." + className);
        }
        return c;
    }

    private Class<?> getConcreteClass(String className) throws LinkageError {
        try {
            Class<?> c = Class.forName(className);
            int modifiers = c.getModifiers();
            if ((modifiers & 0x200) == 0 && (modifiers & 0x400) == 0) {
                return c;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private static String fixKwd(String name) {
        java.lang.Object[] keywordList = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "checkedCast", "class", "clone", "const", "continue", "default", "do", "double", "else", "enum", "equals", "extends", "false", "final", "finalize", "finally", "float", "for", "getClass", "goto", "hashCode", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "notify", "notifyAll", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "toString", "transient", "true", "try", "uncheckedCast", "void", "volatile", "wait", "while"};
        boolean found = Arrays.binarySearch(keywordList, name) >= 0;
        return found ? "_" + name : name;
    }

    private String typeToClass(String id) {
        if (!id.startsWith("::")) {
            throw new MarshalException();
        }
        StringBuilder buf = new StringBuilder(id.length());
        int start = 2;
        boolean done = false;
        while (!done) {
            String s;
            int end = id.indexOf(58, start);
            if (end != -1) {
                s = id.substring(start, end);
                start = end + 2;
            } else {
                s = id.substring(start);
                done = true;
            }
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(BasicStream.fixKwd(s));
        }
        return buf.toString();
    }

    public static boolean compressible() {
        return _bzInputStreamCtor != null && _bzOutputStreamCtor != null;
    }

    static {
        try {
            Class[] types = new Class[1];
            Class<?> cls = Class.forName("org.apache.tools.bzip2.CBZip2InputStream");
            types[0] = InputStream.class;
            _bzInputStreamCtor = cls.getDeclaredConstructor(types);
            cls = Class.forName("org.apache.tools.bzip2.CBZip2OutputStream");
            types = new Class[]{OutputStream.class, Integer.TYPE};
            _bzOutputStreamCtor = cls.getDeclaredConstructor(types);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final class SeqData {
        public int numElements;
        public int minSize;
        public SeqData previous;

        public SeqData(int numElements, int minSize) {
            this.numElements = numElements;
            this.minSize = minSize;
        }
    }

    private static final class WriteEncaps {
        int start;
        int writeIndex;
        IdentityHashMap<Object, Integer> toBeMarshaledMap;
        IdentityHashMap<Object, Integer> marshaledMap;
        int typeIdIndex;
        TreeMap<String, Integer> typeIdMap;
        WriteEncaps next;

        private WriteEncaps() {
        }

        void reset() {
            if (this.toBeMarshaledMap != null) {
                this.writeIndex = 0;
                this.toBeMarshaledMap.clear();
                this.marshaledMap.clear();
                this.typeIdIndex = 0;
                this.typeIdMap.clear();
            }
        }
    }

    private static final class ReadEncaps {
        int start;
        int sz;
        byte encodingMajor;
        byte encodingMinor;
        TreeMap<Integer, LinkedList<Patcher>> patchMap;
        TreeMap<Integer, Object> unmarshaledMap;
        int typeIdIndex;
        TreeMap<Integer, String> typeIdMap;
        ReadEncaps next;

        private ReadEncaps() {
        }

        void reset() {
            if (this.patchMap != null) {
                this.patchMap.clear();
                this.unmarshaledMap.clear();
                this.typeIdIndex = 0;
                this.typeIdMap.clear();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DynamicUserExceptionFactory
    implements UserExceptionFactory {
        private Class<?> _class;

        DynamicUserExceptionFactory(Class<?> c) {
            this._class = c;
        }

        @Override
        public void createAndThrow() throws UserException {
            try {
                throw (UserException)this._class.newInstance();
            }
            catch (UserException ex) {
                throw ex;
            }
            catch (Exception ex) {
                SyscallException e = new SyscallException();
                e.initCause(ex);
                throw e;
            }
        }

        @Override
        public void destroy() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DynamicObjectFactory
    implements ObjectFactory {
        private Class<?> _class;

        DynamicObjectFactory(Class<?> c) {
            this._class = c;
        }

        @Override
        public Object create(String type) {
            try {
                return (Object)this._class.newInstance();
            }
            catch (Exception ex) {
                SyscallException e = new SyscallException();
                e.initCause(ex);
                throw e;
            }
        }

        @Override
        public void destroy() {
        }
    }

    private static class BufferedOutputStream
    extends OutputStream {
        private byte[] _data;
        private int _pos;

        BufferedOutputStream(byte[] data) {
            this._data = data;
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public void write(byte[] b) throws IOException {
            assert (this._data.length - this._pos >= b.length);
            System.arraycopy(b, 0, this._data, this._pos, b.length);
            this._pos += b.length;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            assert (this._data.length - this._pos >= len);
            System.arraycopy(b, off, this._data, this._pos, len);
            this._pos += len;
        }

        public void write(int b) throws IOException {
            assert (this._data.length - this._pos >= 1);
            this._data[this._pos] = (byte)b;
            ++this._pos;
        }

        int pos() {
            return this._pos;
        }
    }
}

