/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import Freeze.DatabaseException;
import Freeze.Evictor;
import Freeze.EvictorDeactivatedException;
import Freeze.EvictorIterator;
import Freeze.EvictorIteratorI;
import Freeze.Index;
import Freeze.ObjectRecord;
import Freeze.ObjectStore;
import Freeze.PingObject;
import Freeze.ServantInitializer;
import Freeze.SharedDbEnv;
import Freeze.Statistics;
import Freeze.TransactionI;
import Ice.Communicator;
import Ice.Current;
import Ice.FacetNotExistException;
import Ice.Identity;
import Ice.IllegalIdentityException;
import Ice.LocalObjectHolder;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import com.sleepycat.db.Cursor;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseType;
import com.sleepycat.db.Environment;
import com.sleepycat.db.OperationStatus;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

abstract class EvictorI
implements Evictor {
    static final String defaultDb = "$default";
    static final String indexPrefix = "$index:";
    protected int _evictorSize = 10;
    protected final Map _storeMap = new HashMap();
    private final Map _facetTypes;
    protected final ObjectAdapter _adapter;
    protected final Communicator _communicator;
    protected final ServantInitializer _initializer;
    protected SharedDbEnv _dbEnv;
    protected final String _filename;
    protected final boolean _createDb;
    protected int _trace = 0;
    protected int _txTrace = 0;
    protected String _errorPrefix;
    protected boolean _deadlockWarning;
    protected boolean _useNonmutating;
    protected DeactivateController _deactivateController = new DeactivateController();
    private Ice.Object _pingObject = new PingObject();

    public ObjectPrx add(Ice.Object servant, Identity ident) {
        return this.addFacet(servant, ident, "");
    }

    public Ice.Object remove(Identity ident) {
        return this.removeFacet(ident, "");
    }

    public boolean hasObject(Identity ident) {
        return this.hasFacet(ident, "");
    }

    public Ice.Object locate(Current current, LocalObjectHolder cookie) {
        if (current.operation != null && current.operation.equals("ice_ping")) {
            if (this.hasFacet(current.id, current.facet)) {
                if (this._trace >= 3) {
                    this._communicator.getLogger().trace("Freeze.Evictor", "ice_ping found \"" + this._communicator.identityToString(current.id) + "\" with facet \"" + current.facet + "\"");
                }
                cookie.value = null;
                return this._pingObject;
            }
            if (this.hasAnotherFacet(current.id, current.facet)) {
                if (this._trace >= 3) {
                    this._communicator.getLogger().trace("Freeze.Evictor", "ice_ping raises FacetNotExistException for \"" + this._communicator.identityToString(current.id) + "\" with facet \"" + current.facet + "\"");
                }
                throw new FacetNotExistException();
            }
            if (this._trace >= 3) {
                this._communicator.getLogger().trace("Freeze.Evictor", "ice_ping will raise ObjectNotExistException for \"" + this._communicator.identityToString(current.id) + "\" with facet \"" + current.facet + "\"");
            }
            return null;
        }
        Ice.Object result = this.locateImpl(current, cookie);
        if (result == null && this.hasAnotherFacet(current.id, current.facet)) {
            throw new FacetNotExistException(current.id, current.facet, current.operation);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setSize(int evictorSize) {
        this._deactivateController.lock();
        try {
            if (evictorSize < 0) {
                Object var3_2 = null;
                this._deactivateController.unlock();
                return;
            }
            this._evictorSize = evictorSize;
            this.evict();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this._deactivateController.unlock();
            throw throwable;
        }
        Object var3_3 = null;
        this._deactivateController.unlock();
    }

    public synchronized int getSize() {
        return this._evictorSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvictorIterator getIterator(String facet, int batchSize) {
        this._deactivateController.lock();
        try {
            if (facet == null) {
                facet = "";
            }
            TransactionI tx = this.beforeQuery();
            EvictorIteratorI evictorIteratorI = new EvictorIteratorI(this.findStore(facet, false), tx, batchSize);
            Object var6_5 = null;
            this._deactivateController.unlock();
            return evictorIteratorI;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this._deactivateController.unlock();
            throw throwable;
        }
    }

    protected abstract boolean hasAnotherFacet(Identity var1, String var2);

    protected abstract Object createEvictorElement(Identity var1, ObjectRecord var2, ObjectStore var3);

    protected abstract Ice.Object locateImpl(Current var1, LocalObjectHolder var2);

    protected abstract void evict();

    protected synchronized void finalize() {
        if (!this._deactivateController.deactivated()) {
            this._communicator.getLogger().warning("Freeze evictor " + this.toString() + " has not been deactivated");
            this.deactivate("");
        }
    }

    protected void closeDbEnv() {
        assert (this._dbEnv != null);
        for (ObjectStore store : this._storeMap.values()) {
            store.close();
        }
        this._dbEnv.close();
        this._dbEnv = null;
    }

    protected synchronized ObjectStore findStore(String facet, boolean createIt) {
        ObjectStore os = (ObjectStore)this._storeMap.get(facet);
        if (os == null && createIt) {
            String facetType = (String)this._facetTypes.get(facet);
            os = new ObjectStore(facet, facetType, true, this, new LinkedList(), false);
            this._storeMap.put(facet, os);
        }
        return os;
    }

    protected void initialize(Identity ident, String facet, Ice.Object servant) {
        if (this._initializer != null) {
            this._initializer.initialize(this._adapter, ident, facet, servant);
        }
    }

    protected EvictorI(ObjectAdapter adapter, String envName, Environment dbEnv, String filename, Map facetTypes, ServantInitializer initializer, Index[] indices, boolean createDb) {
        this._adapter = adapter;
        this._communicator = adapter.getCommunicator();
        this._initializer = initializer;
        this._filename = filename;
        this._createDb = createDb;
        this._facetTypes = facetTypes == null ? new HashMap() : new HashMap(facetTypes);
        this._dbEnv = SharedDbEnv.get(this._communicator, envName, dbEnv);
        this._trace = this._communicator.getProperties().getPropertyAsInt("Freeze.Trace.Evictor");
        this._txTrace = this._communicator.getProperties().getPropertyAsInt("Freeze.Trace.Transaction");
        this._deadlockWarning = this._communicator.getProperties().getPropertyAsInt("Freeze.Warn.Deadlocks") != 0;
        this._useNonmutating = this._communicator.getProperties().getPropertyAsInt("Freeze.Evictor.UseNonmutating") != 0;
        this._errorPrefix = "Freeze Evictor DbEnv(\"" + envName + "\") Db(\"" + this._filename + "\"): ";
        String propertyPrefix = "Freeze.Evictor." + envName + '.' + this._filename;
        boolean populateEmptyIndices = this._communicator.getProperties().getPropertyAsIntWithDefault(propertyPrefix + ".PopulateEmptyIndices", 0) != 0;
        List dbs = this.allDbs();
        dbs.add(defaultDb);
        if (indices != null) {
            for (int i = 0; i < indices.length; ++i) {
                String facet = indices[i].facet();
                if (this._storeMap.get(facet) != null) continue;
                LinkedList<Index> storeIndices = new LinkedList<Index>();
                for (int j = i; j < indices.length; ++j) {
                    if (!indices[j].facet().equals(facet)) continue;
                    storeIndices.add(indices[j]);
                }
                String facetType = (String)this._facetTypes.get(facet);
                ObjectStore store = new ObjectStore(facet, facetType, this._createDb, this, storeIndices, populateEmptyIndices);
                this._storeMap.put(facet, store);
            }
        }
        for (String facet : dbs) {
            if (facet.equals(defaultDb)) {
                facet = "";
            }
            if (this._storeMap.get(facet) != null) continue;
            String facetType = (String)this._facetTypes.get(facet);
            ObjectStore store = new ObjectStore(facet, facetType, this._createDb, this, new LinkedList(), populateEmptyIndices);
            this._storeMap.put(facet, store);
        }
        this._deactivateController.activate();
    }

    protected EvictorI(ObjectAdapter adapter, String envName, String filename, Map facetTypes, ServantInitializer initializer, Index[] indices, boolean createDb) {
        this(adapter, envName, null, filename, facetTypes, initializer, indices, createDb);
    }

    abstract TransactionI beforeQuery();

    static void updateStats(Statistics stats, long time) {
        long diff = time - (stats.creationTime + stats.lastSaveTime);
        if (stats.lastSaveTime == 0L) {
            stats.lastSaveTime = diff;
            stats.avgSaveTime = diff;
        } else {
            stats.lastSaveTime = time - stats.creationTime;
            stats.avgSaveTime = (long)((double)stats.avgSaveTime * 0.95 + (double)diff * 0.05);
        }
    }

    final DeactivateController deactivateController() {
        return this._deactivateController;
    }

    final Communicator communicator() {
        return this._communicator;
    }

    final SharedDbEnv dbEnv() {
        return this._dbEnv;
    }

    final String filename() {
        return this._filename;
    }

    final String errorPrefix() {
        return this._errorPrefix;
    }

    final boolean deadlockWarning() {
        return this._deadlockWarning;
    }

    final int trace() {
        return this._trace;
    }

    /*
     * Loose catch block
     */
    private List allDbs() {
        LinkedList<String> result;
        block22: {
            com.sleepycat.db.DatabaseException dx222;
            Cursor dbc;
            Database db;
            block20: {
                result = new LinkedList<String>();
                db = null;
                dbc = null;
                DatabaseConfig config = new DatabaseConfig();
                config.setType(DatabaseType.UNKNOWN);
                config.setReadOnly(true);
                db = this._dbEnv.getEnv().openDatabase(null, this._filename, null, config);
                dbc = db.openCursor(null, null);
                DatabaseEntry key = new DatabaseEntry();
                DatabaseEntry value = new DatabaseEntry();
                boolean more = true;
                while (more) {
                    String dbName;
                    more = dbc.getNext(key, value, null) == OperationStatus.SUCCESS;
                    if (!more || (dbName = new String(key.getData(), 0, key.getSize(), "UTF8")).startsWith(indexPrefix)) continue;
                    result.add(dbName);
                }
                dbc.close();
                dbc = null;
                db.close();
                db = null;
                Object var10_14 = null;
                if (dbc == null) break block20;
                try {
                    dbc.close();
                }
                catch (com.sleepycat.db.DatabaseException dx222) {
                    // empty catch block
                }
            }
            if (db != null) {
                try {
                    db.close();
                }
                catch (com.sleepycat.db.DatabaseException dx222) {}
            }
            break block22;
            {
                catch (UnsupportedEncodingException ix) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(ix);
                    ex.message = this._errorPrefix + "cannot decode database names";
                    throw ex;
                }
                catch (FileNotFoundException ix) {
                    com.sleepycat.db.DatabaseException dx222;
                    Object var10_15 = null;
                    if (dbc != null) {
                        try {
                            dbc.close();
                        }
                        catch (com.sleepycat.db.DatabaseException dx222) {
                            // empty catch block
                        }
                    }
                    if (db != null) {
                        try {
                            db.close();
                        }
                        catch (com.sleepycat.db.DatabaseException dx222) {}
                    }
                    break block22;
                }
                catch (com.sleepycat.db.DatabaseException dx3) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(dx3);
                    ex.message = this._errorPrefix + "Db.open: " + dx3.getMessage();
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                com.sleepycat.db.DatabaseException dx222;
                Object var10_16 = null;
                if (dbc != null) {
                    try {
                        dbc.close();
                    }
                    catch (com.sleepycat.db.DatabaseException dx222) {
                        // empty catch block
                    }
                }
                if (db != null) {
                    try {
                        db.close();
                    }
                    catch (com.sleepycat.db.DatabaseException dx222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return result;
    }

    static void checkIdentity(Identity ident) {
        if (ident.name == null || ident.name.length() == 0) {
            IllegalIdentityException e = new IllegalIdentityException();
            e.id = ident;
            throw e;
        }
    }

    class DeactivateController {
        private boolean _activated = false;
        private boolean _deactivating = false;
        private boolean _deactivated = false;
        private int _guardCount = 0;

        DeactivateController() {
        }

        synchronized void activate() {
            assert (!this._activated);
            this._activated = true;
        }

        synchronized void lock() {
            assert (this._activated);
            if (this._deactivated || this._deactivating) {
                throw new EvictorDeactivatedException();
            }
            ++this._guardCount;
        }

        synchronized void unlock() {
            assert (this._activated);
            --this._guardCount;
            if (this._deactivating && this._guardCount == 0) {
                this.notifyAll();
            }
        }

        synchronized boolean deactivated() {
            return !this._activated || this._deactivated;
        }

        synchronized boolean deactivate() {
            assert (this._activated);
            if (this._deactivated) {
                return false;
            }
            if (this._deactivating) {
                while (!this._deactivated) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {}
                }
                return false;
            }
            this._deactivating = true;
            while (this._guardCount > 0) {
                if (EvictorI.this._trace >= 1) {
                    EvictorI.this._communicator.getLogger().trace("Freeze.Evictor", "Waiting for " + this._guardCount + " threads to complete before starting deactivation.");
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (EvictorI.this._trace >= 1) {
                EvictorI.this._communicator.getLogger().trace("Freeze.Evictor", "Starting deactivation.");
            }
            return true;
        }

        synchronized void deactivationComplete() {
            if (EvictorI.this._trace >= 1) {
                EvictorI.this._communicator.getLogger().trace("Freeze.Evictor", "Deactivation complete.");
            }
            this._deactivated = true;
            this._deactivating = false;
            this.notifyAll();
        }
    }
}

