/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import Freeze.BackgroundSaveEvictor;
import Freeze.DatabaseException;
import Freeze.EvictorI;
import Freeze.Index;
import Freeze.LinkedList;
import Freeze.NotFoundException;
import Freeze.ObjectRecord;
import Freeze.ObjectStore;
import Freeze.ServantInitializer;
import Freeze.Statistics;
import Freeze.TransactionI;
import Freeze.Util;
import Ice.AlreadyRegisteredException;
import Ice.Current;
import Ice.Identity;
import Ice.LocalObjectHolder;
import Ice.NotRegisteredException;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import Ice.OperationMode;
import IceInternal.Time;
import IceUtilInternal.StringUtil;
import com.sleepycat.db.DeadlockException;
import com.sleepycat.db.Environment;
import com.sleepycat.db.Transaction;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class BackgroundSaveEvictorI
extends EvictorI
implements BackgroundSaveEvictor,
Runnable {
    static final byte clean = 0;
    static final byte created = 1;
    static final byte modified = 2;
    static final byte destroyed = 3;
    static final byte dead = 4;
    private final LinkedList _evictorList = new LinkedList();
    private int _currentEvictorSize = 0;
    private List _modifiedQueue = new ArrayList();
    private boolean _savingThreadDone = false;
    private WatchDogThread _watchDogThread = null;
    private final List _saveNowThreads = new ArrayList();
    private int _saveSizeTrigger;
    private int _maxTxSize;
    private long _savePeriod;
    private Thread _thread;

    BackgroundSaveEvictorI(ObjectAdapter adapter, String envName, String filename, ServantInitializer initializer, Index[] indices, boolean createDb) {
        this(adapter, envName, null, filename, initializer, indices, createDb);
    }

    BackgroundSaveEvictorI(ObjectAdapter adapter, String envName, Environment dbEnv, String filename, ServantInitializer initializer, Index[] indices, boolean createDb) {
        super(adapter, envName, dbEnv, filename, null, initializer, indices, createDb);
        String programName;
        String propertyPrefix = "Freeze.Evictor." + envName + '.' + filename;
        this._saveSizeTrigger = this._communicator.getProperties().getPropertyAsIntWithDefault(propertyPrefix + ".SaveSizeTrigger", 10);
        this._savePeriod = this._communicator.getProperties().getPropertyAsIntWithDefault(propertyPrefix + ".SavePeriod", 60000);
        this._maxTxSize = this._communicator.getProperties().getPropertyAsIntWithDefault(propertyPrefix + ".MaxTxSize", 10 * this._saveSizeTrigger);
        if (this._maxTxSize <= 0) {
            this._maxTxSize = 100;
        }
        String savingThreadName = (programName = this._communicator.getProperties().getProperty("Ice.ProgramName")).length() > 0 ? programName + "-" : "";
        String watchDogThreadName = savingThreadName + "FreezeEvictorWatchDogThread(" + envName + '.' + this._filename + ")";
        savingThreadName = savingThreadName + "FreezeEvictorThread(" + envName + '.' + this._filename + ")";
        long streamTimeout = this._communicator.getProperties().getPropertyAsIntWithDefault(propertyPrefix + ".StreamTimeout", 0) * 1000;
        if (streamTimeout > 0L) {
            this._watchDogThread = new WatchDogThread(streamTimeout, watchDogThreadName);
            this._watchDogThread.start();
        }
        this._thread = new Thread((Runnable)this, savingThreadName);
        this._thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ObjectPrx addFacet(Ice.Object servant, Identity ident, String facet) {
        BackgroundSaveEvictorI.checkIdentity(ident);
        if (facet == null) {
            facet = "";
        }
        this._deactivateController.lock();
        try {
            EvictorElement element;
            ObjectStore store = this.findStore(facet, this._createDb);
            if (store == null) {
                NotFoundException ex = new NotFoundException();
                ex.message = this._errorPrefix + "addFacet: could not open database for facet '" + facet + "'";
                throw ex;
            }
            boolean alreadyThere = false;
            while (true) {
                element = new EvictorElement(ident, store);
                element.status = (byte)4;
                element.rec = new ObjectRecord();
                element.rec.stats = new Statistics();
                Object o = store.cache().putIfAbsent(ident, element);
                if (o != null) {
                    element = (EvictorElement)o;
                }
                BackgroundSaveEvictorI backgroundSaveEvictorI = this;
                // MONITORENTER : backgroundSaveEvictorI
                if (!element.stale) break;
                // MONITOREXIT : backgroundSaveEvictorI
            }
            this.fixEvictPosition(element);
            EvictorElement evictorElement = element;
            // MONITORENTER : evictorElement
            switch (element.status) {
                case 0: 
                case 1: 
                case 2: {
                    alreadyThere = true;
                    break;
                }
                case 3: {
                    element.status = (byte)2;
                    element.rec.servant = servant;
                    break;
                }
                case 4: {
                    element.status = 1;
                    ObjectRecord rec = element.rec;
                    rec.servant = servant;
                    rec.stats.creationTime = Time.currentMonotonicTimeMillis();
                    rec.stats.lastSaveTime = 0L;
                    rec.stats.avgSaveTime = 0L;
                    this.addToModifiedQueue(element);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            // MONITOREXIT : evictorElement
            // MONITOREXIT : backgroundSaveEvictorI
            if (alreadyThere) {
                AlreadyRegisteredException ex = new AlreadyRegisteredException();
                ex.kindOfObject = "servant";
                ex.id = this._communicator.identityToString(ident);
                if (facet.length() <= 0) throw ex;
                ex.id = ex.id + " -f " + StringUtil.escapeString(facet, "");
                throw ex;
            }
            if (this._trace >= 1) {
                String objString = "object \"" + this._communicator.identityToString(ident) + "\"";
                if (!facet.equals("")) {
                    objString = objString + " with facet \"" + facet + "\"";
                }
                this._communicator.getLogger().trace("Freeze.Evictor", "added " + objString + " to Db \"" + this._filename + "\"");
            }
            ObjectPrx obj = this._adapter.createProxy(ident);
            if (facet.length() > 0) {
                obj = obj.ice_facet(facet);
            }
            ObjectPrx objectPrx = obj;
            Object var14_12 = null;
            this._deactivateController.unlock();
            return objectPrx;
        }
        catch (Throwable throwable) {
            Object var14_13 = null;
            this._deactivateController.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ice.Object removeFacet(Identity ident, String facet) {
        BackgroundSaveEvictorI.checkIdentity(ident);
        if (facet == null) {
            facet = "";
        }
        this._deactivateController.lock();
        try {
            ObjectStore store = this.findStore(facet, false);
            Ice.Object servant = null;
            if (store != null) {
                EvictorElement element;
                while ((element = (EvictorElement)store.cache().pin(ident)) != null) {
                    BackgroundSaveEvictorI backgroundSaveEvictorI = this;
                    synchronized (backgroundSaveEvictorI) {
                        if (element.stale) {
                            continue;
                        }
                        this.fixEvictPosition(element);
                        EvictorElement evictorElement = element;
                        synchronized (evictorElement) {
                            switch (element.status) {
                                case 0: {
                                    servant = element.rec.servant;
                                    element.status = (byte)3;
                                    element.rec.servant = null;
                                    this.addToModifiedQueue(element);
                                    break;
                                }
                                case 1: {
                                    servant = element.rec.servant;
                                    element.status = (byte)4;
                                    element.rec.servant = null;
                                    break;
                                }
                                case 2: {
                                    servant = element.rec.servant;
                                    element.status = (byte)3;
                                    element.rec.servant = null;
                                    break;
                                }
                                case 3: 
                                case 4: {
                                    break;
                                }
                                default: {
                                    assert (false);
                                    break;
                                }
                            }
                        }
                        if (element.keepCount > 0) {
                            assert (servant != null);
                            element.keepCount = 0;
                            this._evictorList.addFirst(element);
                            element.evictPosition = this._evictorList.iterator();
                            element.evictPosition.next();
                            ++this._currentEvictorSize;
                        }
                        break;
                    }
                }
            }
            if (servant == null) {
                NotRegisteredException ex = new NotRegisteredException();
                ex.kindOfObject = "servant";
                ex.id = this._communicator.identityToString(ident);
                if (facet.length() > 0) {
                    ex.id = ex.id + " -f " + StringUtil.escapeString(facet, "");
                }
                throw ex;
            }
            if (this._trace >= 1) {
                String objString = "object \"" + this._communicator.identityToString(ident) + "\"";
                if (!facet.equals("")) {
                    objString = objString + " with facet \"" + facet + "\"";
                }
                this._communicator.getLogger().trace("Freeze.Evictor", "removed " + objString + " from Db \"" + this._filename + "\"");
            }
            Ice.Object object = servant;
            Object var11_10 = null;
            this._deactivateController.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this._deactivateController.unlock();
            throw throwable;
        }
    }

    public void keep(Identity ident) {
        this.keepFacet(ident, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void keepFacet(Identity ident, String facet) {
        BackgroundSaveEvictorI.checkIdentity(ident);
        if (facet == null) {
            facet = "";
        }
        this._deactivateController.lock();
        try {
            boolean notThere;
            block19: {
                notThere = false;
                ObjectStore store = this.findStore(facet, false);
                if (store == null) {
                    notThere = true;
                } else {
                    EvictorElement element;
                    while (true) {
                        if ((element = (EvictorElement)store.cache().pin(ident)) == null) {
                            notThere = true;
                            break block19;
                        }
                        BackgroundSaveEvictorI backgroundSaveEvictorI = this;
                        synchronized (backgroundSaveEvictorI) {
                            if (!element.stale) break;
                        }
                    }
                    {
                        EvictorElement evictorElement = element;
                        synchronized (evictorElement) {
                            if (element.status == 3 || element.status == 4) {
                                notThere = true;
                            } else if (element.keepCount == 0) {
                                if (element.usageCount < 0) {
                                    element.usageCount = 0;
                                } else {
                                    assert (element.evictPosition != null);
                                    element.evictPosition.remove();
                                    element.evictPosition = null;
                                    --this._currentEvictorSize;
                                }
                                element.keepCount = 1;
                            } else {
                                ++element.keepCount;
                            }
                        }
                    }
                }
            }
            if (notThere) {
                NotRegisteredException ex = new NotRegisteredException();
                ex.kindOfObject = "servant";
                ex.id = this._communicator.identityToString(ident);
                if (facet.length() <= 0) throw ex;
                ex.id = ex.id + " -f " + StringUtil.escapeString(facet, "");
                throw ex;
            }
            Object var11_8 = null;
            this._deactivateController.unlock();
            return;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            this._deactivateController.unlock();
            throw throwable;
        }
    }

    public void release(Identity ident) {
        this.releaseFacet(ident, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void releaseFacet(Identity ident, String facet) {
        BackgroundSaveEvictorI.checkIdentity(ident);
        if (facet == null) {
            facet = "";
        }
        this._deactivateController.lock();
        try {
            ObjectStore store = this.findStore(facet, false);
            if (store != null) {
                BackgroundSaveEvictorI backgroundSaveEvictorI = this;
                synchronized (backgroundSaveEvictorI) {
                    EvictorElement element = (EvictorElement)store.cache().getIfPinned(ident);
                    if (element != null) {
                        assert (!element.stale);
                        if (element.keepCount > 0) {
                            if (--element.keepCount == 0) {
                                assert (element.evictPosition == null);
                                this._evictorList.addFirst(element);
                                element.evictPosition = this._evictorList.iterator();
                                element.evictPosition.next();
                                ++this._currentEvictorSize;
                            }
                            // MONITOREXIT @DISABLED, blocks:[0, 3, 7, 9, 10] lbl23 : MonitorExitStatement: MONITOREXIT : var4_4
                            Object var8_6 = null;
                            this._deactivateController.unlock();
                            return;
                        }
                    }
                }
            }
            NotRegisteredException ex = new NotRegisteredException();
            ex.kindOfObject = "servant";
            ex.id = this._communicator.identityToString(ident);
            if (facet.length() <= 0) throw ex;
            ex.id = ex.id + " -f " + StringUtil.escapeString(facet, "");
            throw ex;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this._deactivateController.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasFacet(Identity ident, String facet) {
        boolean bl;
        block12: {
            boolean bl2;
            block11: {
                BackgroundSaveEvictorI.checkIdentity(ident);
                if (facet == null) {
                    facet = "";
                }
                this._deactivateController.lock();
                try {
                    ObjectStore store = this.findStore(facet, false);
                    if (store == null) {
                        boolean bl3 = false;
                        Object var11_7 = null;
                        this._deactivateController.unlock();
                        return bl3;
                    }
                    BackgroundSaveEvictorI backgroundSaveEvictorI = this;
                    synchronized (backgroundSaveEvictorI) {
                        EvictorElement element = (EvictorElement)store.cache().getIfPinned(ident);
                        if (element != null) {
                            assert (!element.stale);
                            EvictorElement evictorElement = element;
                            synchronized (evictorElement) {
                                bl2 = element.status != 4 && element.status != 3;
                            }
                            // MONITOREXIT @DISABLED, blocks:[0, 4, 10] lbl23 : MonitorExitStatement: MONITOREXIT : var4_5
                            break block11;
                        }
                    }
                    bl = store.dbHasObject(ident, null);
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var11_10 = null;
                    this._deactivateController.unlock();
                    throw throwable;
                }
            }
            Object var11_8 = null;
            this._deactivateController.unlock();
            return bl2;
        }
        Object var11_9 = null;
        this._deactivateController.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasAnotherFacet(Identity ident, String facet) {
        boolean bl;
        block15: {
            boolean bl2;
            block14: {
                this._deactivateController.lock();
                try {
                    HashMap storeMapCopy;
                    BackgroundSaveEvictorI backgroundSaveEvictorI = this;
                    synchronized (backgroundSaveEvictorI) {
                        storeMapCopy = new HashMap(this._storeMap);
                    }
                    for (Map.Entry entry : storeMapCopy.entrySet()) {
                        if (facet.equals(entry.getKey())) continue;
                        ObjectStore store = (ObjectStore)entry.getValue();
                        boolean inCache = false;
                        BackgroundSaveEvictorI backgroundSaveEvictorI2 = this;
                        synchronized (backgroundSaveEvictorI2) {
                            EvictorElement element = (EvictorElement)store.cache().getIfPinned(ident);
                            if (element != null) {
                                inCache = true;
                                assert (!element.stale);
                                EvictorElement evictorElement = element;
                                synchronized (evictorElement) {
                                    if (element.status != 4 && element.status != 3) {
                                        boolean bl3 = true;
                                        // MONITOREXIT @DISABLED, blocks:[0, 7, 8, 10, 11, 13] lbl24 : MonitorExitStatement: MONITOREXIT : var10_12
                                        // MONITOREXIT @DISABLED, blocks:[0, 7, 10, 11, 13] lbl25 : MonitorExitStatement: MONITOREXIT : var8_9
                                        Object var15_14 = null;
                                        this._deactivateController.unlock();
                                        return bl3;
                                    }
                                }
                            }
                            if (inCache || !store.dbHasObject(ident, null)) continue;
                        }
                        bl2 = true;
                        break block14;
                    }
                    bl = false;
                    break block15;
                }
                catch (Throwable throwable) {
                    Object var15_17 = null;
                    this._deactivateController.unlock();
                    throw throwable;
                }
            }
            Object var15_15 = null;
            this._deactivateController.unlock();
            return bl2;
        }
        Object var15_16 = null;
        this._deactivateController.unlock();
        return bl;
    }

    protected Object createEvictorElement(Identity ident, ObjectRecord rec, ObjectStore store) {
        EvictorElement elt = new EvictorElement(ident, store);
        elt.rec = rec;
        return elt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Ice.Object locateImpl(Current current, LocalObjectHolder cookie) {
        Ice.Object object;
        block19: {
            Ice.Object object2;
            block18: {
                BackgroundSaveEvictorI backgroundSaveEvictorI;
                block17: {
                    this._deactivateController.lock();
                    try {
                        EvictorElement element;
                        cookie.value = null;
                        ObjectStore store = this.findStore(current.facet, false);
                        if (store == null) {
                            if (this._trace >= 2) {
                                this._communicator.getLogger().trace("Freeze.Evictor", "locate could not find a database for facet \"" + current.facet + "\"");
                            }
                            Ice.Object object3 = null;
                            Object var11_6 = null;
                            this._deactivateController.unlock();
                            return object3;
                        }
                        while (true) {
                            if ((element = (EvictorElement)store.cache().pin(current.id)) == null) {
                                if (this._trace >= 2) {
                                    this._communicator.getLogger().trace("Freeze.Evictor", "locate could not find \"" + this._communicator.identityToString(current.id) + "\" in Db \"" + this._filename + "\"");
                                }
                                backgroundSaveEvictorI = null;
                                break block17;
                            }
                            backgroundSaveEvictorI = this;
                            synchronized (backgroundSaveEvictorI) {
                                if (!element.stale) break;
                            }
                        }
                        {
                            EvictorElement evictorElement = element;
                            synchronized (evictorElement) {
                                if (element.status == 3 || element.status == 4) {
                                    if (this._trace >= 2) {
                                        this._communicator.getLogger().trace("Freeze.Evictor", "locate found \"" + this._communicator.identityToString(current.id) + "\" in the cache for Db \"" + this._filename + "\" but it was dead or destroyed");
                                    }
                                    object2 = null;
                                    // MONITOREXIT @DISABLED, blocks:[0, 5, 6, 15] lbl31 : MonitorExitStatement: MONITOREXIT : var6_12
                                    // MONITOREXIT @DISABLED, blocks:[0, 5, 15] lbl32 : MonitorExitStatement: MONITOREXIT : var5_11
                                    break block18;
                                }
                                if (this._trace >= 2) {
                                    this._communicator.getLogger().trace("Freeze.Evictor", "locate found \"" + this._communicator.identityToString(current.id) + "\" in Db \"" + this._filename + "\"");
                                }
                                this.fixEvictPosition(element);
                                ++element.usageCount;
                                cookie.value = element;
                                assert (element.rec.servant != null);
                                object = element.rec.servant;
                            }
                        }
                        break block19;
                    }
                    catch (Throwable throwable) {
                        Object var11_10 = null;
                        this._deactivateController.unlock();
                        throw throwable;
                    }
                }
                Object var11_7 = null;
                this._deactivateController.unlock();
                return backgroundSaveEvictorI;
            }
            Object var11_8 = null;
            this._deactivateController.unlock();
            return object2;
        }
        Object var11_9 = null;
        this._deactivateController.unlock();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(Current current, Ice.Object servant, Object cookie) {
        this._deactivateController.lock();
        try {
            if (cookie != null) {
                Object object;
                EvictorElement element = (EvictorElement)cookie;
                boolean enqueue = false;
                if (this._useNonmutating && current.mode != OperationMode.Nonmutating || !this._useNonmutating && (servant.ice_operationAttributes(current.operation) & 1) != 0) {
                    object = element;
                    synchronized (object) {
                        if (element.status == 0) {
                            element.status = (byte)2;
                            enqueue = true;
                        }
                    }
                }
                object = this;
                synchronized (object) {
                    assert (!element.stale);
                    assert (element.usageCount >= 1);
                    --element.usageCount;
                    if (enqueue) {
                        this.addToModifiedQueue(element);
                    } else if (element.usageCount == 0 && element.keepCount == 0) {
                        this.evict();
                    }
                }
            }
            Object var10_9 = null;
            this._deactivateController.unlock();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this._deactivateController.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(String category) {
        if (this._deactivateController.deactivate()) {
            try {
                this.saveNow();
                BackgroundSaveEvictorI backgroundSaveEvictorI = this;
                synchronized (backgroundSaveEvictorI) {
                    this._evictorSize = 0;
                    this.evict();
                    this._savingThreadDone = true;
                    this.notifyAll();
                }
                try {
                    this._thread.join();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                if (this._watchDogThread != null) {
                    this._watchDogThread.terminate();
                    try {
                        this._watchDogThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.closeDbEnv();
                Object var5_6 = null;
                this._deactivateController.deactivationComplete();
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this._deactivateController.deactivationComplete();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                boolean tryAgain;
                int txSize;
                List allObjects;
                java.util.LinkedList<EvictorElement> deadObjects = new java.util.LinkedList<EvictorElement>();
                int saveNowThreadsSize = 0;
                BackgroundSaveEvictorI backgroundSaveEvictorI = this;
                synchronized (backgroundSaveEvictorI) {
                    while (!(this._savingThreadDone || this._saveNowThreads.size() != 0 || this._saveSizeTrigger >= 0 && this._modifiedQueue.size() >= this._saveSizeTrigger)) {
                        try {
                            if (this._savePeriod == 0L) {
                                this.wait();
                                continue;
                            }
                            long preSave = Time.currentMonotonicTimeMillis();
                            this.wait(this._savePeriod);
                            if (Time.currentMonotonicTimeMillis() <= preSave + this._savePeriod) continue;
                            break;
                        }
                        catch (InterruptedException ex) {
                        }
                    }
                    saveNowThreadsSize = this._saveNowThreads.size();
                    if (this._savingThreadDone) {
                        assert (this._modifiedQueue.size() == 0);
                        if ($assertionsDisabled) return;
                        if (saveNowThreadsSize == 0) return;
                        throw new AssertionError();
                    }
                    if (this._modifiedQueue.size() == 0) {
                        if (saveNowThreadsSize > 0) {
                            this._saveNowThreads.clear();
                            this.notifyAll();
                        }
                        continue;
                    }
                    allObjects = this._modifiedQueue;
                    this._modifiedQueue = new ArrayList();
                }
                int size = allObjects.size();
                ArrayList<StreamedObject> streamedObjectQueue = new ArrayList<StreamedObject>();
                long streamStart = Time.currentMonotonicTimeMillis();
                for (int i = 0; i < size; ++i) {
                    boolean tryAgain2;
                    EvictorElement element = (EvictorElement)allObjects.get(i);
                    do {
                        tryAgain2 = false;
                        Ice.Object servant = null;
                        Object object = element;
                        synchronized (object) {
                            byte status = element.status;
                            switch (status) {
                                case 1: 
                                case 2: {
                                    servant = element.rec.servant;
                                    break;
                                }
                                case 3: {
                                    streamedObjectQueue.add(this.stream(element, streamStart));
                                    element.status = (byte)4;
                                    deadObjects.add(element);
                                    break;
                                }
                                case 4: {
                                    deadObjects.add(element);
                                    break;
                                }
                            }
                            if (servant == null) continue;
                        }
                        if (this._watchDogThread != null) {
                            this._watchDogThread.activate();
                        }
                        object = servant;
                        synchronized (object) {
                            if (this._watchDogThread != null) {
                                this._watchDogThread.deactivate();
                            }
                            EvictorElement status = element;
                            synchronized (status) {
                                byte status2 = element.status;
                                switch (status2) {
                                    case 1: 
                                    case 2: {
                                        if (servant == element.rec.servant) {
                                            streamedObjectQueue.add(this.stream(element, streamStart));
                                            element.status = 0;
                                            break;
                                        }
                                        tryAgain2 = true;
                                        break;
                                    }
                                    case 3: {
                                        streamedObjectQueue.add(this.stream(element, streamStart));
                                        element.status = (byte)4;
                                        deadObjects.add(element);
                                        break;
                                    }
                                    case 4: {
                                        deadObjects.add(element);
                                        break;
                                    }
                                }
                            }
                        }
                    } while (tryAgain2);
                }
                if (this._trace >= 1) {
                    long now = Time.currentMonotonicTimeMillis();
                    this._communicator.getLogger().trace("Freeze.Evictor", "streamed " + streamedObjectQueue.size() + " objects in " + (now - streamStart) + " ms");
                }
                if ((txSize = streamedObjectQueue.size()) > this._maxTxSize) {
                    txSize = this._maxTxSize;
                }
                do {
                    tryAgain = false;
                    while (streamedObjectQueue.size() > 0) {
                        if (txSize > streamedObjectQueue.size()) {
                            txSize = streamedObjectQueue.size();
                        }
                        long saveStart = Time.currentMonotonicTimeMillis();
                        String txnId = null;
                        try {
                            block60: {
                                Object var18_37;
                                Transaction tx = this._dbEnv.getEnv().beginTransaction(null, null);
                                if (this._txTrace >= 1) {
                                    txnId = Long.toHexString((long)(tx.getId() & Integer.MAX_VALUE) + 0x80000000L);
                                    this._communicator.getLogger().trace("Freeze.Evictor", this._errorPrefix + "started transaction " + txnId + " in saving thread");
                                }
                                try {
                                    for (int i = 0; i < txSize; ++i) {
                                        StreamedObject obj = (StreamedObject)streamedObjectQueue.get(i);
                                        obj.store.save(obj.key, obj.value, obj.status, tx);
                                    }
                                    Transaction toCommit = tx;
                                    tx = null;
                                    toCommit.commit();
                                    if (this._txTrace >= 1) {
                                        this._communicator.getLogger().trace("Freeze.Evictor", this._errorPrefix + "committed transaction " + txnId);
                                    }
                                    var18_37 = null;
                                    if (tx == null) break block60;
                                }
                                catch (Throwable throwable) {
                                    var18_37 = null;
                                    if (tx == null) throw throwable;
                                    tx.abort();
                                    if (this._txTrace < 1) throw throwable;
                                    this._communicator.getLogger().trace("Freeze.Evictor", this._errorPrefix + "rolled back transaction " + txnId);
                                    throw throwable;
                                }
                                tx.abort();
                                if (this._txTrace >= 1) {
                                    this._communicator.getLogger().trace("Freeze.Evictor", this._errorPrefix + "rolled back transaction " + txnId);
                                }
                            }
                            for (int i = 0; i < txSize; ++i) {
                                streamedObjectQueue.remove(0);
                            }
                            if (this._trace < 1) continue;
                            long now = Time.currentMonotonicTimeMillis();
                            this._communicator.getLogger().trace("Freeze.Evictor", "saved " + txSize + " objects in " + (now - saveStart) + " ms");
                        }
                        catch (DeadlockException dx) {
                            if (this._deadlockWarning) {
                                this._communicator.getLogger().warning("Deadlock in Freeze.BackgroundSaveEvictorI.run while writing into Db \"" + this._filename + "\"; retrying...");
                            }
                            tryAgain = true;
                            txSize = (txSize + 1) / 2;
                        }
                        catch (com.sleepycat.db.DatabaseException dx) {
                            DatabaseException ex = new DatabaseException();
                            ex.initCause(dx);
                            ex.message = this._errorPrefix + "saving: " + dx.getMessage();
                            throw ex;
                        }
                    }
                } while (tryAgain);
                BackgroundSaveEvictorI backgroundSaveEvictorI2 = this;
                synchronized (backgroundSaveEvictorI2) {
                    EvictorElement element2;
                    for (int i = 0; i < allObjects.size(); --element2.usageCount, ++i) {
                        element2 = (EvictorElement)allObjects.get(i);
                        assert (element2.usageCount > 0);
                    }
                    allObjects.clear();
                    for (EvictorElement element2 : deadObjects) {
                        if (element2.stale || element2.usageCount != 0 || element2.keepCount != 0) continue;
                        EvictorElement evictorElement = element2;
                        synchronized (evictorElement) {
                            if (element2.status == 4) {
                                this.evict(element2);
                            }
                        }
                    }
                    deadObjects.clear();
                    this.evict();
                    if (saveNowThreadsSize > 0) {
                        for (int i = 0; i < saveNowThreadsSize; ++i) {
                            this._saveNowThreads.remove(0);
                        }
                        this.notifyAll();
                    }
                }
            }
        }
        catch (RuntimeException ex) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            pw.flush();
            this._communicator.getLogger().error(this._errorPrefix + "Fatal error in saving thread:\n" + sw.toString());
            Util.handleFatalError(this, this._communicator, ex);
        }
    }

    protected void evict() {
        assert (Thread.holdsLock(this));
        Iterator p = this._evictorList.riterator();
        while (p.hasNext() && this._currentEvictorSize > this._evictorSize) {
            EvictorElement element = (EvictorElement)p.next();
            if (element.usageCount != 0) continue;
            assert (!element.stale);
            assert (element.keepCount == 0);
            assert (element.evictPosition != null);
            if (this._trace >= 2 || this._trace >= 1 && this._evictorList.size() % 50 == 0) {
                String objString = "object \"" + this._communicator.identityToString(element.identity) + "\"";
                String facet = element.store.facet();
                if (facet.length() > 0) {
                    objString = objString + " with facet \"" + facet + "\"";
                }
                this._communicator.getLogger().trace("Freeze.Evictor", "evicting " + objString + " from the queue; " + "number of elements in the queue: " + this._currentEvictorSize);
            }
            element.stale = true;
            element.store.cache().unpin(element.identity);
            p.remove();
            element.evictPosition = null;
            --this._currentEvictorSize;
        }
    }

    protected TransactionI beforeQuery() {
        this.saveNow();
        return null;
    }

    private synchronized void saveNow() {
        Thread myself = Thread.currentThread();
        this._saveNowThreads.add(myself);
        this.notifyAll();
        do {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this._saveNowThreads.contains(myself));
    }

    private void fixEvictPosition(EvictorElement element) {
        assert (Thread.holdsLock(this));
        assert (!element.stale);
        if (element.keepCount == 0) {
            if (element.usageCount < 0) {
                assert (element.evictPosition == null);
                element.usageCount = 0;
                ++this._currentEvictorSize;
            } else {
                assert (element.evictPosition != null);
                element.evictPosition.remove();
            }
            this._evictorList.addFirst(element);
            element.evictPosition = this._evictorList.iterator();
            element.evictPosition.next();
        }
    }

    private void evict(EvictorElement element) {
        assert (Thread.holdsLock(this));
        assert (!element.stale);
        assert (element.keepCount == 0);
        element.evictPosition.remove();
        --this._currentEvictorSize;
        element.stale = true;
        element.store.cache().unpin(element.identity);
    }

    private void addToModifiedQueue(EvictorElement element) {
        assert (Thread.holdsLock(this));
        ++element.usageCount;
        this._modifiedQueue.add(element);
        if (this._saveSizeTrigger >= 0 && this._modifiedQueue.size() >= this._saveSizeTrigger) {
            this.notifyAll();
        }
    }

    private StreamedObject stream(EvictorElement element, long streamStart) {
        assert (Thread.holdsLock(element));
        assert (element.status != 4);
        StreamedObject obj = new StreamedObject();
        obj.status = element.status;
        obj.store = element.store;
        obj.key = ObjectStore.marshalKey(element.identity, this._communicator);
        if (element.status != 3) {
            BackgroundSaveEvictorI.updateStats(element.rec.stats, streamStart);
            obj.value = ObjectStore.marshalValue(element.rec, this._communicator);
        }
        return obj;
    }

    private static class StreamedObject {
        byte[] key = null;
        byte[] value = null;
        byte status = (byte)4;
        ObjectStore store = null;

        private StreamedObject() {
        }
    }

    private static class EvictorElement {
        final ObjectStore store;
        final Identity identity;
        Iterator evictPosition = null;
        int usageCount = -1;
        int keepCount = 0;
        boolean stale = false;
        ObjectRecord rec = null;
        byte status = 0;

        EvictorElement(Identity identity, ObjectStore store) {
            this.identity = identity;
            this.store = store;
        }
    }

    class WatchDogThread
    extends Thread {
        private final long _timeout;
        private boolean _done;
        private boolean _active;

        WatchDogThread(long timeout, String name) {
            super(name);
            this._done = false;
            this._active = false;
            this._timeout = timeout;
            assert (timeout > 0L);
        }

        public synchronized void run() {
            while (!this._done) {
                long startTime = 0L;
                try {
                    if (this._active) {
                        startTime = Time.currentMonotonicTimeMillis();
                        this.wait(this._timeout);
                    } else {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this._done || !this._active || startTime <= 0L || Time.currentMonotonicTimeMillis() - startTime < this._timeout) continue;
                BackgroundSaveEvictorI.this._communicator.getLogger().error(BackgroundSaveEvictorI.this._errorPrefix + "Fatal error: streaming watch dog thread timed out.");
                Util.handleFatalError(BackgroundSaveEvictorI.this, BackgroundSaveEvictorI.this._communicator, null);
            }
        }

        synchronized void activate() {
            this._active = true;
            this.notify();
        }

        synchronized void deactivate() {
            this._active = false;
            this.notify();
        }

        synchronized void terminate() {
            this._done = true;
            this.notify();
        }
    }
}

